/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.ArchiveLogInfo;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.LoggerUtils;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.datainput.DataProviderFactory;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.fi.aef.logic.model.FileUploadItem;

public class ArchiveTaxBillLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveTaxBillLogicUnit.class);
    private String taxarchivedata;
    private Map<String, Object> extMap = new HashMap<String, Object>(16);
    private ArchiveLogInfo archiveLogInfo;
    Set<Long> hasArchivedSet = new HashSet<Long>(12);
    private String ticcttypeId;
    private List<Map<String, Object>> declareList = new ArrayList<Map<String, Object>>(16);
    private Map<String, List<Map<String, Object>>> periodDacList = new HashMap<String, List<Map<String, Object>>>(16);

    @Override
    protected List<?> prepareListData() {
        Map rangeMap = (Map)SerializationUtils.fromJsonString((String)this.context.getArchiveRangeReport(), Map.class);
        this.taxarchivedata = (String)rangeMap.get("taxarchivedata");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"aef_archivescheme", (String)"group, group.name groupname", (QFilter[])new QFilter("id", "=", (Object)this.context.getSchemeId()).toArray());
        Long groupId = dyn.getLong("group");
        String groupname = dyn.getString("groupname");
        this.extMap = new HashMap<String, Object>(16);
        this.extMap.put("groupname", groupname);
        this.archiveLogInfo = new ArchiveLogInfo(this.context.getOrgId(), this.context.getApplicationId(), this.context.getSchemeId(), this.userId, this.context.getUploadWay(), new Date(), this.context.getIsReverse(), this.context.getBatchcode(), this.context.getBillType(), null, null, null, this.context.getReverseReason(), null, null, null, null, groupId, this.taxarchivedata, " ");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)this.context.getOrgId()).toArray());
        String orgNo = dynamicObject.getString("number");
        String orgName = dynamicObject.getString("name");
        this.extMap.put("orgNo", orgNo);
        this.extMap.put("orgName", orgName);
        this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), orgNo, orgName, null, this.context.getBatchcode(), 16, null, null);
        this.fileUploadItem.setBillType(this.context.getBillType());
        List<Map<String, Object>> list = null;
        if ("bill".equals(this.taxarchivedata)) {
            this.context.setNeedArchiveIds(new HashSet<Long>(this.context.getIds()));
            list = DataProviderFactory.getCurrentDataProvider().getBillData(this.context);
        }
        if ("tccit".equals(this.taxarchivedata)) {
            this.context.setNeedArchiveIds(new HashSet<Long>(2));
            if ("1".equals(this.context.getIsReverse())) {
                this.hasArchivedSet = ArchiveUtil.getHasArchivedIds(this.context.getUploadWay(), this.context.getOrgId(), this.context.getBillType());
                this.ticcttypeId = (String)rangeMap.get("taxticcttype");
                String startDate = (String)rangeMap.get("startdate");
                String endDate = (String)rangeMap.get("enddate");
                String nxxfilter = (String)rangeMap.get("nxxfilter");
                list = ElecreceiptUtils.findTaxcDeclareTempFile(this.context.getOrgId(), startDate, endDate, this.ticcttypeId, nxxfilter);
            } else {
                this.context.getNeedArchiveIds().addAll(this.context.getIds());
                list = (List<Map<String, Object>>)SerializationUtils.fromJsonString((String)this.context.getArchiverange(), List.class);
            }
            this.declareList = list;
        }
        this.contextData.getTaxBillOutputData().setBillList(list);
        return list;
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }

    protected Map<String, Object> prePareMapData() {
        return new HashMap<String, Object>();
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        RowResult result = new RowResult();
        if (obj instanceof Bill) {
            Bill bill = (Bill)obj;
            Object billId = bill.getBillId();
            result.setCurrenKey(billId);
            String orgNo = bill.getOrgNo();
            String orgName = bill.getOrgName();
            String dateStr = DateUtil.getShortStr(bill.getDate());
            this.fileUploadItem.setPeriod(dateStr);
            String fileName = this.context.getBillType() + "_" + billId + ".pdf";
            FileDesc fileDesc = new FileDesc(fileName, null, null, null);
            this.billFileMap.put(billId, fileDesc);
            if ("2".equals(this.context.getIsReverse())) {
                this.fileUploadItem.setFileName(fileName);
                return result;
            }
            ArrayList<Object> pks = new ArrayList<Object>(2);
            pks.add(bill.getBillId());
            try {
                String pdfUrl = null;
                if (StringUtils.isNotBlank((CharSequence)this.printId)) {
                    pdfUrl = DataProviderFactory.getCurrentDataProvider().getPrintUrl(this.context.getPageId(), this.context.getBillType(), this.printId, pks, "billForm", this.context.getPrintType());
                } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(billId))) {
                    PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(billId);
                    pdfUrl = DataProviderFactory.getCurrentDataProvider().getPrintUrl(this.context.getPageId(), this.context.getBillType(), printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
                } else {
                    this.context.getNeedArchiveIds().remove(billId);
                    String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveTaxBillLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), bill.getBillId());
                    this.errDyns.add(LogUtil.generateArchiveErrorLog(this.context.getBillType(), Long.valueOf(billId.toString()), this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
                    logger.error(string);
                    result.setNeedHandle(false);
                    return result;
                }
                this.fileUploadItem.setFileName(fileName);
                fileDesc.setExt("pdf");
                this.fileUploadItem.setBillId((Long)billId);
                this.setPrintFileRelatedInfo(this.fileUploadItem, pdfUrl, fileDesc);
                this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
            }
            catch (Exception e) {
                this.context.getNeedArchiveIds().remove(billId);
                String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveTaxBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), billId, e.getMessage());
                this.errDyns.add(LoggerUtils.generateArchiveErrorLog(this.context.getBillType(), billId, this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
                logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result.setNeedHandle(false);
                return result;
            }
            this.archiveLogInfo.setPeriod(dateStr);
            this.archiveLogInfo.setBillid((Long)billId);
            this.archiveLogInfo.setBillno(bill.getBillNo());
            this.archiveLogInfo.setBillbizdate(bill.getDate());
            this.archiveLogInfo.setSkssqq(bill.getDate());
            this.archiveLogInfo.setSkssqz(bill.getDate());
            DynamicObject temp = ArchiveRecordUtils.getArhieveDynamicObject(this.archiveLogInfo);
            result.setArchiveObject(temp);
            return result;
        }
        Map objMap = (Map)obj;
        if ("1".equals(this.context.getIsReverse())) {
            this.fileUploadItem.setPeriod((String)objMap.get("period"));
            Long billId = (Long)objMap.get("id");
            if (!this.hasArchivedSet.contains(billId)) {
                this.context.getNeedArchiveIds().add(billId);
                result.setCurrenKey(billId);
                FileDesc fileDesc = new FileDesc();
                try {
                    this.setTempFileRelatedInfo(this.fileUploadItem, (String)objMap.get("url"), fileDesc);
                }
                catch (Exception e) {
                    this.context.getNeedArchiveIds().remove(billId);
                    String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveTaxBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), billId, e.getMessage());
                    this.errDyns.add(LoggerUtils.generateArchiveErrorLog(this.context.getBillType(), billId, this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
                    logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    result.setNeedHandle(false);
                    return result;
                }
                String filename = (String)objMap.get("filename");
                this.fileUploadItem.setFileName(filename);
                this.fileUploadItem.setPeriod((String)objMap.get("period"));
                fileDesc.setName(filename);
                fileDesc.setExt(filename.split("\\.")[filename.split("\\.").length - 1]);
                this.billFileMap.put(billId, fileDesc);
                this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
                objMap.put("taxticcttype", this.ticcttypeId);
                this.archiveLogInfo.setOtherdata(SerializationUtils.toJsonString((Object)objMap));
                this.archiveLogInfo.setBillid(billId);
                this.archiveLogInfo.setPeriod((String)objMap.get("period"));
                this.archiveLogInfo.setBillno((String)objMap.get("billno"));
                this.archiveLogInfo.setBillbizdate(DateUtil.stringToDate((String)objMap.get("period"), "yyyy-MM"));
                this.archiveLogInfo.setSkssqq(DateUtil.stringToDate((String)objMap.get("startdate"), "yyyy-MM-dd"));
                this.archiveLogInfo.setSkssqz(DateUtil.stringToDate((String)objMap.get("enddate"), "yyyy-MM-dd"));
                DynamicObject temp = SingleArchiveUtil.getTaxArhieveDynamicObject(this.archiveLogInfo);
                result.setArchiveObject(temp);
                return result;
            }
        } else {
            Long billId = (Long)objMap.get("id");
            result.setCurrenKey(billId);
            this.fileUploadItem.setPeriod((String)objMap.get("period"));
            String filename = (String)objMap.get("filename");
            FileDesc fileDesc = new FileDesc(filename, " ", null, 0);
            fileDesc.setExt(filename.split("\\.")[filename.split("\\.").length - 1]);
            this.billFileMap.put(billId, fileDesc);
            return result;
        }
        return result;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        if (!this.errDyns.isEmpty()) {
            LogUtil.saveErrorLog(this.errDyns);
        }
        if (context.getNeedArchiveIds().size() == 0) {
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        this.contextData.getTaxBillOutputData().setBillFileNameMap(this.billFileMap);
        this.contextData.getTaxBillOutputData().setFileUploadItem(this.fileUploadItem);
        this.attachMap = DataProviderFactory.getCurrentDataProvider().getIdAndAttacheFiles(context.getBillType(), context.getNeedArchiveIds(), context.getAttachtabJson());
        this.contextData.getTaxBillOutputData().setAttachMap(this.attachMap);
        this.extMap.put("flag", LogicUtils.getFlag(context.getIsReverse()));
        this.extMap.put("taxarchivedata", this.taxarchivedata);
        this.extMap.put("billname", this.billName);
        this.extMap.put("billtype", context.getBillType());
        this.extMap.put("needArchiveIds", context.getNeedArchiveIds());
        this.contextData.getOtherData().put("extMap", this.extMap);
        if ("bill".equals(this.taxarchivedata)) {
            this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.TAX_DATA);
            if (this.fileUploadItem != null) {
                this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
            }
        }
        if ("tccit".equals(this.taxarchivedata)) {
            for (Map<String, Object> map : this.declareList) {
                this.periodDacList.computeIfAbsent((String)map.get("period"), value -> new ArrayList()).add(map);
            }
            for (Map.Entry entry : this.periodDacList.entrySet()) {
                List perioddeclare = (List)entry.getValue();
                this.extMap.put("declareList", perioddeclare);
                this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.TAX_DATA);
                if (this.fileUploadItem == null) continue;
                this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
            }
        }
        String className = this.getClass().getName();
        this.noticeArchive(this.fileUploadItem);
        if ("1".equals(context.getIsReverse())) {
            SaveArchiveUtils.saveDynamicObjects(className, this.contextData.getArchiveObjects(), this.billName, context.getNeedArchiveIds(), context.getBillType(), "aef_acelre_tax");
            this.saveFilePath();
        } else {
            ReversalUtils.updateRecordToReserve(className, context.getNeedArchiveIds(), context.getBillType(), this.context.getReverseReason(), context.getBatchcode(), "aef_acelre_tax");
        }
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        if (this.attachMap == null) {
            this.attachMap = DataProviderFactory.getCurrentDataProvider().getIdAndAttacheFiles(context.getBillType(), context.getIds(), context.getAttachtabJson());
            this.contextData.getCommonBillOutputData().setAttachMap(this.attachMap);
        }
        if (result != null && this.attachMap != null) {
            return (List)this.attachMap.get(result.getCurrenKey());
        }
        return new ArrayList<Attach>();
    }
}

