/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.GXUtils;
import kd.fi.aef.logic.common.LoggerUtils;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.datainput.DataProvider;
import kd.fi.aef.logic.datainput.DataProviderFactory;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.fi.aef.logic.model.FileUploadItem;

public class ArchiveVoucherLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveVoucherLogicUnit.class);
    List<DynamicObject> refErrDyns = new ArrayList<DynamicObject>(16);

    protected Map<String, Object> prePareMapData() {
        return null;
    }

    @Override
    protected List<?> prepareListData() {
        SingleArchiveUtil.createThreadCache(this.context.getBillType(), this.context.getIds());
        DataProvider defaultVoucherDataProvider = DataProviderFactory.getCurrentVoucherDataProvider();
        defaultVoucherDataProvider.initProvider(this.context, this.contextData, this, this.documentServerHandler);
        if (this.getDocumentServerHandler().isNeedArchiveRef()) {
            if (this.getDocumentServerHandler().isXbrlPoint(this.context)) {
                this.context.setNeedArchiveIds(new HashSet<Long>(2));
                if (this.multarchive) {
                    this.context.setNeedArchiveIds(new HashSet<Long>(this.context.getIds()));
                    defaultVoucherDataProvider.archiveReferenceBills(this.context);
                }
                defaultVoucherDataProvider.archiveXbrl(this.context);
            } else {
                this.context.setNeedArchiveIds(new HashSet<Long>(this.context.getIds()));
                defaultVoucherDataProvider.archiveReferenceBills(this.context);
            }
            defaultVoucherDataProvider.archiveReceipt(this.context);
        } else {
            this.context.setNeedArchiveIds(new HashSet<Long>(this.context.getIds()));
        }
        defaultVoucherDataProvider.endProvider(this.context, this.contextData);
        if (this.context.getNeedArchiveIds().size() == 0) {
            return new ArrayList();
        }
        this.refErrDyns = (List)this.contextData.getOtherData().get("errDyns");
        this.attachMap = defaultVoucherDataProvider.getIdAndAttacheFiles(this.context.getBillType(), this.context.getNeedArchiveIds(), this.context.getAttachtabJson());
        this.contextData.getVoucherOutputData().setAttachMap(this.attachMap);
        List<Bill> list = defaultVoucherDataProvider.getVoucherData(this.context);
        this.contextData.getVoucherOutputData().setBillList(list);
        this.contextData.getOtherData().put("ftpPath", GXUtils.getFtpPath(this.context.getBillType()));
        return list;
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        RowResult result = new RowResult();
        if (!(obj instanceof Bill)) {
            throw new KDBizException("ArchiveVoucherLogicUnit not match");
        }
        Bill voucher = (Bill)obj;
        Object vid = voucher.getBillId();
        result.setCurrenKey(vid);
        String orgNo = voucher.getOrgNo();
        String orgName = voucher.getOrgName();
        if (this.context.isSplitBook() && this.context.isAws()) {
            orgNo = orgNo + voucher.getBookNumber();
            orgName = orgName + voucher.getBookName();
        }
        String fileName = this.context.getBillType() + "_" + vid + ".pdf";
        String period = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(voucher.getPeriodNumber()) : CreateXmlUtil.dealAdjustmentPeriodNumber(voucher.getPeriodNumber());
        this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), orgNo, orgName, period, this.context.getBatchcode(), 1, fileName, null, voucher.getInstitutionIssuesNo(), voucher.getInstitutionIssuesName());
        this.fileUploadItem.setBillType(this.context.getBillType());
        this.fileUploadItem.setCustomString((String)this.contextData.getOtherData().get("ftpPath"));
        FileDesc fileDesc = new FileDesc(fileName, null, "pdf", null);
        this.billFileMap.put(vid, fileDesc);
        if ("2".equals(this.context.getIsReverse())) {
            return result;
        }
        ArrayList<Object> pks = new ArrayList<Object>(2);
        pks.add(vid);
        String pdfUrl = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)this.printId)) {
                pdfUrl = DataProviderFactory.getCurrentDataProvider().getPrintUrl(this.context.getPageId(), this.context.getBillType(), this.printId, pks, "billForm", this.context.getPrintType());
            } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(vid))) {
                PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(vid);
                pdfUrl = DataProviderFactory.getCurrentDataProvider().getPrintUrl(this.context.getPageId(), this.context.getBillType(), printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
            } else {
                this.context.getNeedArchiveIds().remove(vid);
                String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveCommonBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), voucher.getBillNo());
                this.errDyns.add(LogUtil.generateArchiveErrorLog(this.context.getBillType(), Long.valueOf(vid.toString()), this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
                logger.error(string);
                result.setNeedHandle(false);
                return result;
            }
            this.setPrintFileRelatedInfo(this.fileUploadItem, pdfUrl, fileDesc);
        }
        catch (Exception e) {
            this.context.getNeedArchiveIds().remove(vid);
            String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveCommonBillLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), vid, e.getMessage());
            this.errDyns.add(LoggerUtils.generateArchiveErrorLog(this.context.getBillType(), vid, this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
            logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setNeedHandle(false);
            return result;
        }
        this.fileUploadItem.setBillId((Long)vid);
        this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
        DynamicObject temp = ArchiveRecordUtils.getArhieveRecordDynamicObject(this.context.getBillType(), this.context.getApplicationId(), this.context.getSchemeId(), voucher, this.userId, this.currentDate, this.context.getUploadWay(), "1", null, voucher.getDate(), null, this.context.getBatchcode());
        result.setArchiveObject(temp);
        return result;
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        if (this.attachMap == null) {
            this.attachMap = LogicUtils.getIdAndAttacheFiles(context.getBillType(), context.getIds(), context.getAttachtabJson());
        }
        if (result != null) {
            return (List)this.attachMap.get(result.getCurrenKey());
        }
        return null;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        if (!this.errDyns.isEmpty()) {
            LogUtil.saveErrorLog(this.errDyns);
        }
        if (context.getNeedArchiveIds().size() == 0) {
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        this.contextData.getVoucherOutputData().setFileUploadItem(this.fileUploadItem);
        this.contextData.getVoucherOutputData().setBillFileMap(this.billFileMap);
        this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.VOUCHER);
        if (this.fileUploadItem != null) {
            this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
        }
        Map vatInvoiceMap = (Map)this.contextData.getOtherData().get("vatInvoiceMap");
        String className = this.getClass().getName();
        try (TXHandle h = TX.required();){
            try {
                this.noticeArchive(this.fileUploadItem);
                if ("1".equals(context.getIsReverse())) {
                    SaveArchiveUtils.saveDynamicObjects(className, this.contextData.getArchiveObjects(), this.billName, context.getNeedArchiveIds(), context.getBillType(), "aef_acelre");
                    SaveArchiveUtils.saveInvoice(vatInvoiceMap);
                    this.saveFilePath();
                } else {
                    ReversalUtils.updateRecordToReserve(className, context.getNeedArchiveIds(), context.getBillType(), this.context.getReverseReason(), context.getBatchcode(), "aef_acelre");
                    ReversalUtils.deleteInvoice(vatInvoiceMap, context.getNeedArchiveIds());
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u51ed\u8bc1\uff1a{}\u5165\u5e93\u7535\u5b50\u51ed\u8bc1:{} ", (String)"ArchiveVoucherLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), context.getNeedArchiveIds(), vatInvoiceMap);
        ThreadCache.remove((Object)"glVoucher");
    }
}

