/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.IDUtils;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.datainput.DataProviderFactory;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.fi.aef.logic.model.FileUploadItem;

public class ElecstatementWithVATinvoice
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ElecstatementWithVATinvoice.class);
    private static Map<Long, List<JSONObject>> jsonMap = new HashMap<Long, List<JSONObject>>(16);
    private static Map<Object, List<FileDesc>> mainFileMap = new HashMap<Object, List<FileDesc>>(100);
    private static Map<Object, FileDesc> xbrlFileMap = new HashMap<Object, FileDesc>(100);
    private static Map<String, Set<DynamicObject>> vatInvoiceMap = new HashMap<String, Set<DynamicObject>>(16);

    protected Map<String, Object> prePareMapData() {
        return new HashMap<String, Object>();
    }

    @Override
    protected List<?> prepareListData() {
        List<Bill> list = DataProviderFactory.getCurrentDataProvider().getBillData(this.context);
        this.contextData.getCommonBillOutputData().setBillList(list);
        this.context.setNeedArchiveIds(new HashSet<Long>(this.context.getIds()));
        this.attachMap = DataProviderFactory.getCurrentDataProvider().getIdAndAttacheFiles(this.context.getBillType(), this.context.getIds(), this.context.getAttachtabJson());
        this.contextData.getCommonBillOutputData().setAttachMap(this.attachMap);
        Map<String, DynamicObject> receiptPlgins = this.getTypeWithReceipt();
        jsonMap = ElecreceiptUtils.findReceiptJson(this.context.getBillType(), this.context.getIds(), receiptPlgins, this.context.getPageId());
        return list;
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        if (this.attachMap == null) {
            this.attachMap = DataProviderFactory.getCurrentDataProvider().getIdAndAttacheFiles(context.getBillType(), context.getIds(), context.getAttachtabJson());
        }
        if (result != null && this.attachMap != null) {
            return (List)this.attachMap.get(result.getCurrenKey());
        }
        return new ArrayList<Attach>();
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        RowResult result = new RowResult();
        if (!(obj instanceof Bill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5339\u914d\u7684\u8c03\u7528", (String)"ArchiveCommonBillLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        Bill bill = (Bill)obj;
        Object billId = bill.getBillId();
        result.setCurrenKey(billId);
        String orgNo = bill.getOrgNo();
        String orgName = bill.getOrgName();
        String dateStr = "";
        dateStr = DateUtil.getShortStr(bill.getDate());
        if ("2".equals(this.context.getIsReverse())) {
            this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), orgNo, orgName, dateStr, this.context.getBatchcode(), 20, null, null);
            return result;
        }
        List<JSONObject> jsons = jsonMap.get(billId);
        if (jsons != null && jsons.size() > 0) {
            for (JSONObject json : jsons) {
                String allurl = json.getString("url");
                LogUtil.printLog(logger, ResManager.loadKDString((String)"bkrs:{}, allurl{}", (String)"ElecstatementWithVATinvoice_0", (String)"fi-aef-common", (Object[])new Object[0]), billId, allurl);
                if (!"1".equals(this.context.getIsReverse())) continue;
                this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), orgNo, orgName, dateStr, this.context.getBatchcode(), 20, null, null);
                if (StringUtils.isNotBlank((CharSequence)allurl)) {
                    List<String> urls = Arrays.asList(allurl.split(";"));
                    for (String tempurl : urls) {
                        FileDesc fileDesc = new FileDesc(ElecreceiptUtils.getFileName(tempurl));
                        fileDesc.setExt(allurl.split("\\.")[allurl.split("\\.").length - 1]);
                        try {
                            this.setAttachmentsRelatedInfo(this.fileUploadItem, tempurl, fileDesc);
                        }
                        catch (IOException e) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5931\u8d25{%2$s}", (String)"ElecstatementWithVATinvoice_1", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        }
                        this.fileUploadItem.setBillType(this.context.getBillType());
                        this.fileUploadItem.setBillId((Long)billId);
                        this.fileUploadItem.setFileName(ElecreceiptUtils.getFileName(tempurl));
                        this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
                        mainFileMap.computeIfAbsent(billId, value -> new ArrayList()).add(fileDesc);
                        this.billFileMap.put(billId, fileDesc);
                    }
                }
                byte[] xbrlData = FileUtils.json2Xbrl(json.toJSONString(), "bkrs");
                this.fileUploadItem.setFilebase64(LogicUtils.toBase64(xbrlData));
                this.fileUploadItem.setFileName(billId + "_" + ContextUtil.createXBRLFilename("bkrs", json));
                this.fileUploadItem.setBusinessType(20);
                this.fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(xbrlData));
                this.fileUploadItem.setFileBytes(xbrlData);
                this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
                json.put("org", (Object)bill.getOrgId());
                json.put("sourcebillno", (Object)bill.getBillNo());
                json.put("tickettype", (Object)"bkrs");
                json.put("billid", billId);
                FileDesc fileDesc = new FileDesc(billId + "_" + ContextUtil.createXBRLFilename("bkrs", json), null, ".xml", null);
                fileDesc.setFilesize(xbrlData.length);
                fileDesc.setMd5(FpyOperateUtil.fileMD5(xbrlData));
                xbrlFileMap.put(billId, fileDesc);
                SingleArchiveUtil.insertInvoicePool(vatInvoiceMap, json, "bkrs", null, null, null, null);
            }
            DynamicObject temp = ArchiveRecordUtils.getArhieveRecordDynamicObject(this.context.getBillType(), this.context.getApplicationId(), this.context.getSchemeId(), bill, this.userId, this.currentDate, this.context.getUploadWay(), "1", null, bill.getDate(), null, this.context.getBatchcode());
            result.setArchiveObject(temp);
        }
        return result;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        if (context.getNeedArchiveIds().size() == 0) {
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        this.contextData.setOtherData(new HashMap<String, Object>());
        this.contextData.getOtherData().put("flag", LogicUtils.getFlag(context.getIsReverse()));
        this.contextData.getOtherData().put("mainFileMap", mainFileMap);
        this.contextData.getOtherData().put("xbrlFileMap", xbrlFileMap);
        this.contextData.getCommonBillOutputData().setBillFileMap(this.billFileMap);
        Map<String, Object> imageMap = DataProviderFactory.getCurrentDataProvider().getImageNumberMap(context.getBillType(), IDUtils.convertIDFromLong(context.getIds()));
        this.contextData.getCommonBillOutputData().setImageMap(imageMap);
        this.contextData.getCommonBillOutputData().setFileUploadItem(this.fileUploadItem);
        this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.ELEC_DATA);
        if (this.fileUploadItem != null) {
            this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
        }
        String className = this.getClass().getName();
        this.noticeArchive(this.fileUploadItem);
        if ("1".equals(context.getIsReverse())) {
            SaveArchiveUtils.saveDynamicObjects(className, this.contextData.getArchiveObjects(), this.billName, context.getNeedArchiveIds(), context.getBillType(), "aef_acelre");
            this.saveFilePath();
            SaveArchiveUtils.saveInvoice(vatInvoiceMap);
        } else {
            ReversalUtils.updateRecordToReserve(className, context.getNeedArchiveIds(), context.getBillType(), this.context.getReverseReason(), context.getBatchcode(), "aef_acelre");
            SingleArchiveUtil.deleteBkrs(context.getNeedArchiveIds());
        }
    }

    private Map<String, DynamicObject> getTypeWithReceipt() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isinvoice", "!=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }
}

