/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.Printsample;
import kd.fi.aef.helper.ArchiveSchemeHelper;

public abstract class AbstractArchiveLogicUnit {
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String DATASOURCE = "cangqiong";
    protected ArchiveContext context;
    protected Long userId = UserServiceHelper.getCurrentUserId();
    protected String tenantId = RequestContext.get().getTenantId();
    protected String accountId = RequestContext.get().getAccountId();
    private static final String SUCCESS_CODE = "0000";
    private static final Log logger = LogFactory.getLog(AbstractArchiveLogicUnit.class);
    protected String isReverse;
    protected String flag;
    protected String billType;
    protected String billName;
    protected Set<Long> ids;
    protected String uploadway;
    protected String uploadUrl;
    protected String uploadNoticeUrl;
    protected String uploadDeleteUrl;
    protected String archivesCode;
    protected String batchCode;
    protected String printSample;
    protected Map<Long, PrintIdandType> billIdAndPrintIdMap;
    protected int printType;
    protected String printId;
    protected String isNeedAttachFile;
    protected String schemeId;
    protected String pageId;
    protected String application;
    protected long periodId;
    protected long orgId;
    protected long booktypeId;
    protected boolean isSplitbook;
    protected boolean multarchive;
    protected boolean isxbrlpilot;
    protected boolean isNotNeedUploadFile;
    protected boolean archiveByFilePath;

    public void initAbstractArchiveLogicUnit() {
        this.isSplitbook = this.context.isSplitBook();
        this.isReverse = this.context.getIsReverse();
        this.flag = "2".equals(this.isReverse) ? "delete" : "addnew";
        this.billType = this.context.getBillType();
        this.billName = "aef_rpt".equals(this.billType) ? ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868", (String)"ArchiveErrorLogListSetData_0", (String)"fi-aef-formplugin", (Object[])new Object[0]) : EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
        this.ids = this.context.getIds();
        this.uploadway = this.context.getUploadWay();
        this.uploadUrl = this.context.getFpyUploadUrl();
        this.uploadNoticeUrl = this.context.getFpyNoticeUrl();
        this.archivesCode = this.context.getArchivesCode();
        this.batchCode = UUID.randomUUID().toString();
        this.printSample = this.context.getPrintsampleId();
        this.printType = this.context.getPrintType();
        if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
            this.printId = ArchiveSchemeHelper.queryPrintId(this.printSample, this.printType);
        } else if ("1".equals(this.isReverse)) {
            Map rangeMap;
            if (!(JudgeBillType.isRptFrom(this.billType) || JudgeBillType.isFinaceRpt(this.billType) || "tax".equals(this.context.getArchieveType()))) {
                if (StringUtils.isNotBlank((CharSequence)this.context.getPrintTemplatetag())) {
                    List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                    HashSet<Long> tempIds = new HashSet<Long>(this.ids);
                    this.billIdAndPrintIdMap = ArchiveSchemeHelper.getBillIdAndPrintId(templateList, this.billType, tempIds);
                }
            } else if ("tax".equals(this.context.getArchieveType()) && "bill".equals((String)(rangeMap = (Map)SerializationUtils.fromJsonString((String)this.context.getArchiveRangeReport(), Map.class)).get("taxarchivedata"))) {
                List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                HashSet<Long> tempIds = new HashSet<Long>(this.ids);
                this.billIdAndPrintIdMap = ArchiveSchemeHelper.getBillIdAndPrintId(templateList, this.billType, tempIds);
            }
        }
        this.isNeedAttachFile = this.context.getIsArchieveAttach();
        this.schemeId = this.context.getSchemeId() + "";
        this.pageId = this.context.getPageId();
        this.application = this.context.getApplicationId();
        this.periodId = this.context.getPeriodId();
        this.orgId = this.context.getOrgId();
        this.booktypeId = this.context.getBooktypeId();
        this.isxbrlpilot = this.context.getIsxbrlpilot();
        this.multarchive = SysParamConfig.getBoolean("multarchive");
        this.isNotNeedUploadFile = "3".equals(this.context.getUploadWay()) && "2".equals(this.context.getIsReverse()) && SysParamConfig.getBoolean("archivetoxinghan");
        this.isNotNeedUploadFile = this.isNotNeedUploadFile || "5".equals(this.context.getUploadWay()) && "2".equals(this.context.getIsReverse());
        this.isNotNeedUploadFile = this.isNotNeedUploadFile || "6".equals(this.context.getUploadWay()) && "2".equals(this.context.getIsReverse());
        boolean bl = this.archiveByFilePath = "5".equals(this.context.getUploadWay()) && SysParamConfig.getBoolean("archivebyfilepath");
        if ("3".equals(this.uploadway) || "5".equals(this.uploadway) || "6".equals(this.uploadway)) {
            Map<String, String> tokenMap = AbstractArchiveLogicUnit.initialToken(this.context);
            this.uploadUrl = tokenMap.get("uploadUrl");
            this.uploadNoticeUrl = tokenMap.get("noticeUrl");
            this.uploadDeleteUrl = tokenMap.get("deleteUrl");
            this.archivesCode = tokenMap.get("archivesCode");
        }
    }

    public void doAction(ArchiveContext ctx) {
        this.context = ctx;
        this.initAbstractArchiveLogicUnit();
        this.context.setCurUnit(this.getClass().getName());
        this.execute();
    }

    protected abstract void execute();

    protected void uploadFile(String uploadUrl, FpyUploadItem fpyUploadItem, String billName, String className, boolean isXmlFile) {
        if ("2".equals(this.isReverse) && this.isNotNeedUploadFile && isXmlFile) {
            this.reverse(this.uploadDeleteUrl, fpyUploadItem, billName, className);
            return;
        }
        if (isXmlFile) {
            fpyUploadItem.setFilePath(null);
        }
        String desc = isXmlFile ? ResManager.loadKDString((String)"XML\u63cf\u8ff0\u6587\u4ef6", (String)"AbstractArchiveLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f71\u50cf", (String)"AbstractArchiveLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]);
        String responseContent = "";
        String code = "";
        String description = "";
        try {
            responseContent = FpyOperateUtil.upload(uploadUrl, fpyUploadItem);
            Map map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
            code = map.get("errcode") + "";
            description = map.get("description") + "";
            if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
                logger.error(String.format("[uploadFile][%s]%s\u8c03\u7528\u5f52\u6863\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25", className, billName));
            }
        }
        catch (Exception e) {
            code = String.format(ResManager.loadKDString((String)"[uploadFile]%1$s]%2$s%3$s\u8c03\u7528\u5f52\u6863HTTP URL:%4$s,\u4e0a\u4f20\u63a5\u53e3\u5f02\u5e38{%5$s}", (String)"AbstractArchiveLogicUnit_10", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, desc, uploadUrl + responseContent, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(code);
        }
        if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801:%s", (String)"AbstractArchiveLogicUnit_15", (String)"fi-aef-common", (Object[])new Object[0]), responseContent));
        }
    }

    protected void noticeArchive(String uploadNoticeUrl, FpyUploadItem fpyUploadItem, String billName, String className) {
        if ("2".equals(this.isReverse) && this.isNotNeedUploadFile) {
            return;
        }
        fpyUploadItem.setArchivist(RequestContext.get().getUserName());
        fpyUploadItem.setDataSource(DATASOURCE);
        String code = "";
        try {
            code = FpyOperateUtil.noticeArchive(uploadNoticeUrl, fpyUploadItem);
            if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
                logger.error(String.format("[noticeArchive][%s]%s\u8c03\u7528\u5f52\u6863\u901a\u77e5\u5931\u8d25\u3002", className, billName));
            }
        }
        catch (Exception e) {
            code = String.format(ResManager.loadKDString((String)"[noticeArchive][%1$s]%2$s\u8c03\u7528\u5f52\u6863\u901a\u77e5\u5f02\u5e38:{%3$s}", (String)"AbstractArchiveLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(code);
        }
        if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
            throw new KDBizException(code);
        }
    }

    protected void reverse(String uploadDeleteUrl, FpyUploadItem fpyUploadItem, String billName, String className) {
        if (fpyUploadItem == null || fpyUploadItem.getBillidsMap() == null || fpyUploadItem.getBillidsMap().size() == 0) {
            return;
        }
        ArrayList errorMapList = new ArrayList(16);
        String responseContent = "";
        String description = "";
        String code = "";
        try {
            fpyUploadItem.setArchivist(RequestContext.get().getUserName());
            fpyUploadItem.setDataSource(DATASOURCE);
            responseContent = FpyOperateUtil.reverse(uploadDeleteUrl, fpyUploadItem);
            Map map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
            code = map.get("errcode") + "";
            description = map.get("description") + "";
            if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
                logger.error(String.format("[reverse][%s]%s\u8c03\u7528\u53cd\u5f52\u6863\u6863\u901a\u77e5\u5931\u8d25\u3002", className, billName));
                Map<String, String> billidsMap = fpyUploadItem.getBillidsMap();
                Map<String, String> idsMap = billidsMap.keySet().stream().collect(Collectors.toMap(key -> key.split("\\.")[1], key -> key.split("\\.")[0]));
                if (map.get("data") != null && map.get("data") instanceof List) {
                    List data = (List)map.get("data");
                    for (Map row : data) {
                        String key2 = (String)row.get("billid");
                        String value = (String)row.get("message");
                        if (!idsMap.containsKey(key2)) continue;
                        logger.error(String.format("[reverse][%s]%s AbstractArchiveLogicUnit reverse fail:%s-%s", className, billName, key2, value));
                        HashMap<String, String> errorMap = new HashMap<String, String>(2);
                        errorMap.put("errorId", idsMap.get(key2));
                        errorMap.put("errorMessage", String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"AbstractArchiveLogicUnit_17", (String)"fi-aef-common", (Object[])new Object[0]), billidsMap.get(idsMap.get(key2) + "." + key2), value));
                        errorMapList.add(errorMap);
                    }
                } else {
                    for (Map.Entry<String, String> entry : billidsMap.entrySet()) {
                        HashMap<String, String> errorMap = new HashMap<String, String>(2);
                        errorMap.put("errorId", idsMap.get(entry.getKey().split("\\.")[1]));
                        errorMap.put("errorMessage", String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"AbstractArchiveLogicUnit_17", (String)"fi-aef-common", (Object[])new Object[0]), entry.getValue(), description));
                        errorMapList.add(errorMap);
                    }
                }
            }
        }
        catch (Exception e) {
            code = String.format(ResManager.loadKDString((String)"[reverse][%1$s]%2$s\u8c03\u7528\u53cd\u5f52\u6863\u901a\u77e5\u5f02\u5e38:{%3$s}", (String)"AbstractArchiveLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(code);
        }
        if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
            throw new KDBizException(new ErrorCode(code, description), errorMapList.toArray(new Object[0]));
        }
    }

    protected void saveDynamicObjects(String className, List<DynamicObject> dynamicObjects, String billName, Set<Long> ids, String billType) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"wayid,reason,filingid,fexetime,type,billid,batchcode,booktype,billno", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)});
                ArrayList<Long> billids = new ArrayList<Long>(16);
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        Long billid = record.getLong("billid");
                        List dyns = dynamicObjects.stream().filter(dynamicObject -> dynamicObject.getLong("billid") == billid.longValue()).collect(Collectors.toList());
                        record.set("reason", (Object)"");
                        record.set("booktype", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("booktype") : ((DynamicObject)dynamicObjects.get(0)).getLong("booktype")));
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("wayid_id", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("wayid") : ((DynamicObject)dynamicObjects.get(0)).getLong("wayid")));
                        record.set("batchcode", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getString("batchcode") : ((DynamicObject)dynamicObjects.get(0)).getString("batchcode")));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        if (dyns != null && dyns.size() > 0) {
                            record.set("billno", (Object)((DynamicObject)dyns.get(0)).getString("billno"));
                        }
                        billids.add(record.getLong("billid"));
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                }
                if ((dynamicObjects = dynamicObjects.stream().filter(DynamicObject2 -> !billids.contains(DynamicObject2.getLong("billid"))).collect(Collectors.toList())).size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void saveTaxObjects(String className, List<DynamicObject> dynamicObjects, String billName, Set<Long> ids, String billType) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre_tax", (String)"wayid,reason,filingid,fexetime,type,billid,batchcode,group,billno", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)});
                ArrayList<Long> billids = new ArrayList<Long>(16);
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        Long billid = record.getLong("billid");
                        List dyns = dynamicObjects.stream().filter(dynamicObject -> dynamicObject.getLong("billid") == billid.longValue()).collect(Collectors.toList());
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("wayid", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("wayid") : ((DynamicObject)dynamicObjects.get(0)).getLong("wayid")));
                        record.set("batchcode", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getString("batchcode") : ((DynamicObject)dynamicObjects.get(0)).getString("batchcode")));
                        record.set("filingid", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        record.set("group", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("group") : ((DynamicObject)dynamicObjects.get(0)).getLong("group")));
                        if (dyns != null && dyns.size() > 0) {
                            record.set("billno", (Object)((DynamicObject)dyns.get(0)).getString("billno"));
                        }
                        billids.add(billid);
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                }
                if ((dynamicObjects = dynamicObjects.stream().filter(DynamicObject2 -> !billids.contains(DynamicObject2.getLong("billid"))).collect(Collectors.toList())).size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void saveReportObjects(String className, List<DynamicObject> dynamicObjects, String billType, String billName, String uniqueKey) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"wayid,reason,filingid,fexetime,type, batchcode", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "=", (Object)uniqueKey)});
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("wayid_id", (Object)dynamicObjects.get(0).getLong("wayid"));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        record.set("batchcode", (Object)dynamicObjects.get(0).getString("batchcode"));
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                } else {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void saveSubObjects(String className, List<DynamicObject> dynamicObjects, String billType, String billName, List<String> uniqueKeys) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                ArrayList<String> hasArchiveuniquekeys = new ArrayList<String>(2);
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"wayid,reason,filingid,fexetime,type,batchcode,uniquekey", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "in", uniqueKeys)});
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("wayid_id", (Object)dynamicObjects.get(0).getLong("wayid"));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        record.set("batchcode", (Object)dynamicObjects.get(0).getString("batchcode"));
                        hasArchiveuniquekeys.add(record.getString("uniquekey"));
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                }
                ArrayList<DynamicObject> saveDyns = new ArrayList<DynamicObject>(2);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (hasArchiveuniquekeys.contains(dynamicObject.getString("uniquekey"))) continue;
                    saveDyns.add(dynamicObject);
                }
                SaveServiceHelper.save((DynamicObject[])saveDyns.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void updateRecordToReserve(String className, Set<Long> ids, String billType, String reverseReason, String batchCode) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"reason,filingid,fexetime,type,batchcode", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchCode);
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void updateTaxToReserve(String className, Set<Long> ids, String billType, String reverseReason, String batchcode) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre_tax", (String)"reason,filingid,fexetime,type,batchcode", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid.id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchcode);
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void updateRptRecordToReserve(String className, String uniqueKey, String billType, String reverseReason, String batchcode) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"reason,filingid,fexetime,type,batchcode", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "=", (Object)uniqueKey)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchcode);
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void updateSubleToReserve(String className, List<String> uniqueKeys, String billType, String reverseReason, String batchcode) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"reason,filingid,fexetime,type,batchcode", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "in", uniqueKeys)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchcode);
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void deleteDynamicObjects(String className, String billType, Set<Long> billIds) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                QFilter idFilter = new QFilter("billid", "in", billIds);
                QFilter typeFilter = new QFilter("billtype.id", "=", (Object)billType);
                DeleteServiceHelper.delete((String)"aef_archieve_imagepath", (QFilter[])new QFilter[]{idFilter, typeFilter});
                DeleteServiceHelper.delete((String)"aef_acelre", (QFilter[])new QFilter[]{idFilter});
            }
            catch (Exception e) {
                tx.markRollback();
                String msg = String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u53cd\u5f52\u6863\u5220\u9664\u8bb0\u5f55\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_12", (String)"fi-aef-common", (Object[])new Object[0]), className, billType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.error(msg);
                throw new KDBizException(msg);
            }
        }
    }

    protected String toBase64(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return "";
    }

    protected void saveRptrecords(String className, List<DynamicObject> dynamicObjects, List<String> uniqueKey) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre_rpt", (String)"wayid,reason,filingid,fexetime,type,uniquekey,batchcode", (QFilter[])new QFilter[]{new QFilter("uniquekey", "in", uniqueKey)});
                ArrayList<String> uniqueKeys = new ArrayList<String>(16);
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        record.set("wayid_id", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("wayid"));
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        record.set("batchcode", (Object)((DynamicObject)dynamicObjects.get(0)).getString("batchcode"));
                        uniqueKeys.add(record.getString("uniquekey"));
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                }
                if ((dynamicObjects = dynamicObjects.stream().filter(DynamicObject2 -> !uniqueKeys.contains(DynamicObject2.getString("uniquekey"))).collect(Collectors.toList())).size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void updateRptrecords(String className, List<DynamicObject> dynamicObjects, List<String> uniqueKey, String reason) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre_rpt", (String)"reason,filingid,fexetime,type,batchcode", (QFilter[])new QFilter[]{new QFilter("uniquekey", "in", uniqueKey)})) {
                    record.set("reason", (Object)reason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)dynamicObjects.get(0).getString("batchcode"));
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    protected void saveInvoice(Map<String, Set<DynamicObject>> vatInvoiceMap) {
        if (vatInvoiceMap.size() > 0) {
            for (Map.Entry<String, Set<DynamicObject>> entry : vatInvoiceMap.entrySet()) {
                Set<DynamicObject> dynamicObjects = entry.getValue();
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            }
        }
    }

    protected void deleteBkrs(Set<Long> needArchiveIds) {
        HashSet<Long> idSet = new HashSet<Long>(needArchiveIds.size());
        QFilter idFilter = new QFilter("billid", "in", needArchiveIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractArchiveLogicUnit.deleteBkrs", (String)"aef_bkrs", (String)"id", (QFilter[])idFilter.toArray(), null);){
            for (Row row : dataSet) {
                idSet.add(row.getLong("id"));
            }
        }
        OperationServiceHelper.executeOperate((String)"delete", (String)"aef_bkrs", (Object[])idSet.toArray(), (OperateOption)OperateOption.create());
    }

    protected void deleteInvoice(Map<String, Set<DynamicObject>> vatInvoiceMap, Set<Long> buildXbrlVoucherIds) {
        if (vatInvoiceMap.size() > 0) {
            for (Map.Entry<String, Set<DynamicObject>> entry : vatInvoiceMap.entrySet()) {
                String billType = entry.getKey();
                Set<DynamicObject> dynamicObjects = entry.getValue();
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                HashSet<Long> idSet = new HashSet<Long>(buildXbrlVoucherIds.size());
                QFilter idFilter = new QFilter("directvoucherid", "in", buildXbrlVoucherIds);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractArchiveLogicUnit.deleteInvoice", (String)billType, (String)"id", (QFilter[])idFilter.toArray(), null);){
                    for (Row row : dataSet) {
                        idSet.add(row.getLong("id"));
                    }
                }
                OperationServiceHelper.executeOperate((String)"delete", (String)billType, (Object[])idSet.toArray(), (OperateOption)OperateOption.create());
            }
        }
    }

    protected void insertInvoicePool(Map<String, Set<DynamicObject>> vatInvoiceMap, JSONObject json, String tickettype, Long vid, Map<Long, JSONObject> voucherJson, String refbillType, Long refbillId) {
        String billType = "";
        switch (tickettype) {
            case "atr_receiver": {
                billType = "aef_atrreceiver";
                break;
            }
            case "rai_receiver": {
                billType = "aef_raireceiver";
                break;
            }
            case "bkrs": {
                billType = "aef_bkrs";
                break;
            }
            case "bker_receiver": {
                billType = "aef_bkerreceiver";
                break;
            }
            case "inv_ord_receiver": {
                billType = "aef_invordreceiver";
                break;
            }
            case "inv_spcl_receiver": {
                billType = "aef_invspclreceiver";
                break;
            }
            case "inv_tlf_receiver": {
                billType = "aef_invtlfreceiver";
                break;
            }
            case "ntrev_gpm_receiver": {
                billType = "aef_ntrevgpmreceiver";
                break;
            }
            case "einv_ord_receiver": {
                billType = "aef_einvordreceiver";
                break;
            }
            case "einv_spcl_receiver": {
                billType = "aef_einvspclreceiver";
                break;
            }
            case "efi": {
                billType = "aef_efi";
                break;
            }
        }
        json.remove((Object)"InformationOfAccountingDocumentsTuple");
        DynamicObject dyn = SingleArchiveUtil.getArhievePoolDynamicObject(json, billType, vid, voucherJson, refbillType, refbillId);
        vatInvoiceMap.computeIfAbsent(billType, value -> new HashSet()).add(dyn);
    }

    protected Map<Long, List<Long>> getDapRelation(String billtype, Set<Long> billids) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        QFilter qFilter = new QFilter("billtype", "=", (Object)billtype);
        QFilter qFilter1 = new QFilter("sourcebillid", "in", this.ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.logicunit.fpy.getDapRelation", (String)"ai_daptracker", (String)"voucherid,billtype,sourcebillid", (QFilter[])new QFilter[]{qFilter, qFilter1}, null);){
            for (Row row : dataSet) {
                Long vourcherId = row.getLong("voucherid");
                Long sourcebillid = row.getLong("sourcebillid");
                resultMap.computeIfAbsent(sourcebillid, value -> new ArrayList()).add(vourcherId);
            }
        }
        return resultMap;
    }

    protected void saveArchieveconfig(String billType, String batchCode, String isNeedAttachFile, Map<String, Printsample> refBillAllInfo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_archieveconfig");
        QFilter qFilter = new QFilter("batchcode", "=", (Object)batchCode);
        if (!QueryServiceHelper.exists((String)"aef_archieveconfig", (QFilter[])qFilter.toArray())) {
            DynamicObject dyn = (DynamicObject)type.createInstance();
            dyn.set("billtype", (Object)billType);
            dyn.set("batchcode", (Object)batchCode);
            dyn.set("isneedattachfile", (Object)isNeedAttachFile);
            if (refBillAllInfo != null && !refBillAllInfo.isEmpty()) {
                dyn.set("archiverange_tag", (Object)SerializationUtils.toJsonString(refBillAllInfo));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
    }

    protected void deleteArchieveconfig(String billType, String batchCode) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        if (StringUtils.isNotBlank((CharSequence)batchCode)) {
            qFilters.add(new QFilter("billtype", "=", (Object)billType));
            qFilters.add(new QFilter("batchcode", "=", (Object)batchCode));
            qFilters.add(new QFilter("type", "=", (Object)"1"));
            if (!QueryServiceHelper.exists((String)"aef_acelre", (QFilter[])qFilters.toArray(new QFilter[0]))) {
                DeleteServiceHelper.delete((String)"aef_archieveconfig", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("batchcode", "=", (Object)batchCode)});
            }
        }
    }

    protected void deleteTaxArchieveconfig(String billType, String batchCode) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("billtype", "=", (Object)billType));
        qFilters.add(new QFilter("batchcode", "=", (Object)batchCode));
        qFilters.add(new QFilter("type", "=", (Object)"1"));
        if (!QueryServiceHelper.exists((String)"aef_acelre_tax", (QFilter[])qFilters.toArray(new QFilter[0]))) {
            DeleteServiceHelper.delete((String)"aef_archieveconfig", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("batchcode", "=", (Object)batchCode)});
        }
    }

    public static Map<String, String> initialToken(ArchiveContext context) {
        String uploadUrl = "";
        String noticeUrl = "";
        String deleteUrl = "";
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
        String message = "";
        if (imageConfig == null) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"ArchiveOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]);
            KDBizException kdBizException = new KDBizException(new ErrorCode("9999", message), new Object[0]);
            throw kdBizException;
        }
        String token = FpyOperateUtil.getAppToken(imageConfig);
        if (StringUtils.isEmpty((CharSequence)token)) {
            message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5f52\u6863\u670d\u52a1\u5668\u914d\u7f6e\u6216\u8005\u7f51\u7edc\u3002", (String)"AbstractArchiveLogicUnit_14", (String)"fi-aef-common", (Object[])new Object[0]);
            KDBizException kdBizException = new KDBizException(new ErrorCode("9999", message), new Object[0]);
            throw kdBizException;
        }
        ThreeTuple<String, String, String> url = FpyOperateUtil.getURL(imageConfig, token);
        uploadUrl = (String)url.item1;
        noticeUrl = (String)url.item2;
        deleteUrl = (String)url.item3;
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        resultMap.put("uploadUrl", uploadUrl);
        resultMap.put("noticeUrl", noticeUrl);
        resultMap.put("deleteUrl", deleteUrl);
        resultMap.put("archivesCode", imageConfig.getString("username"));
        return resultMap;
    }

    protected void setAttachmentsRelatedInfo(FpyUploadItem fpyUploadItem, String url) throws IOException {
        byte[] fileData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        fpyUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (fileData = FileUtils.downLoadHttpsFile(url)).length > 0) {
            fpyUploadItem.setFilebase64(this.toBase64(fileData));
            fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(fileData));
            fpyUploadItem.setFileBytes(fileData);
            fpyUploadItem.setFilePath(null);
        }
    }

    protected FpyUploadItem buildPrintFileUploadItem(String archivesCode, String accountBookNo, String accountBookName, String period, String batchNumber, int businessType, String fileName, String url, String institutionIssuesNo, String institutionIssuesName) throws IOException {
        FpyUploadItem fpyUploadItem = new FpyUploadItem(archivesCode, accountBookNo, accountBookName, period, batchNumber, businessType, fileName, null, institutionIssuesNo, institutionIssuesName);
        this.setPrintFileRelatedInfo(fpyUploadItem, url);
        return fpyUploadItem;
    }

    protected void setPrintFileRelatedInfo(FpyUploadItem fpyUploadItem, String url) throws IOException {
        byte[] pdfData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (url.startsWith("configKey=")) {
            url = "tempfile/download.do?" + url;
        }
        fpyUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (pdfData = FileUtils.downLoadFileFromUrl(url)).length > 0) {
            fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(pdfData));
            fpyUploadItem.setFileBytes(pdfData);
            fpyUploadItem.setFilebase64(this.toBase64(pdfData));
            fpyUploadItem.setFilePath(null);
        }
    }

    protected void setAnyFileRelatedInfo(FpyUploadItem fpyUploadItem, String url) throws IOException {
        byte[] pdfData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        fpyUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (pdfData = FileUtils.downLoadAnyUrl(url)).length > 0) {
            fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(pdfData));
            fpyUploadItem.setFileBytes(pdfData);
            fpyUploadItem.setFilebase64(this.toBase64(pdfData));
            fpyUploadItem.setFilePath(null);
        }
    }

    protected void setTempFileRelatedInfo(FpyUploadItem fpyUploadItem, String url) throws IOException {
        byte[] pdfData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        fpyUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (pdfData = FileUtils.downLoadFileFromUrl(url)).length > 0) {
            fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(pdfData));
            fpyUploadItem.setFileBytes(pdfData);
            fpyUploadItem.setFilebase64(this.toBase64(pdfData));
            fpyUploadItem.setFilePath(null);
        }
    }
}

