/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.dowjones;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.DowJonesVideoImp;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.ArchiveInfo;
import kd.fi.aef.entity.FileInfo;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveBillByDowJonesLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveBillByDowJonesLogicUnit.class);

    @Override
    protected void execute() {
        String serviceip = this.context.getServiceIp();
        String serviceport = this.context.getPort();
        BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.billType);
        this.context.setNeedArchiveIds(this.ids);
        String mainOrg = bet.getMainOrg();
        String billNo = QueryFinanceBillHelper.getBillNo(this.billType);
        String period = QueryFinanceBillHelper.getPeriodField(this.billType);
        String selectFields = "id," + billNo + " " + "billno" + "," + mainOrg + " " + "org";
        if (JudgeBillType.isFinaceBill(this.billType)) {
            selectFields = selectFields + "," + period + " " + "period";
        }
        String uploadUrl = DowJonesVideoImp.getServiceUrl("/services/UploadAttachment.ashx", serviceip, serviceport);
        Date date = new Date();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)selectFields, (QFilter[])new QFilter[]{idFilter}, null);
        Map<Long, ArrayList<Map<String, String>>> map = SingleArchiveUtil.getAttachFile(this.billType, this.ids);
        while (set.hasNext()) {
            boolean res;
            Row row = set.next();
            Long billId = row.getLong("id");
            byte[] pdfData = null;
            ArrayList<Object> pks = new ArrayList<Object>(2);
            pks.add(row.get("id"));
            pdfData = FileUtils.getPrintByte(this.pageId, this.billType, this.printId, pks, "billForm", this.printType);
            ArchiveInfo archiveInfo = new ArchiveInfo();
            archiveInfo.setBill(this.billType);
            archiveInfo.setBillid(billId);
            archiveInfo.setBillDowsId(this.billType + billId);
            FileInfo pdfInfo = new FileInfo(this.billType + billId + ".pdf", pdfData);
            archiveInfo.setPdfInfo(pdfInfo);
            if ("1".equals(this.isNeedAttachFile)) {
                ArrayList<Map<String, String>> mapList = map.get(billId);
                ArrayList<FileInfo> attachFiles = new ArrayList<FileInfo>();
                if (mapList != null) {
                    for (Map<String, String> m : mapList) {
                        try {
                            byte[] attachFile = FileUtils.downLoadHttpsFile(m.get("url"));
                            attachFiles.add(new FileInfo(m.get("fileName"), attachFile));
                        }
                        catch (IOException e) {
                            String billName = EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
                            logger.error(String.format("%1$s\u4e0b\u8f7d\u5355\u636e\u9644\u4ef6\u5931\u8d25{%2$s}\u3002", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u8f7d\u5355\u636e\u9644\u4ef6\u5931\u8d25{%2$s}\u3002", (String)"ArchiveBillByDowJonesLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        }
                    }
                }
                archiveInfo.setAttachInfo(attachFiles);
            }
            if (!(res = DowJonesVideoImp.PushFileToDowJones(uploadUrl, archiveInfo))) {
                String billName = EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
                logger.error(String.format("%s\u4e0a\u4f20\u5931\u8d25,\u8bf7\u68c0\u67e5\u9053\u53ef\u7ef4\u65af\u670d\u52a1\u5668\u7f51\u7edc\u8fde\u901a\u6027\u3002", billName));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0a\u4f20\u5931\u8d25,\u8bf7\u68c0\u67e5\u9053\u53ef\u7ef4\u65af\u670d\u52a1\u5668\u7f51\u7edc\u8fde\u901a\u6027\u3002", (String)"ArchiveBillByDowJonesLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), billName));
            }
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordDynamicObject(this.billType, this.application, this.schemeId, row, this.userId, date, this.uploadway, "1", null, null, null, null);
            dynamicObjects.add(temp);
        }
        try (TXHandle tx = TX.requiresNew((String)"ArchiveBillByDowJonesLogicUnit");){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                dynamicObjects.clear();
            }
            catch (Exception e) {
                tx.markRollback();
                String billName = EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
                logger.error(String.format("%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}\u3002", (String)"ArchiveBillByDowJonesLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }
}

