/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.dowjones;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.DowJonesVideoImp;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.ArchiveInfo;
import kd.fi.aef.entity.FileInfo;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveRptByDowJonesLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveRptByDowJonesLogicUnit.class);

    @Override
    protected void execute() {
        String uploadway = this.context.getUploadWay();
        String billType = this.context.getBillType();
        String serviceip = this.context.getServiceIp();
        String serviceport = this.context.getPort();
        String uploadUrl = DowJonesVideoImp.getServiceUrl("/services/UploadAttachment.ashx", serviceip, serviceport);
        Date date = new Date();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        String appId = this.context.getApplicationId();
        String schemeId = this.context.getSchemeId() + "";
        String printSampleId = this.context.getPrintsampleId();
        String id = "";
        int printType = this.context.getPrintType();
        id = ArchiveSchemeHelper.queryPrintId(printSampleId, printType);
        Long orgId = this.context.getOrgId();
        Long periodId = this.context.getPeriodId();
        Long booktypeId = this.context.getBooktypeId();
        String uniqueKey = orgId + "-" + booktypeId + "-" + periodId;
        try (ReportPrintUtil reportUtil = new ReportPrintUtil();){
            String pageId;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", orgId);
            map.put("startperiod", periodId);
            map.put("endperiod", periodId);
            map.put("bookType", booktypeId);
            if ("gl_rpt_subledger".equals(billType)) {
                map.put("isAsynQuery", Boolean.TRUE);
            }
            if (StringUtils.isEmpty((CharSequence)(pageId = reportUtil.simulateReportSearch(billType, map)))) {
                String billName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                logger.error(String.format("%s\u4e0a\u4f20\u5931\u8d25,\u6253\u5370\u62a5\u8868\u5931\u8d25", billName));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0a\u4f20\u5931\u8d25,\u6253\u5370\u62a5\u8868\u5931\u8d25\u3002", (String)"ArchiveRptByDowJonesLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), billName));
            }
            byte[] pdfData = null;
            pdfData = FileUtils.getPrintByte(pageId, billType, id, null, "report", printType);
            ArchiveInfo archiveInfo = new ArchiveInfo();
            archiveInfo.setBill(billType);
            Long periodStr = 0L;
            Long startperiod = (Long)map.get("startperiod");
            Long endperiod = (Long)map.get("endperiod");
            periodStr = startperiod.equals(endperiod) ? startperiod : endperiod;
            archiveInfo.setBillid(periodStr);
            archiveInfo.setBillDowsId(billType + periodStr);
            FileInfo pdfInfo = new FileInfo(billType + periodStr + ".pdf", pdfData);
            archiveInfo.setPdfInfo(pdfInfo);
            boolean res = DowJonesVideoImp.PushFileToDowJones(uploadUrl, archiveInfo);
            if (!res) {
                String billName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                logger.error(String.format("%s\u4e0a\u4f20\u5931\u8d25,\u8bf7\u68c0\u67e5\u9053\u53ef\u7ef4\u65af\u670d\u52a1\u5668\u7f51\u7edc\u8fde\u901a\u6027\u3002", billName));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0a\u4f20\u5931\u8d25,\u8bf7\u68c0\u67e5\u9053\u53ef\u7ef4\u65af\u670d\u52a1\u5668\u7f51\u7edc\u8fde\u901a\u6027\u3002", (String)"ArchiveRptByDowJonesLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), billName));
            }
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordRptDynamicObject(billType, appId, schemeId, map, date, uploadway, periodStr, this.userId, "1", null, null, uniqueKey, this.batchCode, booktypeId);
            dynamicObjects.add(temp);
        }
        var18_18 = null;
        try (TXHandle tx = TX.requiresNew((String)"ArchiveRptByDowJonesLogicUnit");){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                dynamicObjects.clear();
            }
            catch (Exception e) {
                tx.markRollback();
                String billName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                logger.error(String.format("%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}\u3002", (String)"ArchiveRptByDowJonesLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
    }
}

