/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.PrintContext;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.logic.common.FPYXmlUtils;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveCasReportByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveCasReportByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveCasReportByFpyLogicUnit";
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);

    @Override
    protected void execute() {
        String xmlStr;
        int businessType = this.getBusinessType(this.billType);
        ArrayList<Map<String, String>> xmlList = new ArrayList<Map<String, String>>();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org", (String)"number,name");
        String orgName = org.getString("name");
        String orgNumber = org.getString("number");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.periodId, (String)"bd_period", (String)"number,name");
        String periodName = period.getString("name");
        String periodNumber = CreateXmlUtil.dealPeriodNumber(period.getString("number"));
        String desc = this.billType + "_" + orgNumber + "_" + periodNumber;
        String fileName = desc + ".pdf";
        FpyUploadItem fpyUploadItem = new FpyUploadItem();
        Map<String, Object> paramMap = null;
        Set rptDataFileUrlSet = new HashSet(16);
        if ("2".equals(this.isReverse)) {
            fpyUploadItem = new FpyUploadItem(this.archivesCode, orgNumber, orgName, periodNumber, this.batchCode, businessType, fileName, null);
        } else {
            paramMap = this.getRequestCasRptParamMap();
            rptDataFileUrlSet = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"JournalRptDataService", (String)"getJournalRptDataFileUrl", (Object[])new Object[]{paramMap});
            logger.info("billName: {}, journalRptDataFileUrl: {}", (Object)this.billName, rptDataFileUrlSet);
            for (String rptDataFileUrl : rptDataFileUrlSet) {
                try {
                    fpyUploadItem = this.buildPrintFileUploadItem(this.archivesCode, orgNumber, orgName, periodNumber, this.batchCode, businessType, fileName, rptDataFileUrl, null, null);
                }
                catch (IOException e) {
                    logger.error(String.format("\u6839\u636e rptDataFileUrl %1$s \u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25 {%2$s}\u3002", rptDataFileUrl, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e rptDataFileUrl %1$s \u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25 {%2$s}\u3002", (String)"ArchiveCasReportByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), rptDataFileUrl, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
                this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
            }
        }
        if ("1".equals(this.isReverse) && rptDataFileUrlSet.size() == 0) {
            String hasArchiveCountKey = this.context.getPageId() + "hasarchievecount";
            String countString = this.cache.get(hasArchiveCountKey);
            int count = countString == null ? 0 : Integer.parseInt(countString);
            this.cache.put(hasArchiveCountKey, count - 1 + "");
            this.context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        String billId = this.periodId + "";
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        xmlMap.put("billid", billId);
        xmlMap.put("period", periodNumber);
        xmlMap.put("voucherorgname", orgName);
        xmlMap.put("voucherorgnumber", orgNumber);
        xmlMap.put("file", fileName);
        xmlMap.put("subjno", "0");
        xmlMap.put("subj", "0");
        xmlList.add(xmlMap);
        try {
            String fileDesc = this.getFileDesc(this.billType, orgName, periodName);
            xmlStr = FPYXmlUtils.createCasRptXml(fileDesc, xmlList, this.flag);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveGeneralledByFpyLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        fpyUploadItem.setFilebase64(xmlStr);
        String xmlFileName = desc + "_" + this.batchCode + ".xml";
        fpyUploadItem.setFileName(xmlFileName);
        fpyUploadItem.setBillidsMap(Collections.singletonMap(this.periodId + "." + this.periodId + "", orgName + periodName + this.billName));
        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        String uniqueKey = this.orgId + "-" + this.periodId;
        this.context.setNeedArchiveIds(Collections.singleton(this.periodId));
        if ("1".equals(this.isReverse)) {
            Date date = new Date();
            DynamicObject dynamicObject = SingleArchiveUtil.getArhieveRecordRptDynamicObject(this.billType, this.application, this.schemeId, paramMap, date, this.uploadway, this.periodId, this.userId, "1", null, null, uniqueKey, this.batchCode, this.booktypeId);
            this.saveReportObjects(CLASS_NAME, Collections.singletonList(dynamicObject), this.billType, this.billName, uniqueKey);
        } else {
            this.updateRptRecordToReserve(CLASS_NAME, uniqueKey, this.billType, this.context.getReverseReason(), this.batchCode);
        }
        this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
    }

    private Map<String, Object> getRequestCasRptParamMap() {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(this.orgId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formid", this.billType);
        paramMap.put("queryorgtype", "org");
        List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
        String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
        paramMap.put("templateId", print);
        paramMap.put("printlang", PrintContext.get().getLang());
        paramMap.put("org", orgIdList);
        paramMap.put("iscontainclosed", Boolean.TRUE);
        paramMap.put("datetype", "1");
        paramMap.put("beginperiod", this.periodId);
        paramMap.put("endperiod", this.periodId);
        paramMap.put("radiogroup", "1");
        return paramMap;
    }

    private String getFileDesc(String billType, String orgName, String periodName) {
        String fileDesc;
        switch (billType) {
            case "cas_bankjournalformrpt": {
                fileDesc = String.format(ResManager.loadKDString((String)"%s \u94f6\u884c\u65e5\u8bb0\u8d26(\u62a5\u8868)", (String)"ArchiveCasReportByFpyLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), orgName + periodName);
                break;
            }
            case "cas_cashjournalformrpt": {
                fileDesc = String.format(ResManager.loadKDString((String)"%s \u73b0\u91d1\u65e5\u8bb0\u8d26(\u62a5\u8868)", (String)"ArchiveCasReportByFpyLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), orgName + periodName);
                break;
            }
            default: {
                fileDesc = "";
            }
        }
        return fileDesc;
    }

    private int getBusinessType(String billType) {
        int i;
        switch (billType) {
            case "cas_bankjournalformrpt": {
                i = 17;
                break;
            }
            case "cas_cashjournalformrpt": {
                i = 18;
                break;
            }
            default: {
                i = 0;
            }
        }
        return i;
    }
}

