/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveElecstatementWithVATinvoice
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveElecstatementWithVATinvoice.class);
    private static final String CLASS_NAME = "ArchiveElecstatementWithVATinvoice";

    @Override
    protected void execute() {
        BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.billType);
        String dateField = this.context.getDateField();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        String mainOrg = bet.getMainOrg();
        String billnoField = QueryFinanceBillHelper.getBillNo(this.billType);
        String selectFileds = "id," + dateField + " datefield," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + billnoField + " billno,period, currency.number currency, accountbankname accountname, accountbank.number accountno";
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)selectFileds, (QFilter[])new QFilter[]{idFilter}, null);
        DataSet xmlSet = set.copy();
        HashMap<Long, List<Attach>> attachMap = new HashMap<Long, List<Attach>>(16);
        HashMap<Long, List<DynamicObject>> entryRows = new HashMap<Long, List<DynamicObject>>(16);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)this.billType, (String)"id, entryentity.e_bookdate accounttime, entryentity.e_balancedirection tradetype, entryentity.e_debitamount debitamount, entryentity.e_creditamount creditamount, entryentity.e_acctamount accountbalance,entryentity.e_oppositeacct oppositeaccount, entryentity.e_oppositeacctname oppositename, entryentity.e_remark abstract, entryentity.e_sourcedocumentno voucherNum, entryentity.e_bookjournal tradeid", (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject dynamicObject : dyns) {
            Long pkId = dynamicObject.getLong("id");
            ArrayList attachs = new ArrayList();
            attachMap.put(pkId, attachs);
            entryRows.computeIfAbsent(pkId, Value -> new ArrayList()).add(dynamicObject);
        }
        Date date = new Date();
        String orgNo = "";
        String orgName = "";
        String dateStr = "";
        HashMap<Long, String> billFileNameMap = new HashMap<Long, String>(100);
        FpyUploadItem fpyUploadItem = new FpyUploadItem();
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"ArchiveMultGlvoucherByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, this.ids.size(), Thread.currentThread().getName());
        HashSet<Long> needArchiveIds = new HashSet<Long>(16);
        Map<String, DynamicObject> receiptPlgins = this.getTypeWithReceipt();
        HashMap<String, Set<DynamicObject>> vatInvoiceMap = new HashMap<String, Set<DynamicObject>>(16);
        Map<Long, List<JSONObject>> jsonMap = ElecreceiptUtils.findReceiptJson(this.billType, this.ids, receiptPlgins, this.pageId);
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        while (set.hasNext()) {
            Row row = set.next();
            Long billId = row.getLong("id");
            String billNo = row.getString(billnoField);
            billidsMap.put(billId + "." + billId.toString(), this.billName + billNo);
            orgNo = row.getString("orgnumber");
            orgName = row.getString("orgname");
            try {
                dateStr = new SimpleDateFormat("yyyy-MM").format(row.getDate("datefield"));
            }
            catch (Exception e) {
                logger.error(String.format("%1$s\u65e5\u671f\u5b57\u6bb5\u8f6c\u6362\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u65e5\u671f\u5b57\u6bb5\u8f6c\u6362\u5931\u8d25{%2$s}\u3002", (String)"ArchiveCommonBillByFpyLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            fpyUploadItem = new FpyUploadItem(this.archivesCode, orgNo, orgName, dateStr, this.batchCode, 20, null, null);
            List<Object> jsons = new ArrayList(16);
            if (jsonMap != null && jsonMap.size() > 0) {
                jsons = jsonMap.get(billId);
            }
            List attachs = (List)attachMap.get(billId);
            if (jsons != null && jsons.size() > 0) {
                try {
                    for (JSONObject jSONObject : jsons) {
                        String url = jSONObject.getString("url");
                        if ("1".equals(this.isReverse)) {
                            if (StringUtils.isNotBlank((CharSequence)url)) {
                                billFileNameMap.put(billId, ElecreceiptUtils.getFileName(url));
                                fpyUploadItem = new FpyUploadItem(this.archivesCode, orgNo, orgName, dateStr, this.batchCode, 20, ElecreceiptUtils.getFileName(url), null);
                                this.setAttachmentsRelatedInfo(fpyUploadItem, url);
                                this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                            }
                            byte[] xbrlData = FileUtils.json2Xbrl(jSONObject.toJSONString(), "bkrs");
                            fpyUploadItem.setFilebase64(this.toBase64(xbrlData));
                            fpyUploadItem.setFileName(billId + "_" + ContextUtil.createXBRLFilename("bkrs", jSONObject));
                            fpyUploadItem.setBusinessType(20);
                            fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(xbrlData));
                            fpyUploadItem.setFileBytes(xbrlData);
                            this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                            jSONObject.put("org", (Object)row.getLong("org"));
                            jSONObject.put("sourcebillno", (Object)row.getString(billnoField));
                            jSONObject.put("tickettype", (Object)"bkrs");
                            jSONObject.put("billid", (Object)billId);
                            this.insertInvoicePool(vatInvoiceMap, jSONObject, "bkrs", null, null, null, null);
                        }
                        Attach attach = new Attach();
                        attach.setFileName(ContextUtil.createXBRLFilename("bkrs", jSONObject));
                        attachs.add(attach);
                    }
                }
                catch (IOException e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5931\u8d25{%2$s}", (String)"ArchiveElecstatementWithVATinvoice_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
            }
            needArchiveIds.add(billId);
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordDynamicObject(this.billType, this.application, this.schemeId, row, this.userId, date, this.uploadway, "1", null, row.getDate("datefield"), null, this.batchCode);
            dynamicObjects.add(temp);
        }
        this.context.setNeedArchiveIds(needArchiveIds);
        String xmlstr = "";
        try {
            xmlstr = CreateXmlUtil.createElecXml(xmlSet, billFileNameMap, this.billName, attachMap, this.billType, entryRows, this.flag);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%s\u7684\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}", (String)"ArchiveElecstatementWithVATinvoice_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = String.format(ResManager.loadKDString((String)"%s\u5355\u636e", (String)"ArchiveElecstatementWithVATinvoice_1", (String)"fi-aef-common", (Object[])new Object[0]), orgName + dateStr);
        fpyUploadItem.setFilebase64(xmlstr);
        fpyUploadItem.setBusinessType(20);
        fpyUploadItem.setFileName(desc + this.batchCode + ".xml");
        fpyUploadItem.setBillidsMap(billidsMap);
        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        try (TXHandle h = TX.required((String)CLASS_NAME);){
            try {
                if ("1".equals(this.isReverse)) {
                    this.saveDynamicObjects(CLASS_NAME, dynamicObjects, this.billName, this.ids, this.billType);
                    this.saveArchieveconfig(this.billType, this.batchCode, this.isNeedAttachFile, null);
                    this.saveInvoice(vatInvoiceMap);
                } else {
                    this.updateRecordToReserve(CLASS_NAME, this.ids, this.billType, this.context.getReverseReason(), this.batchCode);
                    this.deleteArchieveconfig(this.billType, this.context.getBatchcode());
                    this.deleteBkrs(needArchiveIds);
                }
                this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }

    private Map<String, DynamicObject> getTypeWithReceipt() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isinvoice", "!=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }
}

