/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveFacardfinByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final String SELECT_FIELDS = "id,billno,period.id period,period.name periodname,period.number periodnumber,org.id org,org.name orgname,org.number orgnumber,assetbook.depreuse.name depreusename,assetbook.depreuse.number depreusenumber, realcard.number assetcode, realcard.assetname assetname, realcard.assetcat.name  assettype,realcard.headusedept.name usedept, realcard.usedate usestarttime, depremethod.name depreciation, originalval originalvalue, basecurrency.number currency";
    private static final Log logger = LogFactory.getLog(ArchiveFacardfinByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveFacardfinByFpyLogicUnit";

    @Override
    protected void execute() {
        ArrayList<DynamicObject> errDyns = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveFacardfinByFpyLogicUnit.excute", (String)this.billType, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{idFilter}, null);
        HashMap<Long, List<Attach>> attachMap = new HashMap();
        if ("1".equals(this.isNeedAttachFile)) {
            attachMap = SingleArchiveUtil.getIdAndAttacheFiles("fa_card_fin", this.ids);
        }
        DataSet xmlDataSet = set.copy();
        Date date = new Date();
        String desc = "";
        String xmlFileName = "";
        FpyUploadItem fpyUploadItem = new FpyUploadItem();
        HashMap<Long, String> billFileNameMap = new HashMap<Long, String>(100);
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"ArchiveMultGlvoucherByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, this.ids.size(), Thread.currentThread().getName());
        HashSet<Long> needArchiveIds = new HashSet<Long>(16);
        needArchiveIds.addAll(this.ids);
        HashSet<Long> errIds = new HashSet<Long>(16);
        String accountBookNo = "";
        String accountBookName = "";
        String period = "";
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        while (set.hasNext()) {
            Row row;
            block18: {
                Object string;
                row = set.next();
                Long billId = row.getLong("id");
                String billNo = row.getString("billno");
                billidsMap.put(billId + "." + billId.toString(), this.billName + billNo);
                desc = String.format(ResManager.loadKDString((String)"%s\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247", (String)"ArchiveFacardfinByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), row.getString("orgname") + row.getString("depreusename") + row.getString("periodname"));
                accountBookNo = row.getString("orgnumber");
                accountBookName = row.getString("orgname");
                if (this.isSplitbook && this.context.isAws()) {
                    accountBookNo = accountBookNo + row.getString("depreusenumber");
                    accountBookName = accountBookName + row.getString("depreusename");
                }
                String institutionIssuesNo = "fa_" + row.getString("depreusenumber");
                String institutionIssuesName = row.getString("depreusename");
                period = CreateXmlUtil.dealPeriodNumber(row.getString("periodnumber"));
                xmlFileName = this.billType + "_" + accountBookNo + "_" + period + "_";
                String fileName = this.billType + "_" + billId + ".pdf";
                billFileNameMap.put(billId, fileName);
                if ("2".equals(this.isReverse)) {
                    fpyUploadItem = new FpyUploadItem(this.archivesCode, accountBookNo, accountBookName, period, this.batchCode, 7, fileName, null, institutionIssuesNo, institutionIssuesName);
                    continue;
                }
                ArrayList<Object> pks = new ArrayList<Object>(2);
                pks.add(row.get("id"));
                try {
                    String pdfUrl = null;
                    if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, this.printId, pks, "billForm", this.printType);
                    } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(row.get("id")))) {
                        PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(row.get("id"));
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
                    } else {
                        errIds.add(billId);
                        needArchiveIds.remove(billId);
                        string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveCommonBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, row.getString("billno"));
                        errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), (String)string));
                        continue;
                    }
                    fpyUploadItem = this.buildPrintFileUploadItem(this.archivesCode, accountBookNo, accountBookName, period, this.batchCode, 7, fileName, pdfUrl, institutionIssuesNo, institutionIssuesName);
                    this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
                catch (Exception e) {
                    errIds.add(billId);
                    needArchiveIds.remove(billId);
                    string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveCommonBillLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billId, e);
                    errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), (String)string));
                    logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    continue;
                }
                List attaches = (List)attachMap.get(billId);
                try {
                    if (attaches == null) break block18;
                    for (Attach attach : attaches) {
                        String url = attach.getUrl();
                        fpyUploadItem.setFileName(billId + "_" + attach.getFileName());
                        this.setAttachmentsRelatedInfo(fpyUploadItem, url);
                        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                    }
                }
                catch (IOException e) {
                    errIds.add(billId);
                    needArchiveIds.remove(billId);
                    String string2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u9644\u4ef6\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveFacardfinByFpyLogicUnit_8", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billId, e.getMessage());
                    errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string2));
                    logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    logger.error(String.format("%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    continue;
                }
            }
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordDynamicObject(this.billType, this.application, this.schemeId, row, this.userId, date, this.uploadway, "1", null, null, null, this.batchCode);
            dynamicObjects.add(temp);
        }
        this.context.setNeedArchiveIds(needArchiveIds);
        String xmlstr = "";
        try {
            xmlstr = CreateXmlUtil.createFacardfinXml(xmlDataSet, desc, billFileNameMap, attachMap, this.flag, errIds);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveFacardfinByFpyLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        fpyUploadItem.setFilebase64(xmlstr);
        fpyUploadItem.setFileName(xmlFileName + this.batchCode + ".xml");
        fpyUploadItem.setBillidsMap(billidsMap);
        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        if ("1".equals(this.isReverse)) {
            this.saveDynamicObjects(CLASS_NAME, dynamicObjects, this.billName, this.ids, this.billType);
            this.saveArchieveconfig(this.billType, this.batchCode, this.isNeedAttachFile, null);
        } else {
            this.updateRecordToReserve(CLASS_NAME, this.ids, this.billType, this.context.getReverseReason(), this.batchCode);
            this.deleteArchieveconfig(this.billType, this.context.getBatchcode());
        }
        if (errDyns.size() > 0) {
            LogUtil.saveErrorLog(errDyns);
        }
        this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
    }
}

