/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveGeneralledByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveGeneralledByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveGeneralledByFpyLogicUnit";

    @Override
    protected void execute() {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        Date date = new Date();
        String uniqueKey = this.orgId + "-" + this.booktypeId + "-" + this.periodId;
        FpyUploadItem fpyUploadItem = new FpyUploadItem();
        try (ReportPrintUtil reportUtil = new ReportPrintUtil();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", this.orgId);
            map.put("startperiod", this.periodId);
            map.put("endperiod", this.periodId);
            map.put("bookType", this.booktypeId);
            map.put("currency", "allcurrency");
            ArrayList<Map<String, String>> xmlList = new ArrayList<Map<String, String>>();
            String filedesc = "";
            String xmlFileName = "";
            map.put("isAsynQuery", Boolean.FALSE);
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org", (String)"number,name");
            String orgName = org.getString("name");
            String orgNumber = org.getString("number");
            DynamicObject booktype = BusinessDataServiceHelper.loadSingleFromCache((Object)this.booktypeId, (String)"bd_accountbookstype", (String)"number,name");
            String booktypeName = booktype.getString("name");
            String booktypeNumber = booktype.getString("number");
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.periodId, (String)"bd_period", (String)"number,name");
            String periodName = period.getString("name");
            String periodNumber = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(period.getString("number")) : CreateXmlUtil.dealAdjustmentPeriodNumber(period.getString("number"));
            String accountBookNo = orgNumber;
            String accountBookName = orgName;
            if (this.isSplitbook && this.context.isAws()) {
                accountBookNo = accountBookNo + booktypeNumber;
                accountBookName = accountBookName + booktypeName;
            }
            String institutionIssuesNo = "gl_" + booktypeNumber;
            String desc = this.billType + "_" + orgNumber + "_" + booktypeNumber + "_" + periodNumber;
            String fileName = desc + ".pdf";
            filedesc = String.format(ResManager.loadKDString((String)"%s\u603b\u8d26", (String)"ArchiveGeneralledByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), orgName + booktypeName + periodName);
            xmlFileName = desc + "_" + this.batchCode + ".xml";
            if ("2".equals(this.isReverse)) {
                fpyUploadItem = new FpyUploadItem(this.archivesCode, accountBookNo, accountBookName, periodNumber, this.batchCode, 8, fileName, null, institutionIssuesNo, booktypeName);
            } else {
                String pageid = reportUtil.simulateReportSearch(this.billType, map);
                String pdfUrl = null;
                if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                    pdfUrl = FileUtils.getPrintUrl(pageid, this.billType, this.printId, null, "report", this.printType);
                } else {
                    List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                    String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
                    pdfUrl = FileUtils.getPrintUrl(pageid, this.billType, print, null, "report", ((PrintTemplate)templateList.get(0)).getPrintType());
                }
                try {
                    fpyUploadItem = this.buildPrintFileUploadItem(this.archivesCode, accountBookNo, accountBookName, periodNumber, this.batchCode, 8, fileName, pdfUrl, institutionIssuesNo, booktypeName);
                }
                catch (IOException e) {
                    logger.error(String.format("%1$s %2$s\uff0c%3$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%4$s}", accountBookName, periodName, this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s\uff0c%3$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%4$s}", (String)"ArchiveGeneralledByFpyLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), accountBookName, periodName, this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
                this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
            }
            String billId = this.periodId + "";
            HashMap<String, String> xmlMap = new HashMap<String, String>();
            xmlMap.put("billid", billId);
            xmlMap.put("period", periodNumber);
            xmlMap.put("periodname", periodName);
            xmlMap.put("voucherorgname", accountBookName);
            xmlMap.put("voucherorgnumber", accountBookNo);
            xmlMap.put("file", fileName);
            xmlList.add(xmlMap);
            String xmlstr = "";
            try {
                xmlstr = CreateXmlUtil.createGeneralledgerXml(filedesc, xmlList, this.flag);
            }
            catch (Exception e) {
                logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveGeneralledByFpyLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            fpyUploadItem.setFilebase64(xmlstr);
            fpyUploadItem.setFileName(xmlFileName);
            fpyUploadItem.setBillidsMap(this.getGeneralBillidsMap(xmlList));
            this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordRptDynamicObject(this.billType, this.application, this.schemeId, map, date, this.uploadway, this.periodId, this.userId, "1", null, null, uniqueKey, this.batchCode, this.booktypeId);
            dynamicObjects.add(temp);
            this.context.setNeedArchiveIds(Collections.singleton(this.periodId));
            if ("1".equals(this.isReverse)) {
                this.saveReportObjects(CLASS_NAME, dynamicObjects, this.billType, this.billName, uniqueKey);
            } else {
                this.updateRptRecordToReserve(CLASS_NAME, uniqueKey, this.billType, this.context.getReverseReason(), this.batchCode);
            }
            this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
        }
    }

    private Map<String, String> getGeneralBillidsMap(List<Map<String, String>> xmlList) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(xmlList.size());
        for (Map<String, String> map : xmlList) {
            billidsMap.put(map.get("billid") + "." + map.get("billid"), map.get("voucherorgname") + map.get("periodname") + this.billName);
        }
        return billidsMap;
    }
}

