/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveGeneralledByFpyLogicUnitNew
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveGeneralledByFpyLogicUnitNew.class);
    private static final String CLASS_NAME = "ArchiveGeneralledByFpyLogicUnit";
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);

    @Override
    protected void execute() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", this.orgId);
        map.put("startperiod", this.periodId);
        map.put("endperiod", this.periodId);
        map.put("bookType", this.booktypeId);
        map.put("accountlevel", 1);
        Set<Object> accountIdList = new HashSet(16);
        if (StringUtils.isNotEmpty((CharSequence)this.context.getArchiverange())) {
            List list = (List)SerializationUtils.deSerializeFromBase64((String)this.context.getArchiverange());
            List list2 = list.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
            accountIdList = new HashSet(list2);
        } else {
            accountIdList = SingleArchiveUtil.getAllFirstLevelAccountId(map);
        }
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accountview", (String)"id,name,number", (QFilter[])new QFilter("id", "in", accountIdList).toArray(), (String)"number");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org", (String)"number,name");
        DynamicObject booktype = BusinessDataServiceHelper.loadSingleFromCache((Object)this.booktypeId, (String)"bd_accountbookstype", (String)"number,name");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.periodId, (String)"bd_period", (String)"number,name");
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        ArrayList<Map<String, String>> xmlList = new ArrayList<Map<String, String>>();
        ArrayList<String> uniqueKeys = new ArrayList<String>(16);
        ArrayList<Long> accountIds = new ArrayList<Long>();
        HashMap<String, String> accountIdsMap = new HashMap<String, String>();
        for (DynamicObject dyn : dyns) {
            this.execute(dyn, org, booktype, period, xmlList, dynamicObjects, uniqueKeys, accountIds, accountIdsMap, dyns.size());
        }
    }

    protected void execute(DynamicObject account, DynamicObject org, DynamicObject booktype, DynamicObject period, List<Map<String, String>> xmlList, List<DynamicObject> dynamicObjects, List<String> uniqueKeys, List<Long> accountIds, Map<String, String> accountIdsMap, int size) {
        Long accountId = account.getLong("id");
        String accountName = account.getString("name");
        String accountNumber = account.getString("number");
        Date date = new Date();
        String uniqueKey = this.orgId + "-" + this.booktypeId + "-" + this.periodId;
        FpyUploadItem fpyUploadItem = new FpyUploadItem();
        try (ReportPrintUtil reportUtil = new ReportPrintUtil();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", this.orgId);
            map.put("startperiod", this.periodId);
            map.put("endperiod", this.periodId);
            map.put("bookType", this.booktypeId);
            map.put("account", new Long[]{accountId});
            map.put("currency", "allcurrency");
            String filedesc = "";
            String xmlFileName = "";
            map.put("isAsynQuery", Boolean.FALSE);
            String orgName = org.getString("name");
            String orgNumber = org.getString("number");
            String booktypeName = booktype.getString("name");
            String booktypeNumber = booktype.getString("number");
            String periodName = period.getString("name");
            String periodNumber = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(period.getString("number")) : CreateXmlUtil.dealAdjustmentPeriodNumber(period.getString("number"));
            String accountBookNo = orgNumber;
            String accountBookName = orgName;
            if (this.isSplitbook && this.context.isAws()) {
                accountBookNo = accountBookNo + booktypeNumber;
                accountBookName = accountBookName + booktypeName;
            }
            String institutionIssuesNo = "gl_" + booktypeNumber;
            String desc = this.billType + "_" + orgNumber + "_" + booktypeNumber + "_" + periodNumber;
            String fileName = desc + "_" + accountNumber + ".pdf";
            filedesc = String.format(ResManager.loadKDString((String)"%s\u603b\u8d26", (String)"ArchiveGeneralledByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), orgName + booktypeName + periodName);
            xmlFileName = desc + "_" + this.batchCode + ".xml";
            accountIds.add(accountId);
            accountIdsMap.put(accountId + "." + accountId + "", accountBookName + periodName + this.billName + accountNumber);
            String pageid = reportUtil.simulateReportSearch(this.billType, map);
            logger.info("accountId:{} pageId:{}", (Object)accountId, (Object)pageid);
            fpyUploadItem = new FpyUploadItem(this.archivesCode, accountBookNo, accountBookName, periodNumber, this.batchCode, 8, fileName, null, institutionIssuesNo, booktypeName);
            if (pageid != null) {
                String uniqueKey2 = uniqueKey + "-" + accountId;
                uniqueKeys.add(uniqueKey2);
                if (!"2".equals(this.isReverse)) {
                    String pdfUrl = null;
                    if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                        pdfUrl = FileUtils.getPrintUrl(pageid, this.billType, this.printId, null, "report", this.printType);
                    } else {
                        List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                        String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
                        pdfUrl = FileUtils.getPrintUrl(pageid, this.billType, print, null, "report", ((PrintTemplate)templateList.get(0)).getPrintType());
                    }
                    try {
                        fpyUploadItem = this.buildPrintFileUploadItem(this.archivesCode, accountBookNo, accountBookName, periodNumber, this.batchCode, 8, fileName, pdfUrl, institutionIssuesNo, booktypeName);
                    }
                    catch (IOException e) {
                        logger.error(String.format("%1$s %2$s %3$s\uff0c%4$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%5$s}", accountBookName, periodName, accountNumber, this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff0c%4$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%5$s}", (String)"ArchiveGeneralledByFpyLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), accountBookName, periodName, accountNumber, this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    }
                    this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
                String billId = accountId + "";
                HashMap<String, String> xmlMap = new HashMap<String, String>();
                xmlMap.put("billid", billId);
                xmlMap.put("period", periodNumber);
                xmlMap.put("periodname", periodName);
                xmlMap.put("voucherorgname", accountBookName);
                xmlMap.put("voucherorgnumber", accountBookNo);
                xmlMap.put("subjno", accountNumber);
                xmlMap.put("subj", accountName);
                xmlMap.put("file", fileName);
                xmlList.add(xmlMap);
                DynamicObject temp = SingleArchiveUtil.getArhieveSubledDynamicObject(this.billType, accountNumber, this.application, this.schemeId, map, date, this.uploadway, this.periodId, this.userId, "1", null, null, uniqueKey2, this.batchCode, this.booktypeId);
                dynamicObjects.add(temp);
            }
            if (accountIds.size() < size) {
                return;
            }
            if ("2".equals(this.context.getIsReverse())) {
                this.context.setNeedArchiveIds(new HashSet<Long>(accountIds));
            } else {
                this.context.setNeedArchiveIds(Collections.singleton(this.periodId));
            }
            if (xmlList.size() == 0) {
                String hasarchieveCountKey = this.context.getPageId() + "hasarchievecount";
                String countString = this.cache.get(hasarchieveCountKey);
                int count = countString == null ? 0 : Integer.parseInt(countString);
                this.cache.put(hasarchieveCountKey, count - 1 + "");
                this.context.setNeedArchiveIds(new HashSet<Long>());
                return;
            }
            String xmlstr = "";
            try {
                xmlstr = CreateXmlUtil.createGeneralledgerXml(filedesc, xmlList, this.flag);
            }
            catch (Exception e) {
                logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveGeneralledByFpyLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            fpyUploadItem.setFilebase64(xmlstr);
            fpyUploadItem.setFileName(xmlFileName);
            fpyUploadItem.setBillidsMap(accountIdsMap);
            this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
            if ("1".equals(this.isReverse)) {
                this.saveSubObjects(CLASS_NAME, dynamicObjects, this.billType, this.billName, uniqueKeys);
            } else {
                this.updateSubleToReserve(CLASS_NAME, uniqueKeys, this.billType, this.context.getReverseReason(), this.batchCode);
            }
            this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
        }
    }
}

