/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.AefUtil;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.elec.util.ElecConfigUtil;
import kd.fi.aef.elec.util.XbrlArchieveUtil;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.entity.BillInfo;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.Printsample;
import kd.fi.aef.entity.Task;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveMultGlvoucherByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveMultGlvoucherByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveMultGlvoucherByFpyLogicUnit";
    private static final String SEQNO = "seqNo";
    private static final String INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE = "InformationOfAccountingDocumentsTuple";
    private String period;
    private String accountBookNo;
    private String accountBookName;
    private FpyUploadItem fpyUploadItem;
    private String xmlstr;
    private String xmlDesc;
    private Map<Long, Map<String, Set<Long>>> linkUpBills;
    private Map<Long, Set<String>> voucherInvoiceMap = new HashMap<Long, Set<String>>(16);
    private Set<Long> needArchiveIds = new HashSet<Long>(16);
    private Map<String, Map<Long, List<String>>> imageNumberMap = new HashMap<String, Map<Long, List<String>>>();
    private Map<String, Object> imageMap = new HashMap<String, Object>();
    private Map<Long, List<Attach>> attachMap = new HashMap<Long, List<Attach>>(16);
    private Map<Long, List<Attach>> refAttachMap = new HashMap<Long, List<Attach>>(16);
    private Map<String, Set<String>> VATBillTypes = new HashMap<String, Set<String>>(16);
    private Set<String> isreceiptSet = new HashSet<String>(16);
    Map<String, Set<Long>> isreceiptBilltypeAndIds = new HashMap<String, Set<Long>>();
    private Map<Long, String> voucherFileNameMap = new HashMap<Long, String>(100);
    private Map<String, String> refBillTempInfo = new HashMap<String, String>(16);
    private Map<String, Printsample> refBillAllInfo = new HashMap<String, Printsample>(16);
    private Map<Long, JSONObject> voucherHeadJson = new HashMap<Long, JSONObject>(16);
    private Map<Long, JSONObject> voucherJson = new HashMap<Long, JSONObject>(16);
    private Map<String, Set<DynamicObject>> vatInvoiceMap = new HashMap<String, Set<DynamicObject>>(16);
    private List<DynamicObject> errDyns = new ArrayList<DynamicObject>(16);
    private Set<String> refBillTypes = new HashSet<String>(16);
    private Map<String, String> refBillTypesAndNames = new HashMap<String, String>(16);
    private Map<Long, BillInfo> voucherInfoMap = new HashMap<Long, BillInfo>(16);

    @Override
    protected void execute() {
        String SELECT_FIELDS = ArchiveUtil.getSelectFields(this.billType, null);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(100);
        QFilter idFilter = new QFilter("id", "=", this.ids.iterator().next());
        DynamicObject dyn = QueryServiceHelper.queryOne((String)this.billType, (String)"id,billno,org.id org,org.number orgnumber, org.name orgname,period.number periodnumber,period.name periodname, booktype.number booktypenumber, booktype.name booktypename", (QFilter[])new QFilter[]{idFilter});
        Date date = new Date();
        this.accountBookNo = dyn.getString("orgnumber");
        this.accountBookName = dyn.getString("orgname");
        if (this.isSplitbook && this.context.isAws()) {
            this.accountBookNo = this.accountBookNo + dyn.getString("booktypenumber");
            this.accountBookName = this.accountBookName + dyn.getString("booktypename");
        }
        String institutionIssuesNo = "gl_" + dyn.getString("booktypenumber");
        String institutionIssuesName = dyn.getString("booktypename");
        if ("2".equals(this.isReverse)) {
            this.pageId = Task.createTaskId();
        }
        this.period = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(dyn.getString("periodnumber")) : CreateXmlUtil.dealAdjustmentPeriodNumber(dyn.getString("periodnumber"));
        this.fpyUploadItem = new FpyUploadItem(this.archivesCode, this.accountBookNo, this.accountBookName, this.period, this.batchCode, 1, null, null, institutionIssuesNo, institutionIssuesName);
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"ArchiveMultGlvoucherByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, this.ids.size(), Thread.currentThread().getName());
        this.VATBillTypes = ElecConfigUtil.getVATBillTypes();
        this.isreceiptSet = ElecConfigUtil.ALL_REC_BILL;
        this.refBillTempInfo = this.context.getRefBillTempInfo();
        this.refBillAllInfo = this.context.getRefBillAllInfo();
        this.linkUpBills = AefUtil.getLinkUpBills(this.ids);
        if (this.refBillTempInfo != null && !this.refBillTempInfo.isEmpty()) {
            this.refBillTypes = this.refBillTempInfo.keySet();
        }
        this.refBillTypesAndNames = this.refBillTypes.stream().collect(Collectors.toMap(refBillType -> refBillType, refBillType -> EntityMetadataCache.getDataEntityType((String)refBillType).getDisplayName().toString()));
        this.isreceiptBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, this.isreceiptSet);
        this.archiveReceipt(this.isreceiptBilltypeAndIds);
        if (Boolean.TRUE.equals(this.isxbrlpilot)) {
            if (this.multarchive) {
                this.needArchiveIds.addAll(this.ids);
                this.archiveGlVoucher();
            }
            this.archiveXbrl();
        } else {
            this.needArchiveIds.addAll(this.ids);
            this.archiveGlVoucher();
        }
        if (this.errDyns.size() > 0) {
            LogUtil.saveErrorLog(this.errDyns);
            this.errDyns.clear();
        }
        if (this.needArchiveIds.size() == 0) {
            this.context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        QFilter needArchiveVoucherFilter = new QFilter("id", "in", this.needArchiveIds);
        DataSet needArchiveset = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{needArchiveVoucherFilter}, null);
        DataSet xmlSet = needArchiveset.copy();
        String idField = ArchiveUtil.getFieldName(this.billType, "id");
        String billnoField = ArchiveUtil.getFieldName(this.billType, QueryFinanceBillHelper.getBillNo(this.billType));
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        while (needArchiveset.hasNext()) {
            Row row = needArchiveset.next();
            Long billId = row.getLong(idField);
            String billNo = row.getString(billnoField);
            billidsMap.put(billId + "." + "gl_voucher" + billId.toString(), this.billName + billNo);
            String fileName = "gl_voucher_" + billId + ".pdf";
            this.xmlDesc = String.format(ResManager.loadKDString((String)"%s\u8fc7\u8d26\u51ed\u8bc1", (String)"ArchiveMultGlvoucherByFpyLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.accountBookName + dyn.getString("periodname"));
            this.voucherFileNameMap.put(billId, fileName);
            if ("1".equals(this.isReverse)) {
                String string;
                ArrayList<Object> pks = new ArrayList<Object>(2);
                pks.add(billId);
                try {
                    String pdfUrl = null;
                    if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, this.printId, pks, "billForm", this.printType);
                    } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(billId))) {
                        PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(billId);
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
                    } else {
                        this.needArchiveIds.remove(billId);
                        string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveCommonBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billId);
                        this.errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
                        continue;
                    }
                    this.fpyUploadItem.setBusinessType(1);
                    this.fpyUploadItem.setFileName(fileName);
                    this.setPrintFileRelatedInfo(this.fpyUploadItem, pdfUrl);
                    this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
                catch (Exception e) {
                    this.needArchiveIds.remove(billId);
                    string = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u53c2\u6570[formId\uff1a%1$s\uff0cpkIds\uff1a%2$s\uff0ctemplateId\uff1a%3$s],\u5f02\u5e38 {%4$s}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, pks, this.printId + "_" + this.printSample, e);
                    this.errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
                    continue;
                }
            }
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordDynamicObject(this.billType, this.application, this.schemeId, row, this.userId, date, this.uploadway, "1", null, null, null, this.batchCode);
            dynamicObjects.add(temp);
        }
        if (this.errDyns.size() > 0) {
            LogUtil.saveErrorLog(this.errDyns);
        }
        if (this.needArchiveIds.size() == 0) {
            this.context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        this.context.setNeedArchiveIds(this.needArchiveIds);
        try {
            HashMap<Long, JSONArray> extInvoiceMap = ElecreceiptUtils.findExtInvoiceJson(new ArrayList<Long>(this.needArchiveIds));
            HashMap<String, Object> otherData = new HashMap<String, Object>();
            otherData.put("period", this.period);
            this.xmlstr = CreateXmlUtil.createBatchVoucherXml(this.xmlDesc, xmlSet, this.attachMap, this.imageMap, this.linkUpBills, this.voucherFileNameMap, this.refBillTypes, this.flag, this.voucherInvoiceMap, extInvoiceMap, otherData);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25,%2$s\u3002", (String)"ArchiveGlvoucherByFpyLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = this.billType + "_" + this.accountBookNo + "_" + this.period + "_" + this.batchCode + ".xml";
        this.fpyUploadItem.setFilebase64(this.xmlstr);
        this.fpyUploadItem.setBusinessType(1);
        this.fpyUploadItem.setFileName(desc);
        this.fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(this.xmlstr)));
        this.fpyUploadItem.setFileBytes(Base64.getDecoder().decode(this.xmlstr));
        this.fpyUploadItem.setBillidsMap(billidsMap);
        this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        try (TXHandle txHandle = TX.required((String)CLASS_NAME);){
            try {
                if ("1".equals(this.isReverse)) {
                    this.saveDynamicObjects(CLASS_NAME, dynamicObjects, this.billName, this.needArchiveIds, this.billType);
                    this.saveArchieveconfig(this.billType, this.batchCode, this.isNeedAttachFile, this.refBillAllInfo);
                    this.saveInvoice(this.vatInvoiceMap);
                } else {
                    this.updateRecordToReserve(CLASS_NAME, this.needArchiveIds, this.billType, this.context.getReverseReason(), this.batchCode);
                    this.deleteArchieveconfig(this.billType, this.context.getBatchcode());
                    this.deleteInvoice(this.vatInvoiceMap, this.needArchiveIds);
                }
                this.noticeArchive(this.uploadNoticeUrl, this.fpyUploadItem, this.billName, CLASS_NAME);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u51ed\u8bc1\uff1a{}\u5165\u5e93\u7535\u5b50\u51ed\u8bc1:{} ", (String)"ArchiveMultGlvoucherByFpyLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), this.needArchiveIds, this.vatInvoiceMap.size());
        if ("gl_voucher".equals(this.billType)) {
            ThreadCache.remove((Object)"glVoucher");
        }
    }

    private void archiveGlVoucher() {
        this.attachMap = SingleArchiveUtil.getIdAndAttacheFiles("gl_voucher", this.ids);
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)"id,billno,vouchertype.name vouchertypename", (QFilter[])new QFilter[]{idFilter}, null);
        while (set.hasNext()) {
            Row row = set.next();
            Long billId = row.getLong("id");
            String billNo = row.getString("billno");
            BillInfo voucherInfo = new BillInfo();
            voucherInfo.setBillId(billId);
            voucherInfo.setBillNo(billNo);
            voucherInfo.setFieldMap(Collections.singletonMap("vouchertypename", row.getString("vouchertypename")));
            this.voucherInfoMap.put(billId, voucherInfo);
            if ("2".equals(this.isReverse) || !"1".equals(this.isNeedAttachFile)) continue;
            List<Attach> attaches = this.attachMap.get(billId);
            try {
                if (attaches == null) continue;
                for (Attach attach : attaches) {
                    String url = attach.getUrl();
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5f00\u59cb\u751f\u6210\u51ed\u8bc1{}\u7684\u9644\u4ef6......url\u4e3a:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), row.getString("billno"), url);
                    this.fpyUploadItem.setFileName(billId + "_" + attach.getFileSize() + "_" + attach.getFileName());
                    this.fpyUploadItem.setBusinessType(2);
                    this.setAttachmentsRelatedInfo(this.fpyUploadItem, url);
                    this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
            }
            catch (Exception e) {
                this.needArchiveIds.remove(billId);
                String string = String.format(ResManager.loadKDString((String)"{%1$s}\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25,\u5f02\u5e38 {%2$s}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_5", (String)"fi-aef-common", (Object[])new Object[0]), row.getString("billno"), e);
                this.errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
            }
        }
        this.archiveRefBill();
    }

    private void archiveReceipt(Map<String, Set<Long>> isreceiptBilltypeAndIds) {
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(this.isreceiptSet, this.linkUpBills);
        HashMap<Long, String> RecIdUrlMap = new HashMap<Long, String>(16);
        HashMap<String, Map<Long, Set<Long>>> receiptIdMap = new HashMap<String, Map<Long, Set<Long>>>(16);
        if (!isreceiptBilltypeAndIds.isEmpty()) {
            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863\u56de\u5355\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_6", (String)"fi-aef-common", (Object[])new Object[0]), isreceiptBilltypeAndIds);
            for (Map.Entry<String, Set<Long>> sentry : isreceiptBilltypeAndIds.entrySet()) {
                String refbillType = sentry.getKey();
                Map<Long, List<JSONObject>> billreceipt = ElecreceiptUtils.findReceiptJson(refbillType, sentry.getValue(), this.pageId);
                if (billreceipt == null || billreceipt.size() <= 0) continue;
                for (Map.Entry<Long, List<JSONObject>> entry : billreceipt.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        String url = json.getString("url");
                        RecIdUrlMap.put(json.getLong("receiptId"), url);
                        receiptIdMap.computeIfAbsent(refbillType, value -> new HashMap()).computeIfAbsent(entry.getKey(), value -> new HashSet()).add(json.getLong("receiptId"));
                        if (!"1".equals(this.isReverse) || !StringUtils.isNotBlank((CharSequence)url)) continue;
                        try {
                            Object pdfData = null;
                            if (url.startsWith("http")) {
                                this.fpyUploadItem.setFileName("RECEIPT_" + json.getLong("receiptId") + ".pdf");
                                this.fpyUploadItem.setBusinessType(13);
                                this.setAnyFileRelatedInfo(this.fpyUploadItem, url);
                                this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                                RecIdUrlMap.put(json.getLong("receiptId"), "RECEIPT_" + json.getLong("receiptId") + ".pdf");
                                continue;
                            }
                            this.fpyUploadItem.setFileName(ElecreceiptUtils.getFileName(url));
                            this.fpyUploadItem.setBusinessType(13);
                            this.setAnyFileRelatedInfo(this.fpyUploadItem, url);
                            this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                        catch (IOException e) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5931\u8d25{%s}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_7", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        }
                    }
                }
            }
        }
        Set<Long> receiptIdSet = RecIdUrlMap.keySet();
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u7684\u6240\u6709\u7535\u5b50\u56de\u5355id\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_8", (String)"fi-aef-common", (Object[])new Object[0]), receiptIdSet.toString());
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u7684\u6240\u6709\u7535\u5b50\u56de\u5355url\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), RecIdUrlMap);
        Map<Long, DynamicObject> receiptDys = ElecreceiptUtils.findReceiptDataSet(receiptIdSet);
        if (receiptDys.size() > 0) {
            try {
                String xmlstr = "";
                xmlstr = CreateXmlUtil.createElecreceiptXml(receiptDys, isreceiptBilltypeAndIds, receiptIdMap, null, this.imageMap, billAndRefvoucherIds, this.flag, RecIdUrlMap);
                String desc = "bankReturn_" + this.accountBookNo + "_" + this.period + "_" + this.batchCode + ".xml";
                this.fpyUploadItem.setFilebase64(xmlstr);
                this.fpyUploadItem.setBusinessType(13);
                this.fpyUploadItem.setFileName(desc);
                this.fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
                this.fpyUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
                this.fpyUploadItem.setBillidsMap(this.getElecreceiptBillidsMap(receiptDys, isreceiptBilltypeAndIds, receiptIdMap));
                this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
            }
            catch (Exception e) {
                logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25,%2$s\u3002", (String)"ArchiveMultGlvoucherByFpyLogicUnit_10", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    private Map<String, String> getElecreceiptBillidsMap(Map<Long, DynamicObject> receiptDys, Map<String, Set<Long>> refBilltypeAndIds, Map<String, Map<Long, Set<Long>>> receiptIdMap) {
        HashMap<String, String> billidsMap = new HashMap<String, String>();
        for (Map.Entry<String, Set<Long>> billReceipt : refBilltypeAndIds.entrySet()) {
            String billType = billReceipt.getKey();
            Set<Long> billList = billReceipt.getValue();
            for (Long billId : billList) {
                Set<Object> receiptIds = new HashSet();
                if (receiptIdMap.containsKey(billType)) {
                    receiptIds = receiptIdMap.get(billType).get(billId);
                }
                if (receiptIds == null || receiptIds.size() <= 0) continue;
                for (Long receiptId : receiptIds) {
                    DynamicObject dyo = receiptDys.get(receiptId);
                    if (dyo == null) continue;
                    billidsMap.put(dyo.get("id") + "." + dyo.get("id").toString(), this.refBillTypesAndNames.get(billType) + dyo.getString("receiptno"));
                }
            }
        }
        return billidsMap;
    }

    private void archiveXbrlReceipt(Map<String, Set<Long>> isreceiptBilltypeAndIds) {
        Map<String, Map<Long, String>> isreceiptbillNos = ArchiveUtil.getBillNos(isreceiptBilltypeAndIds);
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(this.isreceiptSet, this.linkUpBills);
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863xbrl\u56de\u5355\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_11", (String)"fi-aef-common", (Object[])new Object[0]), isreceiptBilltypeAndIds);
        Map<String, DynamicObject> receiptPlgins = ArchiveUtil.getTypeWithReceipt();
        HashMap<String, Map> receiptIdMap = new HashMap<String, Map>(16);
        if (!isreceiptBilltypeAndIds.isEmpty() && receiptPlgins.size() > 0) {
            for (Map.Entry<String, Set<Long>> sentry : isreceiptBilltypeAndIds.entrySet()) {
                String refbillType = sentry.getKey();
                Map<Long, List<Long>> dapVoucher = this.getDapRelation(sentry.getKey(), sentry.getValue());
                Map<Long, List<JSONObject>> billreceipt = ElecreceiptUtils.findReceiptJson(refbillType, sentry.getValue(), receiptPlgins, this.pageId);
                if (billreceipt == null || billreceipt.size() <= 0) continue;
                for (Map.Entry<Long, List<JSONObject>> entry : billreceipt.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        Set<Long> vids = billAndRefvoucherIds.get(refbillType).get(entry.getKey());
                        ArrayList<Long> vList = new ArrayList<Long>(16);
                        vList.addAll(vids);
                        Long pkId = 0L;
                        if (dapVoucher.get(entry.getKey()) != null) {
                            List<Long> dapList = dapVoucher.get(entry.getKey());
                            dapList.retainAll(vList);
                            if (dapList.size() > 0) {
                                pkId = dapList.get(0);
                            }
                        } else {
                            pkId = (Long)vList.get(0);
                        }
                        String url = json.getString("url");
                        receiptIdMap.computeIfAbsent(refbillType, value -> new HashMap()).computeIfAbsent(entry.getKey(), value -> new HashSet()).add(json.getLong("receiptId"));
                        if ("1".equals(this.isReverse) && StringUtils.isNotBlank((CharSequence)url)) {
                            try {
                                byte[] pdfData = FileUtils.downLoadHttpsFile(url);
                                if (this.isxbrlpilot && pdfData != null && pdfData.length > 0 && (url.endsWith(".ofd") || url.endsWith(".pdf"))) {
                                    String fullUrl = FileUtils.getElecLastDir() + File.separator + ElecreceiptUtils.getFileName(url);
                                    FileUtils.writeToFile(pdfData, fullUrl);
                                    String issuerUrl = FileUtils.extractElecXBRL(fullUrl, "bker_issuer", json.getString(SEQNO));
                                    byte[] issuerData = FileUtils.getElecFile(issuerUrl);
                                    if (issuerData != null && issuerData.length > 0) {
                                        this.fpyUploadItem.setFilebase64(this.toBase64(issuerData));
                                        this.fpyUploadItem.setFileName(pkId + "_" + ContextUtil.createXBRLFilename("bker_receiver", json).replace("receiver", "issuer"));
                                        this.fpyUploadItem.setBusinessType(2);
                                        this.fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(issuerData));
                                        this.fpyUploadItem.setFileBytes(issuerData);
                                        this.fpyUploadItem.setFilePath(null);
                                        this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                                        FileUtils.deleteFile(fullUrl);
                                        FileUtils.deleteFile(issuerUrl);
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.error("receipt url :" + url + " :" + e);
                            }
                        }
                        JSONObject vJson = new JSONObject(new LinkedHashMap());
                        vJson.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, (Object)this.voucherJson.get(pkId));
                        json.putAll((Map)this.voucherHeadJson.get(pkId));
                        json.putAll((Map)vJson);
                        ArchiveUtil.setDefaultJson(json, this.period);
                        json.put("sourcebillno", (Object)isreceiptbillNos.get(refbillType).get(entry.getKey()));
                        json.put("tickettype", (Object)"bker_receiver");
                        byte[] xbrlData = FileUtils.json2Xbrl(json.toJSONString(), "bker_receiver");
                        if (xbrlData.length > 0 && "1".equals(this.isReverse)) {
                            this.fpyUploadItem.setFilebase64(this.toBase64(xbrlData));
                            this.fpyUploadItem.setFileName(pkId + "_" + ContextUtil.createXBRLFilename("bker_receiver", json));
                            this.fpyUploadItem.setBusinessType(2);
                            this.fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(xbrlData));
                            this.fpyUploadItem.setFileBytes(xbrlData);
                            this.fpyUploadItem.setFilePath(null);
                            this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                        List attachs = this.attachMap.computeIfAbsent(pkId, value -> new ArrayList());
                        Attach attach = new Attach();
                        attach.setFileName(ContextUtil.createXBRLFilename("bker_receiver", json));
                        attachs.add(attach);
                        Attach attach2 = new Attach();
                        attach2.setFileName(ContextUtil.createXBRLFilename("bker_receiver", json).replace("receiver", "issuer"));
                        attachs.add(attach2);
                        this.needArchiveIds.add(pkId);
                        this.insertInvoicePool(this.vatInvoiceMap, json, "bker_receiver", pkId, this.voucherJson, refbillType, entry.getKey());
                    }
                }
            }
        }
    }

    private void archiveRefBill() {
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u51ed\u8bc1\u914d\u7f6e\u7684\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_12", (String)"fi-aef-common", (Object[])new Object[0]), String.join((CharSequence)",", this.refBillTypes));
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u51ed\u8bc1\u7684\u6240\u6709\u4e0a\u4e0b\u6e38\u5355\u636e\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), this.linkUpBills);
        HashMap<String, Set> errRefBills = new HashMap<String, Set>(16);
        Map<String, Set<Long>> refBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, this.refBillTypes);
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(this.refBillTypes, this.linkUpBills);
        Map<String, List<BillInfo>> linkUpBillInfos = ArchiveUtil.getLinkUpBillInfos(refBilltypeAndIds);
        if ("1".equals(this.isReverse)) {
            for (Map.Entry<String, List<BillInfo>> linkUpBillInfo : linkUpBillInfos.entrySet()) {
                String billtype = linkUpBillInfo.getKey();
                List<BillInfo> list = linkUpBillInfo.getValue();
                String isNeedRefAttachFile = this.refBillAllInfo.get(billtype) == null ? "0" : this.refBillAllInfo.get(billtype).getIsNeedRefAttachFile();
                Map<Object, Object> billAttachMap = new HashMap();
                if ("1".equals(isNeedRefAttachFile)) {
                    billAttachMap = SingleArchiveUtil.getIdAndAttacheFiles(billtype, refBilltypeAndIds.get(billtype));
                }
                Map<String, Map<Long, List<String>>> imageMap = SingleArchiveUtil.getImageNumberMap(billtype, refBilltypeAndIds.get(billtype));
                this.imageNumberMap.putAll(imageMap);
                String refPrintNumber = this.refBillTempInfo.get(billtype);
                PrintIdandType oldPrintIdandType = null;
                Map<Object, Object> refPrintIdAndTypeMap = new HashMap(16);
                if (StringUtils.isNotBlank((CharSequence)refPrintNumber)) {
                    String refPrintId = MetadataDao.getIdByNumber((String)refPrintNumber, (MetaCategory)MetaCategory.Form);
                    oldPrintIdandType = new PrintIdandType();
                    if (StringUtils.isNotBlank((CharSequence)refPrintId)) {
                        oldPrintIdandType.setPrintId(refPrintId);
                        oldPrintIdandType.setPrintType(1);
                    } else {
                        refPrintId = ArchiveSchemeHelper.queryPrintId(refPrintNumber, 2);
                        oldPrintIdandType.setPrintId(refPrintId);
                        oldPrintIdandType.setPrintType(2);
                    }
                } else {
                    Printsample printsample = this.refBillAllInfo.get(billtype);
                    List<PrintTemplate> refPrintTemplates = SerializationUtils.fromJsonStringToList((String)printsample.getPrintTemplateJson(), PrintTemplate.class);
                    refPrintTemplates = ArchiveSchemeHelper.getTemplateStatusMap(refPrintTemplates);
                    HashSet<Long> refBillIds = new HashSet<Long>(16);
                    for (BillInfo billInfo : list) {
                        refBillIds.add(Long.parseLong(billInfo.getBillId().toString()));
                    }
                    refPrintIdAndTypeMap = ArchiveSchemeHelper.getBillIdAndPrintId(refPrintTemplates, billtype, refBillIds);
                }
                for (BillInfo billInfo : list) {
                    String string;
                    Long vId;
                    Object errVids;
                    String pdfUrl = null;
                    ArrayList<Object> pks = new ArrayList<Object>(2);
                    pks.add(billInfo.getBillId());
                    try {
                        if (oldPrintIdandType != null) {
                            pdfUrl = FileUtils.getPrintUrl(this.pageId, billtype, oldPrintIdandType.getPrintId(), pks, "billForm", oldPrintIdandType.getPrintType());
                        } else if (StringUtils.isNotBlank((Object)refPrintIdAndTypeMap.get(billInfo.getBillId()))) {
                            PrintIdandType refPrintIdandType = (PrintIdandType)refPrintIdAndTypeMap.get(billInfo.getBillId());
                            pdfUrl = FileUtils.getPrintUrl(this.pageId, billtype, refPrintIdandType.getPrintId(), pks, "billForm", refPrintIdandType.getPrintType());
                        } else {
                            Set<Long> errVids2 = billAndRefvoucherIds.get(billtype).get(billInfo.getBillId());
                            for (Long l : errVids2) {
                                this.needArchiveIds.remove(l);
                                String string2 = String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\uff0c\u5173\u8054\u5355\u636e : %3$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveMultGlvoucherByFpyLogicUnit_14", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billInfo.getBillId(), billInfo.getBillNo());
                                this.errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, l, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string2));
                            }
                            errRefBills.computeIfAbsent(billtype, value -> new HashSet()).add(billInfo.getBillId());
                            continue;
                        }
                        this.fpyUploadItem.setBusinessType(3);
                        this.fpyUploadItem.setFileName(billtype + "_" + billInfo.getBillId() + ".pdf");
                        this.setPrintFileRelatedInfo(this.fpyUploadItem, pdfUrl);
                        this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                    }
                    catch (Exception e) {
                        errVids = billAndRefvoucherIds.get(billtype).get(billInfo.getBillId());
                        Iterator<Long> iterator = errVids.iterator();
                        while (iterator.hasNext()) {
                            vId = iterator.next();
                            this.needArchiveIds.remove(vId);
                            string = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u53c2\u6570[formId\uff1a%1$s\uff0cpkIds\uff1a%2$s],\u5f02\u5e38 {%3$s}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_15", (String)"fi-aef-common", (Object[])new Object[0]), billtype, pks, e);
                            this.errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, vId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
                        }
                        errRefBills.computeIfAbsent(billtype, value -> new HashSet()).add(billInfo.getBillId());
                        continue;
                    }
                    if (!"1".equals(isNeedRefAttachFile)) continue;
                    try {
                        List billAttaches = (List)billAttachMap.get(billInfo.getBillId());
                        if (billAttaches == null || billAttaches.size() <= 0) continue;
                        for (Attach attach : billAttaches) {
                            String url = attach.getUrl();
                            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e{}:{},\u9644\u4ef6url:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_16", (String)"fi-aef-common", (Object[])new Object[0]), billtype, billInfo.getBillId(), url);
                            this.fpyUploadItem.setFileName(billInfo.getBillId() + "_" + attach.getFileSize() + "_" + attach.getFileName());
                            this.fpyUploadItem.setBusinessType(4);
                            this.setAttachmentsRelatedInfo(this.fpyUploadItem, url);
                            this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                        this.refAttachMap.put(Long.valueOf(billInfo.getBillId().toString()), billAttaches);
                    }
                    catch (Exception e) {
                        errVids = billAndRefvoucherIds.get(billtype).get(billInfo.getBillId());
                        Iterator<Long> iterator = errVids.iterator();
                        while (iterator.hasNext()) {
                            vId = iterator.next();
                            this.needArchiveIds.remove(vId);
                            string = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\uff1a%1$s\uff0c%2$s \u9644\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_17", (String)"fi-aef-common", (Object[])new Object[0]), billtype, billInfo.getBillId(), e.getMessage());
                            this.errDyns.add(LogUtil.generateArchiveErrorLog(billtype, vId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
                        }
                        errRefBills.computeIfAbsent(billtype, value -> new HashSet()).add(billInfo.getBillId());
                    }
                }
            }
        }
        Map<String, Object> imageMap = this.getImgConfig(this.imageNumberMap);
        String xmlstr = "";
        try {
            HashMap<String, Object> extMap = new HashMap<String, Object>(8);
            extMap.put("refAttachMap", this.refAttachMap);
            extMap.put("imageMap", imageMap);
            extMap.put("accountBookNo", this.accountBookNo);
            extMap.put("accountBookName", this.accountBookName);
            extMap.put("period", this.period);
            extMap.put("flag", this.flag);
            extMap.put("errRefBills", errRefBills);
            extMap.put("needArchiveIds", this.needArchiveIds);
            extMap.put("voucherInfoMap", this.voucherInfoMap);
            xmlstr = CreateXmlUtil.createVoucherRefBillXml(linkUpBillInfos, billAndRefvoucherIds, extMap);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25,%2$s\u3002", (String)"ArchiveMultGlvoucherByFpyLogicUnit_18", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = "refbill_" + this.accountBookNo + "_" + this.period + "_" + this.batchCode + ".xml";
        this.fpyUploadItem.setFilebase64(xmlstr);
        this.fpyUploadItem.setBusinessType(4);
        this.fpyUploadItem.setFileName(desc);
        this.fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        this.fpyUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
        this.fpyUploadItem.setBillidsMap(this.getVoucherRefBillidsMap(linkUpBillInfos));
        this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
    }

    private Map<String, String> getVoucherRefBillidsMap(Map<String, List<BillInfo>> linkUpBillInfos) {
        HashMap<String, String> billidsMap = new HashMap<String, String>();
        for (Map.Entry<String, List<BillInfo>> linkUpBillInfo : linkUpBillInfos.entrySet()) {
            String billType = linkUpBillInfo.getKey();
            List<BillInfo> list = linkUpBillInfo.getValue();
            for (BillInfo billInfo : list) {
                if ("ap_finapbill".equals(billType)) {
                    billidsMap.put(billInfo.getBillId() + ".ap_invoice_" + billInfo.getBillId().toString(), billInfo.getBillNo());
                    continue;
                }
                billidsMap.put(billInfo.getBillId() + "." + billType + "_" + billInfo.getBillId().toString(), this.refBillTypesAndNames.get(billType) + billInfo.getBillNo());
            }
        }
        return billidsMap;
    }

    private void archiveXbrl() {
        if ("2".equals(this.isReverse)) {
            this.needArchiveIds.addAll(this.ids);
        }
        Map<String, DynamicObject> invoicePlgins = ArchiveUtil.getTypeWithInvoice();
        HashSet<String> isinvoiceSet = new HashSet(16);
        if (this.VATBillTypes.containsKey("isinvoice")) {
            isinvoiceSet = this.VATBillTypes.get("isinvoice");
        }
        this.voucherJson = ArchiveUtil.getVoucherJson(this.ids, this.voucherHeadJson);
        Map<String, Set<Long>> invoiceBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, isinvoiceSet);
        Map<String, Map<Long, String>> invoicebillNos = ArchiveUtil.getBillNos(invoiceBilltypeAndIds);
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(isinvoiceSet, this.linkUpBills);
        HashSet buildXbrlVoucherIds = new HashSet(16);
        billAndRefvoucherIds.forEach((key, value) -> {
            Map getIdmap = value;
            getIdmap.forEach((billid, voucherIds) -> buildXbrlVoucherIds.addAll(voucherIds));
        });
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863xbrl\u7684\u51ed\u8bc1\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_19", (String)"fi-aef-common", (Object[])new Object[0]), billAndRefvoucherIds);
        if (!invoiceBilltypeAndIds.isEmpty()) {
            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863\u53d1\u7968xbrl\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"ArchiveMultGlvoucherByFpyLogicUnit_20", (String)"fi-aef-common", (Object[])new Object[0]), invoiceBilltypeAndIds);
            for (Map.Entry<String, Set<Long>> sentry : invoiceBilltypeAndIds.entrySet()) {
                String refbillType = sentry.getKey();
                Map<Long, List<Long>> dapVoucher = this.getDapRelation(sentry.getKey(), sentry.getValue());
                Map<Long, List<JSONObject>> billInvoice = ElecreceiptUtils.findInvoiceJson(refbillType, sentry.getValue(), invoicePlgins);
                if (billInvoice == null || billInvoice.size() <= 0) continue;
                Map<String, JSONObject> seqNoAndJson = XbrlArchieveUtil.getSeqNoAndJson(billInvoice);
                for (Map.Entry<Long, List<JSONObject>> entry : billInvoice.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        byte[] xbrlData;
                        if (SysParamConfig.getBoolean("ischeckxbrlurl", true) && StringUtils.isBlank((CharSequence)sourcejson.getString("xbrlUrl"))) continue;
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        String uniqueKey = json.getString(SEQNO);
                        String tickettype = json.getString("tickettype");
                        if (XbrlArchieveUtil.NEED_FIND_VOICEINFO_TICKETTYPRS.contains(tickettype)) {
                            if (!seqNoAndJson.containsKey(uniqueKey)) continue;
                            json.putAll((Map)seqNoAndJson.get(uniqueKey));
                        }
                        JSONObject vJson = new JSONObject(new LinkedHashMap());
                        Set<Long> vids = billAndRefvoucherIds.get(refbillType).get(entry.getKey());
                        ArrayList<Long> vList = new ArrayList<Long>(16);
                        vList.addAll(vids);
                        Long pkId = 0L;
                        if (dapVoucher.get(entry.getKey()) != null) {
                            List<Long> dapList = dapVoucher.get(entry.getKey());
                            dapList.retainAll(vList);
                            if (dapList.size() > 0) {
                                pkId = dapList.get(0);
                            }
                        } else {
                            pkId = (Long)vList.get(0);
                        }
                        vJson.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, (Object)this.voucherJson.get(pkId));
                        json.putAll((Map)this.voucherHeadJson.get(pkId));
                        json.putAll((Map)vJson);
                        json.put("sourcebillno", (Object)invoicebillNos.get(refbillType).get(entry.getKey()));
                        ArchiveUtil.setDefaultJson(json, this.period);
                        this.voucherInvoiceMap.computeIfAbsent(pkId, Value -> new HashSet()).add(uniqueKey);
                        if ("1".equals(this.isReverse) && (xbrlData = FileUtils.json2Xbrl(json.toJSONString(), tickettype)).length > 0) {
                            this.fpyUploadItem.setFilebase64(this.toBase64(xbrlData));
                            this.fpyUploadItem.setFileName(pkId + "_" + ContextUtil.createXBRLFilename(tickettype, json));
                            this.fpyUploadItem.setBusinessType(2);
                            this.fpyUploadItem.setFileMD5(FpyOperateUtil.fileMD5(xbrlData));
                            this.fpyUploadItem.setFileBytes(xbrlData);
                            this.fpyUploadItem.setFilePath(null);
                            this.uploadFile(this.uploadUrl, this.fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                        List attachs = this.attachMap.computeIfAbsent(pkId, value -> new ArrayList());
                        Attach attach = new Attach();
                        attach.setFileName(ContextUtil.createXBRLFilename(tickettype, json));
                        attachs.add(attach);
                        this.needArchiveIds.add(pkId);
                        this.insertInvoicePool(this.vatInvoiceMap, json, tickettype, pkId, this.voucherJson, refbillType, entry.getKey());
                    }
                }
            }
        }
        this.isreceiptSet = this.VATBillTypes.get("isreceipt");
        this.isreceiptBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, this.isreceiptSet);
        this.archiveXbrlReceipt(this.isreceiptBilltypeAndIds);
    }

    private Map<String, Object> getImgConfig(Map<String, Map<Long, List<String>>> imageNumberMap) {
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        QFilter imageFilter1 = new QFilter("number", "=", (Object)"FPY");
        DynamicObject imagedyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_imageconfig", (String)"number,imagesystermip,imageport,enable", (QFilter[])new QFilter[]{imageFilter1});
        QFilter voiceFilter2 = new QFilter("client_id", "!=", (Object)"");
        if (QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfg", (QFilter[])voiceFilter2.toArray()) || QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])voiceFilter2.toArray())) {
            imageMap.put("enable", "A");
        }
        if (imagedyo != null) {
            imageMap.put("numbermap", imageNumberMap);
            imageMap.put("imagesystype", imagedyo.getString("number"));
            imageMap.put("imagesysip", imagedyo.getString("imagesystermip"));
            imageMap.put("imagesysport", imagedyo.getString("imageport"));
        }
        return imageMap;
    }
}

