/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.RptArchiveUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveReportFormByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveReportFormByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveReportFormByFpyLogicUnit";
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);

    /*
     * Could not resolve type clashes
     */
    @Override
    protected void execute() {
        String flag = "2".equals(this.isReverse) ? "delete" : "addnew";
        long bcmscene = this.context.getBcmscene();
        String bcmsceneType = this.context.getBcmsceneType();
        int fpyBusinessType = 0;
        long bcmfy = this.context.getBcmfy();
        String bcmfyName = this.context.getBcmfyName();
        String bcmperiodJson = this.context.getBcmperiodJson();
        Map bcmPeriodMap = (Map)SerializationUtils.deSerializeFromBase64((String)bcmperiodJson);
        String batchNumber = UUID.randomUUID().toString();
        Date date = new Date();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        String hasCountkey = this.context.getPageId() + "hasarchievecount";
        String allCountKey = this.context.getPageId() + "allcount";
        Set<String> hasArchivedKeys = RptArchiveUtil.getHasArchivedKeys(this.uploadway, bcmscene, bcmfy, bcmPeriodMap.keySet());
        Map<String, Map> AllrptUrlMap = new HashMap(16);
        HashMap<String, Long> rptModelMap = new HashMap<String, Long>(16);
        HashMap<String, Long> rptOrgMap = new HashMap<String, Long>(16);
        HashMap<String, String> rptGetNameMap = new HashMap(16);
        HashMap<String, String> rptGetOrgMap = new HashMap(16);
        ArrayList<String> allKeys = new ArrayList<String>(16);
        HashMap<Object, String> rptTypeMap = new HashMap<Object, String>(16);
        FpyUploadItem fpyUploadItem = new FpyUploadItem(this.archivesCode, null, null, null, batchNumber, fpyBusinessType, null, null);
        for (Map.Entry periodEntry : bcmPeriodMap.entrySet()) {
            Long bcmperiod = (Long)periodEntry.getKey();
            this.context.setBcmperiod(bcmperiod);
            Map<Object, Object> rptUrlMap = new HashMap();
            if ("1".equals(this.isReverse)) {
                rptUrlMap = SingleArchiveUtil.invokeBcmPrintService(this.context);
                String type = rptUrlMap.containsKey("type_0") ? "." + (String)rptUrlMap.remove("type_0") : ".pdf";
                rptTypeMap.put(bcmperiod, type);
                for (String hasKey : hasArchivedKeys) {
                    if (!rptUrlMap.containsKey(hasKey)) continue;
                    rptUrlMap.remove(hasKey);
                }
                if (rptUrlMap.isEmpty()) continue;
                for (Map.Entry entry : rptUrlMap.entrySet()) {
                    String[] keyArr = ((String)entry.getKey()).split("_");
                    rptModelMap.put((String)entry.getKey(), Long.parseLong(keyArr[1]));
                    rptOrgMap.put((String)entry.getKey(), Long.parseLong(keyArr[0]));
                    Map tempMap = AllrptUrlMap.computeIfAbsent(Long.parseLong(keyArr[0]) + "_" + bcmperiod, value -> new HashMap());
                    allKeys.add((String)entry.getKey());
                    tempMap.put(entry.getKey(), entry.getValue());
                }
                if ("1".equals(this.isReverse)) {
                    String allCountStr = this.cache.get(allCountKey);
                    int allCount = allCountStr == null ? 0 : Integer.parseInt(allCountStr);
                    this.cache.put(allCountKey, allCount + rptUrlMap.size() + "");
                }
            } else {
                AllrptUrlMap = (Map)SerializationUtils.fromJsonString((String)this.context.getArchiverange(), Map.class);
                AllrptUrlMap.forEach((key, rptMap) -> {
                    for (Map.Entry entry : rptMap.entrySet()) {
                        String[] keyArr = ((String)entry.getKey()).split("_");
                        rptModelMap.put((String)entry.getKey(), Long.parseLong(keyArr[1]));
                        rptOrgMap.put((String)entry.getKey(), Long.parseLong(keyArr[0]));
                        allKeys.add((String)entry.getKey());
                    }
                });
            }
            rptGetNameMap = RptArchiveUtil.getRptGetNameMap(rptModelMap);
            rptGetOrgMap = RptArchiveUtil.getRptGetOrgMap(rptOrgMap);
        }
        if ("1".equals(this.isReverse) && allKeys.isEmpty()) {
            this.cache.put(hasCountkey, "0");
            return;
        }
        ArrayList<KDBizException> kdBizExceptions = new ArrayList<KDBizException>(16);
        int count = 0;
        for (Map.Entry allentry : AllrptUrlMap.entrySet()) {
            Map rptUrlMap = (Map)allentry.getValue();
            Long bcmperiod = Long.valueOf(((String)allentry.getKey()).split("_")[1]);
            batchNumber = UUID.randomUUID().toString();
            fpyUploadItem.setBatchNumber(batchNumber);
            String bcmperiodName = (String)bcmPeriodMap.get(bcmperiod);
            String uniqueKey = (String)rptUrlMap.keySet().iterator().next();
            String base64 = "";
            String type = rptTypeMap.getOrDefault(bcmperiod, ".pdf");
            switch (bcmsceneType) {
                case "MRpt": {
                    fpyBusinessType = 10;
                    base64 = CreateXmlUtil.createMRptXml(rptUrlMap, rptGetNameMap, rptGetOrgMap, flag, bcmfyName, bcmperiodName, type);
                    break;
                }
                case "QRpt": {
                    fpyBusinessType = 11;
                    base64 = CreateXmlUtil.createQRptXml(rptUrlMap, rptGetNameMap, rptGetOrgMap, flag, bcmfyName, bcmperiodName, type);
                    break;
                }
                case "ARpt": {
                    fpyBusinessType = 12;
                    base64 = CreateXmlUtil.createARptXml(rptUrlMap, rptGetNameMap, rptGetOrgMap, flag, bcmfyName, bcmperiodName, type);
                    break;
                }
            }
            String desc = ResManager.loadKDString((String)uniqueKey, (String)"ArchiveReportFormByFpyLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]);
            LogUtil.printLog(logger, ResManager.loadKDString((String)"rptGetOrgMap {} rptGetNameMap {}  rptUrlMap {}", (String)"FPYDocumentServerHandler_8", (String)"fi-aef-common", (Object[])new Object[0]), rptGetOrgMap, rptGetNameMap, rptUrlMap);
            fpyUploadItem.setAccountBookNo(((String)rptGetOrgMap.get(uniqueKey)).split("_")[1]);
            fpyUploadItem.setAccountBookName(((String)rptGetOrgMap.get(uniqueKey)).split("_")[0]);
            fpyUploadItem.setPeriod(CreateXmlUtil.bulidRptPeriod(bcmfyName, bcmperiodName));
            fpyUploadItem.setFilebase64(base64);
            fpyUploadItem.setBusinessType(fpyBusinessType);
            fpyUploadItem.setFileName(String.format(ResManager.loadKDString((String)"%1$s\u5408\u5e76\u62a5\u8868%2$s", (String)"ArchiveReportFormByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), desc + "_" + batchNumber, ".xml"));
            fpyUploadItem.setBillidsMap(this.getMRptBillidsMap(rptUrlMap, rptGetNameMap, rptGetOrgMap, bcmfyName, bcmperiodName));
            KDBizException kdBizException = null;
            try {
                this.uploadFile(this.uploadUrl, fpyUploadItem, bcmsceneType, CLASS_NAME, Boolean.TRUE);
            }
            catch (KDBizException e) {
                if ("2".equals(this.isReverse) && this.isNotNeedUploadFile) {
                    kdBizException = e;
                }
                throw e;
            }
            if (kdBizException != null) {
                kdBizExceptions.add(kdBizException);
                allKeys.removeAll(rptUrlMap.keySet());
                continue;
            }
            for (Map.Entry entry : rptUrlMap.entrySet()) {
                String key2 = (String)entry.getKey();
                String url = (String)entry.getValue();
                if (StringUtils.isBlank((CharSequence)url)) continue;
                String[] keyArr = key2.split("_");
                DynamicObject temp = SingleArchiveUtil.getRptArhieveRecordDynamicObject(this.schemeId, this.userId, date, this.uploadway, "1", null, null, key2, bcmscene, bcmfy, bcmperiod, batchNumber);
                temp.set("billid", (Object)Long.parseLong(keyArr[2]));
                temp.set("billno", (Object)Long.parseLong(keyArr[2]));
                dynamicObjects.add(temp);
                if (this.context.getNeedArchiveIds() == null) {
                    this.context.setNeedArchiveIds(new HashSet<Long>());
                }
                this.context.getNeedArchiveIds().add(Long.parseLong(keyArr[2]));
                try {
                    if ("1".equals(this.isReverse)) {
                        url = UrlService.getDomainContextUrl() + "/" + url;
                        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5f00\u59cb\u751f\u6210\u5408\u5e76\u62a5\u8868{}\u7684\u4e3b\u6587\u4ef6......url\u4e3a:{}", (String)"ArchiveReportFormLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), rptGetOrgMap.get(key2), url);
                        fpyUploadItem.setAccountBookNo(((String)rptGetOrgMap.get(uniqueKey)).split("_")[1]);
                        fpyUploadItem.setAccountBookName(((String)rptGetOrgMap.get(uniqueKey)).split("_")[0]);
                        fpyUploadItem.setPeriod(CreateXmlUtil.bulidRptPeriod(bcmfyName, (String)bcmPeriodMap.get(bcmperiod)));
                        fpyUploadItem.setFileName(key2 + type);
                        fpyUploadItem.setBusinessType(fpyBusinessType);
                        this.setTempFileRelatedInfo(fpyUploadItem, url);
                        this.uploadFile(this.uploadUrl, fpyUploadItem, bcmsceneType, CLASS_NAME, Boolean.FALSE);
                    }
                }
                catch (IOException e) {
                    logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", bcmsceneType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveReportFormLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), bcmsceneType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
                ++count;
                if (!"1".equals(this.isReverse)) continue;
                this.cache.put(hasCountkey, count + "");
            }
            this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, bcmsceneType, CLASS_NAME);
        }
        try {
            if ("1".equals(this.isReverse)) {
                RptArchiveUtil.saveRptrecords(CLASS_NAME, dynamicObjects, allKeys);
            } else {
                RptArchiveUtil.updateRptrecords(CLASS_NAME, dynamicObjects, allKeys, this.context.getReverseReason());
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%s}", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%s}", (String)"ArchiveReportFormLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        ArrayList errorMapList = new ArrayList(16);
        for (KDBizException kdBizException : kdBizExceptions) {
            if (kdBizException.getArgs().length <= 0) continue;
            Object[] errorMaps = kdBizException.getArgs();
            errorMapList.addAll(Arrays.stream(errorMaps).collect(Collectors.toList()));
        }
        if (errorMapList.size() > 0) {
            throw new KDBizException(new ErrorCode("ArchiveReportFormByFpyLogicUnit_reverse_fail", ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25", (String)"ArchiveReportFormByFpyLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0])), errorMapList.toArray(new Object[0]));
        }
    }

    private Map<String, String> getMRptBillidsMap(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String bcmfyName, String bcmperiodName) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            if (kd.bos.util.StringUtils.isBlank((String)allUrl)) continue;
            String billid = rptAllUrlKey.split("_")[2];
            String voucherorgname = rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0];
            String reporttype = rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey);
            billidsMap.put(billid + "." + billid, voucherorgname + bcmfyName + bcmperiodName + reporttype);
        }
        return billidsMap;
    }
}

