/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveSubledgerByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveSubledgerByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveSubledgerByFpyLogicUnit";
    private static Map<Long, String> accountIdAndName = new HashMap<Long, String>();
    private static Map<Long, String> accountIdAndNumber = new HashMap<Long, String>();
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void execute() {
        Date date = new Date();
        String uniqueKey = this.orgId + "-" + this.booktypeId + "-" + this.periodId;
        ArrayList<Map<String, String>> xmlInfos = new ArrayList<Map<String, String>>();
        FpyUploadItem fpyUploadItem = new FpyUploadItem();
        String xmlDesc = "";
        String xmlFileDesc = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", this.orgId);
        map.put("startperiod", this.periodId);
        map.put("endperiod", this.periodId);
        map.put("bookType", this.booktypeId);
        Set<Object> accountIdList = new HashSet(16);
        if (StringUtils.isNotEmpty((CharSequence)this.context.getArchiverange())) {
            List list = (List)SerializationUtils.deSerializeFromBase64((String)this.context.getArchiverange());
            List list2 = list.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
            accountIdList = new HashSet(list2);
        } else {
            accountIdList = SingleArchiveUtil.getAllDetailAccountId(map);
        }
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accountview", (String)"id,name,number", (QFilter[])new QFilter("id", "in", accountIdList).toArray(), (String)"number");
        accountIdList.clear();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org", (String)"number,name");
        String orgName = org.getString("name");
        String orgNumber = org.getString("number");
        DynamicObject booktype = BusinessDataServiceHelper.loadSingleFromCache((Object)this.booktypeId, (String)"bd_accountbookstype", (String)"number,name");
        String booktypeName = booktype.getString("name");
        String booktypeNumber = booktype.getString("number");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.periodId, (String)"bd_period", (String)"number,name");
        String periodName = period.getString("name");
        String periodNumber = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(period.getString("number")) : CreateXmlUtil.dealAdjustmentPeriodNumber(period.getString("number"));
        String accountBookNo = orgNumber;
        String accountBookName = orgName;
        if (this.isSplitbook && this.context.isAws()) {
            accountBookNo = accountBookNo + booktypeNumber;
            accountBookName = accountBookName + booktypeName;
        }
        String institutionIssuesNo = "gl_" + booktypeNumber;
        for (DynamicObject dyn : dyns) {
            accountIdList.add(dyn.getLong("id"));
            accountIdAndName.put(dyn.getLong("id"), dyn.getString("name"));
            accountIdAndNumber.put(dyn.getLong("id"), dyn.getString("number"));
        }
        if ("2".equals(this.context.getIsReverse())) {
            this.context.setNeedArchiveIds(new HashSet<Object>(accountIdList));
        } else {
            this.context.setNeedArchiveIds(Collections.singleton(this.periodId));
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        ArrayList<String> uniqueKeys = new ArrayList<String>(16);
        for (Long l : accountIdList) {
            ReportPrintUtil reportUtil = new ReportPrintUtil();
            Throwable throwable = null;
            try {
                map.put("isAsynQuery", Boolean.FALSE);
                map.put("org", this.orgId);
                map.put("startperiod", this.periodId);
                map.put("endperiod", this.periodId);
                map.put("bookType", this.booktypeId);
                map.put("account", new Long[]{l});
                map.put("currency", "allcurrency");
                map.put("showleafaccount", Boolean.TRUE);
                String uniqueKey2 = uniqueKey + "-" + l;
                uniqueKeys.add(uniqueKey2);
                String pageId = reportUtil.simulateReportSearch(this.billType, map);
                logger.info("accountId:{} pageId:{}", (Object)l, (Object)pageId);
                if (pageId == null) continue;
                xmlFileDesc = this.billType + "_" + orgNumber + "_" + booktypeNumber + "_" + periodNumber + "_" + this.batchCode;
                xmlDesc = String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u8d26", (String)"ArchiveSubledgerByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), orgName + booktypeName + periodName);
                String fileName = this.billType + "_" + orgNumber + "_" + booktypeNumber + "_" + periodNumber + "_" + accountIdAndNumber.get(l) + ".pdf";
                if ("2".equals(this.isReverse)) {
                    fpyUploadItem = new FpyUploadItem(this.archivesCode, accountBookNo, accountBookName, periodNumber, this.batchCode, 9, fileName, null, institutionIssuesNo, booktypeName);
                } else {
                    String pdfUrl = null;
                    try {
                        if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                            pdfUrl = FileUtils.getPrintUrl(pageId, this.billType, this.printId, null, "report", this.printType);
                        } else {
                            List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                            String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
                            pdfUrl = FileUtils.getPrintUrl(pageId, this.billType, print, null, "report", ((PrintTemplate)templateList.get(0)).getPrintType());
                        }
                    }
                    catch (Exception e) {
                        logger.error("accountId:{} pageId:{} error: {}", new Object[]{l, pageId, e});
                        if (reportUtil == null) continue;
                        if (throwable != null) {
                            try {
                                reportUtil.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        reportUtil.close();
                        continue;
                    }
                    try {
                        fpyUploadItem = this.buildPrintFileUploadItem(this.archivesCode, accountBookNo, accountBookName, periodNumber, this.batchCode, 9, fileName, pdfUrl, institutionIssuesNo, booktypeName);
                    }
                    catch (IOException e) {
                        logger.error(String.format("%1$s %2$s %3$s\uff0c%4$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%5$s}", accountBookName, periodName, accountIdAndNumber.get(l), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff0c%4$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%5$s}", (String)"ArchiveSubledgerByFpyLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), accountBookName, periodName, accountIdAndNumber.get(l), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    }
                    this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
                HashMap<String, String> xmlInfo = new HashMap<String, String>();
                xmlInfo.put("billid", l + "");
                xmlInfo.put("period", periodNumber);
                xmlInfo.put("periodname", periodName);
                xmlInfo.put("voucherorgnumber", accountBookNo);
                xmlInfo.put("voucherorgname", accountBookName);
                xmlInfo.put("subjno", accountIdAndNumber.get(l));
                xmlInfo.put("subj", accountIdAndName.get(l));
                xmlInfo.put("file", fileName);
                xmlInfos.add(xmlInfo);
                DynamicObject temp = SingleArchiveUtil.getArhieveSubledDynamicObject(this.billType, accountIdAndNumber.get(l), this.application, this.schemeId, map, date, this.uploadway, this.periodId, this.userId, "1", null, null, uniqueKey2, this.batchCode, this.booktypeId);
                dynamicObjects.add(temp);
                map.remove("account");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
        }
        if (xmlInfos.isEmpty()) {
            String hasarchieveCountKey = this.context.getPageId() + "hasarchievecount";
            String string = this.cache.get(hasarchieveCountKey);
            int count = string == null ? 0 : Integer.parseInt(string);
            this.cache.put(hasarchieveCountKey, count - 1 + "");
            this.context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        String xmlstr = "";
        try {
            xmlstr = CreateXmlUtil.createSubledgerXml(xmlDesc, xmlInfos, this.flag);
        }
        catch (Exception exception) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)exception)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveSubledgerByFpyLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)exception)));
        }
        fpyUploadItem.setFilebase64(xmlstr);
        fpyUploadItem.setFileName(xmlFileDesc + ".xml");
        fpyUploadItem.setBillidsMap(this.getSubsidiaryBillidsMap(xmlInfos));
        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        QFilter qFilter = new QFilter("billtype.id", "=", (Object)"gl_rpt_subledger");
        QFilter keyFilter = new QFilter("uniqueKey", "=", (Object)uniqueKey);
        DeleteServiceHelper.delete((String)"aef_acelre", (QFilter[])new QFilter[]{qFilter, keyFilter});
        if ("1".equals(this.isReverse)) {
            this.saveSubObjects(CLASS_NAME, dynamicObjects, this.billType, this.billName, uniqueKeys);
        } else {
            this.updateSubleToReserve(CLASS_NAME, uniqueKeys, this.billType, this.context.getReverseReason(), this.batchCode);
        }
        this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
    }

    private Map<String, String> getSubsidiaryBillidsMap(List<Map<String, String>> xmlInfos) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(xmlInfos.size());
        for (Map<String, String> map : xmlInfos) {
            billidsMap.put(map.get("billid") + "." + map.get("billid"), map.get("voucherorgname") + map.get("periodname") + this.billName + map.get("subjno"));
        }
        return billidsMap;
    }

    private void getAllAccountId(Set<Long> accountIdList, List<Long> accountMasterIdList, Long orgId, Boolean flag) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (flag.booleanValue()) {
            filters.add(new QFilter("masterid", "in", accountMasterIdList));
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        } else {
            filters.add(new QFilter("id", "in", accountMasterIdList));
        }
        try (DataSet set = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,parent.id parentid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            accountMasterIdList.clear();
            if (set != null) {
                for (Row row : set) {
                    if (row.getLong("parentid") == 0L) {
                        accountIdList.add(row.getLong("id"));
                        continue;
                    }
                    accountMasterIdList.add(row.getLong("parentid"));
                }
            }
        }
        if (!accountMasterIdList.isEmpty()) {
            this.getAllAccountId(accountIdList, accountMasterIdList, orgId, Boolean.FALSE);
        }
    }
}

