/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.ArchiveLogInfo;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveTaxByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveTaxByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveTaxByFpyLogicUnit";

    @Override
    protected void execute() {
        Map rangeMap = (Map)SerializationUtils.fromJsonString((String)this.context.getArchiveRangeReport(), Map.class);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> errDyns = new ArrayList<DynamicObject>(16);
        HashSet<Long> needArchiveIds = new HashSet<Long>(16);
        String taxarchivedata = (String)rangeMap.get("taxarchivedata");
        FpyUploadItem fpyUploadItem = new FpyUploadItem(this.archivesCode, null, null, null, this.batchCode, 16, null, null);
        HashMap<Long, String> billFileNameMap = new HashMap<Long, String>(100);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"aef_archivescheme", (String)"group, group.name groupname", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(this.schemeId)).toArray());
        Long groupId = dyn.getLong("group");
        String groupname = dyn.getString("groupname");
        HashMap<String, Object> extMap = new HashMap<String, Object>(16);
        extMap.put("groupname", groupname);
        Date date = new Date();
        ArchiveLogInfo archiveLogInfo = new ArchiveLogInfo(this.orgId, this.application, Long.valueOf(this.schemeId), this.userId, this.uploadway, date, this.isReverse, this.batchCode, this.billType, null, null, null, this.context.getReverseReason(), null, null, null, null, groupId, taxarchivedata, " ");
        DataSet xmlSet = null;
        List<Object> declareList = new ArrayList(16);
        HashMap<String, List> periodDacList = new HashMap<String, List>(16);
        String orgNo = "";
        String orgName = "";
        HashMap<String, String> billidsMap = new HashMap<String, String>();
        if ("bill".equals(taxarchivedata)) {
            BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.billType);
            String mainOrg = bet.getMainOrg();
            String string = this.context.getDateField();
            LogUtil.printLog(logger, "tax dateField :{}", string);
            String string2 = "";
            needArchiveIds.addAll(this.ids);
            QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
            String billNoFiled = QueryFinanceBillHelper.getBillNo(this.billType);
            Iterator<Object> selectFileds = "id," + string + " datefield," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + billNoFiled + " billno";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)((Object)selectFileds), (QFilter[])new QFilter[]{idFilter}, null);
            xmlSet = dataSet.copy();
            while (dataSet.hasNext()) {
                String string3;
                Row row = dataSet.next();
                Long billId = row.getLong("id");
                String billNo = row.getString("billno");
                billidsMap.put(billId + "." + this.billType + "_" + billId.toString(), this.billName + billNo);
                orgNo = row.getString("orgnumber");
                orgName = row.getString("orgname");
                String string4 = DateUtil.getShortStr(row.getDate("datefield"));
                String fileName = this.billType + "_" + billId + ".pdf";
                billFileNameMap.put(billId, fileName);
                if ("2".equals(this.isReverse)) {
                    fpyUploadItem = new FpyUploadItem(this.archivesCode, orgNo, orgName, string4, this.batchCode, 16, fileName, null);
                    continue;
                }
                ArrayList<Object> pks = new ArrayList<Object>(2);
                pks.add(row.get("id"));
                try {
                    String pdfUrl = null;
                    if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, this.printId, pks, "billForm", this.printType);
                    } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(row.get("id")))) {
                        PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(row.get("id"));
                        LogUtil.printLog(logger, "printIdandType{} ", printIdandType);
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
                    } else {
                        needArchiveIds.remove(billId);
                        string3 = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveTaxBillLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, row.getString("billno"));
                        errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string3));
                        continue;
                    }
                    fpyUploadItem = this.buildPrintFileUploadItem(this.archivesCode, orgNo, orgName, string4, this.batchCode, 16, fileName, pdfUrl, null, null);
                    this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
                catch (Exception e) {
                    needArchiveIds.remove(billId);
                    string3 = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveTaxBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billId, e.getMessage() + "-" + ((PrintIdandType)this.billIdAndPrintIdMap.get(row.get("id"))).getPrintId() + "-" + ((PrintIdandType)this.billIdAndPrintIdMap.get(row.get("id"))).getPrintType());
                    errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string3));
                    logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    continue;
                }
                archiveLogInfo.setPeriod(string4);
                archiveLogInfo.setBillid(billId);
                archiveLogInfo.setBillno(row.getString("billno"));
                archiveLogInfo.setBillbizdate(row.getDate("datefield"));
                archiveLogInfo.setSkssqq(row.getDate("datefield"));
                archiveLogInfo.setSkssqz(row.getDate("datefield"));
                DynamicObject temp = SingleArchiveUtil.getTaxArhieveDynamicObject(archiveLogInfo);
                dynamicObjects.add(temp);
            }
        }
        if ("tccit".equals(taxarchivedata)) {
            if ("1".equals(this.isReverse)) {
                Set<Long> idSet = this.getHasArchivedIds(this.context.getUploadWay(), this.orgId, this.billType);
                Iterator<Object> ticcttypeId = (String)rangeMap.get("taxticcttype");
                String string = (String)rangeMap.get("startdate");
                String string5 = (String)rangeMap.get("enddate");
                String nxxfilter = (String)rangeMap.get("nxxfilter");
                declareList = ElecreceiptUtils.findTaxcDeclareTempFile(this.orgId, string, string5, (String)((Object)ticcttypeId), nxxfilter);
                if (declareList != null && declareList.size() > 0) {
                    fpyUploadItem.setPeriod((String)((Map)declareList.get(0)).get("period"));
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)this.orgId).toArray());
                    orgNo = dynamicObject.getString("number");
                    orgName = dynamicObject.getString("name");
                    fpyUploadItem.setAccountBookNo(orgNo);
                    fpyUploadItem.setAccountBookName(orgName);
                    for (Map map : declareList) {
                        Long billId = (Long)map.get("id");
                        String billNo = (String)map.get("billno");
                        billidsMap.put(billId + "." + this.billType + "_" + billId.toString(), this.billName + billNo);
                        if (idSet.contains(billId)) continue;
                        needArchiveIds.add(billId);
                        try {
                            fpyUploadItem.setFileName((String)map.get("filename"));
                            fpyUploadItem.setPeriod((String)map.get("period"));
                            this.setTempFileRelatedInfo(fpyUploadItem, (String)map.get("url"));
                            this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                        catch (Exception e) {
                            needArchiveIds.remove(billId);
                            String string6 = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveTaxByFpyLogicUnit_7", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billId, e.getMessage());
                            errDyns.add(LogUtil.generateArchiveErrorLog(this.billType, billId, Long.parseLong(this.schemeId), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string6));
                            logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            continue;
                        }
                        billFileNameMap.put(billId, (String)map.get("filename"));
                        map.put("taxticcttype", ticcttypeId);
                        archiveLogInfo.setOtherdata(SerializationUtils.toJsonString((Object)map));
                        archiveLogInfo.setBillid(billId);
                        archiveLogInfo.setPeriod((String)map.get("period"));
                        archiveLogInfo.setBillno((String)map.get("billno"));
                        archiveLogInfo.setBillbizdate(DateUtil.stringToDate((String)map.get("period"), "yyyy-MM"));
                        archiveLogInfo.setSkssqq(DateUtil.stringToDate((String)map.get("startdate"), "yyyy-MM-dd"));
                        archiveLogInfo.setSkssqz(DateUtil.stringToDate((String)map.get("enddate"), "yyyy-MM-dd"));
                        DynamicObject temp = SingleArchiveUtil.getTaxArhieveDynamicObject(archiveLogInfo);
                        dynamicObjects.add(temp);
                    }
                }
            } else {
                needArchiveIds.addAll(this.ids);
                declareList = (List)SerializationUtils.fromJsonString((String)this.context.getArchiverange(), List.class);
                if (declareList != null && declareList.size() > 0) {
                    fpyUploadItem.setPeriod((String)((Map)declareList.get(0)).get("period"));
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)this.orgId).toArray());
                    orgNo = dynamicObject.getString("number");
                    orgName = dynamicObject.getString("name");
                    fpyUploadItem.setAccountBookNo(orgNo);
                    fpyUploadItem.setAccountBookName(orgName);
                    for (Map map : declareList) {
                        Long l = (Long)map.get("id");
                        String billNo = (String)map.get("billno");
                        billidsMap.put(l + "." + this.billType + "_" + l.toString(), this.billName + billNo);
                        billFileNameMap.put(l, (String)map.get("filename"));
                    }
                }
            }
        }
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"ArchiveMultGlvoucherByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, needArchiveIds.size(), Thread.currentThread().getName());
        if (errDyns.size() > 0) {
            LogUtil.saveErrorLog(errDyns);
        }
        this.context.setNeedArchiveIds(needArchiveIds);
        if (needArchiveIds.size() == 0) {
            return;
        }
        Map<Object, Object> attachMap = new HashMap(16);
        if ("1".equals(this.isNeedAttachFile) && "1".equals(this.isReverse)) {
            attachMap = SingleArchiveUtil.getIdAndAttacheFiles(this.billType, needArchiveIds);
            for (Map.Entry entry : attachMap.entrySet()) {
                long l = (Long)entry.getKey();
                List attaches = (List)entry.getValue();
                try {
                    if (attaches == null) continue;
                    for (Attach attach : attaches) {
                        String url = attach.getUrl();
                        fpyUploadItem.setFileName(l + "_" + attach.getFileName());
                        this.setAttachmentsRelatedInfo(fpyUploadItem, url);
                        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                    }
                }
                catch (IOException e) {
                    logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveTaxByFpyLogicUnit_5", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
            }
        }
        String xmlstr = "";
        try {
            if ("bill".equals(taxarchivedata)) {
                xmlstr = CreateXmlUtil.createTaxBillXml(taxarchivedata, xmlSet, declareList, billFileNameMap, this.billName, attachMap, this.billType, this.flag, needArchiveIds, extMap);
                String string = String.format(ResManager.loadKDString((String)"%s\u7a0e\u52a1\u5355\u636e", (String)"FPYDocumentServerHandler_11", (String)"fi-aef-common", (Object[])new Object[0]), orgName + "_" + fpyUploadItem.getPeriod() + "_");
                fpyUploadItem.setFilebase64(xmlstr);
                fpyUploadItem.setFileName(string + this.batchCode + ".xml");
                fpyUploadItem.setBillidsMap(billidsMap);
                this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
            }
            if ("tccit".equals(taxarchivedata)) {
                for (Map map : declareList) {
                    periodDacList.computeIfAbsent((String)map.get("period"), value -> new ArrayList()).add(map);
                }
                for (Map.Entry entry : periodDacList.entrySet()) {
                    String period = (String)entry.getKey();
                    String desc = String.format(ResManager.loadKDString((String)"%s\u7a0e\u52a1\u5355\u636e", (String)"FPYDocumentServerHandler_11", (String)"fi-aef-common", (Object[])new Object[0]), orgName + "_" + period + "_");
                    List perioddeclare = (List)entry.getValue();
                    xmlstr = CreateXmlUtil.createTaxBillXml(taxarchivedata, xmlSet, perioddeclare, billFileNameMap, this.billName, attachMap, this.billType, this.flag, needArchiveIds, extMap);
                    fpyUploadItem.setPeriod(period);
                    fpyUploadItem.setFilebase64(xmlstr);
                    fpyUploadItem.setFileName(desc + this.batchCode + ".xml");
                    fpyUploadItem.setBillidsMap(billidsMap);
                    this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
                }
            }
        }
        catch (Exception exception) {
            logger.error(String.format("\u5f52\u6863%1$s\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", this.billName, exception));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveCommonBillByFpyLogicUnit_6", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, exception));
        }
        if ("1".equals(this.isReverse)) {
            this.saveTaxObjects(CLASS_NAME, dynamicObjects, this.billName, needArchiveIds, this.billType);
            this.saveArchieveconfig(this.billType, this.batchCode, this.isNeedAttachFile, null);
        } else {
            this.updateTaxToReserve(CLASS_NAME, needArchiveIds, this.billType, this.context.getReverseReason(), this.batchCode);
            this.deleteTaxArchieveconfig(this.billType, this.context.getBatchcode());
        }
        this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
    }

    private Set<Long> getHasArchivedIds(String uploadWay, long orgid, String billtype) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("uploadWay", "=", (Object)uploadWay);
        QFilter qFilter1 = new QFilter("type", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("org", "=", (Object)orgid);
        QFilter qFilter3 = new QFilter("billtype", "=", (Object)billtype);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CLASS_NAME, (String)"aef_acelre_tax", (String)"billid", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3}, null);){
            for (Row row : dataSet) {
                ids.add(row.getLong("billid"));
            }
        }
        return ids;
    }
}

