/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.ftp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileNameUtils;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.FileItemInfo;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveBillByFtpLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveBillByFtpLogicUnit.class);

    @Override
    protected void execute() {
        String url;
        this.context.setNeedArchiveIds(this.ids);
        FileService service = FileServiceFactory.getAttachmentFileService();
        if ("gl_voucher".equals(this.billType)) {
            SingleArchiveUtil.createThreadCache(this.billType, this.ids);
        }
        BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.billType);
        String dateField = this.context.getDateField();
        String period = QueryFinanceBillHelper.getPeriodField(this.billType);
        String selectFields = ArchiveUtil.getSelectFields(this.billType, dateField);
        String idField = ArchiveUtil.getFieldName(this.billType, "id");
        String billnoField = ArchiveUtil.getFieldName(this.billType, QueryFinanceBillHelper.getBillNo(this.billType));
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> filePaths = new ArrayList<DynamicObject>();
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)selectFields, (QFilter[])new QFilter[]{idFilter}, null);
        Date date = new Date();
        HashMap<Long, String> idAndNumber = new HashMap<Long, String>(100);
        while (set.hasNext()) {
            Row row = set.next();
            String billId = row.getString(idField);
            idAndNumber.put(row.getLong(idField), row.getString(billnoField));
            Object pdfData = null;
            ArrayList<Object> pks = new ArrayList<Object>(2);
            pks.add(row.get(idField));
            if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                pdfData = FileUtils.getPrintByte(this.pageId, this.billType, this.printId, pks, "billForm", this.printType);
            } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(row.get(idField)))) {
                PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(row.get(idField));
                pdfData = FileUtils.getPrintByte(this.pageId, this.billType, printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
            } else {
                String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveCommonBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, row.getString(billnoField));
                logger.error(string);
                continue;
            }
            FileItem fileItem = SingleArchiveUtil.getFileItem(this.tenantId, this.accountId, (byte[])pdfData, this.billName + row.getString(billnoField), this.billType);
            url = "";
            url = service.upload(fileItem);
            DynamicObject billPath = SingleArchiveUtil.getBillPathDynamicObject(url, this.billType, 1, row.getLong(idField), this.userId, billId + ".pdf", date);
            filePaths.add(billPath);
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordDynamicObject(this.billType, this.application, this.schemeId, row, this.userId, date, this.uploadway, "1", null, dateField == null ? null : row.getDate("period"), null, null);
            dynamicObjects.add(temp);
        }
        if ("1".equals(this.isNeedAttachFile)) {
            DataSet attaches = SingleArchiveUtil.getAttacheDynamicObjects(this.billType, this.ids);
            ArrayList<FileItemInfo> fileItemList = new ArrayList<FileItemInfo>(10);
            try {
                for (Row row : attaches) {
                    String fileName = row.getString("fattachmentname");
                    url = row.getString("ffileid");
                    Long finterid = row.getLong("finterid");
                    byte[] fileData = FileUtils.downLoadHttpsFile(url);
                    ByteArrayInputStream in = new ByteArrayInputStream(fileData);
                    FileItem fileItem = new FileItem(fileName, FileNameUtils.getImageAttFileName((String)this.tenantId, (String)this.accountId, (String)this.billType, (Object)row.get("finterid"), (String)(this.billName + (String)idAndNumber.get(finterid) + fileName)), (InputStream)in);
                    FileItemInfo fileItemInfo = new FileItemInfo(fileItem, row.getString("finterid"));
                    fileItemList.add(fileItemInfo);
                }
            }
            catch (IOException e) {
                logger.error(String.format("%1$s\u83b7\u53d6\u9644\u4ef6\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u9644\u4ef6\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveBillByFtpLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            for (FileItemInfo itemInfo : fileItemList) {
                String attacheurl = "";
                try {
                    attacheurl = service.upload(itemInfo.getFileItem());
                }
                catch (Exception e) {
                    logger.error(String.format("%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveBillByFtpLogicUnit_4", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
                DynamicObject attachePath = SingleArchiveUtil.getBillPathDynamicObject(attacheurl, this.billType, 0, Long.valueOf(itemInfo.getBillId()), this.userId, itemInfo.getFileItem().getFileName(), date);
                filePaths.add(attachePath);
            }
        }
        try (TXHandle tx = TX.requiresNew((String)"ArchiveBillByFtpLogicUnit");){
            try {
                SingleArchiveUtil.saveAefAcelreByFtp(dynamicObjects, filePaths);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}\u3002", (String)"ArchiveBillByFtpLogicUnit_5", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
        if ("gl_voucher".equals(this.billType)) {
            ThreadCache.remove((Object)"glVoucher");
        }
    }
}

