/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.ftp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.RptArchiveUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveReportFormByFtpLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveReportFormByFtpLogicUnit.class);
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);

    @Override
    protected void execute() {
        String uploadway = this.context.getUploadWay();
        String schemeId = this.context.getSchemeId() + "";
        long bcmscene = this.context.getBcmscene();
        String bcmsceneType = this.context.getBcmsceneType();
        long bcmfy = this.context.getBcmfy();
        String bcmperiodJson = this.context.getBcmperiodJson();
        Map bcmPeriodMap = (Map)SerializationUtils.deSerializeFromBase64((String)bcmperiodJson);
        Date date = new Date();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        String hasCountkey = this.context.getPageId() + "hasarchievecount";
        String allCountKey = this.context.getPageId() + "allcount";
        Set<String> hasArchivedKeys = RptArchiveUtil.getHasArchivedKeys(uploadway, bcmscene, bcmfy, bcmPeriodMap.keySet());
        HashMap<String, Map> allrptUrlMap = new HashMap<String, Map>(16);
        ArrayList<String> allKeys = new ArrayList<String>(16);
        ArrayList<DynamicObject> filePaths = new ArrayList<DynamicObject>();
        for (Map.Entry periodEntry : bcmPeriodMap.entrySet()) {
            Long bcmperiod = (Long)periodEntry.getKey();
            this.context.setBcmperiod(bcmperiod);
            Map<String, String> result = SingleArchiveUtil.invokeBcmPrintService(this.context);
            if (result.isEmpty()) continue;
            for (Map.Entry<String, String> entry : result.entrySet()) {
                String key = entry.getKey();
                if (hasArchivedKeys.contains(key)) continue;
                String[] keyArr = key.split("_");
                Map tempMap = allrptUrlMap.computeIfAbsent(Long.parseLong(keyArr[0]) + "_" + bcmperiod, value -> new HashMap());
                tempMap.put(entry.getKey(), entry.getValue());
                allKeys.add(key);
            }
        }
        if (allrptUrlMap.isEmpty()) {
            return;
        }
        String allCountStr = this.cache.get(allCountKey);
        int allCount = allCountStr == null ? 0 : Integer.parseInt(allCountStr);
        this.cache.put(allCountKey, allCount + allKeys.size() + "");
        FileService service = FileServiceFactory.getAttachmentFileService();
        int count = 0;
        for (Map.Entry<String, String> entry : allrptUrlMap.entrySet()) {
            Map rptUrlMap = (Map)((Object)entry.getValue());
            long bcmperiod = Long.parseLong(entry.getKey().split("_")[1]);
            for (Map.Entry entry2 : rptUrlMap.entrySet()) {
                String key = (String)entry2.getKey();
                String url = (String)entry2.getValue();
                String[] keyArr = key.split("_");
                String pdfUrl = null;
                try {
                    url = UrlService.getDomainContextUrl() + "/" + url;
                    byte[] fileData = FileUtils.downLoadFileFromUrl(url);
                    if (fileData.length > 0) {
                        FileItem fileItem = SingleArchiveUtil.getFileItem(this.tenantId, this.accountId, fileData, key, "aef_rpt");
                        pdfUrl = service.upload(fileItem);
                    }
                }
                catch (IOException e) {
                    logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", bcmsceneType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveCommonBillByFpyLogicUnit_5", (String)"fi-aef-common", (Object[])new Object[0]), bcmsceneType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
                DynamicObject billPath = SingleArchiveUtil.getBillPathDynamicObject(pdfUrl, "aef_rpt", 1, Long.parseLong(keyArr[2]), this.userId, key + ".pdf", date);
                filePaths.add(billPath);
                DynamicObject temp = SingleArchiveUtil.getRptArhieveRecordDynamicObject(schemeId, this.userId, date, uploadway, "1", null, null, key, bcmscene, bcmfy, bcmperiod, this.batchCode);
                temp.set("billid", (Object)Long.parseLong(keyArr[2]));
                temp.set("billno", (Object)Long.parseLong(keyArr[2]));
                dynamicObjects.add(temp);
                this.cache.put(hasCountkey, ++count + "");
            }
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"ArchiveReportFormByFtpLogicUnit");){
            try {
                SingleArchiveUtil.saveAefAcelreByFtp(dynamicObjects, filePaths);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%s}", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%s}", (String)"ArchiveReportFormLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }
}

