/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.ftp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveRptByFtpLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveRptByFtpLogicUnit.class);

    @Override
    protected void execute() {
        Date date = new Date();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> filePaths = new ArrayList<DynamicObject>();
        String uniqueKey = this.orgId + "-" + this.booktypeId + "-" + this.periodId;
        try (ReportPrintUtil reportUtil = new ReportPrintUtil();){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org", this.orgId);
            map.put("startperiod", this.periodId);
            map.put("endperiod", this.periodId);
            map.put("bookType", this.booktypeId);
            if ("gl_rpt_subledger".equals(this.billType) || "gl_rpt_generalledger".equals(this.billType)) {
                map.put("isAsynQuery", Boolean.TRUE);
            }
            String pageId = reportUtil.simulateReportSearch(this.billType, map);
            byte[] pdfData = null;
            if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                pdfData = FileUtils.getPrintByte(pageId, this.billType, this.printId, null, "report", this.printType);
            } else {
                List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
                pdfData = FileUtils.getPrintByte(pageId, this.billType, print, null, "report", ((PrintTemplate)templateList.get(0)).getPrintType());
            }
            FileItem fileItem = SingleArchiveUtil.getReportFileItem(this.tenantId, this.accountId, pdfData, this.billType, map);
            FileService service = FileServiceFactory.getAttachmentFileService();
            String url = "";
            try {
                url = service.upload(fileItem);
            }
            catch (Exception e) {
                String billName = EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
                logger.error(String.format("%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveRptByFtpLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            Long billId = System.currentTimeMillis();
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordRptDynamicObject(this.billType, this.application, this.schemeId, map, date, this.uploadway, billId, this.userId, "1", null, null, uniqueKey, this.batchCode, this.booktypeId);
            dynamicObjects.add(temp);
            DynamicObject billPath = SingleArchiveUtil.getBillPathDynamicObject(url, this.billType, 1, billId, this.userId, fileItem.getFileName(), date);
            filePaths.add(billPath);
            try (TXHandle tx = TX.requiresNew((String)"ArchiveRptByFtpLogicUnit");){
                try {
                    SingleArchiveUtil.saveAefAcelreByFtp(dynamicObjects, filePaths);
                }
                catch (Exception e) {
                    tx.markRollback();
                    String billName = EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
                    logger.error(String.format("%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%2$s}\u3002", (String)"ArchiveRptByFtpLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
            }
        }
    }
}

