/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.out;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class OutElecstatementWithVATinvoice
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(OutElecstatementWithVATinvoice.class);

    @Override
    protected void execute() {
        BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.billType);
        String billName = bet.getDisplayName().toString();
        String dateField = this.context.getDateField();
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        String mainOrg = bet.getMainOrg();
        String billNo = QueryFinanceBillHelper.getBillNo(this.billType);
        String selectFileds = "id," + dateField + " datefield," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + billNo + ",period, currency.number currency, accountbankname accountname, accountbank.number accountno";
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)this.billType, (String)selectFileds, (QFilter[])new QFilter[]{idFilter}, null);
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863\u94f6\u884c\u5bf9\u8d26\u5355xbrl\u7684\u5355\u636e\u6709:{},\u7ebf\u7a0b {}", (String)"OutElecstatementWithVATinvoice_1", (String)"fi-aef-common", (Object[])new Object[0]), this.ids.size(), Thread.currentThread().getName());
        Map<String, DynamicObject> receiptPlgins = this.getTypeWithReceipt();
        Map<Long, List<JSONObject>> jsonMap = ElecreceiptUtils.findReceiptJson(this.billType, this.ids, receiptPlgins, this.pageId);
        HashSet<Long> needArchiveIds = new HashSet<Long>(16);
        while (set.hasNext()) {
            Row row = set.next();
            Long billId = row.getLong("id");
            List<Object> jsons = new ArrayList(16);
            if (jsonMap != null && jsonMap.size() > 0) {
                jsons = jsonMap.get(billId);
            }
            if (jsons == null || jsons.size() <= 0) continue;
            try {
                for (JSONObject json : jsons) {
                    needArchiveIds.add(billId);
                    String lastDir = FileUtils.getLastXbrlDir();
                    byte[] xbrlData = FileUtils.json2Xbrl(json.toJSONString(), "bkrs");
                    FileUtils.writeToFile(xbrlData, FileUtils.getXbrlWriteDir(lastDir + File.separator + ContextUtil.createXBRLPath("bkrs", json)) + File.separator + ContextUtil.createXBRLFilename("bkrs", json));
                    FileUtils.zipSpecFile(lastDir + File.separator + ContextUtil.createXBRLPath("bkrs", json));
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u7535\u5b50\u5bf9\u8d26\u5355\u6587\u4ef6\u5931\u8d25{%2$s}", (String)"ArchiveElecstatementWithVATinvoice_0", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
        this.context.setNeedArchiveIds(needArchiveIds);
    }

    private Map<String, DynamicObject> getTypeWithReceipt() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isinvoice", "!=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }
}

