/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.out;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.AefUtil;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.elec.util.XbrlArchieveUtil;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class OutGlvoucherWithVATinvoice
extends AbstractArchiveLogicUnit {
    private static final String SELECT_FIELDS = "id,billno,org.id org,org.number orgnumber,org.name orgname,period.id period,period.number periodnumber,period.name periodname,attachment,vouchertype.name vouchertypename,localcur.number localcurnumber,vdescription,booktype.number booktypenumber,booktype.name booktypename,creator.name creatorname,auditor.name auditorname,debitlocamount,creditlocamount,bookeddate accountdate,posttime posting_date";
    private static final Log logger = LogFactory.getLog(OutGlvoucherWithVATinvoice.class);
    private static final String XBRLURL = "xbrlUrl";
    private static final String INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE = "InformationOfAccountingDocumentsTuple";
    private String period;

    @Override
    protected void execute() {
        String refbillType;
        String billType = this.context.getBillType();
        Set<Long> ids = this.context.getIds();
        String pageId = this.context.getPageId();
        QFilter idFilter = new QFilter("id", "in", ids);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)billType, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{idFilter}, null);
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863{}xbrl\u7684\u5355\u636e\u6709:{},\u7ebf\u7a0b {}", (String)"OutGlvoucherWithVATinvoice_3", (String)"fi-aef-common", (Object[])new Object[0]), billType, ids.size(), Thread.currentThread().getName());
        while (set.hasNext()) {
            Row row = set.next();
            Long billId = row.getLong("id");
            this.period = DateUtil.format(DateUtil.stringToDate(row.getString("periodnumber"), "yyyyMM"), "yyyy-MM");
        }
        Map<Long, Map<String, Set<Long>>> linkUpBills = AefUtil.getLinkUpBills(ids);
        Map<Object, Object> VATBillTypes = new HashMap(16);
        VATBillTypes = this.getVATBillTypes();
        Map<String, DynamicObject> invoicePlgins = this.getTypeWithInvoice();
        Map<String, DynamicObject> receiptPlgins = this.getTypeWithReceipt();
        Set<String> isinvoiceSet = new HashSet<String>(16);
        HashSet<String> isreceiptSet = new HashSet(16);
        HashSet<String> refBillTypes = new HashSet<String>();
        if (!VATBillTypes.isEmpty()) {
            if (VATBillTypes.containsKey("isinvoice")) {
                isinvoiceSet = (Set)VATBillTypes.get("isinvoice");
                refBillTypes.addAll(isinvoiceSet);
            }
            if (VATBillTypes.containsKey("isreceipt")) {
                isreceiptSet = (Set)VATBillTypes.get("isreceipt");
                refBillTypes.addAll(isreceiptSet);
            }
        }
        Map<String, Set<Long>> invoiceBilltypeAndIds = this.getRefBilltypeAndIds(linkUpBills, isinvoiceSet);
        LogUtil.printLog(logger, "linkUpBills: {}", linkUpBills);
        Map<String, Set<Long>> isreceiptBilltypeAndIds = this.getHasReceiptBill(AefUtil.getVoucherLinkUpBillsInFast(ids), isreceiptSet);
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(refBillTypes, linkUpBills);
        HashSet<Long> buildXbrlVoucherIds = new HashSet<Long>(16);
        billAndRefvoucherIds.forEach((key, value) -> {
            Map getIdmap = value;
            getIdmap.forEach((billid, voucherIds) -> buildXbrlVoucherIds.addAll((Collection<Long>)voucherIds));
        });
        LogUtil.printLog(logger, "buildXbrlVoucherIds: {}", ((Object)buildXbrlVoucherIds).toString());
        LogUtil.printLog(logger, "billAndRefvoucherIds: {}", billAndRefvoucherIds);
        HashMap<Long, JSONObject> voucherHeadJson = new HashMap<Long, JSONObject>(16);
        Map<Object, Object> voucherJson = new HashMap(16);
        this.context.setNeedArchiveIds(buildXbrlVoucherIds);
        if (buildXbrlVoucherIds.size() == 0) {
            return;
        }
        voucherJson = ArchiveUtil.getVoucherJson(buildXbrlVoucherIds, voucherHeadJson);
        if (!invoiceBilltypeAndIds.isEmpty()) {
            LogUtil.printLog(logger, "invoiceBilltypeAndIds: {}", invoiceBilltypeAndIds);
            for (Map.Entry<String, Set<Long>> sentry : invoiceBilltypeAndIds.entrySet()) {
                refbillType = sentry.getKey();
                Map<Long, List<JSONObject>> billInvoice = ElecreceiptUtils.findInvoiceJson(refbillType, sentry.getValue(), invoicePlgins);
                Map<Long, List<Long>> dapVoucher = this.getDapRelation(sentry.getKey(), sentry.getValue());
                if (billInvoice == null || billInvoice.size() <= 0) continue;
                Map<String, JSONObject> seqNoAndJson = XbrlArchieveUtil.getSeqNoAndJson(billInvoice);
                for (Map.Entry<Long, List<JSONObject>> entry : billInvoice.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        if (SysParamConfig.getBoolean("ischeckxbrlurl", true) && StringUtils.isBlank((CharSequence)sourcejson.getString(XBRLURL))) continue;
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        String uniqueKey = json.getString("seqNo");
                        String tickettype = json.getString("tickettype");
                        if (XbrlArchieveUtil.NEED_FIND_VOICEINFO_TICKETTYPRS.contains(tickettype)) {
                            if (!seqNoAndJson.containsKey(uniqueKey)) continue;
                            json.putAll((Map)seqNoAndJson.get(uniqueKey));
                        }
                        JSONObject vJson = new JSONObject(new LinkedHashMap());
                        Set<Long> vids = billAndRefvoucherIds.get(refbillType).get(entry.getKey());
                        ArrayList<Long> vList = new ArrayList<Long>(16);
                        vList.addAll(vids);
                        Long pkId = 0L;
                        if (dapVoucher.get(entry.getKey()) != null) {
                            List<Long> dapList = dapVoucher.get(entry.getKey());
                            dapList.retainAll(vList);
                            if (dapList.size() > 0) {
                                pkId = dapList.get(0);
                            }
                        } else {
                            pkId = (Long)vList.get(0);
                        }
                        vJson.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, voucherJson.get(pkId));
                        json.putAll((Map)voucherHeadJson.get(pkId));
                        json.putAll((Map)vJson);
                        ArchiveUtil.setDefaultJson(json, this.period);
                        byte[] xbrlData = FileUtils.json2Xbrl(json.toJSONString(), tickettype);
                        String fullpath = FileUtils.getXbrlWriteDir(FileUtils.getLastXbrlDir() + File.separator + ContextUtil.createXBRLPath(tickettype, json));
                        FileUtils.writeToFile(xbrlData, fullpath + File.separator + ContextUtil.createXBRLFilename(tickettype, json));
                        String issuerUrl = json.getString(XBRLURL);
                        if (StringUtils.isNotEmpty((CharSequence)issuerUrl)) {
                            try {
                                byte[] issuerData = FileUtils.downLoadFromUrl(issuerUrl);
                                if (issuerData != null && issuerData.length > 0) {
                                    FileUtils.writeToFile(issuerData, fullpath + File.separator + ContextUtil.createXBRLFilename(tickettype, json).replace("receiver", "issuer"));
                                }
                            }
                            catch (IOException e) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u5f00\u5177\u7aefxbrl\u6587\u4ef6\u5931\u8d25{%2$s}", (String)"OutGlvoucherWithVATinvoice_0", (String)"fi-aef-common", (Object[])new Object[0]), tickettype.replace("receiver", "issuer"), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                            }
                        }
                        FileUtils.zipSpecFile(FileUtils.getLastXbrlDir() + File.separator + ContextUtil.createXBRLPath(tickettype, json));
                    }
                }
            }
        }
        if (!isreceiptBilltypeAndIds.isEmpty()) {
            logger.info(String.format("\u672c\u6b21\u9700\u8981\u5f52\u6863\u56de\u5355xbrl\u7684\u5173\u8054\u5355\u636e\u6709:%s", isreceiptBilltypeAndIds));
            for (Map.Entry<String, Set<Long>> sentry : isreceiptBilltypeAndIds.entrySet()) {
                refbillType = sentry.getKey();
                Map<Long, List<JSONObject>> billreceipt = ElecreceiptUtils.findReceiptJson(refbillType, sentry.getValue(), receiptPlgins, pageId);
                if (billreceipt == null || billreceipt.size() <= 0) continue;
                for (Map.Entry<Long, List<JSONObject>> entry : billreceipt.entrySet()) {
                    for (JSONObject sourcejson : entry.getValue()) {
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        JSONObject vJson = new JSONObject(new LinkedHashMap());
                        Set<Long> vids = billAndRefvoucherIds.get(refbillType).get(entry.getKey());
                        ArrayList<Long> vList = new ArrayList<Long>(16);
                        vList.addAll(vids);
                        Long voucherId = (Long)vList.get(0);
                        vJson.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, voucherJson.get(voucherId));
                        json.putAll((Map)voucherHeadJson.get(voucherId));
                        json.putAll((Map)vJson);
                        ArchiveUtil.setDefaultJson(json, this.period);
                        String uniqueKey = json.getString("IdentifyingCode");
                        String tickettype = "bker_receiver";
                        try {
                            byte[] pdfData;
                            String url = json.getString("url");
                            if (StringUtils.isNotBlank((CharSequence)url) && (pdfData = FileUtils.downLoadHttpsFile(url)) != null && pdfData.length > 0) {
                                String fullpath = FileUtils.getXbrlWriteDir(FileUtils.getLastXbrlDir() + File.separator + ContextUtil.createXBRLPath(tickettype, json));
                                FileUtils.writeToFile(pdfData, fullpath + File.separator + ElecreceiptUtils.getFileName(url));
                                if (url.endsWith(".ofd") || url.endsWith(".pdf")) {
                                    FileUtils.extractXBRL(fullpath + File.separator + ElecreceiptUtils.getFileName(url), fullpath + File.separator + ContextUtil.createXBRLFilename(tickettype, json).replace("receiver", "issuer"));
                                }
                            }
                            json.remove((Object)"url");
                            byte[] xbrlData = FileUtils.json2Xbrl(json.toJSONString(), tickettype);
                            FileUtils.writeToFile(xbrlData, FileUtils.getXbrlWriteDir(FileUtils.getLastXbrlDir() + File.separator + ContextUtil.createXBRLPath(tickettype, json)) + File.separator + ContextUtil.createXBRLFilename(tickettype, json));
                            FileUtils.zipSpecFile(FileUtils.getLastXbrlDir() + File.separator + ContextUtil.createXBRLPath(tickettype, json));
                        }
                        catch (Exception e) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u5f00\u5177\u7aefxbrl\u6587\u4ef6\u5931\u8d25{%2$s}", (String)"OutGlvoucherWithVATinvoice_0", (String)"fi-aef-common", (Object[])new Object[0]), tickettype.replace("receiver", "issuer"), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        }
                    }
                }
            }
        }
    }

    private Map<String, Set<Long>> getRefBilltypeAndIds(Map<Long, Map<String, Set<Long>>> linkUpBills, Set<String> refBillTypes) {
        HashMap<String, Set<Long>> refBilltypeAndIds = new HashMap<String, Set<Long>>();
        if (refBillTypes.isEmpty()) {
            return refBilltypeAndIds;
        }
        for (Map<String, Set<Long>> map : linkUpBills.values()) {
            for (Map.Entry<String, Set<Long>> m : map.entrySet()) {
                String key = m.getKey();
                if (!refBillTypes.contains(key)) continue;
                refBilltypeAndIds.computeIfAbsent(key, value -> new HashSet()).addAll((Collection)m.getValue());
            }
        }
        return refBilltypeAndIds;
    }

    private Map<String, Set<String>> getVATBillTypes() {
        String algoKey = this.getClass().getName() + "getVATBillTypes";
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>(16);
        try (DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aef_billconfig", (String)"billtype.number billtype, isinvoice, isreceipt", null, null);){
            if (set != null) {
                for (Row row : set) {
                    if (row.getBoolean("isinvoice").booleanValue()) {
                        Set isinvoiceSet = returnMap.computeIfAbsent("isinvoice", Value -> new HashSet());
                        isinvoiceSet.add(row.getString("billtype"));
                    }
                    if (!row.getBoolean("isreceipt").booleanValue()) continue;
                    Set isreceiptSet = returnMap.computeIfAbsent("isreceipt", Value -> new HashSet());
                    isreceiptSet.add(row.getString("billtype"));
                }
            }
        }
        return returnMap;
    }

    private Map<String, DynamicObject> getTypeWithInvoice() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isinvoice", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }

    private Map<String, DynamicObject> getTypeWithReceipt() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isreceipt", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }

    private Map<String, Set<Long>> getHasReceiptBill(Map<String, Set<Long>> linkUpBills, Set<String> refBillTypes) {
        logger.info("getHasReceiptBill : {}", linkUpBills);
        HashMap<String, Set<Long>> refBilltypeAndIds = new HashMap<String, Set<Long>>();
        if (refBillTypes.isEmpty()) {
            return refBilltypeAndIds;
        }
        for (Map.Entry<String, Set<Long>> m : linkUpBills.entrySet()) {
            String key = m.getKey();
            Set<Long> refids = m.getValue();
            if (!refBillTypes.contains(key)) continue;
            refBilltypeAndIds.computeIfAbsent(key, value -> new HashSet()).addAll(refids);
        }
        logger.info("refBilltypeAndIds:{}", refBilltypeAndIds);
        return refBilltypeAndIds;
    }
}

