/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.api;

import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class UpdateAcelreStatusApiService
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(UpdateAcelreStatusApiService.class);
    private static final String BATCHNUMBER = "batchNumber";
    private static final String BILLTYPE = "billtype";
    private static final String BILLID = "billid";
    private static final String ISARCHIVESUCCESS = "isArchiveSuccess";
    private static final String ARCHIVEFAILREASON = "archiveFailReason";
    private static final String T_AEF_ARCHIVE_LOG = "t_aef_archive_log";
    private static final String T_AEF_ACELRE_RPT_LOG = "t_aef_acelre_rpt_log";
    private static final String T_AEF_ARCHIVETAX_LOG = "t_aef_archivetax_log";

    public ApiResult doCustomService(Map<String, Object> params) {
        String billType = (String)params.get(BILLTYPE);
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"UpdateAcelreStatusApiService_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        List billIds = (List)params.get(BILLID);
        if (null == billIds || billIds.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a", (String)"UpdateAcelreStatusApiService_2", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        Boolean isArchiveSuccess = (Boolean)params.get(ISARCHIVESUCCESS);
        if (null == isArchiveSuccess) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u662f\u5426\u5f52\u6863\u6210\u529f\u4e0d\u80fd\u4e3a\u7a7a", (String)"UpdateAcelreStatusApiService_3", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        int count = this.updateRecords(params, billType, billIds, isArchiveSuccess);
        logger.info("updateAcelreStatus\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570params\uff1a{}, \u66f4\u65b0\u6210\u529f{}\u6761\u8bb0\u5f55", params, (Object)count);
        return ApiResult.success((Object)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f%1$s\u6761", (String)"UpdateAcelreStatusApiService_4", (String)"fi-aef-formplugin", (Object[])new Object[0]), count));
    }

    private int updateRecords(Map<String, Object> params, String billType, List<Long> billIds, Boolean isArchiveSuccess) {
        String archiveFailReason = (String)params.get(ARCHIVEFAILREASON);
        String batchNumber = (String)params.get(BATCHNUMBER);
        if (null == archiveFailReason) {
            archiveFailReason = " ";
        } else if (archiveFailReason.length() > 500) {
            archiveFailReason = archiveFailReason.substring(0, 497) + "...";
        }
        String status = Boolean.TRUE.equals(isArchiveSuccess) ? "0" : "1";
        int updateCount = 0;
        int length = 1000;
        int size = billIds.size();
        int count = (size + length - 1) / length;
        String sqlFormat = "update %1$s set fstatus=?,ffailreason=? where fbilltype=? and fbillid in (%2$s)";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"bizappid.bizcloud bizcloud", (QFilter[])new QFilter("id", "=", (Object)billType).toArray());
        String couldid = dynamicObject.getString("bizcloud");
        String tableName = T_AEF_ARCHIVE_LOG;
        switch (billType) {
            case "aef_rpt": {
                tableName = T_AEF_ACELRE_RPT_LOG;
                break;
            }
            default: {
                if (!"/RFOWJE1X=MZ".equals(couldid)) break;
                tableName = T_AEF_ARCHIVETAX_LOG;
            }
        }
        for (int i = 0; i < count; ++i) {
            int start = length * i;
            int end = Math.min(length * (i + 1), size);
            List<Long> batchIds = billIds.subList(start, end);
            String batchIdsParam = StringUtils.join(batchIds, (String)",");
            String updateSql = String.format(sqlFormat, tableName, batchIdsParam);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(updateSql, new Object[]{status, archiveFailReason, billType});
            if (StringUtils.isNotBlank((CharSequence)batchNumber)) {
                sqlBuilder.append("and fbatchcode = ?", new Object[]{batchNumber});
            }
            int records = this.updateLog(sqlBuilder);
            updateCount += records;
        }
        return updateCount;
    }

    private int updateLog(SqlBuilder sqlBuilder) {
        int records = DB.update((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        return records;
    }
}

