/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListGridView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.ImageViewUtils;
import kd.fi.aef.common.util.SysParamConfig;

public class AccElectronicRecordPlugin
extends AbstractListPlugin
implements FilterContainerInitListener {
    private static final String AEF_ACELRE = "aef_acelre";

    public void initialize() {
        super.initialize();
        ListGridView grid = (ListGridView)this.getView().getControl("gridview");
        grid.addClickListener((ClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"imageview", "archivewrite"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "imageview": {
                this.imageView();
                break;
            }
        }
    }

    private void imageView() {
        DynamicObject entry = this.getCurSelectedRow();
        if (entry == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5217\u8868\u4e2d\u7684\u4e00\u884c\u8fdb\u884c\u67e5\u770b\u5f71\u50cf\u3002", (String)"AccElectronicRecordPlugin_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            return;
        }
        String uploadway = entry.getString("uploadway");
        if ("3".equals(uploadway) || "5".equals(uploadway) || "6".equals(uploadway)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u65b9\u5f0f\u5f52\u6863\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5f71\u50cf\u3002", (String)"AccElectronicRecordPlugin_2", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            return;
        }
        String billId = entry.getString("billid");
        String billType = entry.getString("billType.id");
        ImageViewUtils.imageView((IFormView)this.getView(), (String)billId, (String)billType);
    }

    private DynamicObject getCurSelectedRow() {
        ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
        if (listSelectedRows.size() <= 0 || listSelectedRows.size() > 1) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)listSelectedRows.get(0).getPrimaryKeyValue(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AEF_ACELRE));
        return dynamicObject;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Map map;
        ControlFilter type;
        IListColumn currencyListColumn = args.getListColumn("reason");
        List columns = args.getListColumns();
        columns.remove(currencyListColumn);
        IListView view = (IListView)this.getView();
        ControlFilters cfs = view.getControlFilters();
        if (cfs != null && (type = (ControlFilter)(map = cfs.getFilters()).get("type")) != null) {
            List vals = type.getValue();
            if ("2".equals(vals.get(0))) {
                view.setVisible(Boolean.valueOf(false), new String[]{"reversefiling"});
                view.setVisible(Boolean.valueOf(false), new String[]{"imageview"});
                columns.add(currencyListColumn);
            } else {
                view.setVisible(Boolean.valueOf(true), new String[]{"reversefiling"});
                if ("2".equals(this.getPageCache().get("uploadway"))) {
                    view.setVisible(Boolean.valueOf(true), new String[]{"imageview"});
                }
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent evt) {
        super.filterColumnSetFilter(evt);
        String field = evt.getFieldName();
        if (field.startsWith("org.")) {
            HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
            if (resutlt.hasAllOrgPerm()) {
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".filterColumnSetFilter"), (String)AEF_ACELRE, (String)"org", null, null).groupBy(new String[]{"org"}).finish();){
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    ds.forEach(row -> orgIds.add(row.getLong("org")));
                    ArrayList<QFilter> customQFilters = new ArrayList<QFilter>(1);
                    customQFilters.add(new QFilter("id", "in", orgIds));
                    evt.setCustomQFilters(customQFilters);
                    this.setOrgCache(orgIds);
                }
            } else {
                List orgIds = resutlt.getHasPermOrgs();
                if (orgIds != null && orgIds.size() > 0) {
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".filterColumnSetFilter"), (String)AEF_ACELRE, (String)"org", null, null).groupBy(new String[]{"org"}).finish();){
                        ArrayList hasOrgIds = new ArrayList();
                        ds.forEach(row -> hasOrgIds.add(row.getLong("org")));
                        orgIds.retainAll(hasOrgIds);
                        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>(1);
                        customQFilters.add(new QFilter("id", "in", (Object)orgIds));
                        evt.setCustomQFilters(customQFilters);
                        this.setOrgCache(orgIds);
                    }
                }
            }
        } else if (field.startsWith("billtype.")) {
            Long orgId = null;
            if (null != this.getPageCache().get("orgId")) {
                orgId = Long.parseLong(this.getPageCache().get("orgId"));
            } else {
                IListView listView = (IListView)this.getView();
                ControlFilters c = listView.getControlFilters();
                if (null != c && null != c.getFilter("org.id")) {
                    List result = c.getFilter("org.id");
                    ArrayList<Long> ids = new ArrayList<Long>(result.size());
                    for (Object v : result) {
                        if ("".equals(v.toString())) continue;
                        ids.add(Long.valueOf(v.toString()));
                    }
                    if (ids != null && ids.size() > 0) {
                        orgId = (Long)ids.get(0);
                    }
                }
            }
            if (orgId != null) {
                QFilter filter = new QFilter("org", "=", (Object)orgId);
                ArrayList<QFilter> array = new ArrayList<QFilter>(1);
                array.add(filter);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".filterColumnSetFilter"), (String)AEF_ACELRE, (String)"billtype", (QFilter[])array.toArray(new QFilter[array.size()]), null).groupBy(new String[]{"billtype"}).finish();){
                    ArrayList billtypeIds = new ArrayList();
                    ds.forEach(row -> billtypeIds.add((String)row.get("billtype")));
                    ArrayList<QFilter> customQFilters = new ArrayList<QFilter>(1);
                    customQFilters.add(new QFilter("id", "in", billtypeIds));
                    evt.setCustomQFilters(customQFilters);
                }
            }
        }
    }

    private void setOrgCache(List<Long> orgIds) {
        if (null != orgIds && !orgIds.isEmpty() && null == this.getPageCache().get("isFirst")) {
            this.getPageCache().put("isFirst", "false");
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object org = parameter.getCustomParam("org");
            String selectOrg = null == org ? orgIds.get(0).toString() : org.toString();
            this.getPageCache().put("orgId", selectOrg);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List customfilter = (List)args.getFilterValues().get("customfilter");
        if (customfilter != null && customfilter.size() > 0) {
            Optional<Map> org = customfilter.stream().filter(custom -> ((List)custom.get("FieldName")).get(0).equals("org.id")).findFirst();
            Optional<Map> billtype = customfilter.stream().filter(custom -> ((List)custom.get("FieldName")).get(0).equals("billtype.id")).findFirst();
            if (org.isPresent() && billtype.isPresent()) {
                Long orgId = ((List)org.get().get("Value")).size() > 0 && ((List)org.get().get("Value")).get(0) != null ? Long.parseLong(((List)org.get().get("Value")).get(0).toString()) : 0L;
                String billtypeId = ((List)billtype.get().get("Value")).size() > 0 && ((List)billtype.get().get("Value")).get(0) != null ? ((List)billtype.get().get("Value")).get(0).toString() : "";
                QFilter filter = new QFilter("org", "=", (Object)orgId);
                ArrayList<QFilter> array = new ArrayList<QFilter>(1);
                array.add(filter);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".filterContainerSearchClick"), (String)AEF_ACELRE, (String)"billtype", (QFilter[])array.toArray(new QFilter[0]), null).groupBy(new String[]{"billtype"}).finish();){
                    ArrayList billtypeIds = new ArrayList();
                    ds.forEach(row -> billtypeIds.add((String)row.get("billtype")));
                    if (!billtypeIds.contains(billtypeId)) {
                        customfilter.removeIf(custom -> ((List)custom.get("FieldName")).get(0).equals("billtype.id"));
                    }
                }
            }
        }
        super.filterContainerSearchClick(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String name = afterDoOperationEventArgs.getOperateKey();
        if (name.equals("refi_archive")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String hyperLinkName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)"wayid_number", (CharSequence)hyperLinkName)) {
            ListSelectedRow listSelectedRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject dynamicObject = BusinessDataServiceHelper.load((Object[])new String[]{listSelectedRow.getPrimaryKeyValue().toString()}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AEF_ACELRE))[0];
            String pkId = dynamicObject.getString("wayid.id");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkId);
            showParameter.setFormId("aef_archivescheme");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)"billno", (CharSequence)hyperLinkName)) {
            Long orgId;
            String[] uniqueKeys;
            String uniqueKey;
            ListSelectedRow listSelectedRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject dynamicObject = BusinessDataServiceHelper.load((Object[])new String[]{listSelectedRow.getPrimaryKeyValue().toString()}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AEF_ACELRE))[0];
            DynamicObject billtypeObj = dynamicObject.getDynamicObject("billtype");
            if (null == billtypeObj) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u62a5\u8868\u7c7b\u578b\u8054\u67e5\u3002", (String)"AccElectronicRecordPlugin_3", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return;
            }
            String billtype = billtypeObj.getString("number");
            String billId = dynamicObject.getString("billId");
            if (!("gl_rpt_generalledger".equals(billtype) || "gl_rpt_subledger".equals(billtype) || "gl_rpt_subsidiaryledger".equals(billtype) || "cas_bankjournalformrpt".equals(billtype) || "cas_cashjournalformrpt".equals(billtype))) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId((Object)billId);
                showParameter.setFormId(billtype);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            if ("gl_rpt_generalledger".equals(billtype) || "gl_rpt_subledger".equals(billtype) || "gl_rpt_subsidiaryledger".equals(billtype)) {
                uniqueKey = dynamicObject.getString("uniquekey");
                uniqueKeys = uniqueKey.split("-");
                orgId = Long.parseLong(uniqueKeys[0]);
                Long booktypeId = Long.parseLong(uniqueKeys[1]);
                Long periodId = Long.parseLong(uniqueKeys[2]);
                FilterInfo filter = new FilterInfo();
                filter.addFilterItem("booktype", (Object)booktypeId);
                filter.addFilterItem("org", (Object)orgId);
                QFilter orgF = new QFilter("org", "in", (Object)orgId);
                QFilter typeB = new QFilter("bookstype", "=", (Object)booktypeId);
                DynamicObject bookDyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,periodtype,accounttable,basecurrency,accounttable.maxlevel maxlevel", (QFilter[])new QFilter[]{orgF, typeB});
                filter.addFilterItem("periodtype", (Object)bookDyn.getLong("periodtype"));
                filter.addFilterItem("accounttable", (Object)bookDyn.getLong("accounttable"));
                filter.addFilterItem("currency", (Object)"allcurrency");
                filter.addFilterItem("startperiod", (Object)periodId);
                filter.addFilterItem("endperiod", (Object)periodId);
                if ("gl_rpt_generalledger".equals(billtype) && SysParamConfig.getBoolean((String)"support_gl_rpt_generalledger_new")) {
                    filter.addFilterItem("accountlevel", (Object)1);
                    if (uniqueKeys.length == 4) {
                        filter.addFilterItem("account", (Object)Long.parseLong(uniqueKeys[3]));
                    }
                } else {
                    filter.addFilterItem("accountlevel", (Object)bookDyn.getInt("maxlevel"));
                }
                if ("gl_rpt_subledger".equals(billtype)) {
                    if (uniqueKeys.length == 4) {
                        filter.addFilterItem("account", (Object)Long.parseLong(uniqueKeys[3]));
                    }
                    filter.addFilterItem("searchtype", (Object)"1");
                    filter.addFilterItem("orgs", (Object)new Long[]{orgId});
                }
                ReportShowParameter report = new ReportShowParameter();
                ReportQueryParam queryParam = new ReportQueryParam();
                queryParam.setFilter(filter);
                report.setFormId(billtype);
                report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                queryParam.setFilter(filter);
                report.setQueryParam(queryParam);
                this.getView().showForm((FormShowParameter)report);
            }
            if ("cas_bankjournalformrpt".equals(billtype) || "cas_cashjournalformrpt".equals(billtype)) {
                uniqueKey = dynamicObject.getString("uniquekey");
                uniqueKeys = uniqueKey.split("-");
                orgId = Long.parseLong(uniqueKeys[0]);
                Long periodId = Long.parseLong(uniqueKeys[1]);
                ReportShowParameter reportShowParameter = new ReportShowParameter();
                reportShowParameter.setFormId(billtype);
                reportShowParameter.setCustomParam("fromAEF", (Object)Boolean.TRUE);
                reportShowParameter.setCustomParam("org", (Object)orgId);
                reportShowParameter.setCustomParam("datatype", (Object)"1");
                reportShowParameter.setCustomParam("beginperiod", (Object)periodId);
                reportShowParameter.setCustomParam("endperiod", (Object)periodId);
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                reportShowParameter.setOpenStyle(openStyle);
                this.getView().showForm((FormShowParameter)reportShowParameter);
            }
        }
    }

    private Set<Long> getCurrencyByAccountBankId(Object accountBankId) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        qFilterList.add(new QFilter("id", "=", accountBankId));
        qFilterList.add(new QFilter("currency.fbasedataid.enable", "=", (Object)Character.valueOf('1')));
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"currency.fbasedataid.id", (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        HashSet<Long> currencyIdSet = new HashSet<Long>(queryAcctColl.size());
        for (DynamicObject acctObj : queryAcctColl) {
            currencyIdSet.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return currencyIdSet;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        if (null == this.getPageCache().get("uploadway")) {
            DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
            if (null == imageConfig) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"AccElectronicRecordPlugin_33", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return;
            }
            String upload = imageConfig.getString("uploadway");
            this.getPageCache().put("uploadway", upload);
            if (!"2".equals(this.getPageCache().get("uploadway"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"imageview"});
            }
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String uploadway;
            FormShowParameter formShow;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commFilter.getFieldName();
            if (fieldName.startsWith("org.")) {
                formShow = this.getView().getFormShowParameter();
                Object org = formShow.getCustomParam("org");
                if (org != null) {
                    commFilter.setDefaultValue(org.toString());
                }
                if (null == this.getPageCache().get("orgId")) continue;
                commFilter.setDefaultValue(this.getPageCache().get("orgId"));
                this.getPageCache().remove("orgId");
                continue;
            }
            if (fieldName.startsWith("billtype.")) {
                formShow = this.getView().getFormShowParameter();
                Object billtype = formShow.getCustomParam("billtype");
                if (billtype == null) continue;
                commFilter.setDefaultValue(billtype.toString());
                continue;
            }
            if (!fieldName.startsWith("type") || "3".equals(uploadway = this.getPageCache().get("uploadway")) || "5".equals(uploadway) || "6".equals(uploadway)) continue;
            List list = commFilter.getComboItems();
            list.remove(1);
            commFilter.setComboItems(list);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent e) {
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        HasPermOrgResult resutlt;
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.") && !(resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId())).hasAllOrgPerm()) {
            List orgIds = resutlt.getHasPermOrgs();
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }
}

