/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AefConditionEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String json = (String)showParam.getCustomParam("expressjson");
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
            fg.SetValue(fc);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterGrid();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String billtype = (String)showParam.getCustomParam("billtype");
            HashMap<String, String> dataMap = new HashMap<String, String>();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billtype);
            FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
            FilterCondition fc = fg.getFilterGridState().getFilterCondition();
            FilterBuilder filterBuilder = new FilterBuilder(entityType, fc, false);
            filterBuilder.buildFilter(false);
            String filterStr = filterBuilder.getFilterString();
            filterStr = filterStr.replaceAll("\\s{3,}", "  ");
            dataMap.put("expressdesc", filterStr);
            dataMap.put("expressjson", SerializationUtils.toJsonString((Object)fc));
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        }
    }

    private void initFilterGrid() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String billtype = (String)showParam.getCustomParam("billtype");
        if (StringUtils.isEmpty((CharSequence)billtype)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u672a\u83b7\u53d6\u5230\u5f52\u6863\u7c7b\u578b\u3001\u5355\u636e\u7c7b\u578b\u3002", (String)"ArchiveRangeFormPlugin_5", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            return;
        }
        FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billtype);
        String mainOrg = entityType.getMainOrg();
        EntityTypeUtil util = new EntityTypeUtil();
        String billstatus = ((BillEntityType)entityType).getBillStatus();
        List filterColumns = util.getFilterColumns((IDataEntityType)entityType);
        Iterator it = filterColumns.iterator();
        while (it.hasNext()) {
            Map filterColumn = (Map)it.next();
            String fieldName = (String)filterColumn.get("fieldName");
            String type = (String)filterColumn.get("type");
            if (mainOrg != null && !"gl_rpt_generalledger".equals(billtype) && !"gl_rpt_subledger".equals(billtype) && !"gl_rpt_subsidiaryledger".equals(billtype) && fieldName.startsWith(mainOrg)) {
                it.remove();
                continue;
            }
            if (null == type || !type.startsWith("date")) continue;
            it.remove();
        }
        fg.setEntityNumber(billtype);
        fg.setFilterColumns(filterColumns);
    }
}

