/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.ArchiveRangeInfo;
import kd.fi.aef.entity.Task;

public class ArchiveEdit
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener,
BeforeF7SelectListener {
    private final DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.archive);
    private static final int THREAD_SIZE = 2;
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"fi/aef/ArchiveEdit", (int)2);
    private static final String ORG = "org";
    private static final String ARCHIVEPLAN = "archiveplan";
    private static final String BOOKTYPE = "booktype";
    private static final String FINANCE = "finance";
    private static final String BILL = "bill";
    private static final String REPORTFORM = "reportform";
    private static final String TAX = "tax";
    private static final String MSG = "msg";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setPermissionItemId("/=N=NAA4+3V2");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"doarchive"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener(evt -> {
            DynamicObject plan;
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
            if (!resutlt.hasAllOrgPerm()) {
                HasPermOrgResult resutlt1 = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"15", (String)"aef", (String)"aef_archive", (String)"/=N=NAA4+3V2");
                qFilters.add(new QFilter("id", "in", (Object)resutlt1.getHasPermOrgs()));
            }
            if ((plan = (DynamicObject)this.getModel().getValue(ARCHIVEPLAN)) != null && TAX.equals(plan.getString("archivetype"))) {
                qFilters.add(new QFilter("fistax", "=", (Object)"1"));
            }
        });
        BasedataEdit scheme = (BasedataEdit)this.getControl(ARCHIVEPLAN);
        scheme.addBeforeF7SelectListener(evt -> {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = sp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            if (this.isExport()) {
                qFilters.add(new QFilter("archivetype", "!=", (Object)REPORTFORM));
            }
        });
        BasedataEdit bookTypeBase = (BasedataEdit)this.getView().getControl(BOOKTYPE);
        bookTypeBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startperiodBase = (BasedataEdit)this.getView().getControl("startperiod");
        startperiodBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endperiodBase = (BasedataEdit)this.getView().getControl("endperiod");
        endperiodBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fadepreuseBase = (BasedataEdit)this.getView().getControl("fadepreuse");
        fadepreuseBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bcmsceneBase = (BasedataEdit)this.getView().getControl("bcmscene");
        bcmsceneBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bcmfyBase = (BasedataEdit)this.getView().getControl("bcmfy");
        bcmfyBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bcmperiodBase = (BasedataEdit)this.getView().getControl("bcmperiod");
        bcmperiodBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultValue();
        this.getView().setVisible(Boolean.FALSE, new String[]{"processlable", "leftbrackets", "hasarchievecount", "percent", "allcount", "rightbrackets"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        DynamicObject archiveScheme = (DynamicObject)this.getModel().getValue(ARCHIVEPLAN);
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        String appId = this.getAppId(archiveScheme);
        IDataModel model = this.getModel();
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                if (archiveScheme == null) break;
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                long orgId = org.getLong("id");
                if (!archiveScheme.getString("archivetype").equals(FINANCE)) break;
                if ("fa".equals(appId)) {
                    this.setFa(orgId, false);
                    this.showFaCard();
                    break;
                }
                Long bookTypeId = this.getSetBookTypeId(orgId, appId);
                this.setStartAndEndPeriod(appId, bookTypeId);
                this.setFinanceFiledVisible(appId);
                break;
            }
            case "booktype": {
                this.setStartAndEndPeriod(appId, ((DynamicObject)newValue).getLong("id"));
                break;
            }
            case "archiveplan": {
                if (archiveScheme == null) break;
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                if (archiveScheme.getString("archivetype").equals(TAX)) {
                    DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                    if (oldValue != null && !oldValue.getString("archivetype").equals(TAX)) {
                        this.getModel().setValue(ORG, (Object)"");
                    }
                    this.showTax();
                    this.setDateTax();
                    break;
                }
                if (org == null) {
                    Long orgid = RequestContext.get().getOrgId();
                    HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
                    if (resutlt.hasAllOrgPerm()) {
                        this.getModel().setValue(ORG, (Object)orgid);
                    } else {
                        List orgIds = resutlt.getHasPermOrgs();
                        if (orgIds != null && !orgIds.isEmpty() && !orgIds.contains(orgid)) {
                            orgid = (Long)orgIds.get(0);
                        }
                        this.getModel().setValue(ORG, (Object)orgid);
                    }
                }
                if (archiveScheme.getString("archivetype").equals(FINANCE)) {
                    org = (DynamicObject)this.getModel().getValue(ORG);
                    long orgId = org.getLong("id");
                    if ("fa".equals(appId)) {
                        this.setFa(orgId, false);
                        this.showFaCard();
                        break;
                    }
                    Long bookTypeId = this.getSetBookTypeId(orgId, appId);
                    this.setStartAndEndPeriod(appId, bookTypeId);
                    this.setFinanceFiledVisible(appId);
                    break;
                }
                if (archiveScheme.getString("archivetype").equals(BILL)) {
                    this.showbill();
                    this.setDaterange();
                    break;
                }
                if (!archiveScheme.getString("archivetype").equals(REPORTFORM)) break;
                this.showreportform();
                break;
            }
            case "startperiod": {
                if (model.getValue("startperiod") == null || model.getValue("endperiod") == null) break;
                long startPeriod = ((DynamicObject)newValue).getLong("id");
                long endPeriod = ((DynamicObject)model.getValue("endperiod")).getLong("id");
                if (endPeriod != 0L && endPeriod >= startPeriod) break;
                model.setValue("endperiod", (Object)startPeriod);
                break;
            }
            case "endperiod": {
                if (model.getValue("endperiod") == null) break;
                long endPeriod = ((DynamicObject)newValue).getLong("id");
                DynamicObject startPeriodDyn = (DynamicObject)model.getValue("startperiod");
                if (Objects.isNull(startPeriodDyn)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"ArchiveEdit_24", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                    return;
                }
                long startPeriod = startPeriodDyn.getLong("id");
                if (startPeriod != 0L && startPeriod <= endPeriod) break;
                model.setValue("startperiod", (Object)endPeriod);
                break;
            }
            case "bcmscene": {
                model.setValue("bcmperiod", null);
                break;
            }
        }
    }

    private boolean checkPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"aef").getId();
        return PermissionServiceHelper.hasSpecificPerm((long)ContextUtil.getUserId(), (String)appId, (String)"aef_archive", (String)"/=N=NAA4+3V2");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("doarchive".equals(key)) {
            if (!this.checkPermission()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f1a\u8ba1\u6863\u6848\u5f52\u6863\u7684\u5f52\u6863\u64cd\u4f5c\u6743\u9650\u3002", (String)"ArchiveEdit_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u5f52\u6863\u540e\uff0c\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\u5c06\u4e0a\u4f20\u5230\u6863\u6848\u7cfb\u7edf\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ArchiveEdit_40", (String)"fi-aef-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("contentChange"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result = evt.getResult();
        if ("contentChange".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject archiveScheme = (DynamicObject)this.getModel().getValue(ARCHIVEPLAN);
            if (archiveScheme == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u6863\u65b9\u6848\u3002", (String)"ArchiveEdit_2", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return;
            }
            final OperateOption option = this.getOperateOption(archiveScheme);
            if (option.containsVariable(MSG)) {
                this.getView().showTipNotification(option.getVariableValue(MSG));
                return;
            }
            option.setVariableValue(ARCHIVEPLAN, archiveScheme.getString("id"));
            final String pageId = Task.createTaskId();
            this.setPageId(pageId);
            this.setPage(false);
            this.cache.put("pageId", pageId);
            this.cache.put(pageId + "finishedBill", "0");
            this.cache.put(pageId + "isFinish", "false");
            this.cache.put(pageId + "hasarchievecount", "0");
            this.cache.put(pageId + "allcount", "0");
            DynamicObject orgDyn = (DynamicObject)this.getModel().getValue(ORG);
            if (!StringUtils.isBlank((CharSequence)orgDyn.getString("uniformsocialcreditcode"))) {
                this.cache.put(pageId + "orgUnionCode", orgDyn.getString("uniformsocialcreditcode"));
            } else {
                this.cache.put(pageId + "orgUnionCode", orgDyn.getString("number"));
            }
            this.cache.remove(pageId + "exporturl");
            Task archive = new Task(pageId, new Runnable(){

                @Override
                public void run() {
                    option.setVariableValue("pageId", ArchiveEdit.this.getPageId());
                    option.setVariableValue("archievePage", "1");
                    DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"aef_archive");
                    OperationResult result = OperationServiceHelper.executeOperate((String)"fi_archive", (String)"aef_archive", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)option);
                    ArchiveEdit.this.cache.put(pageId + "isFinish", "true");
                    ArchiveEdit.this.cache.put(pageId + "isSuccess", String.valueOf(result.isSuccess()));
                }
            });
            threadPool.execute((Runnable)archive);
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.start();
        }
    }

    private OperateOption getOperateOption(DynamicObject archiveScheme) {
        OperateOption option = OperateOption.create();
        String archivetype = archiveScheme.getString("archivetype");
        option.setVariableValue("archivetype", archivetype);
        if (REPORTFORM.equals(archivetype)) {
            Long bcmsceneId = (Long)this.getModel().getValue("bcmscene_id");
            if (bcmsceneId == 0L) {
                option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"ArchiveEdit_26", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return option;
            }
            option.setVariableValue("bcmsceneType", ((DynamicObject)this.getModel().getValue("bcmscene")).getString("number"));
            option.setVariableValue("bcmscene", bcmsceneId.toString());
            Long bcmfyId = (Long)this.getModel().getValue("bcmfy_id");
            if (bcmfyId == 0L) {
                option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"ArchiveEdit_27", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return option;
            }
            option.setVariableValue("bcmfyName", ((DynamicObject)this.getModel().getValue("bcmfy")).getString("name"));
            option.setVariableValue("bcmfy", bcmfyId.toString());
            DynamicObjectCollection bcmperiod = (DynamicObjectCollection)this.getModel().getValue("bcmperiod");
            if (null == bcmperiod || bcmperiod.isEmpty()) {
                option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ArchiveEdit_28", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return option;
            }
            HashMap<Long, String> bcmPeriodMap = new HashMap<Long, String>(bcmperiod.size());
            for (DynamicObject obj : bcmperiod) {
                DynamicObject data = (DynamicObject)obj.get("fbasedataid");
                bcmPeriodMap.put(data.getLong("id"), data.getString("name"));
            }
            option.setVariableValue("bcmperiod", SerializationUtils.serializeToBase64(bcmPeriodMap));
        } else if (TAX.equals(archivetype)) {
            Long orgId = (Long)this.getModel().getValue("org_id");
            if (orgId == 0L) {
                option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u6863\u7ec4\u7ec7\u3002", (String)"ArchiveEdit_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return option;
            }
            option.setVariableValue(ORG, orgId.toString());
            Date sDate = (Date)this.getModel().getValue("startdate");
            Date eDate = (Date)this.getModel().getValue("enddate");
            String string = this.taxDateValidator(sDate, eDate);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                option.setVariableValue(MSG, string);
                return option;
            }
            option.setVariableValue("startdate", DateUtil.format((Date)((Date)this.getModel().getValue("startdate")), (String)"yyyy-MM-dd"));
            option.setVariableValue("enddate", DateUtil.format((Date)((Date)this.getModel().getValue("enddate")), (String)"yyyy-MM-dd"));
        } else {
            Long orgId = (Long)this.getModel().getValue("org_id");
            if (orgId == 0L) {
                option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u6863\u7ec4\u7ec7\u3002", (String)"ArchiveEdit_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return option;
            }
            option.setVariableValue(ORG, orgId.toString());
            if (BILL.equals(archivetype)) {
                Date eDate;
                Date sDate = (Date)this.getModel().getValue("startdate");
                String string = this.yearDateDiff(sDate, eDate = (Date)this.getModel().getValue("enddate"));
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    option.setVariableValue(MSG, string);
                    return option;
                }
                option.setVariableValue("startdate", DateUtil.format((Date)((Date)this.getModel().getValue("startdate")), (String)"yyyy-MM-dd"));
                option.setVariableValue("enddate", DateUtil.format((Date)((Date)this.getModel().getValue("enddate")), (String)"yyyy-MM-dd"));
            } else {
                String appId = this.getAppId(archiveScheme);
                boolean isFa = "fa".equals(appId);
                option.setVariableValue("isFa", isFa + "");
                option.setVariableValue("app_id", appId);
                if (isFa) {
                    Long fadepreuseId = (Long)this.getModel().getValue("fadepreuse_id");
                    if (fadepreuseId == 0L) {
                        option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"ArchiveEdit_22", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                        return option;
                    }
                    option.setVariableValue("fadepreuse", fadepreuseId.toString());
                } else if ("gl".equals(appId)) {
                    Long bookTypeId = (Long)this.getModel().getValue("booktype_id");
                    if (bookTypeId == 0L) {
                        option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ArchiveEdit_23", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                        return option;
                    }
                    option.setVariableValue(BOOKTYPE, bookTypeId.toString());
                }
                Long startperiodId = (Long)this.getModel().getValue("startperiod_id");
                if (startperiodId == 0L) {
                    option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"ArchiveEdit_24", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                    return option;
                }
                option.setVariableValue("startperiod", startperiodId.toString());
                Long endperiod = (Long)this.getModel().getValue("endperiod_id");
                if (endperiod == 0L) {
                    option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"ArchiveEdit_25", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                    return option;
                }
                option.setVariableValue("endperiod", endperiod.toString());
            }
        }
        return option;
    }

    private String getAppId(DynamicObject archiveScheme) {
        if (Objects.isNull(archiveScheme)) {
            return "";
        }
        DynamicObjectCollection entitys = archiveScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entitys) {
            String billTypeNumber = entity.getString("billtype.number");
            if (!StringUtils.isNotBlank((CharSequence)billTypeNumber)) continue;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billTypeNumber);
            return dataEntityType.getAppId();
        }
        return "";
    }

    private void setPage(boolean finish) {
        this.getView().setEnable(Boolean.valueOf(finish), new String[]{"doarchive"});
        this.getView().setVisible(Boolean.valueOf(!finish), new String[]{"processlable", "leftbrackets", "hasarchievecount", "percent", "allcount", "rightbrackets"});
    }

    public void onProgress(ProgressEvent progressEvent) {
        String pageId = this.getPageId();
        boolean isFinish = Boolean.parseBoolean(this.cache.get(pageId + "isFinish"));
        String nothavetemplate = this.cache.get(pageId + "nothavetemplate");
        if (isFinish) {
            boolean isSuccess;
            boolean bl = isSuccess = this.cache.get(pageId + "isSuccess") == null || Boolean.parseBoolean(this.cache.get(pageId + "isSuccess"));
            if (!isSuccess) {
                String errorMsg = this.cache.get(pageId + "errorMsg");
                errorMsg = errorMsg == null ? "" : errorMsg;
                String key = pageId + "hasarchievecount";
                String hasarchievecount = this.cache.get(key);
                String allcount = this.cache.get(pageId + "allcount");
                if (hasarchievecount != null && Integer.parseInt(hasarchievecount) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u90e8\u5206\u6210\u529f,\u5df2\u6210\u529f\u5f52\u6863%1$s,\u5171%2$s\u5f20\u3002\u9519\u8bef\u4fe1\u606f\uff1a%3$s", (String)"ArchiveEdit_8", (String)"fi-aef-formplugin", (Object[])new Object[0]), hasarchievecount, allcount, errorMsg), Integer.valueOf(200000));
                } else if (StringUtils.isEmpty((CharSequence)nothavetemplate)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25,%s", (String)"ArchiveEdit_4", (String)"fi-aef-formplugin", (Object[])new Object[0]), errorMsg));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25,%s", (String)"ArchiveEdit_4", (String)"fi-aef-formplugin", (Object[])new Object[0]), nothavetemplate));
                }
            } else {
                String key = pageId + "hasarchievecount";
                String hasarchievecount = this.cache.get(key);
                if (StringUtils.isEmpty((CharSequence)nothavetemplate)) {
                    if (hasarchievecount == null || "0".equals(hasarchievecount)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_9", (String)"fi-aef-formplugin", (Object[])new Object[0]), Integer.valueOf(30000));
                    } else if (this.isExport()) {
                        String exportUrl = this.cache.get(pageId + "exporturl");
                        if (StringUtils.isEmpty((CharSequence)exportUrl)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_18", (String)"fi-ai-formplugin", (Object[])new Object[0]), Integer.valueOf(20000));
                        } else {
                            this.getView().openUrl(exportUrl);
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ArchiveEdit_14", (String)"fi-ai-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                        }
                    } else {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f%s\u5f20\u3002", (String)"ArchiveEdit_10", (String)"fi-aef-formplugin", (Object[])new Object[0]), hasarchievecount), Integer.valueOf(600000));
                    }
                } else if (this.isExport()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25,%s\u3002", (String)"ArchiveEdit_17", (String)"fi-aef-formplugin", (Object[])new Object[0]), nothavetemplate), Integer.valueOf(60000));
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f%1$s\u5f20,%2$s", (String)"ArchiveEdit_11", (String)"fi-aef-formplugin", (Object[])new Object[0]), hasarchievecount == null ? "0" : hasarchievecount, nothavetemplate), Integer.valueOf(60000));
                }
            }
            this.stopProgressBar();
        } else {
            Label label1 = (Label)this.getControl("hasarchievecount");
            Label label2 = (Label)this.getControl("allcount");
            label1.setText(this.cache.get(pageId + "hasarchievecount"));
            label2.setText(this.cache.get(pageId + "allcount"));
        }
    }

    private void stopProgressBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
        this.removeCache();
        Label label1 = (Label)this.getControl("hasarchievecount");
        Label label2 = (Label)this.getControl("allcount");
        label1.setText("0");
        label2.setText("0");
        this.setPage(true);
    }

    private void removeCache() {
        String pageId = this.getPageId();
        this.cache.remove(pageId + "isFinish");
        this.cache.remove(pageId + "isSuccess");
        this.cache.remove(pageId + "hasarchievecount");
        this.cache.remove(pageId + "allcount");
        this.cache.remove(pageId + "errorMsg");
        this.cache.remove(pageId + "finishedBill");
        this.cache.remove(pageId + "exporturl");
        this.cache.remove(pageId + "orgUnionCode");
        this.getPageCache().remove("pageId");
    }

    private boolean isExport() {
        return SysParamConfig.getBoolean((String)"exportvat", (boolean)false);
    }

    private boolean isControlPeriodSelect() {
        return SysParamConfig.getBoolean((String)"controlperiodselect", (boolean)true);
    }

    private String getPageId() {
        return this.getPageCache().get("pageId");
    }

    private DynamicObject getDataEntity() {
        String value = this.getPageCache().get("DataEntity");
        if (!StringUtil.isEmpty((String)value)) {
            return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)value, (IDataEntityType)this.getModel().getDataEntityType());
        }
        return null;
    }

    private void setDefaultValue() {
        Long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
        if (result.hasAllOrgPerm()) {
            this.getModel().setValue(ORG, (Object)orgId);
        } else {
            List orgIds = result.getHasPermOrgs();
            if (orgIds != null && !orgIds.isEmpty()) {
                if (!orgIds.contains(orgId)) {
                    orgId = (Long)orgIds.get(0);
                }
                this.getModel().setValue(ORG, (Object)orgId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u3002", (String)"ArchiveEdit_31", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            }
        }
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"aef_archivescheme", (String)"id,archivetype,entryentity.billtype", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray());
        HashMap<DynamicObject, String> schemesMap = new HashMap<DynamicObject, String>(16);
        for (DynamicObject scheme : schemes) {
            schemesMap.put(scheme, scheme.getString("archivetype"));
        }
        if (schemes.length == 0) {
            this.setFinanceFiledVisible("gl");
        } else if (schemesMap.containsValue(FINANCE)) {
            Long bookTypeId = this.getSetBookTypeId(orgId, "gl");
            for (Map.Entry ent : schemesMap.entrySet()) {
                String appId = this.getAppId((DynamicObject)ent.getKey());
                if (!"gl".equals(appId) || !((String)ent.getValue()).equals(FINANCE)) continue;
                this.setFinanceFiledVisible("gl");
                this.setStartAndEndPeriod("gl", bookTypeId);
                this.getModel().setValue(ARCHIVEPLAN, ((DynamicObject)ent.getKey()).get("id"));
                break;
            }
            if (this.getModel().getValue(ARCHIVEPLAN) == null) {
                for (Map.Entry ent : schemesMap.entrySet()) {
                    if (!"fa".equals(this.getAppId((DynamicObject)ent.getKey())) || !((String)ent.getValue()).equals(FINANCE)) continue;
                    this.showFaCard();
                    this.setFa(orgId, true);
                    this.getModel().setValue(ARCHIVEPLAN, ((DynamicObject)ent.getKey()).get("id"));
                    break;
                }
            }
        } else if (schemesMap.containsValue(BILL)) {
            for (Map.Entry entry : schemesMap.entrySet()) {
                if (!((String)entry.getValue()).equals(BILL)) continue;
                this.showbill();
                this.setDaterange();
                this.getModel().setValue(ARCHIVEPLAN, ((DynamicObject)entry.getKey()).get("id"));
                break;
            }
            this.showbill();
            this.setDaterange();
        } else if (schemesMap.containsValue(REPORTFORM)) {
            for (Map.Entry entry : schemesMap.entrySet()) {
                if (!((String)entry.getValue()).equals(REPORTFORM)) continue;
                this.showreportform();
                this.getModel().setValue(ARCHIVEPLAN, ((DynamicObject)entry.getKey()).get("id"));
                break;
            }
        } else if (schemesMap.containsValue(TAX)) {
            for (Map.Entry entry : schemesMap.entrySet()) {
                if (!((String)entry.getValue()).equals(TAX)) continue;
                if (!((DynamicObject)this.getModel().getValue(ORG)).getBoolean("fistax")) {
                    this.getModel().setValue(ORG, null);
                }
                this.showTax();
                this.getModel().setValue(ARCHIVEPLAN, ((DynamicObject)entry.getKey()).get("id"));
                break;
            }
        } else {
            this.setFinanceFiledVisible("gl");
        }
    }

    private Long getSetBookTypeId(long orgId, String appId) {
        DynamicObject book;
        QFilter orgQFilter = new QFilter(ORG, "=", (Object)orgId);
        Long bookTypeId = null;
        if ("gl".equals(appId)) {
            bookTypeId = this.getGLAccountBookTypeId(orgQFilter);
            this.getModel().setValue(BOOKTYPE, (Object)bookTypeId);
        } else if ("cas".equals(appId) && Objects.nonNull(book = this.getBook(orgId, null, appId)) && Objects.nonNull(book.get("periodtype"))) {
            return book.getLong("periodtype");
        }
        return bookTypeId;
    }

    private Long getGLAccountBookTypeId(QFilter orgQFilter) {
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id,bookstype.name, bookstype.accounttype", (QFilter[])new QFilter[]{orgQFilter});
        if (books != null && books.size() > 0) {
            HashMap<String, Long> bookMap = new HashMap<String, Long>(16);
            for (DynamicObject dynamicObject : books) {
                if (!"1".equals(dynamicObject.getString("bookstype.accounttype"))) continue;
                bookMap.put("mainbook", dynamicObject.getLong("bookstype.id"));
            }
            if (bookMap.containsKey("mainbook")) {
                return (Long)bookMap.get("mainbook");
            }
            return ((DynamicObject)books.get(0)).getLong("bookstype.id");
        }
        return null;
    }

    private void setStartAndEndPeriod(String appId, Long bookTypeId) {
        DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue(ORG);
        Map<Object, Object> periodMap = new HashMap(2);
        if (Objects.nonNull(orgDynObj)) {
            periodMap = this.getStartAndEndPeriodMap(appId, orgDynObj, bookTypeId);
        }
        this.getModel().setValue("startperiod", periodMap.get("startperiod"));
        this.getModel().setValue("endperiod", periodMap.get("endperiod"));
    }

    private Map<String, Long> getStartAndEndPeriodMap(String appId, DynamicObject orgDynObj, Long bookTypeId) {
        HashMap<String, Long> result = new HashMap<String, Long>(2);
        DynamicObject bookDynObj = this.getBook(orgDynObj.getLong("id"), bookTypeId, appId);
        if ("gl".equals(appId)) {
            if (bookDynObj != null && bookDynObj.getLong("curperiod") != 0L && bookDynObj.getLong("curperiod") != bookDynObj.getLong("startperiod")) {
                DynamicObject beforePeriod = this.getPreviousPeriod(bookDynObj.get("curperiod"), appId);
                if (null != beforePeriod) {
                    result.put("startperiod", beforePeriod.getLong("id"));
                    result.put("endperiod", beforePeriod.getLong("id"));
                }
            } else {
                result.put("startperiod", null);
                result.put("endperiod", null);
            }
        } else if ("cas".equals(appId)) {
            if (bookDynObj != null && bookDynObj.getLong("currentperiod") != 0L && bookDynObj.getLong("currentperiod") != bookDynObj.getLong("startperiod")) {
                DynamicObject beforePeriod = this.getPreviousPeriod(bookDynObj.get("currentperiod"), appId);
                if (null != beforePeriod) {
                    result.put("startperiod", beforePeriod.getLong("id"));
                    result.put("endperiod", beforePeriod.getLong("id"));
                }
            } else {
                result.put("startperiod", null);
                result.put("endperiod", null);
            }
        }
        return result;
    }

    private void setFa(long orgid, boolean isFirst) {
        QFilter filter = new QFilter(ORG, "=", (Object)orgid);
        DynamicObject assetbook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id,depreuse,curperiod,startperiod", (QFilter[])new QFilter[]{filter});
        if (assetbook != null && assetbook.getLong("curperiod") != 0L && assetbook.getLong("curperiod") != assetbook.getLong("startperiod")) {
            this.getModel().setValue("fadepreuse", assetbook.get("depreuse"));
            DynamicObject beforeperiod = this.getPreviousPeriod(assetbook.get("curperiod"), "fa");
            if (null != beforeperiod) {
                this.getModel().setValue("startperiod", (Object)beforeperiod.getLong("id"));
                this.getModel().setValue("endperiod", (Object)beforeperiod.getLong("id"));
            }
        } else if (!isFirst) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8d44\u4ea7\u8d26\u7c3f\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_13", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        DynamicObject archiveScheme = (DynamicObject)this.getModel().getValue(ARCHIVEPLAN);
        if (archiveScheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u6863\u65b9\u6848\u3002", (String)"ArchiveEdit_2", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else if (archiveScheme.getString("archivetype").equals(FINANCE)) {
            DynamicObject orgDynObj = (DynamicObject)this.getModel().getValue(ORG);
            if (orgDynObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u6863\u7ec4\u7ec7\u3002", (String)"ArchiveEdit_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String appId = this.getAppId(archiveScheme);
            boolean isControlPeriodSelect = this.isControlPeriodSelect();
            if ("fa".equals(appId)) {
                QFilter orgFilter = new QFilter(ORG, "=", (Object)orgDynObj.getLong("id"));
                this.setFaDepreUseF7(baseData, f7List, orgFilter);
                if ("startperiod".equals(baseData.getKey()) || "endperiod".equals(baseData.getKey())) {
                    this.setFaStartAndEndPeriodF7(e, f7List, orgFilter, isControlPeriodSelect);
                }
            } else {
                if (BOOKTYPE.equals(baseData.getKey()) && "gl".equals(appId)) {
                    this.setGlBookTypeF7(e, f7List, orgDynObj);
                }
                if ("startperiod".equals(baseData.getKey()) || "endperiod".equals(baseData.getKey())) {
                    if ("gl".equals(appId)) {
                        DynamicObject bookTypeDynObj = (DynamicObject)this.getModel().getValue(BOOKTYPE);
                        if (bookTypeDynObj == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ArchiveEdit_16", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                            e.setCancel(true);
                            return;
                        }
                        this.setGlStartAndEndPeriodF7(f7List, orgDynObj, bookTypeDynObj, isControlPeriodSelect);
                    } else if ("cas".equals(appId)) {
                        this.setCasStartAndEndPeriodF7(f7List, orgDynObj, isControlPeriodSelect);
                    }
                }
            }
        } else if (archiveScheme.getString("archivetype").equals(REPORTFORM)) {
            if ("bcmfy".equals(baseData.getKey()) || "bcmscene".equals(baseData.getKey()) || "bcmperiod".equals(baseData.getKey())) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
                Long schemeId = archiveScheme.getLong("id");
                Long modelId = this.getModelIdByScheme(schemeId);
                filters.add(new QFilter("model", "=", (Object)modelId));
                filters.add(new QFilter("enable", "=", (Object)"1"));
                filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                if ("bcmfy".equals(baseData.getKey())) {
                    filters.add(new QFilter("aggoprt", "=", (Object)"1"));
                }
                if ("bcmscene".equals(baseData.getKey())) {
                    filters.add(new QFilter("number", "in", Arrays.asList("MRpt", "QRpt", "ARpt")));
                }
                if ("bcmperiod".equals(baseData.getKey())) {
                    IDataModel model = this.getModel();
                    DynamicObject bcmscene = (DynamicObject)model.getValue("bcmscene");
                    if (null == bcmscene) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"ArchiveEdit_12", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    List<Long> periodIds = ArchiveEdit.getPeriodIds(modelId, bcmscene.getLong("id"));
                    filters.add(new QFilter("id", "in", periodIds));
                }
                f7List.getListFilterParameter().setQFilters(filters);
            }
        } else if (archiveScheme.getString("archivetype").equals(TAX)) {
            // empty if block
        }
    }

    private void setCasStartAndEndPeriodF7(ListShowParameter f7List, DynamicObject orgDynObj, boolean isControlPeriodSelect) {
        long orgId = orgDynObj.getLong("id");
        DynamicObject bookDynObj = this.getBook(orgId, null, "cas");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        QFilter isAudit = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        qFilterList.add(isAudit);
        if (Objects.nonNull(bookDynObj) && bookDynObj.getLong("currentperiod") != 0L && bookDynObj.getLong("currentperiod") != bookDynObj.getLong("startperiod")) {
            QFilter periodTypeQFilter = new QFilter("periodtype", "=", bookDynObj.get("periodtype"));
            qFilterList.add(periodTypeQFilter);
            QFilter startPeriodQFilter = new QFilter("id", ">=", bookDynObj.get("startperiod"));
            qFilterList.add(startPeriodQFilter);
            if (isControlPeriodSelect) {
                QFilter endPeriodQFilter = new QFilter("id", "<", bookDynObj.get("currentperiod"));
                qFilterList.add(endPeriodQFilter);
            }
            f7List.getListFilterParameter().setQFilters(qFilterList);
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)0L);
            qFilterList.add(qFilter);
            f7List.getListFilterParameter().setQFilters(qFilterList);
        }
    }

    private void setGlStartAndEndPeriodF7(ListShowParameter f7List, DynamicObject orgDynObj, DynamicObject bookTypeDynObj, boolean isControlPeriodSelect) {
        DynamicObject bookDynObj = this.getBook(orgDynObj.getLong("id"), bookTypeDynObj.getLong("id"), "gl");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        if (bookDynObj != null && bookDynObj.getLong("curperiod") != 0L && bookDynObj.getLong("curperiod") != bookDynObj.getLong("startperiod")) {
            QFilter periodTypeQFilter = new QFilter("periodtype", "=", bookDynObj.get("periodtype"));
            QFilter startPeriodQFilter = new QFilter("id", ">=", bookDynObj.get("startperiod"));
            filters.add(periodTypeQFilter);
            filters.add(startPeriodQFilter);
            if (isControlPeriodSelect) {
                QFilter endPeriodQFilter = new QFilter("id", "<", bookDynObj.get("curperiod"));
                filters.add(endPeriodQFilter);
            }
            f7List.getListFilterParameter().setQFilters(filters);
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)0L);
            filters.add(qFilter);
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }

    private void setGlBookTypeF7(BeforeF7SelectEvent e, ListShowParameter f7List, DynamicObject orgDynObj) {
        QFilter orgQFilter = new QFilter(ORG, "=", (Object)orgDynObj.getLong("id"));
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id,bookstype.name", (QFilter[])new QFilter[]{orgQFilter});
        ArrayList<Long> bookIdList = new ArrayList<Long>(16);
        if (books != null && books.size() > 0) {
            for (DynamicObject dynamicObject : books) {
                bookIdList.add(dynamicObject.getLong("bookstype.id"));
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "in", bookIdList));
            f7List.getListFilterParameter().setQFilters(filters);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6682\u65e0\u8d26\u7c3f\u3002", (String)"ArchiveEdit_21", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void setFaStartAndEndPeriodF7(BeforeF7SelectEvent e, ListShowParameter f7List, QFilter orgFilter, boolean isControlPeriodSelect) {
        DynamicObject faDepreUseDynObj = (DynamicObject)this.getModel().getValue("fadepreuse");
        if (faDepreUseDynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"ArchiveEdit_33", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter depreUseQFilter = new QFilter("depreuse", "=", (Object)faDepreUseDynObj.getLong("id"));
        DynamicObject assetBookDynObj = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id,depreuse,startperiod,periodtype,curperiod", (QFilter[])new QFilter[]{orgFilter, depreUseQFilter});
        if (assetBookDynObj != null && assetBookDynObj.getLong("curperiod") != 0L && assetBookDynObj.getLong("curperiod") != assetBookDynObj.getLong("startperiod")) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter isAudit = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            QFilter qFilter = new QFilter("periodtype", "=", assetBookDynObj.get("periodtype"));
            QFilter qFilter2 = new QFilter("id", ">=", assetBookDynObj.get("startperiod"));
            filters.add(isAudit);
            filters.add(qFilter);
            filters.add(qFilter2);
            if (isControlPeriodSelect) {
                QFilter qFilter3 = new QFilter("id", "<", assetBookDynObj.get("curperiod"));
                filters.add(qFilter3);
            }
            f7List.getListFilterParameter().setQFilters(filters);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8d44\u4ea7\u8d26\u7c3f\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_13", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void setFaDepreUseF7(BasedataEdit baseData, ListShowParameter f7List, QFilter orgFilter) {
        DynamicObjectCollection assetbooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"id,depreuse,curperiod", (QFilter[])new QFilter[]{orgFilter});
        ArrayList<Long> depreuses = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : assetbooks) {
            depreuses.add(dynamicObject.getLong("depreuse"));
        }
        if ("fadepreuse".equals(baseData.getKey())) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("enable", "=", (Object)"1"));
            filters.add(new QFilter("id", "in", depreuses));
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }

    public static List<Long> getPeriodIds(long modelId, long scenarioId) {
        DynamicObjectCollection coll;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("id", "=", (Object)scenarioId));
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> periodIds = new ArrayList<Long>();
        if (dy != null && (coll = dy.getDynamicObjectCollection("sceneperiod")) != null && !coll.isEmpty()) {
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (period != null) {
                    periodIds.add(period.getLong("id"));
                }
            });
        }
        return periodIds;
    }

    public static DynamicObjectCollection getScenePeriod(long modelId, long scenarioId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("model", "=", (Object)modelId));
        filters.add(new QFilter("id", "=", (Object)scenarioId));
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])filters.toArray(new QFilter[0]));
        if (dy == null) {
            return null;
        }
        return dy.getDynamicObjectCollection("sceneperiod");
    }

    private void setPageId(String pageId) {
        this.getPageCache().put("pageId", pageId);
    }

    private void setFinanceFiledVisible(String appId) {
        HashSet<String> noVisibleSet = new HashSet<String>(5);
        noVisibleSet.add("fadepreuse");
        noVisibleSet.add("daterange");
        noVisibleSet.add("bcmscene");
        noVisibleSet.add("bcmfy");
        noVisibleSet.add("bcmperiod");
        HashSet<String> visibleSet = new HashSet<String>(5);
        visibleSet.add(ARCHIVEPLAN);
        visibleSet.add(ORG);
        visibleSet.add(BOOKTYPE);
        visibleSet.add("startperiod");
        visibleSet.add("endperiod");
        if ("cas".equals(appId)) {
            noVisibleSet.add(BOOKTYPE);
            visibleSet.remove(BOOKTYPE);
        }
        this.getView().setVisible(Boolean.FALSE, noVisibleSet.toArray(new String[0]));
        this.getView().setVisible(Boolean.TRUE, visibleSet.toArray(new String[0]));
    }

    private void showbill() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BOOKTYPE, "startperiod", "endperiod", "fadepreuse", "bcmscene", "bcmfy", "bcmperiod"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ARCHIVEPLAN, ORG, "daterange"});
    }

    private void showTax() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BOOKTYPE, "startperiod", "endperiod", "fadepreuse", "bcmscene", "bcmfy", "bcmperiod"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ARCHIVEPLAN, ORG, "daterange"});
    }

    private void showreportform() {
        Long schemeId;
        Long modelId;
        IDataModel model = this.getModel();
        Long fyId = null;
        Long sceneId = null;
        Long periodId = null;
        DynamicObject archiveScheme = (DynamicObject)model.getValue(ARCHIVEPLAN);
        if (null != archiveScheme && null != (modelId = this.getModelIdByScheme(schemeId = Long.valueOf(archiveScheme.getLong("id")))) && modelId != 0L) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
            filters.add(new QFilter("model", "=", (Object)modelId));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            ArrayList<QFilter> fyFilters = new ArrayList<QFilter>(filters);
            fyFilters.add(new QFilter("aggoprt", "=", (Object)"1"));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bcm_fymembertree", (String)"id", (QFilter[])fyFilters.toArray(new QFilter[0]), (String)"number desc", (int)1);){
                if (null != ds && ds.hasNext()) {
                    fyId = ds.next().getLong("id");
                }
            }
            ArrayList<QFilter> sceneFilters = new ArrayList<QFilter>(filters);
            sceneFilters.add(new QFilter("number", "in", Arrays.asList("MRpt", "QRpt", "ARpt")));
            try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bcm_scenemembertree", (String)"id", (QFilter[])sceneFilters.toArray(new QFilter[0]), (String)"number", (int)1);){
                if (null != ds2 && ds2.hasNext()) {
                    sceneId = ds2.next().getLong("id");
                }
            }
            if (null != sceneId) {
                List<Long> periodIds = ArchiveEdit.getPeriodIds(modelId, sceneId);
                ArrayList<QFilter> periodFilters = new ArrayList<QFilter>(filters);
                periodFilters.add(new QFilter("id", "in", periodIds));
                try (DataSet ds3 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bcm_periodmembertree", (String)"id", (QFilter[])periodFilters.toArray(new QFilter[0]), (String)"number desc", (int)1);){
                    if (null != ds3 && ds3.hasNext()) {
                        periodId = ds3.next().getLong("id");
                    }
                }
            }
        }
        model.setValue("bcmscene", sceneId);
        model.setValue("bcmfy", fyId);
        if (null != periodId) {
            model.setValue("bcmperiod", (Object)new Long[]{periodId});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ORG, BOOKTYPE, "startperiod", "endperiod", "daterange", "fadepreuse"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ARCHIVEPLAN, "bcmscene", "bcmfy", "bcmperiod"});
    }

    private Long getModelIdByScheme(Long schemeId) {
        String largesamplejsonTag;
        DynamicObjectCollection archiveSchemeEntry;
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"aef_archivescheme", (String)"entryentity.largesamplejson_tag");
        if (null != scheme && !(archiveSchemeEntry = scheme.getDynamicObjectCollection("entryentity")).isEmpty() && StringUtils.isNotBlank((CharSequence)(largesamplejsonTag = ((DynamicObject)archiveSchemeEntry.get(0)).getString("largesamplejson_tag")))) {
            ArchiveRangeInfo info = (ArchiveRangeInfo)SerializationUtils.fromJsonString((String)largesamplejsonTag, ArchiveRangeInfo.class);
            return info.getModelId();
        }
        return 0L;
    }

    private void showFaCard() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BOOKTYPE, "daterange", "bcmscene", "bcmfy", "bcmperiod"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ARCHIVEPLAN, ORG, "fadepreuse", "startperiod", "endperiod"});
    }

    private void setDaterange() {
        Date now = new Date();
        this.getModel().setValue("enddate", (Object)now);
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(2, -1);
        Date m3 = c.getTime();
        this.getModel().setValue("startdate", (Object)m3);
    }

    private void setDateTax() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        this.getModel().setValue("startdate", (Object)calendar.getTime());
        calendar.set(5, calendar.getActualMaximum(5));
        this.getModel().setValue("enddate", (Object)calendar.getTime());
    }

    public String yearDateDiff(Date start, Date end) {
        if (null == start || null == end) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u8303\u56f4\u3002", (String)"ArchiveEdit_34", (String)"fi-aef-formplugin", (Object[])new Object[0]);
        }
        long time1 = start.getTime();
        long time2 = end.getTime();
        long time = time2 - time1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        if (!simpleDateFormat.format(start).equals(simpleDateFormat.format(end))) {
            return ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u8de8\u5e74\u3002", (String)"ArchiveEdit_19", (String)"fi-aef-formplugin", (Object[])new Object[0]);
        }
        if (time < 0L) {
            return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ArchiveEdit_20", (String)"fi-aef-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public String taxDateValidator(Date start, Date end) {
        if (null == start || null == end) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u8303\u56f4\u3002", (String)"ArchiveEdit_34", (String)"fi-aef-formplugin", (Object[])new Object[0]);
        }
        long time1 = start.getTime();
        long time2 = end.getTime();
        if (time2 - time1 < 0L) {
            return ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ArchiveEdit_20", (String)"fi-aef-formplugin", (Object[])new Object[0]);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        if (!simpleDateFormat.format(start).equals(simpleDateFormat.format(end))) {
            return ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u8de8\u5e74\u3002", (String)"ArchiveEdit_19", (String)"fi-aef-formplugin", (Object[])new Object[0]);
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(start);
        c2.setTime(end);
        c2.set(5, c2.get(5) + 1);
        if (c2.get(5) == 1 && c1.get(5) == 1) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5f52\u6863\u7c7b\u578b\u4e3a\u7a0e\u52a1\u65f6\uff0c\u65e5\u671f\u8303\u56f4\u5fc5\u987b\u9009\u62e9\u662f\u6574\u6708\u6216\u8005\u6574\u5b63\uff0c\u8bf7\u68c0\u67e5\u65e5\u671f\u8303\u56f4\u7684\u914d\u7f6e\u3002", (String)"ArchiveEdit_35", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private DynamicObject getPreviousPeriod(Object curPeriodId, String appId) {
        if (curPeriodId == null) {
            return null;
        }
        try {
            DynamicObjectCollection coll;
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            QFilter filterDate = new QFilter("id", "<", curPeriodId);
            qFilterList.add(filterDate);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            qFilterList.add(filterType);
            if (!"gl".equals(appId)) {
                qFilterList.add(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
            }
            if ((coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"id desc", (int)1)) == null || coll.isEmpty()) {
                return null;
            }
            return (DynamicObject)coll.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    private DynamicObject getBook(Long orgId, Long bookTypeId, String appId) {
        if ("gl".equals(appId)) {
            QFilter orgQFilter = new QFilter(ORG, "=", (Object)orgId);
            QFilter bookTypeIdQFilter = new QFilter("bookstype", "=", (Object)bookTypeId);
            return QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,curperiod,periodtype,startperiod", (QFilter[])new QFilter[]{orgQFilter, bookTypeIdQFilter});
        }
        if ("cas".equals(appId)) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            QFilter orgQFilter = new QFilter(ORG, "=", (Object)orgId);
            qFilterList.add(orgQFilter);
            QFilter isFinishInitQFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
            qFilterList.add(isFinishInitQFilter);
            if (Objects.nonNull(bookTypeId)) {
                QFilter bookTypeIdQFilter = new QFilter("periodtype", "=", (Object)bookTypeId);
                qFilterList.add(bookTypeIdQFilter);
            }
            return QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"startperiod, currentperiod, periodtype", (QFilter[])qFilterList.toArray(new QFilter[0]));
        }
        return null;
    }
}

