/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.query.ArchivePoolHelper;

public class ArchivePoolListPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ArchivePoolListPlugin.class);
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String Q_ORG = "q_org";
    private static final String Q_TYPE = "q_type";
    private static final String INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE = "InformationOfAccountingDocumentsTuple";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgTypeBase = (BasedataEdit)this.getView().getControl(Q_ORG);
        orgTypeBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar bar = (Toolbar)this.getControl("toolbarap");
        bar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgid = RequestContext.get().getOrgId();
        HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (resutlt.hasAllOrgPerm()) {
            this.getModel().setValue(Q_ORG, (Object)orgid);
        } else {
            HasPermOrgResult result2 = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"15", (String)"aef", (String)"aef_archivepool", (String)"47150e89000000ac");
            List orgIds = result2.getHasPermOrgs();
            if (orgIds != null && !orgIds.isEmpty()) {
                if (!orgIds.contains(orgid)) {
                    orgid = (Long)orgIds.get(0);
                }
                this.getModel().setValue(Q_ORG, (Object)orgid);
            }
        }
        Date now = new Date();
        this.getModel().setValue("enddate", (Object)now);
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(2, -3);
        Date m3 = c.getTime();
        this.getModel().setValue("startdate", (Object)m3);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.flushFilterGridAp(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        if (Q_ORG.equals(baseData.getKey())) {
            ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
            HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
            if (!result.hasAllOrgPerm()) {
                HasPermOrgResult result2 = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"15", (String)"aef", (String)"aef_archivepool", (String)"47150e89000000ac");
                QFilter qFilter = new QFilter("id", "in", (Object)result2.getHasPermOrgs());
                f7List.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    private void flushFilterGridAp(boolean isClearRow) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        if (isClearRow) {
            fc.getFilterRow().clear();
        }
        EntityTypeUtil util = new EntityTypeUtil();
        String qType = (String)this.getModel().getValue(Q_TYPE);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)qType);
        List filterColumns = util.getFilterColumns((IDataEntityType)entityType);
        this.filterColumnList(filterColumns, qType, fc);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(qType);
        filterGrid.SetValue(fc);
        this.getView().updateView(FILTERGRIDAP);
    }

    private void filterColumnList(List<Map<String, Object>> filterColumns, String qType, FilterCondition fc) {
        ArrayList<String> fieldList = new ArrayList<String>(20);
        ArchivePoolHelper.addSpecialFields(fieldList, qType);
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        while (iter.hasNext()) {
            Map<String, Object> column = iter.next();
            String fieldName = (String)column.get("fieldName");
            if (fieldList.contains(fieldName)) continue;
            iter.remove();
        }
        fc.getFilterRow().removeIf(row -> !fieldList.contains(row.getFieldName()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (Q_TYPE.equals(propertyName)) {
            this.flushFilterGridAp(true);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName) {
            case "number": {
                String number = rowData.getString("number");
                String type = rowData.getString("type");
                if (!StringUtils.isNotEmpty((CharSequence)number)) break;
                Long id = Long.parseLong(number.replace(ArchivePoolHelper.getNumberPrefixByType(type), ""));
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)type);
                this.showTabForm(type, entityType.getDisplayName().getLocaleValue() + "_" + number, id);
                break;
            }
            case "sourcebillno": {
                long billId = rowData.getLong("billid");
                String billType = rowData.getString("billtype");
                this.showTabForm(billType, null, billId);
                break;
            }
            case "vouchernumber": {
                long vchId = rowData.getLong("voucherid");
                this.showTabForm("gl_voucher", null, vchId);
                break;
            }
        }
    }

    private void showTabForm(String formId, String formName, Object pkValue) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setFormId(formId);
        if (null != formName) {
            parameter.setCaption(formName);
        }
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("exprotVAT".equals(evt.getItemKey())) {
            String filePath;
            Map result;
            String billtype = "";
            long orgId = 0L;
            HashMap<String, Long> numAndIdMap = new HashMap<String, Long>(16);
            ReportList control = (ReportList)this.getControl("reportlistap");
            ReportListModel reportModel = (ReportListModel)control.getReportModel();
            int rowCount = control.getReportModel().getRowCount();
            if (rowCount == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u5f15\u51fa\u7684\u7535\u5b50\u51ed\u8bc1\u4fe1\u606f\uff0c\u8bf7\u5148\u67e5\u8be2\u540e\u518d\u5f15\u51fa\u3002", (String)"ArchivePoolListPlugin_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportRowSet data = reportModel.getReportTaskResult().getData(0, rowCount);
            while (data.next()) {
                if (orgId == 0L) {
                    orgId = (Long)data.getObject("org");
                }
                numAndIdMap.put((String)data.getObject("number"), (Long)data.getObject("id"));
                billtype = (String)data.getObject("type");
            }
            QFilter idFilter = new QFilter("id", "in", numAndIdMap.values());
            String selectField = "largejson_tag,xbrlurl,id";
            if (!"aef_bkrs".equals(billtype)) {
                selectField = selectField + ",directvoucherid";
            }
            DataSet set = QueryServiceHelper.queryDataSet((String)"ArchivePoolListPlugin.excute", (String)billtype, (String)selectField, (QFilter[])new QFilter[]{idFilter}, null);
            DataSet xbrlSet = set.copy();
            HashSet<Long> voucherSet = new HashSet<Long>(16);
            while (set.hasNext()) {
                Row row = set.next();
                if ("aef_bkrs".equals(billtype)) continue;
                Long vId = row.getLong("directvoucherid");
                voucherSet.add(vId);
            }
            Map voucherJson = new HashMap(16);
            if (voucherSet.size() > 0) {
                voucherJson = ArchiveUtil.getVoucherJson(voucherSet);
            }
            String tickettype = "";
            while (xbrlSet.hasNext()) {
                String url;
                String xbrlWriteDir;
                JSONObject json;
                block36: {
                    String issuerUrl;
                    Row row = xbrlSet.next();
                    json = JSONObject.parseObject((String)row.getString("largejson_tag"));
                    if (!"aef_bkrs".equals(billtype)) {
                        json.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, voucherJson.get(row.getLong("directvoucherid")));
                    }
                    if ("einv_ord_receiver".equals(tickettype = json.getString("tickettype")) || "einv_spcl_receiver".equals(tickettype)) {
                        json.put("RequestTime", (Object)DateUtil.format((Date)json.getDate("RequestTime"), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    byte[] xbrlData = FileUtils.json2Xbrl((String)json.toJSONString(), (String)tickettype);
                    xbrlWriteDir = FileUtils.getXbrlWriteDir((String)(FileUtils.getPoolXbrlDir((String)this.getView().getPageId()) + File.separator + ContextUtil.createXBRLPath((String)tickettype, (JSONObject)json)));
                    FileUtils.writeToFile((byte[])xbrlData, (String)(xbrlWriteDir + File.separator + ContextUtil.createXBRLFilename((String)tickettype, (JSONObject)json)));
                    if (this.isInVoice(billtype) && StringUtils.isNotEmpty((CharSequence)(issuerUrl = json.getString("xbrlUrl")))) {
                        try {
                            byte[] issuerData = FileUtils.downLoadAnyUrl((String)issuerUrl);
                            if (issuerData == null || issuerData.length <= 0) break block36;
                            FileUtils.writeToFile((byte[])issuerData, (String)(xbrlWriteDir + File.separator + ContextUtil.createXBRLFilename((String)tickettype, (JSONObject)json).replace("receiver", "issuer")));
                        }
                        catch (IOException e) {
                            logger.error(ResManager.loadKDString((String)"{}\u83b7\u53d6\u5f00\u5177\u7aefxbrl\u6587\u4ef6\u5931\u8d25{}", (String)"ArchivePoolListPlugin_2", (String)"fi-aef-formplugin", (Object[])new Object[0]), (Object)tickettype.replace("receiver", "issuer"), (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            continue;
                        }
                    }
                }
                if ("aef_bkerreceiver".equals(billtype) && StringUtils.isNotBlank((CharSequence)(url = json.getString("url")))) {
                    try {
                        byte[] pdfData = FileUtils.downLoadAnyUrl((String)url);
                        String fullUrl = xbrlWriteDir + File.separator + ElecreceiptUtils.getFileName((String)url);
                        FileUtils.writeToFile((byte[])pdfData, (String)fullUrl);
                        if ((url.endsWith(".ofd") || url.endsWith(".pdf")) && pdfData.length > 0) {
                            FileUtils.extractXBRL((String)fullUrl, (String)(xbrlWriteDir + File.separator + ContextUtil.createXBRLFilename((String)tickettype, (JSONObject)json).replace("receiver", "issuer")));
                        }
                        FileUtils.deleteFile((String)fullUrl);
                    }
                    catch (Exception e) {
                        logger.error(ResManager.loadKDString((String)"{}\u83b7\u53d6\u5f00\u5177\u7aefxbrl\u6587\u4ef6\u5931\u8d25{}", (String)"ArchivePoolListPlugin_2", (String)"fi-aef-formplugin", (Object[])new Object[0]), (Object)tickettype.replace("receiver", "issuer"), (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                        continue;
                    }
                }
                FileUtils.zipSpecFile((String)xbrlWriteDir);
            }
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"uniformsocialcreditcode,number");
            String orgUnionCode = "";
            if (null != orgDyn && StringUtils.isBlank((CharSequence)(orgUnionCode = orgDyn.getString("uniformsocialcreditcode")))) {
                orgUnionCode = orgDyn.getString("number");
            }
            if (!(result = FileUtils.exportPool((String)orgUnionCode, (String)this.getView().getPageId())).isEmpty() && StringUtils.isNotBlank((CharSequence)(filePath = (String)result.get("fileName")))) {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));){
                    String url = FileUtils.saveAsUrl((InputStream)in, (String)("receiver_" + orgUnionCode + "_" + System.currentTimeMillis() + ".zip"));
                    this.getView().openUrl(url);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ArchiveEdit_14", (String)"fi-ai-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                }
                catch (IOException e) {
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    FileUtils.deleteFile((String)filePath);
                }
            }
        }
    }

    private boolean isInVoice(String billtype) {
        return "aef_atrreceiver".equals(billtype) || "aef_raireceiver".equals(billtype) || "aef_invordreceiver".equals(billtype) || "aef_invtlfreceiver".equals(billtype) || "aef_invspclreceiver".equals(billtype) || "aef_ntrevgpmreceiver".equals(billtype) || "aef_efi".equals(billtype) || "aef_einvspclreceiver".equals(billtype) || "aef_einvordreceiver".equals(billtype);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_EADA");
        LicenseCheckResult result1 = new LicenseCheckResult();
        result1.setHasLicense(Boolean.valueOf(false));
        try {
            result1 = LicenseServiceHelper.checkLicenseRight((Long)UserServiceHelper.getCurrentUserId(), (String)"EVP", (String)"evp_voucher");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!result.getHasLicense().booleanValue() && !result1.getHasLicense().booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u7535\u5b50\u51ed\u8bc1\u6c60\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ArchivePoolListPlugin_0", (String)"fi-aef-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }
}

