/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.Printsample;

public class ArchiveRangeFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String REFBILL = "refbill";
    private static final String REFBILLSAMPLE = "refbillsample";
    private static final String REFBILLSAMPLEID = "refbillsampleid";
    private static final String ISNEEDREFATTACHFILE = "isneedrefattachfile";
    private static final String PERIODFLEX = "periodflex";
    private static final String DEFCONDITIONFLEX = "defconditionflex";
    private static final String ADVCONAP = "advconap";
    private static final String ENTITY = "entryentity";
    private static final String PRINTTEMPLATEFORMID = "aef_printtemplatemultiple";
    private static final String PRINTTEMPLATE_TAG = "printtemplate_tag";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
        BasedataEdit refbill = (BasedataEdit)this.getControl(REFBILL);
        TextEdit caption = (TextEdit)this.getView().getControl(REFBILLSAMPLE);
        caption.addButtonClickListener((ClickListener)this);
        refbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterGrid();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String json = (String)showParam.getCustomParam("archiverangejson");
        if (StringUtils.isNotEmpty((String)json)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
            fg.SetValue(fc);
        }
        this.setFlexVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (key.equals(REFBILL)) {
            DynamicObject newValObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValObj == null) {
                return;
            }
            model.setValue(REFBILLSAMPLE, (Object)"", rowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List list;
        String largesamplejson_tag;
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String billType = (String)showParam.getCustomParam("billtype");
        if ("gl_voucher".equals(billType) && !StringUtils.isEmpty((String)(largesamplejson_tag = (String)showParam.getCustomParam("largesamplejson_tag"))) && (list = SerializationUtils.fromJsonStringToList((String)largesamplejson_tag, Printsample.class)) != null && list.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTITY, list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.getModel().setValue(REFBILL, (Object)((Printsample)list.get(i)).getBillType(), i);
                this.getModel().setValue(REFBILLSAMPLE, (Object)((Printsample)list.get(i)).getRefbillsampleName(), i);
                this.getModel().setValue(REFBILLSAMPLEID, (Object)((Printsample)list.get(i)).getRefbillsampleid(), i);
                this.getModel().setValue(PRINTTEMPLATE_TAG, (Object)((Printsample)list.get(i)).getPrintTemplateJson(), i);
                if (((Printsample)list.get(i)).getIsNeedRefAttachFile() == null) continue;
                this.getModel().setValue(ISNEEDREFATTACHFILE, (Object)((Printsample)list.get(i)).getIsNeedRefAttachFile(), i);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String billtype = (String)showParam.getCustomParam("billtype");
            String archivetype = (String)showParam.getCustomParam("archivetype");
            HashMap<String, String> dataMap = new HashMap<String, String>();
            if ("bill".equals(archivetype) || "tax".equals(archivetype)) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billtype);
                FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
                FilterCondition fc = fg.getFilterGridState().getFilterCondition();
                FilterBuilder filterBuilder = new FilterBuilder(entityType, fc, false);
                filterBuilder.buildFilter(false);
                String filterStr = filterBuilder.getFilterString();
                filterStr = filterStr.replaceAll("\\s{3,}", "  ");
                dataMap.put("archiverange", filterStr);
                dataMap.put("archiverangejson", SerializationUtils.toJsonString((Object)fc));
            }
            if ("gl_voucher".equals(billtype)) {
                List<Printsample> printsampleList = this.getPrintsampleList();
                if (printsampleList == null) {
                    return;
                }
                dataMap.put("largesamplejson_tag", SerializationUtils.toJsonString(printsampleList));
            }
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        } else if (REFBILLSAMPLE.equals(key)) {
            String billtype = this.getBillTypeFiled();
            if (StringUtil.isEmpty((String)billtype)) {
                return;
            }
            Map<String, String> printsmaplels = this.getTemplates(billtype);
            if (printsmaplels != null && printsmaplels.size() > 0) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(PRINTTEMPLATEFORMID);
                parameter.setCustomParam("formLs", printsmaplels);
                parameter.setCustomParam("billtype", (Object)billtype);
                parameter.setCustomParam("templatelist", (Object)((String)this.getModel().getValue(PRINTTEMPLATE_TAG, rowIndex)));
                parameter.setCustomParam("oldprintsmaple", (Object)((String)this.getModel().getValue(REFBILLSAMPLEID, rowIndex)));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFBILL));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveRangeFormPlugin_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<Printsample> getPrintsampleList() {
        ArrayList<Printsample> printsampleList = new ArrayList<Printsample>();
        DynamicObjectCollection dyns = this.getModel().getEntryEntity(ENTITY);
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        for (DynamicObject dyn : dyns) {
            ++i;
            Printsample printsample = new Printsample();
            if (dyn.getDynamicObject(REFBILL) == null) continue;
            String id = dyn.getDynamicObject(REFBILL).getString("id");
            if (set.contains(id)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u5173\u8054\u5355\u636e[%s],\u8bf7\u4fee\u6539\u3002", (String)"ArchiveRangeFormPlugin_2", (String)"fi-aef-formplugin", (Object[])new Object[0]), dyn.getDynamicObject(REFBILL).getString("name")));
                return null;
            }
            set.add(id);
            printsample.setBillType(dyn.getDynamicObject(REFBILL).getString("number"));
            printsample.setRefbillsampleName(dyn.getString(REFBILLSAMPLE));
            printsample.setRefbillsampleid(dyn.getString(REFBILLSAMPLEID));
            printsample.setIsNeedRefAttachFile(dyn.getString(ISNEEDREFATTACHFILE));
            printsample.setPrintTemplateJson(dyn.getString(PRINTTEMPLATE_TAG));
            if (StringUtils.isEmpty((String)dyn.getString(REFBILLSAMPLE))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u3002", (String)"ArchiveRangeFormPlugin_3", (String)"fi-aef-formplugin", (Object[])new Object[0]), i + ""));
                return null;
            }
            printsampleList.add(printsample);
        }
        return printsampleList;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnValue = closedCallBackEvent.getReturnData();
        if (returnValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        int currentRow = Integer.parseInt(this.getPageCache().get("currentrow"));
        switch (closedCallBackEvent.getActionId()) {
            case "refbill": {
                List templateList = (List)returnValue;
                List templatenames = templateList.stream().map(PrintTemplate::getTemplateName).collect(Collectors.toList());
                model.setValue(REFBILLSAMPLE, (Object)String.join((CharSequence)",", templatenames), currentRow);
                model.setValue(REFBILLSAMPLEID, (Object)"", currentRow);
                model.setValue(PRINTTEMPLATE_TAG, (Object)SerializationUtils.toJsonString((Object)templateList), currentRow);
                break;
            }
        }
    }

    private String getBillTypeFiled() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
        this.getPageCache().put("currentrow", Integer.toString(rowIndex));
        DynamicObject curRowObj = this.getModel().getEntryRowEntity(ENTITY, rowIndex);
        String billtype = curRowObj.getString("refbill.number");
        if (StringUtil.isEmpty((String)billtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u884c\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ArchiveRangeFormPlugin_4", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        return billtype;
    }

    private Map<String, String> getTemplates(String formId) {
        HashMap<String, String> templateMap = new HashMap<String, String>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billformid", "=", (Object)formId));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"printtplid, type", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Object> oldPrintMeatIdList = new ArrayList<Object>(dyns.length);
        for (DynamicObject dyn : dyns) {
            String type = dyn.getString("type");
            DynamicObject printTplMetaDynObj = dyn.getDynamicObject("printtplid");
            Object printTplId = dyn.get("printtplid_id");
            if (printTplMetaDynObj == null) {
                oldPrintMeatIdList.add(printTplId);
                continue;
            }
            String name = printTplMetaDynObj.getString("name");
            if (!"B".equals(type)) {
                if (StringUtils.isBlank((String)name)) {
                    oldPrintMeatIdList.add(printTplId);
                    continue;
                }
                templateMap.put(printTplMetaDynObj.getString("number"), name);
                continue;
            }
            templateMap.put(printTplMetaDynObj.getString("number"), name);
        }
        if (oldPrintMeatIdList.isEmpty()) {
            return templateMap;
        }
        DynamicObjectCollection formmetaMap = QueryServiceHelper.query((String)"bos_formmeta", (String)"id, number, name", (QFilter[])new QFilter("id", "in", oldPrintMeatIdList).toArray());
        if (formmetaMap.size() > 0) {
            for (DynamicObject dynamicObject : formmetaMap) {
                Object number = dynamicObject.get("number");
                Object name = dynamicObject.get("name");
                templateMap.put(number.toString(), name.toString());
            }
        }
        return templateMap;
    }

    private void initFilterGrid() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String billtype = (String)showParam.getCustomParam("billtype");
        String archivetype = (String)showParam.getCustomParam("archivetype");
        if (StringUtils.isEmpty((String)archivetype) || StringUtils.isEmpty((String)billtype)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u672a\u83b7\u53d6\u5230\u5f52\u6863\u7c7b\u578b\u3001\u5355\u636e\u7c7b\u578b\u3002", (String)"ArchiveRangeFormPlugin_5", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            return;
        }
        FilterGrid fg = (FilterGrid)this.getControl("filtergridap");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billtype);
        String mainOrg = entityType.getMainOrg();
        String billstatus = ((BillEntityType)entityType).getBillStatus();
        EntityTypeUtil util = new EntityTypeUtil();
        List filterColumns = util.getFilterColumns((IDataEntityType)entityType);
        Iterator it = filterColumns.iterator();
        while (it.hasNext()) {
            Map filterColumn = (Map)it.next();
            String fieldName = (String)filterColumn.get("fieldName");
            String type = (String)filterColumn.get("type");
            if (mainOrg != null && !"gl_rpt_generalledger".equals(billtype) && !"gl_rpt_subledger".equals(billtype) && !"gl_rpt_subsidiaryledger".equals(billtype) && fieldName.startsWith(mainOrg)) {
                it.remove();
                continue;
            }
            if (null == type || !type.startsWith("date")) continue;
            it.remove();
        }
        fg.setEntityNumber(billtype);
        fg.setFilterColumns(filterColumns);
    }

    private void setFlexVisible() {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String archivetype = (String)showParam.getCustomParam("archivetype");
        String billType = (String)showParam.getCustomParam("billtype");
        if ("finance".equals(archivetype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DEFCONDITIONFLEX});
        }
        this.getView().setVisible(Boolean.valueOf("gl_voucher".equals(billType)), new String[]{ADVCONAP});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        if (REFBILL.equals(baseData.getKey())) {
            List<String> formIds = Arrays.asList("cas_balanceadjust", "cas_bankstatement", "gl_rpt_generalledger", "gl_rpt_subledger", "gl_voucher", "bei_elecstatement", "bei_elecreceipt");
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("number", "not in", formIds));
            filters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }
}

