/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.aef.entity.ArchiveRangeInfo;

public class ArchiveRangeReportFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String ORG = "org";
    private static final String ORGJSON = "orgjson";
    private static final String REPORTFORM = "reportform";
    private static final String AMOUNTUNIT = "amountunit";
    private static final String CURRENCY = "currency";
    private static final String FI_AEF_FORMPLUGIN = "fi-aef-formplugin";
    private static final String ENTITY = "Entity";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit org = (TextEdit)this.getView().getControl(ORG);
        org.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit reportForm = (BasedataEdit)this.getControl(REPORTFORM);
        reportForm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl(CURRENCY);
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        if (Boolean.TRUE.equals(showParam.getCustomParam("enable_archiverange_rpt"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{MODEL, ORG, REPORTFORM, AMOUNTUNIT, CURRENCY, "btnok"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        switch (key) {
            case "model": {
                Object newValue = changeData.getNewValue();
                if (newValue == null) break;
                model.setValue(ORG, (Object)"");
                model.setValue(REPORTFORM, (Object)"");
                model.setValue(CURRENCY, (Object)"");
                break;
            }
            case "org": {
                if (!StringUtils.isEmpty((String)changeData.getNewValue().toString())) break;
                model.setValue(ORGJSON, (Object)"");
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        ArchiveRangeInfo info;
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String largesamplejsonTag = (String)showParam.getCustomParam("largesamplejson_tag");
        if (StringUtils.isNotEmpty((String)largesamplejsonTag) && null != (info = (ArchiveRangeInfo)SerializationUtils.fromJsonString((String)largesamplejsonTag, ArchiveRangeInfo.class))) {
            IDataModel model = this.getModel();
            model.setValue(MODEL, (Object)info.getModelId());
            String orgJson = info.getOrgJson();
            List orgList = (List)SerializationUtils.fromJsonString((String)orgJson, List.class);
            if (null != orgList && !orgList.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Map map : orgList) {
                    builder.append((String)map.get("name"));
                    builder.append("\uff1b");
                }
                String names = builder.toString();
                model.setValue(ORG, (Object)names.substring(0, names.length() - 1));
            }
            model.setValue(ORGJSON, (Object)orgJson);
            List reportIds = info.getReportEntityIds();
            if (null != reportIds && !reportIds.isEmpty()) {
                model.setValue(REPORTFORM, (Object)reportIds.toArray(new Long[0]));
            }
            model.setValue(AMOUNTUNIT, (Object)info.getAmountUnit());
            model.setValue(CURRENCY, (Object)info.getCurrencyId());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            String tipMsg;
            DynamicObject currency;
            String amountunit;
            DynamicObjectCollection reportform;
            String org;
            IDataModel model = this.getModel();
            DynamicObject modelObj = (DynamicObject)model.getValue(MODEL);
            StringBuilder builder = new StringBuilder();
            if (null == modelObj) {
                builder.append(ResManager.loadKDString((String)"\u4f53\u7cfb\uff0c", (String)"ArchiveRangeReportFormPlugin_1", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((String)(org = (String)model.getValue(ORG)))) {
                builder.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff0c", (String)"ArchiveRangeReportFormPlugin_2", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (null == (reportform = (DynamicObjectCollection)model.getValue(REPORTFORM)) || reportform.isEmpty()) {
                builder.append(ResManager.loadKDString((String)"\u62a5\u8868\uff0c", (String)"ArchiveRangeReportFormPlugin_3", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)(amountunit = (String)model.getValue(AMOUNTUNIT)))) {
                builder.append(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d\uff0c", (String)"ArchiveRangeReportFormPlugin_4", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (null == (currency = (DynamicObject)model.getValue(CURRENCY))) {
                builder.append(ResManager.loadKDString((String)"\u5e01\u522b\uff0c", (String)"ArchiveRangeReportFormPlugin_5", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)(tipMsg = builder.toString()))) {
                String kdString = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\uff1a%s\u3002", (String)"ArchiveRangeReportFormPlugin_0", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(kdString, tipMsg.substring(0, tipMsg.length() - 1)));
                return;
            }
            Map<String, String> dataMap = this.getArchiveRangeInfo();
            this.getView().returnDataToParent(dataMap);
            this.getView().close();
        }
        if (ORG.equals(key)) {
            this.showSelectOrgView();
        }
    }

    private void showSelectOrgView() {
        IDataModel model = this.getModel();
        DynamicObject model2 = (DynamicObject)model.getValue(MODEL);
        if (null == model2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ArchiveRangeReportFormPlugin_11", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_tem");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"ArchiveRangeReportFormPlugin_12", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCustomParam("sign", (Object)ENTITY);
        formShowParameter.setCustomParam("isUpDownBtn", (Object)true);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(model2.getLong("id")));
        String org = (String)model.getValue(ORG);
        String orgJson = (String)model.getValue(ORGJSON);
        formShowParameter.setCustomParam("sign", (Object)ENTITY);
        if (StringUtils.isNotEmpty((String)org) && StringUtils.isNotEmpty((String)orgJson)) {
            formShowParameter.setCustomParam(ENTITY, (Object)orgJson);
        } else {
            formShowParameter.setCustomParam(ENTITY, (Object)"[]");
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("selectmember".equals(actionId) && e.getReturnData() != null) {
            IDataModel model = this.getModel();
            DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
            if (null != newdoc && !newdoc.isEmpty()) {
                ArrayList newList = new ArrayList(newdoc.size());
                StringBuilder builder = new StringBuilder();
                for (DynamicObject object : newdoc) {
                    String name = object.getString("mname1");
                    builder.append(name);
                    builder.append("\uff1b");
                    HashMap<String, String> m = new HashMap<String, String>(4);
                    m.put("id", object.getString("mid1"));
                    m.put("scope", object.getString("filltypevalue1"));
                    m.put("number", object.getString("mnum1"));
                    m.put("name", name);
                    newList.add(m);
                }
                String names = builder.toString();
                model.setValue(ORG, (Object)names.substring(0, names.length() - 1));
                model.setValue(ORGJSON, (Object)SerializationUtils.toJsonString(newList));
            } else {
                model.setValue(ORG, (Object)"");
                model.setValue(ORGJSON, (Object)"");
            }
        }
    }

    private Map<String, String> getArchiveRangeInfo() {
        IDataModel model = this.getModel();
        ArchiveRangeInfo info = new ArchiveRangeInfo();
        DynamicObject modelObj = (DynamicObject)model.getValue(MODEL);
        Long modelId = modelObj.getLong("id");
        info.setModelId(modelId);
        String orgjson = (String)model.getValue(ORGJSON);
        info.setOrgJson(orgjson);
        DynamicObjectCollection reportforms = (DynamicObjectCollection)model.getValue(REPORTFORM);
        ArrayList<Long> reportEntityIds = new ArrayList<Long>();
        StringBuilder rfBuilder = new StringBuilder();
        rfBuilder.append(ResManager.loadKDString((String)"\uff083\uff09\u62a5\u8868 ", (String)"ArchiveRangeReportFormPlugin_8", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
        for (DynamicObject reportform : reportforms) {
            DynamicObject o = (DynamicObject)reportform.get("fbasedataid");
            Long reportEntityId = o.getLong("id");
            String name = o.getString("name");
            reportEntityIds.add(reportEntityId);
            rfBuilder.append(name);
            rfBuilder.append("\uff1b");
        }
        String reportformStr = rfBuilder.substring(0, rfBuilder.length() - 1);
        info.setReportEntityIds(reportEntityIds);
        String amountUnit = (String)model.getValue(AMOUNTUNIT);
        info.setAmountUnit(Integer.parseInt(amountUnit));
        DynamicObject currency = (DynamicObject)model.getValue(CURRENCY);
        info.setCurrencyId(Long.valueOf(currency.getLong("id")));
        HashMap<String, String> dataMap = new HashMap<String, String>(2);
        dataMap.put("largesamplejson_tag", SerializationUtils.toJsonString((Object)info));
        String archiverangereport = String.format(ResManager.loadKDString((String)"\uff081\uff09\u4f53\u7cfb\u3010%s\u3011", (String)"ArchiveRangeReportFormPlugin_6", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), modelObj.getString("name")) + " " + String.format(ResManager.loadKDString((String)"\uff082\uff09\u7ec4\u7ec7\u3010%s\u3011", (String)"ArchiveRangeReportFormPlugin_7", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), model.getValue(ORG)) + " " + reportformStr + String.format(ResManager.loadKDString((String)"\uff084\uff09\u91d1\u989d\u5355\u4f4d\u3010%s\u3011", (String)"ArchiveRangeReportFormPlugin_9", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), this.getAmountUnitName(amountUnit)) + " " + String.format(ResManager.loadKDString((String)"\uff085\uff09\u5e01\u79cd\u3010%s\u3011", (String)"ArchiveRangeReportFormPlugin_10", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), currency.getString("name"));
        if (archiverangereport.length() > 500) {
            archiverangereport = archiverangereport.substring(0, 500) + "...";
        }
        dataMap.put("archiverangereport", archiverangereport);
        return dataMap;
    }

    private String getAmountUnitName(String amountUnit) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(AMOUNTUNIT);
        return ((ComboProp)comboEdit.getProperty()).getItemByName(amountUnit);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (null == model) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ArchiveRangeReportFormPlugin_11", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long id = model.getLong("id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (REPORTFORM.equals(baseData.getKey())) {
            filters.add(new QFilter("model.id", "=", (Object)id));
            f7List.getListFilterParameter().setQFilters(filters);
        } else if (CURRENCY.equals(baseData.getKey())) {
            filters.add(new QFilter("model.id", "=", (Object)id));
            filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }
}

