/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.aef.common.util.FormMetaDataUtil;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.Printsample;

public class ArchiveSchemeEdit
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static final String AEF_ACELRE = "aef_acelre";
    private static final String SAMPLEPRINTFORMID = "aef_printtemplatemultiple";
    private static final String ENTITY = "entryentity";
    private static final String ARCHIVETYPE = "archivetype";
    private static final String FINANCE = "finance";
    private static final String BILL = "bill";
    private static final String REPORTFORM = "reportform";
    private static final String IS_XBRL_PILOT = "isxbrlpilot";
    private static final String TAX = "tax";
    private static final String BILLTYPE = "billtype";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String GROUP = "group";
    private static final String PRINTTEMPLATE_TAG = "printtemplate_tag";
    private static final String PRINTTEMPLATE_DISPLAY = "printtemplate_display";
    private static final String PRINTSAMPLEID = "printsampleid";
    private static final String IS_FIRST = "isfirst";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit caption = (TextEdit)this.getView().getControl(PRINTTEMPLATE_DISPLAY);
        caption.addButtonClickListener((ClickListener)this);
        TextEdit arcRange = (TextEdit)this.getControl("archiverange");
        arcRange.addButtonClickListener((ClickListener)this);
        BasedataEdit billtype = (BasedataEdit)this.getControl(BILLTYPE);
        billtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit arcRangeReport = (TextEdit)this.getControl("archiverangereport");
        arcRangeReport.addButtonClickListener((ClickListener)this);
        TextEdit datefieldtext = (TextEdit)this.getControl("datefieldtext");
        datefieldtext.addButtonClickListener((ClickListener)this);
        TextEdit attachtab = (TextEdit)this.getControl("attachtab");
        attachtab.addButtonClickListener((ClickListener)this);
        BasedataEdit group = (BasedataEdit)this.getControl(GROUP);
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"save"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put(IS_FIRST, "true");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Object createOrg = model.getValue("createorg");
        if (null == createOrg) {
            IFormView parentView;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object org = parameter.getCustomParam("org");
            long curLoginOrg = null != org ? Long.parseLong(org.toString()) : (null != (parentView = this.getView().getParentView()) && "aef_apphome".equals(parentView.getEntityId()) ? ((Long)this.getView().getParentView().getModel().getValue("orgid_id")).longValue() : RequestContext.get().getOrgId());
            model.setValue("createorg", (Object)curLoginOrg);
            model.setValue("org", (Object)curLoginOrg);
            model.setValue("useorg", (Object)curLoginOrg);
            String ctg = (String)model.getValue("ctrlstrategy");
            if (StringUtils.isEmpty((CharSequence)ctg) && StringUtils.isEmpty((CharSequence)(ctg = BaseDataServiceHelper.getBdCtrlStrgy((String)"aef_archivescheme", (String)String.valueOf(curLoginOrg))))) {
                ctg = "5";
            }
            model.setValue("ctrlstrategy", (Object)ctg);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GROUP});
        }
    }

    public void afterBindData(EventObject e) {
        String billType;
        int rowIndex;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String archivetype = (String)model.getValue(ARCHIVETYPE);
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTITY);
        if (FINANCE.equals(archivetype)) {
            this.buildaiComboItems(FINANCE);
            rowIndex = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                String billtype = dynamicObject.getString("billtype.number");
                if ("gl_voucher".equals(billtype)) {
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"archiverange"});
                } else {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"archiverange"});
                }
                if (Arrays.asList("gl_rpt_generalledger", "gl_rpt_subledger", "gl_rpt_subsidiaryledger", "cas_bankjournalformrpt", "cas_cashjournalformrpt").contains(billtype)) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"isneedattachfile"});
                } else {
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"isneedattachfile"});
                }
                ++rowIndex;
            }
        }
        if (BILL.equals(archivetype)) {
            this.buildaiComboItems(BILL);
            rowIndex = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                billType = dynamicObject.getString("billtype.number");
                this.setArchevedate(billType, rowIndex);
                ++rowIndex;
            }
        }
        if (TAX.equals(archivetype)) {
            rowIndex = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                billType = dynamicObject.getString("billtype.number");
                this.setArchevedate(billType, rowIndex);
                String string = this.getModel().getValue("archiverangereport", rowIndex).toString();
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    Map rangeMap = (Map)SerializationUtils.fromJsonString((String)string, Map.class);
                    this.getModel().setValue("taxarchivedata", rangeMap.get("taxarchivedata"), rowIndex);
                    this.getModel().setValue("taxticcttype", rangeMap.get("taxticcttype"), rowIndex);
                }
                ++rowIndex;
            }
            this.buildaiComboItems(BILL);
        }
        this.setDynamicMetadata();
        this.setEnableByAcelre(archivetype);
        this.refreshPrintSamleName();
        this.getPageCache().put(IS_FIRST, "false");
    }

    private void setEnableByAcelre(String archivetype) {
        block6: {
            Map<String, Set<String>> returnMap;
            Set<String> typeSet;
            IFormView view;
            IDataModel model;
            block7: {
                model = this.getModel();
                Long id = (Long)model.getValue("id");
                if (null == id || id <= 0L) break block6;
                view = this.getView();
                if (!FINANCE.equals(archivetype) && !BILL.equals(archivetype)) break block7;
                Set<String> typeSet2 = this.getTypeByAcelre();
                if (typeSet2.isEmpty()) break block6;
                view.setEnable(Boolean.FALSE, new String[]{"number"});
                view.setEnable(Boolean.FALSE, new String[]{"name"});
                view.setEnable(Boolean.FALSE, new String[]{ARCHIVETYPE});
                view.setEnable(Boolean.FALSE, new String[]{GROUP});
                view.setEnable(Boolean.FALSE, new String[]{IS_XBRL_PILOT});
                DynamicObjectCollection entryEntity = model.getEntryEntity(ENTITY);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    if (!typeSet2.contains(dynamicObject.getString("billtype.number"))) continue;
                    view.setEnable(Boolean.FALSE, i, new String[]{BILLTYPE});
                    view.setEnable(Boolean.FALSE, i, new String[]{"isneedattachfile"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"datefieldtext"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"aiarchive"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"attachtab"});
                }
                break block6;
            }
            if (REPORTFORM.equals(archivetype) && this.isExistRptAcelre()) {
                view.setEnable(Boolean.FALSE, new String[]{"number"});
                view.setEnable(Boolean.FALSE, new String[]{"name"});
                view.setEnable(Boolean.FALSE, new String[]{ARCHIVETYPE});
                view.setEnable(Boolean.FALSE, new String[]{GROUP});
                view.setEnable(Boolean.FALSE, 0, new String[]{"aiarchive"});
            } else if (TAX.equals(archivetype) && !(typeSet = (returnMap = this.getTaxByAcelre()).get("billTypeSet")).isEmpty()) {
                view.setEnable(Boolean.FALSE, new String[]{"number"});
                view.setEnable(Boolean.FALSE, new String[]{"name"});
                view.setEnable(Boolean.FALSE, new String[]{ARCHIVETYPE});
                view.setEnable(Boolean.FALSE, new String[]{GROUP});
                DynamicObjectCollection entryEntity = model.getEntryEntity(ENTITY);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                    if (!typeSet.contains(dynamicObject.getString("billtype.number"))) continue;
                    if (TCVAT_NSRXX.equals(dynamicObject.getString("billtype.number"))) {
                        Set<String> tccitTypeSet = returnMap.get("tccitTypeSet");
                        if (!tccitTypeSet.contains(dynamicObject.getString("taxticcttype.number"))) continue;
                        view.setEnable(Boolean.FALSE, i, new String[]{"taxarchivedata"});
                        view.setEnable(Boolean.FALSE, i, new String[]{"taxticcttype"});
                        view.setEnable(Boolean.FALSE, i, new String[]{BILLTYPE});
                        view.setEnable(Boolean.FALSE, i, new String[]{"isneedattachfile"});
                        view.setEnable(Boolean.FALSE, i, new String[]{"datefieldtext"});
                        view.setEnable(Boolean.FALSE, i, new String[]{"aiarchive"});
                        view.setEnable(Boolean.FALSE, i, new String[]{"attachtab"});
                        continue;
                    }
                    view.setEnable(Boolean.FALSE, i, new String[]{"taxarchivedata"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"taxticcttype"});
                    view.setEnable(Boolean.FALSE, i, new String[]{BILLTYPE});
                    view.setEnable(Boolean.FALSE, i, new String[]{"isneedattachfile"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"datefieldtext"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"aiarchive"});
                    view.setEnable(Boolean.FALSE, i, new String[]{"attachtab"});
                }
            }
        }
    }

    private void buildaiComboItems(String archiveType) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("aiarchive");
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(2);
        if (BILL.equals(archiveType)) {
            ComboItem item = new ComboItem();
            item.setId("1");
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u6708", (String)"ArchiveSchemeEdit_7", (String)"fi-aef-formplugin", (Object[])new Object[0])));
            item.setValue("1");
            ComboItem item2 = new ComboItem();
            item2.setId("2");
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u4e0a\u6708", (String)"ArchiveSchemeEdit_8", (String)"fi-aef-formplugin", (Object[])new Object[0])));
            item2.setValue("2");
            combos.add(item);
            combos.add(item2);
            comboEdit.setComboItems(combos);
        } else if (FINANCE.equals(archiveType)) {
            ComboItem item = new ComboItem();
            item.setId("1");
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u671f", (String)"ArchiveSchemeEdit_9", (String)"fi-aef-formplugin", (Object[])new Object[0])));
            item.setValue("1");
            ComboItem item2 = new ComboItem();
            item2.setId("2");
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u4e0a\u671f", (String)"ArchiveSchemeEdit_10", (String)"fi-aef-formplugin", (Object[])new Object[0])));
            item2.setValue("2");
            combos.add(item);
            combos.add(item2);
            comboEdit.setComboItems(combos);
        }
    }

    private Set<String> getTypeByAcelre() {
        IDataModel model = this.getModel();
        Long id = (Long)model.getValue("id");
        HashSet<String> typeSet = new HashSet<String>(5);
        if (id > 0L) {
            QFilter[] qFilters = new QFilter[]{new QFilter("wayid", "=", (Object)id), new QFilter("type", "=", (Object)Character.valueOf('1'))};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)AEF_ACELRE, (String)BILLTYPE, (QFilter[])qFilters, null).groupBy(new String[]{BILLTYPE}).finish();){
                for (Row row : ds) {
                    String billtype = row.getString(BILLTYPE);
                    if (!StringUtils.isNotEmpty((CharSequence)billtype)) continue;
                    typeSet.add(billtype);
                }
            }
        }
        return typeSet;
    }

    private Map<String, Set<String>> getTaxByAcelre() {
        IDataModel model = this.getModel();
        Long id = (Long)model.getValue("id");
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>(2);
        HashSet<String> billTypeSet = new HashSet<String>(5);
        HashSet<String> tccitTypeSet = new HashSet<String>(5);
        if (id > 0L) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
            QFilter qFilter1 = new QFilter("wayid", "=", (Object)id);
            QFilter qFilter2 = new QFilter("type", "=", (Object)Character.valueOf('1'));
            qFilters.add(qFilter1);
            qFilters.add(qFilter2);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"aef_acelre_tax", (String)BILLTYPE, (QFilter[])qFilters.toArray(new QFilter[0]), null).groupBy(new String[]{BILLTYPE}).finish();){
                for (Row row : ds) {
                    String billtype = row.getString(BILLTYPE);
                    if (!StringUtils.isNotEmpty((CharSequence)billtype)) continue;
                    billTypeSet.add(billtype);
                }
            }
            if (billTypeSet.contains(TCVAT_NSRXX)) {
                QFilter qFilter3 = new QFilter(BILLTYPE, "=", (Object)TCVAT_NSRXX);
                qFilters.add(qFilter3);
                DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"aef_acelre_tax", (String)"billtype, otherdata_tag", (QFilter[])qFilters.toArray(new QFilter[0]), null);
                Object object = null;
                try {
                    for (Row row : ds) {
                        String otherdata = row.getString("otherdata_tag");
                        if (!StringUtils.isNotEmpty((CharSequence)otherdata)) continue;
                        Map map = (Map)SerializationUtils.fromJsonString((String)otherdata, Map.class);
                        tccitTypeSet.add((String)map.get("taxticcttype"));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
        }
        returnMap.put("billTypeSet", billTypeSet);
        returnMap.put("tccitTypeSet", tccitTypeSet);
        return returnMap;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel model = this.getModel();
        String archivetype = (String)model.getValue(ARCHIVETYPE);
        String rowMsg = "";
        int[] rowIndexs = e.getRowIndexs();
        if (FINANCE.equals(archivetype) || BILL.equals(archivetype)) {
            Set<String> typeSet = this.getTypeByAcelre();
            if (typeSet.isEmpty()) {
                return;
            }
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTITY);
            StringBuilder rows = new StringBuilder();
            for (int rowIndex : rowIndexs) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
                String billtype = dynamicObject.getString("billtype.number");
                if (!typeSet.contains(billtype) || !this.isOldRow(ENTITY, rowIndex)) continue;
                e.setCancel(true);
                rows.append(rowIndex + 1);
                rows.append("\uff0c");
            }
            rowMsg = rows.toString();
        } else if (REPORTFORM.equals(archivetype)) {
            for (int rowIndex : rowIndexs) {
                if (rowIndex != 0 || !this.isExistRptAcelre()) continue;
                e.setCancel(true);
                rowMsg = "1\uff0c";
            }
        } else if (TAX.equals(archivetype)) {
            Map<String, Set<String>> returnMap = this.getTaxByAcelre();
            Set<String> typeSet = returnMap.get("billTypeSet");
            Set<String> tccitTypeSet = returnMap.get("tccitTypeSet");
            if (typeSet.isEmpty()) {
                return;
            }
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTITY);
            StringBuilder rows = new StringBuilder();
            for (int rowIndex : rowIndexs) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
                String billtype = dynamicObject.getString("billtype.number");
                if (!typeSet.contains(billtype)) continue;
                if (TCVAT_NSRXX.equals(billtype)) {
                    if (!tccitTypeSet.contains(dynamicObject.getString("taxticcttype.number"))) continue;
                    e.setCancel(true);
                    rows.append(rowIndex + 1);
                    rows.append("\uff0c");
                    continue;
                }
                e.setCancel(true);
                rows.append(rowIndex + 1);
                rows.append("\uff0c");
            }
            rowMsg = rows.toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)rowMsg)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\u5206\u5f55\u5df2\u5173\u8054\u5f52\u6863\u8bb0\u5f55\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ArchiveSchemeEdit_5", (String)"fi-aef-formplugin", (Object[])new Object[0]), rowMsg.substring(0, rowMsg.length() - 1)));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String archiveType = (String)this.getModel().getValue(ARCHIVETYPE);
        if (TAX.equals(archiveType)) {
            RowDataEntity[] rows;
            for (RowDataEntity rowDataEntity : rows = e.getRowDataEntities()) {
                this.getModel().setValue("taxarchivedata", (Object)"tccit", rowDataEntity.getRowIndex());
                this.getModel().setValue(BILLTYPE, (Object)TCVAT_NSRXX, rowDataEntity.getRowIndex());
                if (!rowDataEntity.getDataEntity().getString("taxarchivedata").equals("tccit")) continue;
                this.getView().setEnable(Boolean.FALSE, rowDataEntity.getRowIndex(), new String[]{BILLTYPE});
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "archiverangereport": {
                if (!this.isOldRow(ENTITY, e.getRowIndex()) || !this.isExistRptAcelre()) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u884c\u5206\u5f55\u5df2\u5173\u8054\u5f52\u6863\u8bb0\u5f55\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ArchiveSchemeEdit_6", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean isExistRptAcelre() {
        Long id = (Long)this.getModel().getValue("id");
        return QueryServiceHelper.exists((String)"aef_acelre_rpt", (QFilter[])new QFilter("wayid", "=", (Object)id).toArray());
    }

    private boolean isOldRow(String entryKey, int rowIndex) {
        DynamicObject entity = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        if (null != entity) {
            return entity.getLong("id") > 0L;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "archivetype": {
                model.setValue(IS_XBRL_PILOT, (Object)Boolean.FALSE);
                model.deleteEntryData(ENTITY);
                model.createNewEntryRow(ENTITY);
                this.setDynamicMetadata();
                break;
            }
            case "billtype": {
                DynamicObject newValObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (newValObj == null) {
                    return;
                }
                String newVal = newValObj.getString("number");
                if (Arrays.stream(new String[]{"gl_rpt_generalledger", "gl_rpt_subledger", "gl_rpt_subsidiaryledger", "cas_bankjournalformrpt", "cas_cashjournalformrpt"}).filter(p -> p.equals(newVal)).count() == 1L) {
                    model.setValue("isneedattachfile", (Object)"0", rowIndex);
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"isneedattachfile"});
                } else {
                    model.setValue("isneedattachfile", (Object)"1", rowIndex);
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"isneedattachfile"});
                }
                if (BILL.equals((String)model.getValue(ARCHIVETYPE))) {
                    Map<String, String> attachTab = this.getAttachTab(newValObj.getString("number"));
                    String attach = String.join((CharSequence)"\uff0c", attachTab.values());
                    if (attachTab.size() <= 1) {
                        attach = ResManager.loadKDString((String)"\u6240\u6709\u9644\u4ef6", (String)"ArchiveSchemeEdit_12", (String)"fi-aef-formplugin", (Object[])new Object[0]);
                    }
                    model.setValue("attachtab", (Object)attach, rowIndex);
                }
                model.setValue("archiverange", (Object)"", rowIndex);
                model.setValue("archiverangejson", (Object)"", rowIndex);
                model.setValue(PRINTTEMPLATE_DISPLAY, (Object)"", rowIndex);
                model.setValue(PRINTTEMPLATE_TAG, (Object)"", rowIndex);
                model.setValue(PRINTSAMPLEID, (Object)"", rowIndex);
                model.setValue("largesamplejson_tag", (Object)"", rowIndex);
                model.setValue("datefieldtext", (Object)"", rowIndex);
                model.setValue("datefield", (Object)"", rowIndex);
                String archivetype = (String)model.getValue(ARCHIVETYPE);
                if (!FINANCE.equals(archivetype)) break;
                if ("gl_voucher".equals(newVal)) {
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"archiverange"});
                    break;
                }
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"archiverange"});
                break;
            }
            case "datefieldtext": {
                String datefieldtext = (String)model.getValue("datefieldtext", rowIndex);
                if (!StringUtils.isBlank((CharSequence)datefieldtext)) break;
                model.setValue("datefield", (Object)"", rowIndex);
                break;
            }
            case "isxbrlpilot": {
                model.deleteEntryData(ENTITY);
                int newEntryRow = model.createNewEntryRow(ENTITY);
                this.setDynamicMetadata();
                Boolean isXbrlPilot = (Boolean)this.getModel().getValue(IS_XBRL_PILOT);
                if (!Boolean.TRUE.equals(isXbrlPilot)) break;
                String archiveType = (String)this.getModel().getValue(ARCHIVETYPE);
                if (FINANCE.equals(archiveType)) {
                    model.setValue(BILLTYPE, (Object)"gl_voucher", newEntryRow);
                    break;
                }
                if (!BILL.equals(archiveType)) break;
                model.setValue(BILLTYPE, (Object)"bei_elecstatement", newEntryRow);
                break;
            }
            case "isneedattachfile": {
                if (model.getValue(BILLTYPE, rowIndex) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"ArchiveSchemeEdit_15", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                    break;
                }
                String isneedattachfile = (String)model.getValue("isneedattachfile", rowIndex);
                if ("0".equals(isneedattachfile)) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"attachtab"});
                    model.setValue("attachtab", (Object)"", rowIndex);
                    model.setValue("attachtabjson", (Object)"", rowIndex);
                    break;
                }
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"attachtab"});
                String billType = ((DynamicObject)model.getValue(BILLTYPE, rowIndex)).getString("number");
                Map<String, String> attachTab = this.getAttachTab(billType);
                String attach = String.join((CharSequence)"\uff0c", attachTab.values());
                if (attachTab.size() <= 1) {
                    attach = ResManager.loadKDString((String)"\u6240\u6709\u9644\u4ef6", (String)"ArchiveSchemeEdit_12", (String)"fi-aef-formplugin", (Object[])new Object[0]);
                    model.setValue("attachtab", (Object)attach, rowIndex);
                    model.setValue("attachtabjson", (Object)"", rowIndex);
                    break;
                }
                model.setValue("attachtab", (Object)attach, rowIndex);
                model.setValue("attachtabjson", (Object)SerializationUtils.toJsonString(attachTab), rowIndex);
                break;
            }
            case "taxarchivedata": {
                String taxarchivedata = (String)model.getValue("taxarchivedata", rowIndex);
                if (taxarchivedata.equals("tccit")) {
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"taxticcttype"});
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{BILLTYPE});
                    this.getModel().setValue(BILLTYPE, (Object)TCVAT_NSRXX, rowIndex);
                }
                if (!taxarchivedata.equals(BILL)) break;
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{BILLTYPE});
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"taxticcttype"});
                if (!"true".equals(this.getPageCache().get(IS_FIRST))) {
                    this.getModel().setValue(BILLTYPE, (Object)"", rowIndex);
                }
                this.getModel().setValue("taxticcttype", (Object)"", rowIndex);
            }
        }
    }

    private Map<String, String> getAttachTab(String billType) {
        List rootItems = FormMetadataCache.getRootControl((String)billType).getItems();
        HashMap<String, Control> lstField = new HashMap<String, Control>(16);
        for (Control item : rootItems) {
            this.buildlstField(item, lstField);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        for (Control control : lstField.values()) {
            List list;
            if (!(control instanceof Container) || (list = ((Container)control).getItems()) == null || list.size() <= 0) continue;
            for (Control item : list) {
                if (!(item instanceof AttachmentPanel)) continue;
                AttachmentPanelAp ap = (AttachmentPanelAp)FormMetaDataUtil.getControlAp((String)billType, (String)item.getKey());
                resultMap.put(item.getKey(), ap.getName().getLocaleValue());
            }
        }
        return resultMap;
    }

    private void buildlstField(Control item, Map<String, Control> lstField) {
        if (item instanceof EntryGrid) {
            lstField.put(item.getKey(), item);
        }
        if (item instanceof Container) {
            List lstCtls = ((Container)item).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    lstField.put(item.getKey(), item);
                    this.buildlstField(ctl, lstField);
                    continue;
                }
                lstField.put(item.getKey(), item);
            }
        } else {
            lstField.put(item.getKey(), item);
        }
    }

    private void setArchevedate(String billNumber, int rowIndex) {
        IDataModel model = this.getModel();
        String dateField = (String)model.getValue("datefield", rowIndex);
        if (StringUtils.isNotEmpty((CharSequence)dateField)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billNumber);
            DynamicPropertyCollection dcps = (DynamicPropertyCollection)entityType.getProperties();
            String dateFieldText = null;
            for (IDataEntityProperty dcp : dcps) {
                if (!(dcp instanceof DateTimeProp) || !dateField.equals(dcp.getName())) continue;
                dateFieldText = dcp.getDisplayName().getLocaleValue();
                break;
            }
            model.setValue("datefieldtext", dateFieldText, rowIndex);
        }
    }

    private void setDynamicMetadata() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String archivetype = (String)model.getValue(ARCHIVETYPE);
        TextEdit textEdit = (TextEdit)this.getView().getControl("datefieldtext");
        view.setVisible(Boolean.FALSE, new String[]{"attachtab"});
        view.setVisible(Boolean.FALSE, new String[]{"taxarchivedata"});
        view.setVisible(Boolean.FALSE, new String[]{"taxticcttype"});
        switch (archivetype) {
            case "finance": {
                this.buildaiComboItems(FINANCE);
                view.setVisible(Boolean.TRUE, new String[]{"archiverange"});
                view.setVisible(Boolean.FALSE, new String[]{"datefieldtext"});
                textEdit.setMustInput(Boolean.FALSE.booleanValue());
                this.setVisible(true);
                break;
            }
            case "bill": {
                this.buildaiComboItems(BILL);
                view.setVisible(Boolean.TRUE, new String[]{"archiverange"});
                view.setVisible(Boolean.TRUE, new String[]{"datefieldtext"});
                view.setVisible(Boolean.TRUE, new String[]{"attachtab"});
                view.setEnable(Boolean.FALSE, new String[]{"attachtab"});
                textEdit.setMustInput(Boolean.TRUE.booleanValue());
                this.setVisible(true);
                break;
            }
            case "reportform": {
                view.setVisible(Boolean.FALSE, new String[]{"archiverange"});
                view.setVisible(Boolean.FALSE, new String[]{"datefieldtext"});
                view.setVisible(Boolean.FALSE, new String[]{"aiarchive"});
                textEdit.setMustInput(Boolean.FALSE.booleanValue());
                this.setVisible(false);
                break;
            }
            case "tax": {
                this.setVisible(true);
                view.setVisible(Boolean.TRUE, new String[]{"taxarchivedata"});
                view.setVisible(Boolean.TRUE, new String[]{"taxticcttype"});
                this.buildaiComboItems(BILL);
                view.setVisible(Boolean.TRUE, new String[]{"archiverange"});
                view.setVisible(Boolean.TRUE, new String[]{"datefieldtext"});
                BasedataEdit billtypeEdit = (BasedataEdit)this.getView().getControl(BILLTYPE);
                TextEdit datefieldEdit = (TextEdit)this.getView().getControl("datefieldtext");
                ComboEdit taxarchivedataEdit = (ComboEdit)this.getView().getControl("taxarchivedata");
                billtypeEdit.setMustInput(Boolean.FALSE.booleanValue());
                datefieldEdit.setMustInput(Boolean.FALSE.booleanValue());
                taxarchivedataEdit.setMustInput(Boolean.TRUE.booleanValue());
                view.setVisible(Boolean.FALSE, new String[]{IS_XBRL_PILOT});
                view.setVisible(Boolean.FALSE, new String[]{"archiverangereport"});
                ((TextEdit)this.getView().getControl(PRINTTEMPLATE_DISPLAY)).setMustInput(false);
                break;
            }
        }
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_EADA");
        LicenseCheckResult result1 = new LicenseCheckResult();
        result1.setHasLicense(Boolean.valueOf(false));
        try {
            result1 = LicenseServiceHelper.checkLicenseRight((Long)UserServiceHelper.getCurrentUserId(), (String)"EVP", (String)"evp_voucher");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!result.getHasLicense().booleanValue() && !result1.getHasLicense().booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{IS_XBRL_PILOT});
        }
    }

    private void setVisible(boolean flag) {
        IFormView view = this.getView();
        if (flag) {
            view.setVisible(Boolean.TRUE, new String[]{BILLTYPE});
            ((BasedataEdit)this.getView().getControl(BILLTYPE)).setMustInput(true);
            view.setVisible(Boolean.TRUE, new String[]{"isneedattachfile"});
            view.setVisible(Boolean.TRUE, new String[]{PRINTTEMPLATE_DISPLAY});
            ((TextEdit)this.getView().getControl(PRINTTEMPLATE_DISPLAY)).setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{"archiverangereport"});
            ((TextEdit)this.getView().getControl("archiverangereport")).setMustInput(false);
            view.setVisible(Boolean.TRUE, new String[]{IS_XBRL_PILOT});
            Boolean isxbrlpilot = (Boolean)this.getModel().getValue(IS_XBRL_PILOT);
            if (Boolean.FALSE.equals(isxbrlpilot)) {
                view.setVisible(Boolean.TRUE, new String[]{"archiverange"});
                view.setVisible(Boolean.TRUE, new String[]{"aiarchive"});
            } else {
                String archivetype = (String)this.getModel().getValue(ARCHIVETYPE);
                if (!FINANCE.equals(archivetype) && BILL.equals(archivetype)) {
                    view.setVisible(Boolean.TRUE, new String[]{"archiverange"});
                    view.setVisible(Boolean.FALSE, new String[]{PRINTTEMPLATE_DISPLAY});
                    view.setVisible(Boolean.FALSE, new String[]{"aiarchive", "isneedattachfile"});
                }
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{BILLTYPE});
            ((BasedataEdit)this.getView().getControl(BILLTYPE)).setMustInput(false);
            view.setVisible(Boolean.FALSE, new String[]{"isneedattachfile"});
            view.setVisible(Boolean.FALSE, new String[]{PRINTTEMPLATE_DISPLAY});
            ((TextEdit)this.getView().getControl(PRINTTEMPLATE_DISPLAY)).setMustInput(false);
            view.setVisible(Boolean.TRUE, new String[]{"archiverangereport"});
            ((TextEdit)this.getView().getControl("archiverangereport")).setMustInput(true);
            view.setVisible(Boolean.FALSE, new String[]{IS_XBRL_PILOT});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "printtemplate_display": {
                String billtype = this.getBillTypeFiled();
                if (StringUtils.isEmpty((CharSequence)billtype)) break;
                if (TCVAT_NSRXX.equals(billtype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u9700\u8981\u914d\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveSchemeEdit_13", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                    break;
                }
                Map<String, String> printsmaplels = this.getTemplates(billtype);
                if (printsmaplels.size() > 0) {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId(SAMPLEPRINTFORMID);
                    parameter.setCustomParam("formLs", printsmaplels);
                    parameter.setCustomParam(BILLTYPE, (Object)billtype);
                    parameter.setCustomParam("templatelist", (Object)((String)this.getModel().getValue(PRINTTEMPLATE_TAG, rowIndex)));
                    parameter.setCustomParam("oldprintsmaple", (Object)((String)this.getModel().getValue(PRINTSAMPLEID, rowIndex)));
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getselectprintsmaple"));
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(parameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveSchemeEdit_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                break;
            }
            case "archiverange": {
                String billtype = this.getBillTypeFiled();
                if (StringUtils.isEmpty((CharSequence)billtype)) break;
                this.showFormArchiveRange(billtype);
                break;
            }
            case "archiverangereport": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
                this.getPageCache().put("currentrow", Integer.toString(rowIndex));
                this.showFormArchiveRangeReport();
                break;
            }
            case "datefieldtext": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
                String billtype = this.getBillTypeFiled();
                if (StringUtils.isEmpty((CharSequence)billtype)) break;
                if (TCVAT_NSRXX.equals(billtype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4e0d\u9700\u8981\u914d\u7f6e\u5f52\u6863\u65e5\u671f\u3002", (String)"ArchiveSchemeEdit_14", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getPageCache().put("currentrow", Integer.toString(rowIndex));
                this.showFormDateField(billtype);
                break;
            }
            case "attachtab": {
                String billtype = this.getBillTypeFiled();
                if (StringUtils.isEmpty((CharSequence)billtype)) break;
                Map<String, String> printsmaplels = this.getAttachTab(billtype);
                printsmaplels.put("attachString", (String)this.getModel().getValue("attachtab", this.getModel().getEntryCurrentRowIndex(ENTITY)));
                if (printsmaplels.size() > 2) {
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("aef_attach_select");
                    parameter.setCustomParam("formLs", printsmaplels);
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getattachtab"));
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm(parameter);
                    break;
                }
                String attach = ResManager.loadKDString((String)"\u6240\u6709\u9644\u4ef6", (String)"ArchiveSchemeEdit_12", (String)"fi-aef-formplugin", (Object[])new Object[0]);
                this.getModel().setValue("attachtab", (Object)attach, this.getModel().getEntryCurrentRowIndex(ENTITY));
                this.getModel().setValue("attachtabjson", (Object)"", this.getModel().getEntryCurrentRowIndex(ENTITY));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u591a\u4e2a\u9644\u4ef6\u9875\u7b7e\u3002", (String)"ArchiveSchemeEdit_16", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnValue = closedCallBackEvent.getReturnData();
        if (returnValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        int currentRow = Integer.parseInt(this.getPageCache().get("currentrow"));
        switch (closedCallBackEvent.getActionId()) {
            case "getselectprintsmaple": {
                if (returnValue == null) break;
                List templateList = (List)returnValue;
                List templatenames = templateList.stream().map(PrintTemplate::getTemplateName).collect(Collectors.toList());
                model.setValue(PRINTTEMPLATE_DISPLAY, (Object)String.join((CharSequence)",", templatenames), currentRow);
                model.setValue(PRINTSAMPLEID, (Object)"", currentRow);
                model.setValue(PRINTTEMPLATE_TAG, (Object)SerializationUtils.toJsonString((Object)templateList), currentRow);
                break;
            }
            case "archiverange": {
                Map dataMap = (Map)returnValue;
                String archiverange = (String)dataMap.get("archiverange");
                String archiverangejson = (String)dataMap.get("archiverangejson");
                String archivetype = (String)model.getValue(ARCHIVETYPE);
                if (FINANCE.equals(archivetype)) {
                    String billtype = ((DynamicObject)model.getValue(BILLTYPE, currentRow)).getString("number");
                    if ("gl_voucher".equals(billtype)) {
                        String largesamplejson_tag = (String)dataMap.get("largesamplejson_tag");
                        model.setValue("largesamplejson_tag", (Object)largesamplejson_tag, currentRow);
                        if (StringUtils.isNotEmpty((CharSequence)largesamplejson_tag)) {
                            List list = SerializationUtils.fromJsonStringToList((String)largesamplejson_tag, Printsample.class);
                            if (null == list || list.isEmpty()) {
                                model.setValue("archiverange", (Object)"", currentRow);
                                return;
                            }
                            StringBuilder builder = new StringBuilder();
                            for (Printsample printsample : list) {
                                String billType = printsample.getBillType();
                                String billName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                                builder.append(billName);
                                builder.append("\uff0c");
                            }
                            archiverange = builder.toString();
                            if ((archiverange = archiverange.substring(0, archiverange.length() - 1)).length() > 500) {
                                archiverange = archiverange.substring(0, 500) + "...";
                            }
                            model.setValue("archiverange", (Object)archiverange, currentRow);
                        } else {
                            model.setValue("archiverange", (Object)"", currentRow);
                        }
                    }
                } else if (BILL.equals(archivetype) || TAX.equals(archivetype)) {
                    model.setValue("archiverange", (Object)archiverange, currentRow);
                }
                model.setValue("archiverangejson", (Object)archiverangejson, currentRow);
                break;
            }
            case "archiverangereport": {
                Map dataMap = (Map)returnValue;
                model.setValue("largesamplejson_tag", dataMap.get("largesamplejson_tag"), currentRow);
                model.setValue("archiverangereport", dataMap.get("archiverangereport"), currentRow);
                break;
            }
            case "dateFieldSelector": {
                Map val = (Map)returnValue;
                model.setValue("datefieldtext", val.get("text"), currentRow);
                model.setValue("datefield", val.get("id"), currentRow);
                break;
            }
            case "getattachtab": {
                if (returnValue == null) break;
                Map map = (Map)SerializationUtils.fromJsonString((String)((String)returnValue), Map.class);
                model.setValue("attachtab", (Object)String.join((CharSequence)"\uff0c", map.values()), currentRow);
                model.setValue("attachtabjson", returnValue, currentRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        if (BILLTYPE.equals(baseData.getKey())) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            String archiveType = (String)this.getModel().getValue(ARCHIVETYPE);
            Boolean isXbrlPilot = (Boolean)this.getModel().getValue(IS_XBRL_PILOT);
            if (StringUtils.isEmpty((CharSequence)archiveType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u7c7b\u578b\u3002", (String)"ArchiveSchemeEdit_3", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (FINANCE.equals(archiveType)) {
                if (Boolean.FALSE.equals(isXbrlPilot)) {
                    List<String> formIds = this.getFormList();
                    filters.add(new QFilter("number", "in", formIds));
                } else {
                    filters.add(new QFilter("number", "=", (Object)"gl_voucher"));
                }
            } else if (BILL.equals(archiveType)) {
                if (Boolean.FALSE.equals(isXbrlPilot)) {
                    filters.add(new QFilter("number", "not in", Arrays.asList("fa_card_fin", "gl_rpt_generalledger", "gl_rpt_subledger", "gl_voucher", "cas_bankjournal", "cas_cashjournal", TCVAT_NSRXX)));
                } else {
                    filters.add(new QFilter("number", "=", (Object)"bei_elecstatement"));
                }
                filters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
                filters.add(new QFilter("bizappid", "!=", (Object)"/T89/HOQNVSV"));
                filters.add(new QFilter("bizappid.bizcloud", "!=", (Object)"/RFOWJE1X=MZ"));
            } else if (TAX.equals(archiveType)) {
                filters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
                filters.add(new QFilter("bizappid.bizcloud", "=", (Object)"/RFOWJE1X=MZ"));
                filters.add(new QFilter("number", "!=", (Object)TCVAT_NSRXX));
            }
            f7List.getListFilterParameter().setQFilters(filters);
        }
        if (GROUP.equals(baseData.getKey())) {
            f7List.getListFilterParameter().setFilter(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        }
    }

    private List<String> getFormList() {
        return Arrays.asList("fa_card_fin", "gl_rpt_generalledger", "gl_rpt_subledger", "gl_voucher", "cas_bankjournalformrpt", "cas_cashjournalformrpt");
    }

    private Map<String, String> getTemplates(String formId) {
        HashMap<String, String> templateMap = new HashMap<String, String>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billformid", "=", (Object)formId));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"printtplid, type", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Object> oldPrintMeatIdList = new ArrayList<Object>(dyns.length);
        for (DynamicObject dyn : dyns) {
            String type = dyn.getString("type");
            DynamicObject printTplMetaDynObj = dyn.getDynamicObject("printtplid");
            Object printTplId = dyn.get("printtplid_id");
            if (printTplMetaDynObj == null) {
                oldPrintMeatIdList.add(printTplId);
                continue;
            }
            String name = printTplMetaDynObj.getString("name");
            if (!"B".equals(type)) {
                if (StringUtils.isBlank((CharSequence)name)) {
                    oldPrintMeatIdList.add(printTplId);
                    continue;
                }
                templateMap.put(printTplMetaDynObj.getString("number"), name);
                continue;
            }
            templateMap.put(printTplMetaDynObj.getString("number"), name);
        }
        if (oldPrintMeatIdList.isEmpty()) {
            return templateMap;
        }
        DynamicObjectCollection formmetaMap = QueryServiceHelper.query((String)"bos_formmeta", (String)"id, number, name", (QFilter[])new QFilter("id", "in", oldPrintMeatIdList).toArray());
        if (formmetaMap.size() > 0) {
            for (DynamicObject dynamicObject : formmetaMap) {
                Object number = dynamicObject.get("number");
                Object name = dynamicObject.get("name");
                templateMap.put(number.toString(), name.toString());
            }
        }
        return templateMap;
    }

    private void refreshPrintSamleName() {
        int i;
        int count = this.getModel().getEntryRowCount(ENTITY);
        if (count == 0) {
            return;
        }
        ArrayList<String> printsamplels = new ArrayList<String>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            String printFormId = this.getModel().getValue(PRINTSAMPLEID, i2).toString();
            String printtemplate_tag = this.getModel().getValue(PRINTTEMPLATE_TAG, i2).toString();
            if (!StringUtils.isEmpty((CharSequence)printFormId)) {
                printsamplels.add(printFormId);
            }
            if (StringUtils.isEmpty((CharSequence)printtemplate_tag)) continue;
            List templateList = SerializationUtils.fromJsonStringToList((String)printtemplate_tag, PrintTemplate.class);
            List templatenumbers = templateList.stream().map(PrintTemplate::getTemplateNumber).collect(Collectors.toList());
            printsamplels.addAll(templatenumbers);
        }
        QFilter filter = new QFilter("modeltype", "=", (Object)"PrintModel");
        QFilter filter1 = new QFilter("number", "in", printsamplels);
        QFilter[] filters = new QFilter[]{filter, filter1};
        DynamicObjectCollection formmetaMap = QueryServiceHelper.query((String)"bos_formmeta", (String)"number, name", (QFilter[])filters);
        HashMap<String, Object> numNameMap = new HashMap<String, Object>(count);
        for (i = 0; i < formmetaMap.size(); ++i) {
            numNameMap.put(((DynamicObject)formmetaMap.get(i)).get("number").toString(), ((DynamicObject)formmetaMap.get(i)).get("name"));
        }
        for (i = 0; i < count; ++i) {
            String printSample = this.getModel().getValue(PRINTSAMPLEID, i).toString();
            String printtemplate_tag = this.getModel().getValue(PRINTTEMPLATE_TAG, i).toString();
            if (StringUtils.isNotEmpty((CharSequence)printSample)) {
                if (numNameMap.get(printSample) != null) {
                    this.getModel().setValue(PRINTTEMPLATE_DISPLAY, (Object)numNameMap.get(printSample).toString(), i);
                    continue;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_print_meta", (String)"number, name", (QFilter[])new QFilter("number", "=", (Object)printSample).toArray());
                if (null == dynamicObject || !StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("name"))) continue;
                this.getModel().setValue(PRINTTEMPLATE_DISPLAY, (Object)dynamicObject.getString("name"), i);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)printtemplate_tag)) continue;
            List templateList = SerializationUtils.fromJsonStringToList((String)printtemplate_tag, PrintTemplate.class);
            List templatenumbers = templateList.stream().map(PrintTemplate::getTemplateNumber).collect(Collectors.toList());
            ArrayList<String> displays = new ArrayList<String>(2);
            for (String templatenumber : templatenumbers) {
                if (numNameMap.get(templatenumber) != null) {
                    displays.add(numNameMap.get(templatenumber).toString());
                    continue;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_print_meta", (String)"number, name", (QFilter[])new QFilter("number", "=", (Object)templatenumber).toArray());
                if (null == dynamicObject || !StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("name"))) continue;
                displays.add(dynamicObject.getString("name"));
            }
            if (displays.size() <= 0) continue;
            this.getModel().setValue(PRINTTEMPLATE_DISPLAY, (Object)String.join((CharSequence)"\uff0c", displays), i);
        }
    }

    private String getBillTypeFiled() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
        this.getPageCache().put("currentrow", Integer.toString(rowIndex));
        DynamicObject curRowObj = this.getModel().getEntryRowEntity(ENTITY, rowIndex);
        if ("tccit".equals(curRowObj.getString("taxarchivedata")) && TAX.equals((String)this.getModel().getValue(ARCHIVETYPE))) {
            return TCVAT_NSRXX;
        }
        String billtype = curRowObj.getString("billtype.number");
        if (StringUtils.isEmpty((CharSequence)billtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u884c\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ArchiveSchemeEdit_4", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        return billtype;
    }

    private void showFormArchiveRange(String billtype) {
        IDataModel model = this.getModel();
        String archivetype = (String)model.getValue(ARCHIVETYPE);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aef_archiverange");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCustomParam(ARCHIVETYPE, (Object)archivetype);
        showParameter.setCustomParam(BILLTYPE, (Object)billtype);
        showParameter.setCustomParam("archiveperiod", model.getValue("archiveperiod", rowIndex));
        if (this.isOldRow(ENTITY, rowIndex)) {
            Set<String> billTypeSet = this.getTypeByAcelre();
            showParameter.setCustomParam("enable_archiverange", (Object)billTypeSet.contains(billtype));
        }
        String archiverange = (String)model.getValue("archiverange", rowIndex);
        if (BILL.equals(archivetype) || TAX.equals(archivetype)) {
            if (StringUtils.isBlank((CharSequence)archiverange)) {
                model.setValue("archiverangejson", (Object)"", rowIndex);
            }
            showParameter.setCustomParam("archiverangejson", model.getValue("archiverangejson", rowIndex));
        }
        if ("gl_voucher".equals(billtype)) {
            if (StringUtils.isBlank((CharSequence)archiverange)) {
                model.setValue("largesamplejson_tag", (Object)"", rowIndex);
            }
            showParameter.setCustomParam("largesamplejson_tag", model.getValue("largesamplejson_tag", rowIndex));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "archiverange");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showFormArchiveRangeReport() {
        IDataModel model = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aef_archiverange_report");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        String archiverangereport = (String)model.getValue("archiverangereport", rowIndex);
        if (StringUtils.isBlank((CharSequence)archiverangereport)) {
            model.setValue("largesamplejson_tag", (Object)"", rowIndex);
        }
        if (this.isOldRow(ENTITY, rowIndex) && this.isExistRptAcelre()) {
            showParameter.setCustomParam("enable_archiverange_rpt", (Object)Boolean.TRUE);
        }
        showParameter.setCustomParam("largesamplejson_tag", model.getValue("largesamplejson_tag", rowIndex));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "archiverangereport");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showFormDateField(String billtype) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("aef_archivescheme_date");
        param.setCustomParam(BILLTYPE, (Object)billtype);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dateFieldSelector"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)"/T89/HOQNVSV", (String)"aef_archivescheme", (Long)Long.valueOf(RequestContext.get().getUserId()));
        if (!result.getHasLicense().booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u4f1a\u8ba1\u7535\u5b50\u6863\u6848\u96c6\u6210\u4e13\u4e1a\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ArchiveSchemeEdit_11", (String)"fi-aef-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        } else {
            super.preOpenForm(e);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "save": {
                String archivetype = (String)this.getModel().getValue(ARCHIVETYPE);
                if (!TAX.equals(archivetype)) break;
                DynamicObjectCollection entryDys = this.getModel().getEntryEntity(ENTITY);
                int rowIndex = 0;
                for (DynamicObject dyn : entryDys) {
                    HashMap<String, Object> rangeMap = new HashMap<String, Object>(2);
                    rangeMap.put("taxarchivedata", dyn.getString("taxarchivedata"));
                    rangeMap.put("taxticcttype", dyn.get("taxticcttype_id"));
                    this.getModel().setValue("archiverangereport", (Object)SerializationUtils.toJsonString(rangeMap), rowIndex);
                    ++rowIndex;
                }
                break;
            }
        }
    }
}

