/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.text.SimpleDateFormat;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.aef.common.util.ContextUtil;

public class CardArchiveLogPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(CardArchiveLogPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.getValues();
    }

    private String getNameByBilltype(String billType) {
        MainEntityType type = null;
        try {
            type = EntityMetadataCache.getDataEntityType((String)billType);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (null == type) {
            return billType;
        }
        return type.getDisplayName().getLocaleValue();
    }

    public void initialize() {
        this.addClickListeners(new String[]{"labelap"});
    }

    public void click(EventObject evt) {
        long orgId = 18L;
        IFormView pview = this.getView().getParentView();
        if (pview != null) {
            orgId = (Long)this.getView().getParentView().getModel().getValue("orgid_id");
        }
        if (orgId <= 0L) {
            return;
        }
        switch (((Control)evt.getSource()).getKey()) {
            case "labelap": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("aef_acelre");
                listShowParameter.setFormId("bos_list");
                listShowParameter.setAppId("aef");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setCustomParam("org", (Object)orgId);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private void getValues() {
        long orgId = 18L;
        IFormView pview = this.getView().getParentView();
        if (pview != null) {
            orgId = (Long)this.getView().getParentView().getModel().getValue("orgid_id");
        }
        if (orgId <= 0L) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        String selectFields = "fexetime, billtype";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.formplugin.CardArchiveNumPlugin.getValues", (String)"aef_acelre", (String)selectFields, (QFilter[])new QFilter[]{orgFilter}, null).groupBy(new String[]{"fexetime", "billtype"}).count().finish().orderBy(new String[]{"fexetime desc"}).top(7);){
            Long userID = ContextUtil.getUserId();
            String dateFormat = InteServiceHelper.getDateFormat((Long)userID);
            String timeFormat = (String)InteServiceHelper.getTimeFormat((Long)userID).get("timeFormat");
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat + " " + timeFormat);
            int index = 0;
            for (Row row : ds) {
                StringBuilder sb = new StringBuilder();
                String time = sdf.format(row.getDate("fexetime"));
                sb.append(time);
                sb.append(' ');
                String name = this.getNameByBilltype(row.getString("billtype"));
                sb.append(name);
                sb.append(ResManager.loadKDString((String)"\u6210\u529f\u5f52\u6863\u3002", (String)"CardArchiveLogPlugin_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                Integer count = row.getInteger("count");
                sb.append(count);
                sb.append(ResManager.loadKDString((String)"\u4efd", (String)"CardArchiveLogPlugin_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                Label lab = (Label)this.getControl("loglab" + index);
                lab.setText(sb.toString());
                ++index;
            }
        }
    }
}

