/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.lang.constant.Constable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CardArchiveNumPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public void afterCreateNewData(EventObject e) {
        long orgId = 18L;
        IFormView pview = this.getView().getParentView();
        if (pview != null) {
            orgId = (Long)this.getView().getParentView().getModel().getValue("orgid_id");
        }
        this.paintChart(this.getValues("tabpageap", orgId));
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        super.registerListener(e);
    }

    private void paintChart(Map<String, Integer> values) {
        HistogramChart chart = (HistogramChart)this.getControl("aefchart");
        chart.setDraggable(true);
        chart.setShowTooltip(true);
        BarSeries barSeries = chart.createBarSeries("bar");
        barSeries.setBarWidth("40");
        Axis xAxis = chart.createXAxis(null, AxisType.category);
        chart.createYAxis(ResManager.loadKDString((String)"\u5355\u4f4d\uff1a\u4efd", (String)"CardArchiveNumPlugin_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisTick", axisTick);
        HashMap<String, String> axisLabel = new HashMap<String, String>();
        axisLabel.put("interval", "auto");
        xAxis.setPropValue("axisLabel", axisLabel);
        if (Objects.isNull(values) || values.isEmpty()) {
            xAxis.setCategorys(Collections.emptyList());
            barSeries.setData(new Number[0]);
        } else {
            values.forEach((k, v) -> {
                LocaleString displayName = EntityMetadataCache.getDataEntityType((String)k).getDisplayName();
                xAxis.addCategory(displayName.getLocaleValue());
                barSeries.addData((Number)v);
            });
        }
        chart.refresh();
    }

    public void tabSelected(TabSelectEvent e) {
        long orgId = 18L;
        IFormView pview = this.getView().getParentView();
        if (pview != null) {
            orgId = (Long)this.getView().getParentView().getModel().getValue("orgid_id");
        }
        switch (e.getTabKey()) {
            case "tabpageap": {
                Map<String, Integer> values = this.getValues("tabpageap", orgId);
                this.paintChart(values);
                break;
            }
            case "tabpageap1": {
                Map<String, Integer> values = this.getValues("tabpageap1", orgId);
                this.paintChart(values);
                break;
            }
            case "tabpageap2": {
                Map<String, Integer> values = this.getValues("tabpageap2", orgId);
                this.paintChart(values);
            }
        }
    }

    private Map<String, Integer> getValues(String key, Long orgId) {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        Calendar calendar = Calendar.getInstance();
        Date lastDate = calendar.getTime();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date firstDate = null;
        switch (key) {
            case "tabpageap": {
                firstDate = calendar.getTime();
                break;
            }
            case "tabpageap1": {
                calendar.add(5, -30);
                firstDate = calendar.getTime();
                break;
            }
            case "tabpageap2": {
                calendar.add(5, -90);
                firstDate = calendar.getTime();
            }
        }
        QFilter dateFilter = QFilter.of((String)"fexetime >= ? and fexetime < ?", (Object[])new Object[]{firstDate, lastDate});
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.formplugin.CardArchiveNumPlugin.getValues", (String)"aef_acelre", (String)"billtype", (QFilter[])new QFilter[]{dateFilter, orgFilter}, null).groupBy(new String[]{"billtype"}).count().finish();){
            for (Row row : ds) {
                String type = row.getString("billtype");
                Integer count = row.getInteger("count");
                values.put(type, count);
            }
        }
        return values;
    }
}

