/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CardArchivePlugin
extends AbstractFormPlugin
implements ClickListener {
    public void beforeBindData(EventObject e) {
        long orgId = 18L;
        IFormView pview = this.getView().getParentView();
        if (pview != null) {
            orgId = (Long)this.getView().getParentView().getModel().getValue("orgid_id");
        }
        if (orgId <= 0L) {
            return;
        }
        Integer schemeNum = this.getSchemeCount();
        Tuple2<Integer, Integer> monthAndHistoryRecordCounts = this.getMonthAndHistoryRecordCounts(orgId);
        ((Label)this.getControl("schemenum")).setText(schemeNum.toString());
        ((Label)this.getControl("totalnum")).setText(schemeNum.toString());
        ((Label)this.getControl("labeltotal")).setText(((Integer)monthAndHistoryRecordCounts.t2).toString());
        if (schemeNum.compareTo(0) > 0) {
            this.setNum(new BigDecimal((Integer)monthAndHistoryRecordCounts.t1), new BigDecimal(schemeNum));
        }
        super.beforeBindData(e);
    }

    public void initialize() {
        this.addClickListeners(new String[]{"newarch", "newarch1", "managescheme"});
        super.initialize();
    }

    public void click(EventObject evt) {
        IFormView view = this.getView();
        String key = ((Control)evt.getSource()).getKey();
        long orgId = 18L;
        IFormView pview = this.getView().getParentView();
        if (pview != null) {
            orgId = (Long)this.getView().getParentView().getModel().getValue("orgid_id");
        }
        if (orgId <= 0L) {
            return;
        }
        switch (key) {
            case "newarch": 
            case "newarch1": {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("aef_archivescheme");
                showParameter.setCustomParam("org", (Object)orgId);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                view.showForm((FormShowParameter)showParameter);
                break;
            }
            case "managescheme": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("aef_archivescheme");
                listShowParameter.setAppId("aef");
                listShowParameter.setCustomParam("org", (Object)orgId);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private void setNum(BigDecimal sucNum, BigDecimal totalNum) {
        ((Label)this.getControl("successnum")).setText(sucNum.toString());
        BigDecimal sucLength = sucNum.multiply(new BigDecimal("200")).divide(totalNum, 0, RoundingMode.HALF_DOWN);
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
        map.put("w", new LocaleString(sucLength.toString() + "px"));
        this.getView().updateControlMetadata("suclab", map);
    }

    private Integer getSchemeCount() {
        return QueryServiceHelper.queryPrimaryKeys((String)"aef_archivescheme", null, null, (int)-1).size();
    }

    private Tuple2<Integer, Integer> getMonthAndHistoryRecordCounts(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        try (DataSet allRecords = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"aef_acelre", (String)"wayid,fexetime", (QFilter[])new QFilter[]{orgFilter}, null);){
            Integer wayCount = 0;
            try (DataSet curMonthRecords = allRecords.copy().filter("fexetime >= begin and fexetime < end", this.getTimeRange()).groupBy(new String[]{"wayid"}).count().finish();){
                for (Row row : curMonthRecords) {
                    if (row.getInteger("count") <= 0) continue;
                    Integer n = wayCount;
                    Integer n2 = wayCount = Integer.valueOf(wayCount + 1);
                }
            }
            DataSet finish = allRecords.groupBy(null).count().finish();
            Integer totalCount = 0;
            for (Row row : finish) {
                totalCount = totalCount + row.getInteger("count");
            }
            Iterator iterator = new Tuple2((Object)wayCount, (Object)totalCount);
            return iterator;
        }
    }

    private Map<String, Object> getTimeRange() {
        Calendar cale = Calendar.getInstance();
        cale.set(10, 0);
        cale.set(12, 0);
        cale.set(13, 0);
        cale.add(2, 0);
        cale.set(5, 1);
        Date firstDay = cale.getTime();
        cale.add(2, 1);
        cale.set(5, 1);
        Date lastDay = cale.getTime();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("begin", firstDay);
        result.put("end", lastDay);
        return result;
    }
}

