/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.aef.common.util.SysParamConfig;

public class ClearArchiveLogTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ClearArchiveLogTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        log.info("\u5f52\u6863\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1[ClearArchiveLogTask]\u5f00\u59cb\u6267\u884c");
        int days = 15;
        String daysStr = SysParamConfig.get((String)"archiveErrLogClearDays");
        if (StringUtils.isNotBlank((CharSequence)daysStr)) {
            try {
                days = Integer.parseInt(daysStr);
            }
            catch (NumberFormatException e) {
                log.error((Throwable)e);
            }
        }
        List<Long> ids = ClearArchiveLogTask.getDeleteIds(days);
        int delCount = 0;
        if (!ids.isEmpty()) {
            int length = 1000;
            int size = ids.size();
            int count = (size + length - 1) / length;
            for (int i = 0; i < count; ++i) {
                int start = length * i;
                int end = Math.min(length * (i + 1), size);
                List<Long> batchIds = ids.subList(start, end);
                int records = ClearArchiveLogTask.delRecords(batchIds);
                delCount += records;
            }
        }
        log.info("\u5f52\u6863\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1[ClearArchiveLogTask]\u6267\u884c\u5b8c\u6210\uff0c\u6e05\u7406\u5f52\u6863\u9519\u8bef\u65e5\u5fd7{}\u6761", (Object)delCount);
    }

    private static List<Long> getDeleteIds(int days) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter qFilter = new QFilter("creattime", "<", (Object)ClearArchiveLogTask.getBeforeDays(days));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.formplugin.ClearArchiveLogTask", (String)"aef_errorlog", (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                ids.add(id);
            }
        }
        return ids;
    }

    private static int delRecords(List<Long> batchIds) {
        return DeleteServiceHelper.delete((String)"aef_errorlog", (QFilter[])new QFilter("id", "in", batchIds).toArray());
    }

    public static Date getBeforeDays(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days);
        return calendar.getTime();
    }
}

