/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;

public class FieldChooseEdit
extends AbstractBillPlugIn {
    public static final String BILLTYPE = "billtype";
    public static final String FIELDNAME = "fieldname";
    public static final String FIELDNUMBER = "fieldnumber";
    public static final String XMLFILED = "xmlfiled";
    public static final String ISSYSPRESET = "issyspreset";
    public static final String ENTRYENTITY = "entryentity";
    public static final String FIELDTYPE = "fieldtype";
    public static final String DISPLAYPROP = "displayprop";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter form = this.getView().getFormShowParameter();
        Map customParams = form.getCustomParams();
        if (customParams == null) {
            this.getView().close();
            return;
        }
        String billNumber = (String)customParams.get("billnumber");
        this.initEntryEntity(billNumber);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnDataToParent();
        }
    }

    private void initEntryEntity(String billNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        DynamicPropertyCollection dcps = (DynamicPropertyCollection)dataEntityType.getProperties();
        DynamicObjectType entryType = this.getModel().getEntryEntity(ENTRYENTITY).getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
        entryColl.clear();
        for (IDataEntityProperty property : dcps) {
            if (property instanceof LongProp || property instanceof EntryProp || StringUtils.isBlank((CharSequence)property.getAlias())) continue;
            DynamicObject entryObj = new DynamicObject(entryType);
            String number = property.getName();
            String localeValue = "";
            if (!StringUtils.isNotBlank((Object)property.getDisplayName()) || StringUtils.isBlank((CharSequence)(localeValue = property.getDisplayName().getLocaleValue_zh_CN())) || StringUtils.isBlank((CharSequence)number)) continue;
            entryObj.set("number", (Object)number);
            entryObj.set("name", (Object)localeValue);
            if (property instanceof BasedataProp) {
                String displayProp = ((BasedataProp)property).getDisplayProp();
                entryObj.set("showtype", (Object)FieldChooseEdit.getDisplayProp(displayProp));
                entryObj.set("type", (Object)3);
            } else if (property instanceof AmountProp) {
                entryObj.set("type", (Object)2);
            } else if (property instanceof BooleanProp) {
                entryObj.set("type", (Object)4);
            } else if (property instanceof DateTimeProp) {
                entryObj.set("type", (Object)5);
            } else {
                entryObj.set("type", (Object)1);
            }
            entryColl.add((Object)entryObj);
        }
        this.getModel().updateEntryCache(entryColl);
        this.getView().updateView(ENTRYENTITY);
    }

    public void returnDataToParent() {
        ArrayList para = new ArrayList();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        int index = (Integer)customParams.get("index");
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FieldChooseEdit_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject dynamicRow = (DynamicObject)entity.get(selectRow);
                HashMap<String, String> rowInfo = new HashMap<String, String>(10);
                rowInfo.put("index", String.valueOf(index++));
                rowInfo.put(FIELDNAME, dynamicRow.getString("name"));
                rowInfo.put(FIELDNUMBER, dynamicRow.getString("number"));
                rowInfo.put(FIELDTYPE, dynamicRow.getString("type"));
                rowInfo.put(DISPLAYPROP, dynamicRow.getString("showtype"));
                para.add(rowInfo);
            }
        }
        view.returnDataToParent(para);
        view.close();
    }

    public static String getDisplayProp(String prop) {
        String res;
        switch (prop) {
            case "number": {
                res = "1";
                break;
            }
            case "name": {
                res = "2";
                break;
            }
            default: {
                res = "3";
            }
        }
        return res;
    }
}

