/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.entity.ArchiveRangeInfo;
import kd.fi.aef.entity.Task;

public class MergeRptArchiveFormPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MergeRptArchiveFormPlugin.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"fi/aef/MergeRptArchiveFormPlugin", (int)2);
    private final DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.archive);
    private static final String MODEL = "model";
    private static final String ORG = "org";
    private static final String ORG_JSON = "orgjson";
    private static final String REPORT_FORM = "reportform";
    private static final String AMOUNT_UNIT = "amountunit";
    private static final String CURRENCY = "currency";
    private static final String FI_AEF_FORMPLUGIN = "fi-aef-formplugin";
    private static final String MSG = "msg";
    private static final String ENTITY = "Entity";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setPermissionItemId("/=N=NAA4+3V2");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit org = (TextEdit)this.getView().getControl(ORG);
        org.addButtonClickListener((ClickListener)this);
        BasedataEdit reportForm = (BasedataEdit)this.getControl(REPORT_FORM);
        reportForm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl(CURRENCY);
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bcmSceneBase = (BasedataEdit)this.getView().getControl("bcmscene");
        bcmSceneBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bcmFyBase = (BasedataEdit)this.getView().getControl("bcmfy");
        bcmFyBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bcmPeriodBase = (BasedataEdit)this.getView().getControl("bcmperiod");
        bcmPeriodBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"doarchive"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"processlable", "leftbrackets", "hasarchievecount", "percent", "allcount", "rightbrackets"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (key) {
            case "model": {
                if (!Objects.nonNull(newValue)) break;
                model.setValue(ORG, (Object)"");
                model.setValue(REPORT_FORM, (Object)"");
                model.setValue(CURRENCY, (Object)"");
                model.setValue("bcmscene", (Object)"");
                model.setValue("bcmfy", (Object)"");
                model.setValue("bcmperiod", (Object)"");
                break;
            }
            case "bcmscene": {
                if (!Objects.nonNull(newValue)) break;
                model.setValue("bcmperiod", (Object)"");
                break;
            }
            case "org": {
                if (!Objects.nonNull(newValue) || !StringUtils.isEmpty((String)newValue.toString())) break;
                model.setValue(ORG_JSON, (Object)"");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ORG.equals(key)) {
            this.showSelectOrgView();
        } else if ("doarchive".equals(key)) {
            if (!this.checkPermission()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4f1a\u8ba1\u6863\u6848\u5f52\u6863\u7684\u5f52\u6863\u64cd\u4f5c\u6743\u9650\u3002", (String)"ArchiveEdit_0", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u5f52\u6863\u540e\uff0c\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\u5c06\u4e0a\u4f20\u5230\u6863\u6848\u7cfb\u7edf\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ArchiveEdit_40", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("contentChange"));
        }
    }

    private boolean checkPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"aef").getId();
        return PermissionServiceHelper.hasSpecificPerm((long)ContextUtil.getUserId(), (String)appId, (String)"aef_archive", (String)"/=N=NAA4+3V2");
    }

    private void showSelectOrgView() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = (DynamicObject)model.getValue(MODEL);
        if (Objects.isNull(dynamicObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ArchiveRangeReportFormPlugin_11", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_tem");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"ArchiveRangeReportFormPlugin_12", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCustomParam("sign", (Object)ENTITY);
        formShowParameter.setCustomParam("isUpDownBtn", (Object)true);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(dynamicObject.getLong("id")));
        String org = (String)model.getValue(ORG);
        String orgJson = (String)model.getValue(ORG_JSON);
        formShowParameter.setCustomParam("sign", (Object)ENTITY);
        if (StringUtils.isNotEmpty((String)org) && StringUtils.isNotEmpty((String)orgJson)) {
            formShowParameter.setCustomParam(ENTITY, (Object)orgJson);
        } else {
            formShowParameter.setCustomParam(ENTITY, (Object)"[]");
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectMember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        String callBackId = evt.getCallBackId();
        if ("contentChange".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption option = this.getOperateOption();
            if (option.containsVariable(MSG)) {
                this.getView().showTipNotification(option.getVariableValue(MSG));
                return;
            }
            option.setVariableValue("archiveplan", "0");
            String pageId = Task.createTaskId();
            this.setPageId(pageId);
            this.setPage(false);
            this.cache.put("pageId", pageId);
            this.cache.put(pageId + "finishedBill", "0");
            this.cache.put(pageId + "isFinish", "false");
            this.cache.put(pageId + "hasarchievecount", "0");
            this.cache.put(pageId + "allcount", "0");
            this.cache.remove(pageId + "exporturl");
            Task archive = new Task(pageId, () -> {
                option.setVariableValue("pageId", this.getPageId());
                option.setVariableValue("mergeRptArchivePage", "1");
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"aef_archive");
                OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"fi_archive", (String)"aef_archive", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)option);
                this.cache.put(pageId + "isFinish", "true");
                this.cache.put(pageId + "isSuccess", String.valueOf(executeOperate.isSuccess()));
            });
            threadPool.execute((Runnable)archive);
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.start();
        }
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        ArchiveRangeInfo info = new ArchiveRangeInfo();
        option.setVariableValue("archivetype", REPORT_FORM);
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(MODEL);
        if (Objects.isNull(modelDyn)) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ArchiveRangeReportFormPlugin_11", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        Long modelId = modelDyn.getLong("id");
        info.setModelId(modelId);
        Object orgJson = this.getModel().getValue(ORG_JSON);
        if (Objects.isNull(orgJson) || StringUtils.isEmpty((String)orgJson.toString())) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u6863\u7ec4\u7ec7\u3002", (String)"ArchiveEdit_1", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        info.setOrgJson(orgJson.toString());
        DynamicObjectCollection reportFormDynCollection = (DynamicObjectCollection)this.getModel().getValue(REPORT_FORM);
        if (Objects.isNull(reportFormDynCollection) || reportFormDynCollection.size() == 0) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u3002", (String)"ArchiveEdit_3", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        ArrayList<Long> reportEntityIds = new ArrayList<Long>();
        for (DynamicObject reportForm : reportFormDynCollection) {
            DynamicObject dynObj = (DynamicObject)reportForm.get("fbasedataid");
            reportEntityIds.add(dynObj.getLong("id"));
        }
        info.setReportEntityIds(reportEntityIds);
        String amountUnit = (String)this.getModel().getValue(AMOUNT_UNIT);
        if (StringUtils.isEmpty((String)amountUnit)) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91d1\u989d\u5355\u4f4d\u3002", (String)"ArchiveEdit_36", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        info.setAmountUnit(Integer.parseInt(amountUnit));
        DynamicObject currencyDyn = (DynamicObject)this.getModel().getValue(CURRENCY);
        if (Objects.isNull(currencyDyn)) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u522b\u3002", (String)"ArchiveEdit_37", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        info.setCurrencyId(Long.valueOf(currencyDyn.getLong("id")));
        option.setVariableValue("mergeRptArchiveRangeJsonInfo", SerializationUtils.toJsonString((Object)info));
        Long bcmSceneId = (Long)this.getModel().getValue("bcmscene_id");
        if (Objects.isNull(bcmSceneId) || bcmSceneId == 0L) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f\u3002", (String)"ArchiveEdit_26", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        option.setVariableValue("bcmsceneType", ((DynamicObject)this.getModel().getValue("bcmscene")).getString("number"));
        option.setVariableValue("bcmscene", bcmSceneId.toString());
        Long bcmFyId = (Long)this.getModel().getValue("bcmfy_id");
        if (Objects.isNull(bcmFyId) || bcmFyId == 0L) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d22\u5e74\u3002", (String)"ArchiveEdit_27", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        option.setVariableValue("bcmfyName", ((DynamicObject)this.getModel().getValue("bcmfy")).getString("name"));
        option.setVariableValue("bcmfy", bcmFyId.toString());
        DynamicObjectCollection bcmPeriod = (DynamicObjectCollection)this.getModel().getValue("bcmperiod");
        if (Objects.isNull(bcmPeriod) || bcmPeriod.isEmpty()) {
            option.setVariableValue(MSG, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ArchiveEdit_28", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            return option;
        }
        HashMap<Long, String> bcmPeriodMap = new HashMap<Long, String>(bcmPeriod.size());
        for (DynamicObject obj : bcmPeriod) {
            DynamicObject data = (DynamicObject)obj.get("fbasedataid");
            bcmPeriodMap.put(data.getLong("id"), data.getString("name"));
        }
        option.setVariableValue("bcmperiod", SerializationUtils.serializeToBase64(bcmPeriodMap));
        return option;
    }

    private void setPage(boolean finish) {
        this.getView().setEnable(Boolean.valueOf(finish), new String[]{"doarchive"});
        this.getView().setVisible(Boolean.valueOf(!finish), new String[]{"processlable", "leftbrackets", "hasarchievecount", "percent", "allcount", "rightbrackets"});
    }

    private void setPageId(String pageId) {
        this.getPageCache().put("pageId", pageId);
    }

    private String getPageId() {
        return this.getPageCache().get("pageId");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("selectMember".equals(actionId) && Objects.nonNull(e.getReturnData())) {
            IDataModel model = this.getModel();
            DynamicObjectCollection returnData = (DynamicObjectCollection)e.getReturnData();
            if (Objects.nonNull(returnData) && !returnData.isEmpty()) {
                ArrayList mapList = new ArrayList(returnData.size());
                StringBuilder builder = new StringBuilder();
                for (DynamicObject object : returnData) {
                    String name = object.getString("mname1");
                    builder.append(name);
                    builder.append("\uff1b");
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    map.put("id", object.getString("mid1"));
                    map.put("scope", object.getString("filltypevalue1"));
                    map.put("number", object.getString("mnum1"));
                    map.put("name", name);
                    mapList.add(map);
                }
                String names = builder.toString();
                model.setValue(ORG, (Object)names.substring(0, names.length() - 1));
                model.setValue(ORG_JSON, (Object)SerializationUtils.toJsonString(mapList));
            } else {
                model.setValue(ORG, (Object)"");
                model.setValue(ORG_JSON, (Object)"");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit baseData = (BasedataEdit)e.getSource();
        String key = baseData.getKey();
        ListShowParameter f7List = (ListShowParameter)e.getFormShowParameter();
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(MODEL);
        if (Objects.isNull(modelDyn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ArchiveRangeReportFormPlugin_11", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long modelId = modelDyn.getLong("id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (REPORT_FORM.equals(key)) {
            filters.add(new QFilter("model.id", "=", (Object)modelId));
            f7List.getListFilterParameter().setQFilters(filters);
        } else if (CURRENCY.equals(key)) {
            filters.add(new QFilter("model.id", "=", (Object)modelId));
            filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            f7List.getListFilterParameter().setQFilters(filters);
        } else if ("bcmfy".equals(key) || "bcmscene".equals(key) || "bcmperiod".equals(key)) {
            filters.add(new QFilter(MODEL, "=", (Object)modelId));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            if ("bcmfy".equals(key)) {
                filters.add(new QFilter("aggoprt", "=", (Object)"1"));
            }
            if ("bcmscene".equals(key)) {
                filters.add(new QFilter("number", "in", Arrays.asList("MRpt", "QRpt", "ARpt")));
            }
            if ("bcmperiod".equals(key)) {
                IDataModel model = this.getModel();
                DynamicObject bcmScene = (DynamicObject)model.getValue("bcmscene");
                if (Objects.isNull(bcmScene)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"ArchiveEdit_12", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> periodIds = this.getPeriodIds(modelId, bcmScene.getLong("id"));
                filters.add(new QFilter("id", "in", periodIds));
            }
            f7List.getListFilterParameter().setQFilters(filters);
        }
    }

    private List<Long> getPeriodIds(long modelId, long scenarioId) {
        DynamicObjectCollection coll;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter(MODEL, "=", (Object)modelId));
        filters.add(new QFilter("id", "=", (Object)scenarioId));
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> periodIds = new ArrayList<Long>();
        if (Objects.nonNull(dy) && Objects.nonNull(coll = dy.getDynamicObjectCollection("sceneperiod")) && !coll.isEmpty()) {
            coll.forEach(p -> {
                DynamicObject period = p.getDynamicObject("fbasedataid");
                if (Objects.nonNull(period)) {
                    periodIds.add(period.getLong("id"));
                }
            });
        }
        return periodIds;
    }

    public void onProgress(ProgressEvent progressEvent) {
        String pageId = this.getPageId();
        boolean isFinish = Boolean.parseBoolean(this.cache.get(pageId + "isFinish"));
        String notHaveTemplate = this.cache.get(pageId + "nothavetemplate");
        if (isFinish) {
            boolean isSuccess;
            boolean bl = isSuccess = this.cache.get(pageId + "isSuccess") == null || Boolean.parseBoolean(this.cache.get(pageId + "isSuccess"));
            if (!isSuccess) {
                String errorMsg = this.cache.get(pageId + "errorMsg");
                errorMsg = errorMsg == null ? "" : errorMsg;
                String key = pageId + "hasarchievecount";
                String hasArchiveCount = this.cache.get(key);
                String allCount = this.cache.get(pageId + "allcount");
                if (hasArchiveCount != null && Integer.parseInt(hasArchiveCount) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u90e8\u5206\u6210\u529f,\u5df2\u6210\u529f\u5f52\u6863%1$s,\u5171%2$s\u5f20\u3002\u9519\u8bef\u4fe1\u606f\uff1a%3$s", (String)"ArchiveEdit_8", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), hasArchiveCount, allCount, errorMsg), Integer.valueOf(200000));
                } else if (StringUtils.isEmpty((String)notHaveTemplate)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25,%s", (String)"ArchiveEdit_4", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), errorMsg));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5931\u8d25,%s", (String)"ArchiveEdit_4", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), notHaveTemplate));
                }
            } else {
                String key = pageId + "hasarchievecount";
                logger.info("\u83b7\u53d6\u5f52\u6863\u6210\u529f\u7684key\uff1a{}", (Object)key);
                String hasArchiveCount = this.cache.get(key);
                logger.info("\u83b7\u53d6\u5230\u7684\u5df2\u5f52\u6863\u7684\u6570\u91cf\uff1a{}", (Object)hasArchiveCount);
                if (StringUtils.isEmpty((String)notHaveTemplate)) {
                    if (hasArchiveCount == null || "0".equals(hasArchiveCount)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_9", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(30000));
                    } else {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f%s\u5f20\u3002", (String)"ArchiveEdit_10", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), hasArchiveCount), Integer.valueOf(600000));
                    }
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f%1$s\u5f20,%2$s", (String)"ArchiveEdit_11", (String)FI_AEF_FORMPLUGIN, (Object[])new Object[0]), hasArchiveCount == null ? "0" : hasArchiveCount, notHaveTemplate), Integer.valueOf(60000));
                }
            }
            this.stopProgressBar();
        } else {
            Label label1 = (Label)this.getControl("hasarchievecount");
            Label label2 = (Label)this.getControl("allcount");
            label1.setText(this.cache.get(pageId + "hasarchievecount"));
            label2.setText(this.cache.get(pageId + "allcount"));
        }
    }

    private void stopProgressBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
        this.removeCache();
        Label label1 = (Label)this.getControl("hasarchievecount");
        Label label2 = (Label)this.getControl("allcount");
        label1.setText("0");
        label2.setText("0");
        this.setPage(true);
    }

    private void removeCache() {
        String pageId = this.getPageId();
        this.cache.remove(pageId + "isFinish");
        this.cache.remove(pageId + "isSuccess");
        this.cache.remove(pageId + "hasarchievecount");
        this.cache.remove(pageId + "allcount");
        this.cache.remove(pageId + "errorMsg");
        this.cache.remove(pageId + "finishedBill");
        this.cache.remove(pageId + "exporturl");
        this.cache.remove(pageId + "orgUnionCode");
        this.getPageCache().remove("pageId");
    }
}

