/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PrintSampleSelect
extends AbstractFormPlugin
implements ClickListener {
    private static final String ENTITYNAME = "entryentity";
    private Map<String, String> formLs;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.formLs = (Map)parameter.getCustomParam("formLs");
        this.ShowData(this.formLs);
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                String value = this.GetSelectdValue();
                this.getView().returnDataToParent((Object)value);
                this.getView().close();
                break;
            }
        }
    }

    private void ShowData(Map<String, String> formLs) {
        if (formLs == null || formLs.size() == 0) {
            return;
        }
        this.getModel().getDataEntity(true);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTITYNAME);
        collection.clear();
        formLs.forEach((k, v) -> {
            DynamicObject row = (DynamicObject)collection.getDynamicObjectType().createInstance();
            row.set("name", v);
            row.set("key", k);
            collection.add((Object)row);
        });
        this.getModel().setValue(ENTITYNAME, (Object)collection);
        this.getView().updateView(ENTITYNAME);
    }

    private String GetSelectdValue() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTITYNAME);
        int[] rows = grid.getEntryState().getSelectedRows();
        StringBuilder sb = new StringBuilder();
        if (rows != null && rows.length > 0) {
            int res = rows[0];
            sb.append(this.getModel().getValue("key", res));
            sb.append(',');
            sb.append(this.getModel().getValue("name", res));
            return sb.toString();
        }
        return null;
    }
}

