/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.aef.entity.PrintTemplate;

public class PrintTemplateMultiSelect
extends AbstractFormPlugin
implements ClickListener {
    private static final String TEMPLATENAME = "templatename";
    private static final String TEMPLATENUMBER = "templatenumber";
    private static final String EXPRESSDESC = "expressdesc";
    private static final String EXPRESSJSON = "expressjson";
    private static final String ENTITYNAME = "entryentity";
    private static final String BILLTYPE = "billtype";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        TextEdit caption = (TextEdit)this.getView().getControl(EXPRESSDESC);
        caption.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map printsmaplels = (Map)this.getView().getFormShowParameter().getCustomParam("formLs");
        this.initTemplateCom(printsmaplels);
        String templatelistjson = (String)this.getView().getFormShowParameter().getCustomParam("templatelist");
        String oldprintsmaple = (String)this.getView().getFormShowParameter().getCustomParam("oldprintsmaple");
        if (StringUtils.isBlank((CharSequence)templatelistjson) && StringUtils.isBlank((CharSequence)oldprintsmaple) && printsmaplels.size() > 0) {
            this.getModel().setValue(TEMPLATENUMBER, printsmaplels.keySet().iterator().next(), 0);
            this.getModel().setValue(TEMPLATENAME, printsmaplels.keySet().iterator().next(), 0);
        }
        List<PrintTemplate> templateList = new ArrayList(2);
        this.getPageCache().put(BILLTYPE, (String)this.getView().getFormShowParameter().getCustomParam(BILLTYPE));
        this.getPageCache().put("printsmaplels", SerializationUtils.toJsonString((Object)printsmaplels));
        if (StringUtils.isNotBlank((CharSequence)templatelistjson)) {
            templateList = SerializationUtils.fromJsonStringToList((String)templatelistjson, PrintTemplate.class);
        }
        if (StringUtils.isNotBlank((CharSequence)oldprintsmaple)) {
            PrintTemplate printTemplate = new PrintTemplate();
            printTemplate.setTemplateName(oldprintsmaple);
            printTemplate.setTemplateNumber(oldprintsmaple);
            printTemplate.setExpressdesc("");
            printTemplate.setExpressjson("");
            templateList.add(printTemplate);
        }
        if (templateList.size() > 0) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTITYNAME);
            collection.clear();
            for (PrintTemplate printTemplate : templateList) {
                DynamicObject row = (DynamicObject)collection.getDynamicObjectType().createInstance();
                row.set(TEMPLATENAME, (Object)printTemplate.getTemplateNumber());
                row.set(TEMPLATENUMBER, (Object)printTemplate.getTemplateNumber());
                row.set(EXPRESSDESC, (Object)printTemplate.getExpressdesc());
                row.set(EXPRESSJSON, (Object)printTemplate.getExpressjson());
                collection.add((Object)row);
            }
            this.getModel().setValue(ENTITYNAME, (Object)collection);
            this.getView().updateView(ENTITYNAME);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                String errMessage = this.checkData();
                if (StringUtils.isNotBlank((CharSequence)errMessage)) {
                    this.getView().showTipNotification(errMessage);
                    return;
                }
                List<PrintTemplate> value = this.GetSelectdValue();
                this.getView().returnDataToParent(value);
                this.getView().close();
                break;
            }
            case "expressdesc": {
                String billtype = this.getPageCache().get(BILLTYPE);
                if ("gl_rpt_generalledger".equals(billtype) || "gl_rpt_subledger".equals(billtype) || "gl_rpt_subsidiaryledger".equals(billtype) || "cas_bankjournalformrpt".equals(billtype) || "cas_cashjournalformrpt".equals(billtype)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d26\u8868\u7c7b\u578b\u5f52\u6863\u4e0d\u80fd\u8bbe\u7f6e\u6a21\u677f\u7684\u53d6\u503c\u6761\u4ef6\u3002", (String)"PrintTemplateMultiSelect_3", (String)"fi-aef-formplugin", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("aef_condition");
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITYNAME);
                showParameter.getCustomParams().put(BILLTYPE, billtype);
                showParameter.getCustomParams().put(EXPRESSJSON, this.getModel().getValue(EXPRESSJSON, rowIndex));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPRESSDESC));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnValue = closedCallBackEvent.getReturnData();
        if (returnValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        switch (closedCallBackEvent.getActionId()) {
            case "expressdesc": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITYNAME);
                Map dataMap = (Map)returnValue;
                String expressdesc = (String)dataMap.get(EXPRESSDESC);
                String expressjson = (String)dataMap.get(EXPRESSJSON);
                model.setValue(EXPRESSDESC, (Object)expressdesc, rowIndex);
                model.setValue(EXPRESSJSON, (Object)expressjson, rowIndex);
            }
        }
    }

    private void initTemplateCom(Map<String, String> printsmaplels) {
        if (printsmaplels == null || printsmaplels.size() == 0) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TEMPLATENAME);
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(2);
        for (Map.Entry<String, String> entry : printsmaplels.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            itemList.add(item);
        }
        comboEdit.setComboItems(itemList);
    }

    private String checkData() {
        ArrayList<String> errmessages = new ArrayList<String>(2);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTITYNAME);
        int i = 1;
        Map printsmaplels = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("printsmaplels"), Map.class);
        List blankdyns = collection.stream().filter(dynamicObject -> StringUtils.isBlank((CharSequence)dynamicObject.getString(EXPRESSDESC))).collect(Collectors.toList());
        if (blankdyns.size() > 1) {
            errmessages.add(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u914d\u7f6e\u4e00\u884c\u6ca1\u6709\u8fc7\u6ee4\u6761\u4ef6\u7684\u6570\u636e", (String)"PrintTemplateMultiSelect_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            return String.join((CharSequence)"\uff1b", errmessages) + "\u3002";
        }
        for (int j = 0; j < collection.size(); ++j) {
            DynamicObject dynamicObject2 = (DynamicObject)collection.get(j);
            String templatename = (String)printsmaplels.get(dynamicObject2.getString(TEMPLATENAME));
            String templatenumber = dynamicObject2.getString(TEMPLATENUMBER);
            String experssdesc = dynamicObject2.getString(EXPRESSDESC);
            String experssjson = dynamicObject2.getString(EXPRESSJSON);
            if (StringUtils.isBlank((CharSequence)experssdesc) && collection.size() != i && collection.size() != 1) {
                errmessages.add(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8fc7\u6ee4\u6761\u4ef6\u7684\u6570\u636e\u5e94\u914d\u7f6e\u5728\u6700\u540e\u4e00\u884c", (String)"PrintTemplateMultiSelect_2", (String)"fi-aef-formplugin", (Object[])new Object[0]), i));
                break;
            }
            if (StringUtils.isBlank((CharSequence)templatename) || StringUtils.isBlank((CharSequence)templatenumber)) {
                errmessages.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6253\u5370\u6a21\u677f\u65e0\u6548,\u8bf7\u68c0\u67e5\u8be5\u6a21\u677f\u662f\u5426\u5df2\u5e9f\u5f03", (String)"PrintTemplateMultiSelect_0", (String)"fi-aef-formplugin", (Object[])new Object[0]), i));
            }
            ++i;
        }
        if (errmessages.size() > 0) {
            return String.join((CharSequence)"\uff1b", errmessages) + "\u3002";
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "templatename": {
                model.setValue(TEMPLATENUMBER, model.getValue(TEMPLATENAME, rowIndex), rowIndex);
                break;
            }
            case "expressdesc": {
                if (!StringUtils.isBlank((Object)model.getValue(EXPRESSDESC, rowIndex))) break;
                model.setValue(EXPRESSJSON, (Object)"", rowIndex);
            }
        }
    }

    private List<PrintTemplate> GetSelectdValue() {
        ArrayList<PrintTemplate> returnList = new ArrayList<PrintTemplate>(8);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTITYNAME);
        Map printsmaplels = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("printsmaplels"), Map.class);
        for (DynamicObject dynamicObject : collection) {
            PrintTemplate printTemplate = new PrintTemplate();
            printTemplate.setTemplateName((String)printsmaplels.get(dynamicObject.getString(TEMPLATENAME)));
            printTemplate.setTemplateNumber(dynamicObject.getString(TEMPLATENUMBER));
            printTemplate.setExpressdesc(dynamicObject.getString(EXPRESSDESC));
            printTemplate.setExpressjson(dynamicObject.getString(EXPRESSJSON));
            returnList.add(printTemplate);
        }
        return returnList;
    }
}

