/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.aef.common.util.DowJonesVideoImp;

public class ShowBillAchieveImage
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private TreeView treev;
    private String billType;
    private String billId;
    private Map<String, String> billNodeAndUrlMap = new HashMap<String, String>();
    private Map<String, Set<Long>> billTypeAndIds = new HashMap<String, Set<Long>>();
    private static final String AttachNodeId = "1";
    private static final String ParentBillNodeId = "2";
    private static final String[] aviliableFormat = new String[]{"jpg", "png", "jpeg", "bmp", "doc", "docx", "xlsx", "xls", "pdf"};

    public void initialize() {
        TreeView fieldTree = (TreeView)this.getControl("treeviewap");
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.treev = fieldTree;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        this.billType = (String)fsp.getCustomParam("billType");
        this.billId = fsp.getCustomParam("billId") instanceof String ? (String)fsp.getCustomParam("billId") : Long.toString((Long)fsp.getCustomParam("billId"));
        this.getPageCache().put("uploadWay", (String)fsp.getCustomParam("uploadway"));
        this.billTypeAndIds = (Map)SerializationUtils.deSerializeFromBase64((String)((String)fsp.getCustomParam("bfRowLinkUp")));
        this.initBillNodeAndUrlMap(this.billTypeAndIds);
        this.initTree(this.billType, this.billId);
    }

    private void initBillNodeAndUrlMap(Map<String, Set<Long>> billTypeAndIds) {
        block16: {
            String uploadWay = this.getPageCache().get("uploadWay");
            String billandtype = this.billType + this.billId;
            if (billTypeAndIds == null) break block16;
            if (AttachNodeId.equals(uploadWay)) {
                for (Map.Entry<String, Set<Long>> entry : billTypeAndIds.entrySet()) {
                    Set<Long> billIds = entry.getValue();
                    String billtype = entry.getKey();
                    for (Long billid : billIds) {
                        String url;
                        if ((billtype + billid).equals(billandtype) || StringUtils.isEmpty((CharSequence)(url = DowJonesVideoImp.GetBillIAttachmentViewUrl((String)billtype, (String)(billid + ""))))) continue;
                        this.billNodeAndUrlMap.put(url, "" + this.billId + this.billType + ".pdf");
                    }
                }
            } else {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
                for (Map.Entry<String, Set<Long>> entry : billTypeAndIds.entrySet()) {
                    String billtype = entry.getKey();
                    Set<Long> billIds = entry.getValue();
                    qFilters.clear();
                    qFilters.add(new QFilter("billtype", "=", (Object)billtype));
                    qFilters.add(new QFilter("billid", "in", billIds));
                    String algoKey = ((Object)((Object)this)).getClass().getName() + "initBillNodeAndUrlMap";
                    DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aef_archieve_imagepath", (String)"billid,billtype,imagepath", (QFilter[])qFilters.toArray(new QFilter[0]), null);
                    Throwable throwable = null;
                    try {
                        if (set == null) continue;
                        for (Row row : set) {
                            if ((billtype + row.getString(0)).equals(billandtype)) continue;
                            this.billNodeAndUrlMap.put(row.getString(2), row.getString(0) + row.getString(1) + ".pdf");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (set == null) continue;
                        if (throwable != null) {
                            try {
                                set.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        set.close();
                    }
                }
            }
        }
    }

    private void initTree(String billType, String billId) {
        TreeNode firstRoot = new TreeNode();
        firstRoot.setParentid("");
        firstRoot.setId("0");
        firstRoot.setText(ResManager.loadKDString((String)"\u5355\u636e\u5f71\u50cf", (String)"ShowBillAchieveImage_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        firstRoot.setIsOpened(true);
        this.treev.addNode(firstRoot);
        TreeNode treeNode = null;
        treeNode = ParentBillNodeId.equals(this.getPageCache().get("uploadWay")) ? this.initSonRootByFtp(billType, billId, firstRoot) : this.initSonRootByDowJones(billType, billId, firstRoot);
        if (treeNode != null) {
            this.buildBillNodes(treeNode);
            this.treev.focusNode(treeNode);
            this.treev.treeNodeClick(firstRoot.getId(), treeNode.getId());
        } else {
            TreeNode billRootNode = this.buildBillNodes(firstRoot);
            if (billRootNode != null) {
                this.treev.focusNode(billRootNode);
                this.treev.treeNodeClick(firstRoot.getId(), billRootNode.getId());
            }
        }
    }

    private TreeNode initSonRootByDowJones(String billType, String billId, TreeNode firstRoot) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billid", "=", (Object)Long.valueOf(billId)));
        filters.add(new QFilter("billType", "=", (Object)billType));
        DynamicObject archieveRecord = QueryServiceHelper.queryOne((String)"aef_acelre", (String)"billno", (QFilter[])filters.toArray(new QFilter[0]));
        String voucherid = DowJonesVideoImp.GetBillIAttachmentViewUrl((String)billType, (String)billId);
        String rootName = archieveRecord.getString("billno") + ".pdf";
        TreeNode treeNode = this.createTreeNode(voucherid, "0", rootName);
        firstRoot.addChild(treeNode);
        this.getPageCache().put(voucherid, voucherid.split("\\.")[voucherid.split("\\.").length - 1]);
        ArrayList<QFilter> filters1 = new ArrayList<QFilter>();
        filters1.add(new QFilter("finterid", "=", (Object)billId));
        filters1.add(new QFilter("fbilltype", "=", (Object)billType));
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bos_attachment", (String)"fattachmentname,ffileid,fextname", (QFilter[])filters1.toArray(new QFilter[0]));
        if (data != null && data.size() > 0) {
            TreeNode appendNode = this.createTreeNode(AttachNodeId, voucherid, ResManager.loadKDString((String)"\u9644\u4ef6", (String)"ShowBillAchieveImage_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            treeNode.addChild(appendNode);
            for (int i = 0; i < data.size(); ++i) {
                String fileName = ((DynamicObject)data.get(i)).getString("fattachmentname");
                String extName = ((DynamicObject)data.get(i)).getString("fextname");
                if (!Arrays.stream(aviliableFormat).anyMatch(h -> h.equalsIgnoreCase(extName))) continue;
                String url = DowJonesVideoImp.GetBillIAttachmentViewUrl((String)billType, (String)billId, (String)fileName);
                TreeNode attachNode = this.createTreeNode(url, AttachNodeId, fileName);
                appendNode.addChild(attachNode);
                this.getPageCache().put(url, fileName.split("\\.")[fileName.split("\\.").length - 1]);
            }
        }
        return treeNode;
    }

    private TreeNode initSonRootByFtp(String billType, String billId, TreeNode firstRoot) {
        String billTypeName;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billid", "=", (Object)Long.valueOf(billId)));
        filters.add(new QFilter("billType", "=", (Object)billType));
        if (null != billType && !"aef_rpt".equals(billType)) {
            filters.add(new QFilter("billType", "=", (Object)billType));
            billTypeName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
        } else {
            billTypeName = "";
        }
        String entityName = "aef_rpt".equals(billType) ? "aef_acelre_rpt" : "aef_acelre";
        DynamicObject archieveRecord = (DynamicObject)QueryServiceHelper.query((String)entityName, (String)"billno", (QFilter[])filters.toArray(new QFilter[0]), (String)"fexetime desc").get(0);
        DynamicObjectCollection imagepaths = QueryServiceHelper.query((String)"aef_archieve_imagepath", (String)"filename,imagepath,imagetype", (QFilter[])filters.toArray(new QFilter[0]), (String)"archievetime,imagetype desc");
        if (archieveRecord == null || imagepaths == null) {
            return null;
        }
        String voucherid = ((DynamicObject)imagepaths.get(0)).getString("imagepath");
        String rootName = billTypeName + archieveRecord.getString("billno") + ".pdf";
        TreeNode treeNode = this.createTreeNode(voucherid, "0", rootName);
        firstRoot.addChild(treeNode);
        this.getPageCache().put(voucherid, voucherid.split("\\.")[voucherid.split("\\.").length - 1]);
        if (imagepaths.size() > 1) {
            TreeNode appendNode = this.createTreeNode(AttachNodeId, voucherid, ResManager.loadKDString((String)"\u9644\u4ef6", (String)"ShowBillAchieveImage_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            treeNode.addChild(appendNode);
            for (int i = 1; i < imagepaths.size(); ++i) {
                String imagetype = ((DynamicObject)imagepaths.get(i)).getString("imagetype");
                if (AttachNodeId.equals(imagetype)) continue;
                String url = ((DynamicObject)imagepaths.get(i)).getString("imagepath");
                String filename = ((DynamicObject)imagepaths.get(i)).getString("filename");
                TreeNode attachNode = this.createTreeNode(url, AttachNodeId, filename);
                appendNode.addChild(attachNode);
                this.getPageCache().put(url, filename.split("\\.")[filename.split("\\.").length - 1]);
            }
        }
        return treeNode;
    }

    private TreeNode buildBillNodes(TreeNode pNode) {
        TreeNode billRootNode = null;
        if (this.billNodeAndUrlMap != null && !this.billNodeAndUrlMap.isEmpty()) {
            billRootNode = this.createTreeNode(ParentBillNodeId, pNode.getId(), ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e", (String)"ShowBillAchieveImage_2", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            pNode.addChild(billRootNode);
            for (Map.Entry<String, String> entry : this.billNodeAndUrlMap.entrySet()) {
                String nodeId = entry.getKey();
                String nodeUrl = entry.getValue();
                TreeNode billNode = this.createTreeNode(nodeId, ParentBillNodeId, nodeUrl);
                billRootNode.addChild(billNode);
                if (nodeUrl == null) continue;
                this.getPageCache().put(nodeId, nodeUrl.split("\\.")[nodeUrl.split("\\.").length - 1]);
            }
        }
        return billRootNode;
    }

    private TreeNode createTreeNode(String nodeId, String parentId, String nodeName) {
        TreeNode treeNode = new TreeNode();
        treeNode.setParentid(parentId);
        treeNode.setId(nodeId);
        treeNode.setText(nodeName);
        treeNode.setIsOpened(true);
        return treeNode;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String uploadWay = this.getPageCache().get("uploadWay");
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        String extname = this.getPageCache().get(nodeId);
        if ("0".equals(nodeId) || AttachNodeId.equals(nodeId) || ParentBillNodeId.equals(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u6216\u865a\u62df\u8282\u70b9\u4e0b\u4e0d\u53ef\u67e5\u770b\u5f71\u50cf\u3002", (String)"ShowBillAchieveImage_3", (String)"fi-aef-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = "";
        url = ParentBillNodeId.equals(uploadWay) ? UrlService.getAttachmentPreviewUrl((String)nodeId) : UrlService.getAttachmentFullUrl((String)nodeId);
        String htmlCtrlName = "";
        String htmlContent = "";
        if (AttachNodeId.equals(uploadWay)) {
            htmlCtrlName = "htmlapdowjones";
            htmlContent = "<iframe src='" + nodeId + "' ></iframe >";
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexftp"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdowjones"});
        } else {
            htmlCtrlName = "htmlap";
            String htmlCss = "txt".equals(extname) ? "" : " style='border: none' ";
            htmlContent = "<iframe " + htmlCss + " src='" + url + "' ></iframe>";
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexftp"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdowjones"});
        }
        Html htmlap = (Html)this.getView().getControl(htmlCtrlName);
        htmlap.setConent(htmlContent);
    }
}

