/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.query;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;

public class ArchivePoolHelper {
    private static String getIdentificationOrg() {
        return ResManager.loadKDString((String)"\u7b7e\u53d1\u673a\u6784", (String)"ArchivePoolHelper_0", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBankBranchNumber() {
        return ResManager.loadKDString((String)"\u8425\u4e1a\u7f51\u70b9\u7f16\u53f7", (String)"ArchivePoolHelper_1", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getCurrency() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ArchivePoolHelper_2", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAccount() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u8d26\u53f7", (String)"ArchivePoolHelper_3", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getCustomerName() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u8d26\u6237\u540d\u79f0", (String)"ArchivePoolHelper_4", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getCustomerNumber() {
        return ResManager.loadKDString((String)"\u5ba2\u6237\u53f7", (String)"ArchivePoolHelper_5", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getYear() {
        return ResManager.loadKDString((String)"\u5e74\u4efd", (String)"ArchivePoolHelper_6", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getMonth() {
        return ResManager.loadKDString((String)"\u6708\u4efd", (String)"ArchivePoolHelper_7", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getPrintTimes() {
        return ResManager.loadKDString((String)"\u6253\u5370\u6b21\u6570", (String)"ArchivePoolHelper_8", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getPrintDate() {
        return ResManager.loadKDString((String)"\u6253\u5370\u65e5\u671f", (String)"ArchivePoolHelper_9", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAccountBal() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d", (String)"ArchivePoolHelper_10", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getReserveBal() {
        return ResManager.loadKDString((String)"\u4fdd\u7559\u4f59\u989d", (String)"ArchivePoolHelper_11", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getFrozenBal() {
        return ResManager.loadKDString((String)"\u51bb\u7ed3\u4f59\u989d", (String)"ArchivePoolHelper_12", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getOverdraftBal() {
        return ResManager.loadKDString((String)"\u900f\u652f\u4f59\u989d", (String)"ArchivePoolHelper_13", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAvailableBal() {
        return ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"ArchivePoolHelper_14", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBkrsHeadGroup() {
        return ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u5934\u4fe1\u606f", (String)"ArchivePoolHelper_15", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBkrsEndTermGroup() {
        return ResManager.loadKDString((String)"\u5bf9\u8d26\u5468\u671f\u672b\u4fe1\u606f", (String)"ArchivePoolHelper_16", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBkerInvoiceGroup() {
        return ResManager.loadKDString((String)"\u6536\u4ed8\u6b3e\u7968\u636e\u4fe1\u606f", (String)"ArchivePoolHelper_17", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getInvoiceType() {
        return ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b", (String)"ArchivePoolHelper_18", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getDateofissue() {
        return ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"ArchivePoolHelper_19", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getInvoiceCode() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u53f7", (String)"ArchivePoolHelper_20", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getPayAndRevAmount() {
        return ResManager.loadKDString((String)"\u5e94\u6536/\u4ed8\u6b3e\u9879\u91d1\u989d", (String)"ArchivePoolHelper_21", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenClaimed() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u8ba4\u9886", (String)"ArchivePoolHelper_22", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenReconciled() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u5bf9\u8d26", (String)"ArchivePoolHelper_23", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenTransfer() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6d41\u8f6c", (String)"ArchivePoolHelper_24", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAccountGroup() {
        return ResManager.loadKDString((String)"\u4f1a\u8ba1\u4e3b\u4f53\u4fe1\u606f", (String)"ArchivePoolHelper_25", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAccountName() {
        return ResManager.loadKDString((String)"\u4f1a\u8ba1\u4e3b\u4f53\u540d\u79f0", (String)"ArchivePoolHelper_26", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAccountCode() {
        return ResManager.loadKDString((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (String)"ArchivePoolHelper_27", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getIdentifyingCode() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6821\u9a8c\u7801", (String)"ArchivePoolHelper_28", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getContractNumber() {
        return ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"ArchivePoolHelper_29", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getInvoiceStatusGroup() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001", (String)"ArchivePoolHelper_30", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getInvoiceUniqueCode() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u552f\u4e00\u6807\u8bc6", (String)"ArchivePoolHelper_31", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getInvoiceNumber() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"ArchivePoolHelper_80", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getIsRedInvoice() {
        return ResManager.loadKDString((String)"\u662f\u5426\u7ea2\u5b57\u53d1\u7968", (String)"ArchivePoolHelper_32", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenChecked() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u9a8c\u771f", (String)"ArchivePoolHelper_33", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBizInfo() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u4fe1\u606f", (String)"ArchivePoolHelper_34", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String geContractNumber() {
        return ResManager.loadKDString((String)"\u5408\u540c\u7f16\u7801", (String)"ArchivePoolHelper_35", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String geMatchingState() {
        return ResManager.loadKDString((String)"\u5339\u914d\u72b6\u6001", (String)"ArchivePoolHelper_36", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAmortizationMethod() {
        return ResManager.loadKDString((String)"\u6298\u65e7\u644a\u9500\u65b9\u6cd5", (String)"ArchivePoolHelper_37", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenBooked() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u5165\u8d26", (String)"ArchivePoolHelper_38", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenFsos() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u505a\u4fdd\u7406\u3001\u51fa\u552e\u3001 \u8d44\u4ea7\u8bc1\u5238\u5316", (String)"ArchivePoolHelper_39", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getPayInfo() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e\u4fe1\u606f", (String)"ArchivePoolHelper_40", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenPaid() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u4ed8\u6b3e", (String)"ArchivePoolHelper_41", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getElectronicNumber() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u56de\u5355\u7f16\u53f7", (String)"ArchivePoolHelper_42", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTaxManagementInfo() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u7ba1\u7406\u4fe1\u606f", (String)"ArchivePoolHelper_43", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBeginPeriod() {
        return ResManager.loadKDString((String)"\u6743\u8d23\u53d1\u751f\u5236\u4e0b\u652f\u51fa\u6240\u5c5e\u671f\u8d77", (String)"ArchivePoolHelper_44", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEndPeriod() {
        return ResManager.loadKDString((String)"\u6743\u8d23\u53d1\u751f\u5236\u4e0b\u652f\u51fa\u6240\u5c5e\u671f\u6b62", (String)"ArchivePoolHelper_45", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenCompleted() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u6240\u5f97\u7a0e\u7a0e\u524d\u6263\u9664", (String)"ArchivePoolHelper_46", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getBeginYear() {
        return ResManager.loadKDString((String)"\u6240\u5f97\u7a0e\u7a0e\u524d\u6263\u9664\u5e74\u5ea6\u8d77", (String)"ArchivePoolHelper_47", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEndYear() {
        return ResManager.loadKDString((String)"\u6240\u5f97\u7a0e\u7a0e\u524d\u6263\u9664\u5e74\u5ea6\u6b62", (String)"ArchivePoolHelper_48", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTravelNumber() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u53f7\u7801", (String)"ArchivePoolHelper_49", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getDeductInfo() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u62b5\u6263\u4fe1\u606f", (String)"ArchivePoolHelper_50", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenDeducted() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u62b5\u6263", (String)"ArchivePoolHelper_51", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getDeductionTaxPeriod() {
        return ResManager.loadKDString((String)"\u62b5\u6263\u7a0e\u671f", (String)"ArchivePoolHelper_52", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getReceiptStatusGroup() {
        return ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001", (String)"ArchivePoolHelper_53", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEInvoiceId() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u7f34\u6b3e\u4e66\u6807\u8bc6", (String)"ArchivePoolHelper_54", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getInvoiceUsageInfo() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u7528\u9014\u4fe1\u606f", (String)"ArchivePoolHelper_55", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getHasBeenConfirmed() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5df2\u7528\u9014\u786e\u8ba4", (String)"ArchivePoolHelper_56", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getUsageConfirmation() {
        return ResManager.loadKDString((String)"\u786e\u8ba4\u7528\u9014", (String)"ArchivePoolHelper_57", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getUsageonfIrmationPeriod() {
        return ResManager.loadKDString((String)"\u7528\u9014\u786e\u8ba4\u6240\u5c5e\u671f", (String)"ArchivePoolHelper_58", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTransferredOut() {
        return ResManager.loadKDString((String)"\u8fdb\u9879\u7a0e\u989d\u8f6c\u51fa\u4fe1\u606f", (String)"ArchivePoolHelper_59", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getIsTransferredOut() {
        return ResManager.loadKDString((String)"\u662f\u5426\u8fdb\u9879\u7a0e\u989d\u8f6c\u51fa", (String)"ArchivePoolHelper_60", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTransferredOutAmount() {
        return ResManager.loadKDString((String)"\u8fdb\u9879\u7a0e\u989d\u8f6c\u51fa\u91d1\u989d", (String)"ArchivePoolHelper_61", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getPaidamt() {
        return ResManager.loadKDString((String)"\u7f34\u6b3e\u91d1\u989d", (String)"ArchivePoolHelper_62", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getFiguresAmt() {
        return ResManager.loadKDString((String)"\u5c0f\u5199\u91d1\u989d", (String)"ArchivePoolHelper_63", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getAomoutNoTax() {
        return ResManager.loadKDString((String)"\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09", (String)"ArchivePoolHelper_64", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTaxRate() {
        return ResManager.loadKDString((String)"\u7a0e\u7387", (String)"ArchivePoolHelper_65", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTaxAmount() {
        return ResManager.loadKDString((String)"\u7a0e\u989d", (String)"ArchivePoolHelper_66", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getFare() {
        return ResManager.loadKDString((String)"\u7968\u4ef7", (String)"ArchivePoolHelper_67", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getIssueParty() {
        return ResManager.loadKDString((String)"\u586b\u5f00\u5355\u4f4d", (String)"ArchivePoolHelper_68", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getIssueDate() {
        return ResManager.loadKDString((String)"\u586b\u5f00\u65e5\u671f", (String)"ArchivePoolHelper_69", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTaxSocialCreditCode() {
        return ResManager.loadKDString((String)"\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff08\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff09", (String)"ArchivePoolHelper_70", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTotalAmoutNoTax() {
        return ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d\u5408\u8ba1", (String)"ArchivePoolHelper_71", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTotalTaxAmount() {
        return ResManager.loadKDString((String)"\u7a0e\u989d\u5408\u8ba1", (String)"ArchivePoolHelper_72", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTaxIncludedAmountInFigures() {
        return ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\uff08\u5c0f\u5199\uff09", (String)"ArchivePoolHelper_73", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getNameOfSaller() {
        return ResManager.loadKDString((String)"\u9500\u552e\u65b9\u540d\u79f0", (String)"ArchivePoolHelper_74", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEfiInvoiceId() {
        return ResManager.loadKDString((String)"\u8d22\u653f\u7535\u5b50\u7968\u636e\u6807\u8bc6", (String)"ArchivePoolHelper_75", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getTotalAmt() {
        return ResManager.loadKDString((String)"\u603b\u91d1\u989d", (String)"ArchivePoolHelper_76", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEfiInvoiceGroup() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f", (String)"ArchivePoolHelper_77", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEfiStatus() {
        return ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001", (String)"ArchivePoolHelper_78", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private static String getEInvoiceGroup() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u4fe1\u606f", (String)"ArchivePoolHelper_79", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    public static void createColumnOfNtrEv(List<AbstractReportColumn> columns) {
        ReportColumnGroup receiptStatusGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getReceiptStatusGroup(), "receiptStatusGroup");
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getEInvoiceId(), "einvoiceid", "text"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDateofissue(), "billdate", "date"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getPaidamt(), "paidamt", "amount"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIsRedInvoice(), "isredinvoice", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenChecked(), "hasbeenchecked", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenBooked(), "hasbeenbooked", "checkbox"));
        columns.add((AbstractReportColumn)receiptStatusGroup);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    public static void createColumnOfEfi(List<AbstractReportColumn> columns) {
        ReportColumnGroup efiGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getEfiInvoiceGroup(), "efiGroup");
        ArchivePoolHelper.addColumnToGroup(efiGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getEfiInvoiceId(), "einvoiceid", "text"));
        ArchivePoolHelper.addColumnToGroup(efiGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDateofissue(), "dateofissue", "date"));
        ArchivePoolHelper.addColumnToGroup(efiGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTotalAmt(), "totalamount", "amount"));
        ReportColumnGroup efiStatus = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getEfiStatus(), "efiStatus");
        ArchivePoolHelper.addColumnToGroup(efiStatus, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIsRedInvoice(), "isredinvoice", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(efiStatus, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenChecked(), "hasbeenchecked", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(efiStatus, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenBooked(), "hasbeenbooked", "checkbox"));
        columns.add((AbstractReportColumn)efiGroup);
        columns.add((AbstractReportColumn)efiStatus);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    private static void addAccountGroup(List<AbstractReportColumn> columns) {
        ReportColumnGroup accountGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getAccountGroup(), "accountInfoGroup");
        ArchivePoolHelper.addColumnToGroup(accountGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAccountName(), "accountingentityname", "text"));
        ArchivePoolHelper.addColumnToGroup(accountGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAccountCode(), "socialcreditcode", "text"));
        columns.add((AbstractReportColumn)accountGroup);
    }

    public static void createColumnOfRai(List<AbstractReportColumn> columns) {
        ReportColumnGroup invoiceStatusGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getInvoiceStatusGroup(), "invoiceStatusGroup");
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTravelNumber(), "travelnumber", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDateofissue(), "dateofissue", "date"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAomoutNoTax(), "totalamountexcludingtax", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTaxRate(), "taxrate", "qty"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTaxAmount(), "taxamount", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIsRedInvoice(), "isredinvoice", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenBooked(), "hasbeenbooked", "checkbox"));
        columns.add((AbstractReportColumn)invoiceStatusGroup);
        ReportColumnGroup deductInfoGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getDeductInfo(), "deductInfoGroup");
        ArchivePoolHelper.addColumnToGroup(deductInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenDeducted(), "hasbeendeducted", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(deductInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDeductionTaxPeriod(), "deductiontaxperiod", "text"));
        columns.add((AbstractReportColumn)deductInfoGroup);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    public static void createColumnOfAtr(List<AbstractReportColumn> columns) {
        ReportColumnGroup receiptStatusGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getReceiptStatusGroup(), "receiptStatusGroup");
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTravelNumber(), "travelnumber", "text"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getFare(), "fare", "amount"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIssueParty(), "issueparty", "text"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIssueDate(), "issuedate", "date"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIsRedInvoice(), "isredinvoice", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenChecked(), "hasbeenchecked", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(receiptStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenBooked(), "hasbeenbooked", "checkbox"));
        columns.add((AbstractReportColumn)receiptStatusGroup);
        ReportColumnGroup deductInfoGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getDeductInfo(), "deductInfoGroup");
        ArchivePoolHelper.addColumnToGroup(deductInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenDeducted(), "hasbeendeducted", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(deductInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDeductionTaxPeriod(), "deductiontaxperiod", "text"));
        columns.add((AbstractReportColumn)deductInfoGroup);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    public static void createColumnOfInvoiceTlf(List<AbstractReportColumn> columns) {
        ReportColumnGroup invoiceStatusGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getInvoiceStatusGroup(), "invoiceStatusGroup");
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getInvoiceUniqueCode(), "uniquecode", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getNameOfSaller(), "nameofseller", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTaxSocialCreditCode(), "taxsocialcreditcode", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTotalAmoutNoTax(), "totalamountexcludingtax", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTotalTaxAmount(), "totaltaxamount", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTaxIncludedAmountInFigures(), "taxincludedamountinfigure", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDateofissue(), "dateofissue", "date"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIsRedInvoice(), "isredinvoice", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenChecked(), "hasbeenchecked", "checkbox"));
        columns.add((AbstractReportColumn)invoiceStatusGroup);
        ReportColumnGroup invoiceUsageInfo = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getInvoiceUsageInfo(), "invoiceUsageInfo");
        ArchivePoolHelper.addColumnToGroup(invoiceUsageInfo, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenConfirmed(), "hasbeenconfirmed", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(invoiceUsageInfo, ArchivePoolHelper.getColumn(ArchivePoolHelper.getUsageConfirmation(), "usageconfirmation", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceUsageInfo, ArchivePoolHelper.getColumn(ArchivePoolHelper.getUsageonfIrmationPeriod(), "usageconfirmationperiod", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceUsageInfo, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenBooked(), "hasbeenbooked", "checkbox"));
        columns.add((AbstractReportColumn)invoiceUsageInfo);
        ReportColumnGroup payInfoGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getPayInfo(), "payInfoGroup");
        ArchivePoolHelper.addColumnToGroup(payInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenPaid(), "hasbeenpaid", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(payInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getElectronicNumber(), "electronicnumber", "text"));
        columns.add((AbstractReportColumn)payInfoGroup);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    public static void createColumnOfInvoice(String qType, List<AbstractReportColumn> columns) {
        ReportColumnGroup invoiceStatusGroup = new ReportColumnGroup();
        switch (qType) {
            case "aef_invordreceiver": 
            case "aef_invspclreceiver": {
                invoiceStatusGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getInvoiceStatusGroup(), "invoiceStatusGroup");
                ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getInvoiceUniqueCode(), "uniquecode", "text"));
                break;
            }
            case "aef_einvordreceiver": 
            case "aef_einvspclreceiver": {
                invoiceStatusGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getEInvoiceGroup(), "invoiceStatusGroup");
                ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getInvoiceNumber(), "invoicenumber", "text"));
                break;
            }
        }
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getNameOfSaller(), "nameofseller", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTaxSocialCreditCode(), "taxsocialcreditcode", "text"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTotalAmoutNoTax(), "totalamountexcludingtax", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTotalTaxAmount(), "totaltaxamount", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getTaxIncludedAmountInFigures(), "taxincludedamountinfigure", "amount"));
        ArchivePoolHelper.addColumnToGroup(invoiceStatusGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDateofissue(), "dateofissue", "date"));
        columns.add((AbstractReportColumn)invoiceStatusGroup);
        ReportColumnGroup bizInfoGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getBizInfo(), "bizInfoGroup");
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.geContractNumber(), "contractnumber", "text"));
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.geMatchingState(), "matchingstate", "text"));
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAmortizationMethod(), "amortizationmethod", "text"));
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIsRedInvoice(), "isredinvoice", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenChecked(), "hasbeenchecked", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenBooked(), "hasbeenbooked", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(bizInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenFsos(), "hasbeenfsos", "checkbox"));
        columns.add((AbstractReportColumn)bizInfoGroup);
        ReportColumnGroup payInfoGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getPayInfo(), "payInfoGroup");
        ArchivePoolHelper.addColumnToGroup(payInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenPaid(), "hasbeenpaid", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(payInfoGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getElectronicNumber(), "electronicnumber", "text"));
        columns.add((AbstractReportColumn)payInfoGroup);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    public static void createColumnOfBker(List<AbstractReportColumn> columns) {
        columns.add((AbstractReportColumn)ArchivePoolHelper.getColumn(ArchivePoolHelper.getIdentifyingCode(), "identifyingcode", "text"));
        columns.add((AbstractReportColumn)ArchivePoolHelper.getColumn(ArchivePoolHelper.getCurrency(), "currency", "text"));
        columns.add((AbstractReportColumn)ArchivePoolHelper.getColumn(ArchivePoolHelper.getFiguresAmt(), "transactionamountinfigure", "amount"));
        columns.add((AbstractReportColumn)ArchivePoolHelper.getColumn(ArchivePoolHelper.getContractNumber(), "contractnumber", "text"));
        ReportColumnGroup bkerInvoiceGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getBkerInvoiceGroup(), "bkerInvoiceGroup");
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getInvoiceType(), "typeofinvoice", "text"));
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getDateofissue(), "dateofissue", "date"));
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getInvoiceCode(), "uniquecode", "text"));
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getPayAndRevAmount(), "payandrevamount", "amount"));
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenClaimed(), "hasbeenclaimed", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenReconciled(), "hasbeenreconciled", "checkbox"));
        ArchivePoolHelper.addColumnToGroup(bkerInvoiceGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getHasBeenTransfer(), "hasbeentransfer", "checkbox"));
        columns.add((AbstractReportColumn)bkerInvoiceGroup);
        ArchivePoolHelper.addAccountGroup(columns);
    }

    public static void createColumnOfBkrs(List<AbstractReportColumn> columns) {
        ReportColumnGroup bkrsHeadGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getBkrsHeadGroup(), "bkrsHeadGroup");
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getIdentificationOrg(), "identificationorg", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getBankBranchNumber(), "bankbranchnumber", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getCurrency(), "currency", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAccount(), "settlementaccount", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getCustomerName(), "accountname", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getCustomerNumber(), "bankcustomernumber", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getYear(), "reconyear", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getMonth(), "reconmonth", "text"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getPrintTimes(), "printtimes", "integer"));
        ArchivePoolHelper.addColumnToGroup(bkrsHeadGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getPrintDate(), "printdate", "date"));
        columns.add((AbstractReportColumn)bkrsHeadGroup);
        ReportColumnGroup endTermGroup = ArchivePoolHelper.getColumnGroup(ArchivePoolHelper.getBkrsEndTermGroup(), "bkrsEndTermGroup");
        ArchivePoolHelper.addColumnToGroup(endTermGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAccountBal(), "accountbal", "amount"));
        ArchivePoolHelper.addColumnToGroup(endTermGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getReserveBal(), "reservebal", "amount"));
        ArchivePoolHelper.addColumnToGroup(endTermGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getFrozenBal(), "frozenbal", "amount"));
        ArchivePoolHelper.addColumnToGroup(endTermGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getOverdraftBal(), "overdraftbal", "amount"));
        ArchivePoolHelper.addColumnToGroup(endTermGroup, ArchivePoolHelper.getColumn(ArchivePoolHelper.getAvailableBal(), "availablebal", "amount"));
        columns.add((AbstractReportColumn)endTermGroup);
    }

    public static ReportColumnGroup getColumnGroup(String localeString, String fieldKey) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setCaption(new LocaleString(localeString));
        group.setFieldKey(fieldKey);
        return group;
    }

    public static ReportColumn getColumn(String localeString, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(localeString));
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        return column;
    }

    private static void addColumnToGroup(ReportColumnGroup group, ReportColumn column) {
        group.getChildren().add(column);
    }

    public static void addFieldOfNtrEv(List<String> fieldList) {
        fieldList.add("einvoiceid");
        fieldList.add("billdate");
        fieldList.add("paidamt");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("hasbeenbooked");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addFieldOfRai(List<String> fieldList) {
        fieldList.add("travelnumber");
        fieldList.add("dateofissue");
        fieldList.add("totalamountexcludingtax");
        fieldList.add("taxrate");
        fieldList.add("taxamount");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenbooked");
        fieldList.add("hasbeendeducted");
        fieldList.add("deductiontaxperiod");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addFieldOfAtr(List<String> fieldList) {
        fieldList.add("travelnumber");
        fieldList.add("fare");
        fieldList.add("issueparty");
        fieldList.add("issuedate");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("hasbeenbooked");
        fieldList.add("hasbeendeducted");
        fieldList.add("deductiontaxperiod");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addFieldOfBkrs(List<String> fieldList) {
        fieldList.add("identificationorg");
        fieldList.add("bankbranchnumber");
        fieldList.add("currency");
        fieldList.add("settlementaccount");
        fieldList.add("accountname");
        fieldList.add("bankcustomernumber");
        fieldList.add("reconyear");
        fieldList.add("reconmonth");
        fieldList.add("printtimes");
        fieldList.add("printdate");
        fieldList.add("accountbal");
        fieldList.add("reservebal");
        fieldList.add("frozenbal");
        fieldList.add("overdraftbal");
        fieldList.add("availablebal");
    }

    public static void addFieldOfBke(List<String> fieldList) {
        fieldList.add("identifyingcode");
        fieldList.add("transactionamountinfigure");
        fieldList.add("currency");
        fieldList.add("contractnumber");
        fieldList.add("typeofinvoice");
        fieldList.add("dateofissue");
        fieldList.add("uniquecode");
        fieldList.add("payandrevamount");
        fieldList.add("hasbeenclaimed");
        fieldList.add("hasbeenreconciled");
        fieldList.add("hasbeentransfer");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addFieldOfInvoiceOrdOrSpc(List<String> fieldList) {
        fieldList.add("uniquecode");
        fieldList.add("nameofseller");
        fieldList.add("taxsocialcreditcode");
        fieldList.add("totalamountexcludingtax");
        fieldList.add("totaltaxamount");
        fieldList.add("taxincludedamountinfigure");
        fieldList.add("dateofissue");
        fieldList.add("contractnumber");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("matchingstate");
        fieldList.add("amortizationmethod");
        fieldList.add("hasbeenbooked");
        fieldList.add("hasbeenfsos");
        fieldList.add("hasbeenpaid");
        fieldList.add("electronicnumber");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
        fieldList.add("beginperiod");
        fieldList.add("endperiod");
        fieldList.add("hasbeencompleted");
        fieldList.add("beginyear");
        fieldList.add("endyear");
    }

    public static void addFieldOfEInvoiceOrdOrSpc(List<String> fieldList) {
        fieldList.add("invoicenumber");
        fieldList.add("nameofseller");
        fieldList.add("taxsocialcreditcode");
        fieldList.add("totalamountexcludingtax");
        fieldList.add("totaltaxamount");
        fieldList.add("taxincludedamountinfigure");
        fieldList.add("dateofissue");
        fieldList.add("contractnumber");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("matchingstate");
        fieldList.add("amortizationmethod");
        fieldList.add("hasbeenbooked");
        fieldList.add("hasbeenfsos");
        fieldList.add("hasbeenpaid");
        fieldList.add("electronicnumber");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
        fieldList.add("beginperiod");
        fieldList.add("endperiod");
        fieldList.add("hasbeencompleted");
        fieldList.add("beginyear");
        fieldList.add("endyear");
    }

    public static void addFieldOfEfi(List<String> fieldList) {
        fieldList.add("einvoiceid");
        fieldList.add("dateofissue");
        fieldList.add("totalamount");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("hasbeenbooked");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addFieldOfEINV(List<String> fieldList) {
        fieldList.add("invoicenumber");
        fieldList.add("nameofseller");
        fieldList.add("taxsocialcreditcode");
        fieldList.add("totalamountexcludingtax");
        fieldList.add("totaltaxamount");
        fieldList.add("taxincludedamountinfigure");
        fieldList.add("dateofissue");
        fieldList.add("contractnumber");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("matchingstate");
        fieldList.add("amortizationmethod");
        fieldList.add("hasbeenbooked");
        fieldList.add("hasbeenfsos");
        fieldList.add("hasbeenpaid");
        fieldList.add("electronicnumber");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
        fieldList.add("beginperiod");
        fieldList.add("endperiod");
        fieldList.add("hasbeencompleted");
        fieldList.add("beginyear");
        fieldList.add("endyear");
    }

    public static void addFieldOfInvoiceTlf(List<String> fieldList) {
        fieldList.add("uniquecode");
        fieldList.add("nameofseller");
        fieldList.add("taxsocialcreditcode");
        fieldList.add("totalamountexcludingtax");
        fieldList.add("totaltaxamount");
        fieldList.add("taxincludedamountinfigure");
        fieldList.add("dateofissue");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("hasbeenconfirmed");
        fieldList.add("usageconfirmation");
        fieldList.add("usageconfirmationperiod");
        fieldList.add("hasbeenbooked");
        fieldList.add("hasbeenfsos");
        fieldList.add("hasbeenpaid");
        fieldList.add("electronicnumber");
        fieldList.add("istransferredout");
        fieldList.add("transferredoutamount");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addFieldOfEFI(List<String> fieldList) {
        fieldList.add("einvoiceid");
        fieldList.add("dateofissue");
        fieldList.add("totalamount");
        fieldList.add("isredinvoice");
        fieldList.add("hasbeenchecked");
        fieldList.add("hasbeenbooked");
        fieldList.add("accountingentityname");
        fieldList.add("socialcreditcode");
    }

    public static void addSpecialFields(List<String> fieldList, String qType) {
        fieldList.add("sourcebillno");
        if (!"aef_bkrs".equals(qType)) {
            fieldList.add("vouchernumber");
        }
        switch (qType) {
            case "aef_bkrs": {
                ArchivePoolHelper.addFieldOfBkrs(fieldList);
                break;
            }
            case "aef_bkerreceiver": {
                ArchivePoolHelper.addFieldOfBke(fieldList);
                break;
            }
            case "aef_invordreceiver": {
                ArchivePoolHelper.addFieldOfInvoiceOrdOrSpc(fieldList);
                break;
            }
            case "aef_invspclreceiver": {
                ArchivePoolHelper.addFieldOfInvoiceOrdOrSpc(fieldList);
                break;
            }
            case "aef_invtlfreceiver": {
                ArchivePoolHelper.addFieldOfInvoiceTlf(fieldList);
                break;
            }
            case "aef_atrreceiver": {
                ArchivePoolHelper.addFieldOfAtr(fieldList);
                break;
            }
            case "aef_raireceiver": {
                ArchivePoolHelper.addFieldOfRai(fieldList);
                break;
            }
            case "aef_ntrevgpmreceiver": {
                ArchivePoolHelper.addFieldOfNtrEv(fieldList);
                break;
            }
            case "aef_einvordreceiver": 
            case "aef_einvspclreceiver": {
                ArchivePoolHelper.addFieldOfEINV(fieldList);
                break;
            }
            case "aef_efi": {
                ArchivePoolHelper.addFieldOfEFI(fieldList);
                break;
            }
        }
    }

    public static void addSelectFields(List<String> fieldList, String qType) {
        fieldList.add("sourcebillno");
        switch (qType) {
            case "aef_bkrs": {
                ArchivePoolHelper.addFieldOfBkrs(fieldList);
                break;
            }
            case "aef_bkerreceiver": {
                ArchivePoolHelper.addFieldOfBke(fieldList);
                break;
            }
            case "aef_invordreceiver": {
                ArchivePoolHelper.addFieldOfInvoiceOrdOrSpc(fieldList);
                break;
            }
            case "aef_invspclreceiver": {
                ArchivePoolHelper.addFieldOfInvoiceOrdOrSpc(fieldList);
                break;
            }
            case "aef_invtlfreceiver": {
                ArchivePoolHelper.addFieldOfInvoiceTlf(fieldList);
                break;
            }
            case "aef_atrreceiver": {
                ArchivePoolHelper.addFieldOfAtr(fieldList);
                break;
            }
            case "aef_raireceiver": {
                ArchivePoolHelper.addFieldOfRai(fieldList);
                break;
            }
            case "aef_ntrevgpmreceiver": {
                ArchivePoolHelper.addFieldOfNtrEv(fieldList);
                break;
            }
            case "aef_einvordreceiver": 
            case "aef_einvspclreceiver": {
                ArchivePoolHelper.addFieldOfEInvoiceOrdOrSpc(fieldList);
                break;
            }
            case "aef_efi": {
                ArchivePoolHelper.addFieldOfEfi(fieldList);
                break;
            }
        }
    }

    public static String getNumberPrefixByType(String qType) {
        List<String> lists = Arrays.asList("aef_invordreceiver", "aef_invspclreceiver", "aef_invtlfreceiver", "aef_einvordreceiver", "aef_einvspclreceiver");
        String prefix = lists.contains(qType) ? qType.split("_")[1].substring(0, 5) : qType.split("_")[1].substring(0, 3);
        return prefix.toUpperCase();
    }

    public static String getNumberFieldExpr(String qType) {
        return String.format("concat('%s',%s)", ArchivePoolHelper.getNumberPrefixByType(qType), "id");
    }
}

