/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.query.ArchivePoolHelper;

public class ArchivePoolListQuery
extends AbstractReportListDataPlugin {
    private static final String ALGO = ArchivePoolListQuery.class.getName();
    private String qType;
    private static final String TYPE = "type";
    private static final String NUMBER = "number";

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        this.initParam(filterInfo, filters);
        return QueryServiceHelper.queryDataSet((String)ALGO, (String)this.qType, (String)this.getCurSelectedFields(), (QFilter[])filters.toArray(new QFilter[0]), null).orderBy(new String[]{"archivedate desc"});
    }

    private void initParam(FilterInfo filterInfo, List<QFilter> filters) {
        QFilter commFilter;
        this.qType = filterInfo.getString("q_type");
        DynamicObject org = filterInfo.getDynamicObject("q_org");
        if (null != org) {
            long orgId = org.getLong("id");
            if (orgId > 0L) {
                filters.add(new QFilter("org", "=", (Object)orgId));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"ArchivePoolListQuery_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        Date startDate = filterInfo.getDate("startdate");
        Date endDate = filterInfo.getDate("enddate");
        if (null != startDate) {
            filters.add(new QFilter("archivedate", ">=", (Object)DateUtil.getDateWithSpecMills((Date)startDate, (int)0)));
        }
        if (null != endDate) {
            filters.add(new QFilter("archivedate", "<=", (Object)DateUtil.getDateWithSpecMills((Date)endDate, (int)999)));
        }
        if (null != (commFilter = filterInfo.getCommFilter(this.qType))) {
            filters.add(commFilter);
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        switch (this.qType) {
            case "aef_bkrs": {
                ArchivePoolHelper.createColumnOfBkrs(columns);
                columns.removeIf(column -> column instanceof ReportColumn && "vouchernumber".equals(((ReportColumn)column).getFieldKey()));
                break;
            }
            case "aef_bkerreceiver": {
                ArchivePoolHelper.createColumnOfBker(columns);
                break;
            }
            case "aef_invordreceiver": 
            case "aef_invspclreceiver": 
            case "aef_einvordreceiver": 
            case "aef_einvspclreceiver": {
                ArchivePoolHelper.createColumnOfInvoice(this.qType, columns);
                break;
            }
            case "aef_invtlfreceiver": {
                ArchivePoolHelper.createColumnOfInvoiceTlf(columns);
                break;
            }
            case "aef_atrreceiver": {
                ArchivePoolHelper.createColumnOfAtr(columns);
                break;
            }
            case "aef_raireceiver": {
                ArchivePoolHelper.createColumnOfRai(columns);
                break;
            }
            case "aef_ntrevgpmreceiver": {
                ArchivePoolHelper.createColumnOfNtrEv(columns);
                break;
            }
            case "aef_efi": {
                ArchivePoolHelper.createColumnOfEfi(columns);
                break;
            }
        }
        return columns;
    }

    private String getCurSelectedFields() {
        List<String> result = this.buildSelectFieldList();
        return String.join((CharSequence)",", result);
    }

    private List<String> buildSelectFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(20);
        fieldList.add("id");
        fieldList.add("billid");
        if (!"aef_bkrs".equals(this.qType)) {
            fieldList.add(String.format("entryentity.vouchernumber %s", "vouchernumber"));
            fieldList.add(String.format("entryentity.voucherid %s", "voucherid"));
        }
        fieldList.add("billtype");
        fieldList.add("org");
        fieldList.add("archivedate");
        fieldList.add(String.format("%s as %s", "'" + this.qType + "'", TYPE));
        fieldList.add(String.format("%s as %s", ArchivePoolHelper.getNumberFieldExpr(this.qType), NUMBER));
        ArchivePoolHelper.addSelectFields(fieldList, this.qType);
        return fieldList;
    }
}

