/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArchiveRobotApi
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(ArchiveRobotApi.class);
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");

    public SkillRunResult pullData(SkillRunContext runContext) {
        if (runContext == null) {
            throw new KDBizException(ResManager.loadKDString((String)"SkillRunContext\u4e3a\u7a7a", (String)"ArchiveQueryApi_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        SkillRunResult skillResult = runContext.getSkillResult();
        String skillNum = runContext.getSkillNum();
        Date startTime = runContext.getStartTime();
        Date endTime = runContext.getEndTime();
        if (startTime == null || endTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u622a\u6b62\u65f6\u95f4\u4e3a\u7a7a", (String)"ArchiveQueryApi_1", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
        int schemeSize = this.getSchemeSize();
        int allTimes = this.getTimesBetween(startTime, endTime);
        Date date = new Date();
        Calendar now = Calendar.getInstance();
        now.add(5, -30);
        Date startDate = now.getTime();
        int thirtyTimes = this.getTimesBetween(startDate, date);
        now.add(5, -60);
        startDate = now.getTime();
        int ninetyTimes = this.getTimesBetween(startDate, date);
        HashMap<String, String> schemeMap = new HashMap<String, String>(4);
        schemeMap.put("name", ResManager.loadKDString((String)"\u5f52\u6863\u65b9\u6848\u6570\u91cf", (String)"ArchiveQueryApi_2", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        schemeMap.put("value", String.valueOf(schemeSize));
        schemeMap.put("valueType", "0");
        schemeMap.put("number", "gdfasl");
        HashMap<String, String> thirtyTimesMap = new HashMap<String, String>(4);
        thirtyTimesMap.put("name", ResManager.loadKDString((String)"30\u5929\u5185\u5f52\u6863\u6570\u91cf", (String)"ArchiveQueryApi_4", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        thirtyTimesMap.put("value", String.valueOf(thirtyTimes));
        thirtyTimesMap.put("valueType", "0");
        thirtyTimesMap.put("number", "30tngdsl");
        HashMap<String, String> ninetyTimesMap = new HashMap<String, String>(4);
        ninetyTimesMap.put("name", ResManager.loadKDString((String)"90\u5929\u5185\u5f52\u6863\u6570\u91cf", (String)"ArchiveQueryApi_5", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        ninetyTimesMap.put("value", String.valueOf(ninetyTimes));
        ninetyTimesMap.put("valueType", "0");
        ninetyTimesMap.put("number", "90tngdsl");
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(4);
        list.add(schemeMap);
        list.add(thirtyTimesMap);
        list.add(ninetyTimesMap);
        skillResult.setData(list);
        skillResult.setDate(startTime);
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(Integer.valueOf(allTimes));
        logger.info("ArchiveQueryApi pullData skillResult: {}", (Object)skillResult);
        return skillResult;
    }

    private int getSchemeSize() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from  t_aef_archivescheme", new Object[0]);
        return this.executeSql(sqlBuilder);
    }

    private int getTimesBetween(Date startTime, Date endTime) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from  t_aef_archive_log where", new Object[0]);
        sqlBuilder.append("fexetime >= ?", new Object[]{startTime});
        sqlBuilder.append(" and fexetime <= ?", new Object[]{endTime});
        DynamicObject serviceconfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"uploadway", null);
        String uploadway = serviceconfig.getString("uploadway");
        if ("3".equals(uploadway) || "5".equals(uploadway) || "6".equals(uploadway)) {
            sqlBuilder.append(" and ftype = '1'", new Object[0]);
        }
        return this.executeSql(sqlBuilder);
    }

    private int executeSql(SqlBuilder sqlBuilder) {
        return (Integer)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                rs.next();
                return rs.getInt(1);
            }
        });
    }
}

