/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.entity.Printsample;

public class ArchiveSchemeDataUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ArchiveSchemeDataUpgradeService.class);
    private static final String ARCHIVERANGE = "archiverange";
    private static final String FINANCE = "finance";
    private static final String BILL = "bill";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        logger.info("\u5f00\u59cb\u5f52\u6863\u65b9\u6848\u6570\u636e\u5347\u7ea7");
        try {
            this.updateData();
            result.setSuccess(true);
            logger.info("ArchiveSchemeDataUpgradeService_SUCCESS");
        }
        catch (Exception e) {
            logger.info("ArchiveSchemeDataUpgradeService_ERROR");
            result.setSuccess(false);
            result.setErrorInfo("ArchiveSchemeDataUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updateData() {
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"update t_aef_archive_log set ftype='1' where ftype is null or ftype = ' ';");
        List idList = (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select fid as id from t_aef_archivescheme where farchivetype is null or farchivetype = ' '", null, e -> {
            ArrayList<Long> ids = new ArrayList<Long>(50);
            while (e.next()) {
                Long id = e.getLong("id");
                ids.add(id);
            }
            return ids;
        });
        if (idList.isEmpty()) {
            return;
        }
        Map largesamplejsonMap = (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select fentryid,flargesamplejson_tag from t_aef_archiveentry", null, e -> {
            HashMap<Long, String> tempMap = new HashMap<Long, String>(50);
            while (e.next()) {
                String tag = e.getString("flargesamplejson_tag");
                if (!StringUtils.isNotEmpty((CharSequence)tag)) continue;
                tempMap.put(e.getLong("fentryid"), tag);
            }
            return tempMap;
        });
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_archivescheme");
        BusinessDataServiceHelper.removeCache((DynamicObjectType)type);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(new Long[0]), (String)"aef_archivescheme");
        if (null == objectMap || objectMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(50);
        ArrayList<DynamicObject> newRows = new ArrayList<DynamicObject>(50);
        ArrayList<Object[]> params = new ArrayList<Object[]>(50);
        ArrayList<Object[]> logParams = new ArrayList<Object[]>(20);
        for (DynamicObject scheme : objectMap.values()) {
            String archiveType;
            DynamicObjectCollection entitys = (DynamicObjectCollection)scheme.get("entryentity");
            if (null == entitys) continue;
            if (entitys.size() == 1) {
                DynamicObject entity = (DynamicObject)entitys.get(0);
                archiveType = this.getArchiveTypeByEntryId(entity.getLong("id"));
                this.setArchiveRange(entity, archiveType, largesamplejsonMap);
                this.setArchiverangeJson(entity, archiveType);
                rows.add(scheme);
                params.add(new Object[]{archiveType, scheme.getLong("id")});
                continue;
            }
            if (entitys.size() <= 1) continue;
            Set<String> archiveTypeSet = this.getArchiveTypeSet(scheme.getLong("id"));
            if (archiveTypeSet.isEmpty()) {
                return;
            }
            if (archiveTypeSet.contains(FINANCE) && archiveTypeSet.contains(BILL)) {
                CloneUtils util = new CloneUtils(true, true);
                DynamicObject newBillScheme = (DynamicObject)util.clone((IDataEntityBase)scheme);
                this.setField(scheme, newBillScheme);
                DynamicObjectCollection financeList = new DynamicObjectCollection();
                DynamicObjectCollection billList = new DynamicObjectCollection();
                int billSeq = 1;
                int financeSeq = 1;
                for (DynamicObject entity : entitys) {
                    String archivetype = this.getArchiveTypeByEntryId(entity.getLong("id"));
                    if (FINANCE.equals(archivetype)) {
                        entity.set("seq", (Object)financeSeq);
                        this.setArchiveRange(entity, archivetype, largesamplejsonMap);
                        financeList.add((Object)entity);
                        ++financeSeq;
                        continue;
                    }
                    if (!BILL.equals(archivetype)) continue;
                    DynamicObject newEntity = (DynamicObject)util.clone((IDataEntityBase)entity);
                    newEntity.set("id", (Object)entity.getLong("id"));
                    this.setArchiverangeJson(newEntity, archivetype);
                    newEntity.set("seq", (Object)billSeq);
                    billList.add((Object)newEntity);
                    ++billSeq;
                }
                scheme.set("entryentity", (Object)financeList);
                rows.add(scheme);
                newBillScheme.set("entryentity", (Object)billList);
                newRows.add(newBillScheme);
                params.add(new Object[]{FINANCE, scheme.getLong("id")});
                params.add(new Object[]{BILL, newBillScheme.getLong("id")});
                logParams.add(new Object[]{newBillScheme.getLong("id"), scheme.getLong("id")});
                continue;
            }
            if (archiveTypeSet.size() != 1 || !FINANCE.equals(archiveType = archiveTypeSet.iterator().next()) && !BILL.equals(archiveType)) continue;
            for (DynamicObject object : entitys) {
                this.setArchiveRange(object, archiveType, largesamplejsonMap);
                this.setArchiverangeJson(object, archiveType);
            }
            rows.add(scheme);
            params.add(new Object[]{archiveType, scheme.getLong("id")});
        }
        SaveServiceHelper.save((DynamicObject[])rows.toArray(new DynamicObject[0]));
        if (!newRows.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])newRows.toArray(new DynamicObject[0]));
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"update t_aef_archivescheme set farchivetype=? where fid=?", params);
        if (!logParams.isEmpty()) {
            String updateLogSql = "update t_aef_archive_log set fwayid=? where fwayid=? and fbilltype not in ('cas_balanceadjust','cas_bankstatement','fa_card_fin','gl_rpt_generalledger','gl_rpt_subledger','gl_voucher');";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateLogSql, logParams);
        }
    }

    private void setField(DynamicObject scheme, DynamicObject newBillScheme) {
        Long newBillFid = DBServiceHelper.genLongIds((String)"t_aef_archivescheme", (int)1)[0];
        newBillScheme.set("id", (Object)newBillFid);
        newBillScheme.set("number", (Object)(scheme.get("number") + "#"));
        LocaleDynamicObjectCollection local = (LocaleDynamicObjectCollection)newBillScheme.get("multilanguagetext");
        if (null != local && !local.isEmpty()) {
            for (DynamicObject dynamicObject : local) {
                String fpkId = DBServiceHelper.genStringId();
                dynamicObject.set("pkid", (Object)fpkId);
                String newZh = dynamicObject.get("name") + "#";
                dynamicObject.set("name", (Object)newZh);
            }
        }
    }

    private void setArchiverangeJson(DynamicObject obj, String archiveType) {
        String json;
        if (BILL.equals(archiveType) && StringUtils.isNotEmpty((CharSequence)(json = obj.getString("archiverangejson")))) {
            String billNumber = obj.getString("billtype.number");
            HashSet<String> dateFiledSet = new HashSet<String>(16);
            MainEntityType entityType = null;
            try {
                entityType = EntityMetadataCache.getDataEntityType((String)billNumber);
                EntityTypeUtil util = new EntityTypeUtil();
                List filterColumns = util.getFilterColumns((IDataEntityType)entityType);
                for (Map filterColumn : filterColumns) {
                    String type = (String)filterColumn.get("type");
                    String fieldName = (String)filterColumn.get("fieldName");
                    if (null == type || !type.startsWith("date")) continue;
                    dateFiledSet.add(fieldName);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            List filterRow = fc.getFilterRow();
            if (null != entityType) {
                filterRow.removeIf(row -> dateFiledSet.contains(row.getFieldName()));
                FilterBuilder filterBuilder = new FilterBuilder(entityType, fc, false);
                filterBuilder.buildFilter(false);
                String filterStr = filterBuilder.getFilterString();
                filterStr = filterStr.replaceAll("\\s{3,}", "  ");
                if (filterStr.length() > 500) {
                    filterStr = filterStr.substring(0, 500) + "...";
                }
                obj.set(ARCHIVERANGE, (Object)filterStr);
                obj.set("archiverangejson", (Object)SerializationUtils.toJsonString((Object)fc));
            }
        }
    }

    private void setArchiveRange(DynamicObject obj, String archiveType, Map<Long, String> map) {
        List list;
        Long entryid;
        String largesamplejsonTag;
        if (!FINANCE.equals(archiveType)) {
            return;
        }
        String archiverange = null;
        if ("gl_voucher".equals(obj.getString("billtype.number")) && StringUtils.isNotEmpty((CharSequence)(largesamplejsonTag = map.get(entryid = (Long)obj.getPkValue()))) && null != (list = SerializationUtils.fromJsonStringToList((String)largesamplejsonTag, Printsample.class)) && !list.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Printsample printsample : list) {
                builder.append(this.getBillName(printsample));
                builder.append('\uff0c');
            }
            archiverange = builder.toString();
            if (StringUtils.isNotEmpty((CharSequence)archiverange) && (archiverange = archiverange.substring(0, archiverange.length() - 1)).length() > 500) {
                archiverange = archiverange.substring(0, 500) + "...";
            }
        }
        if (null != archiverange) {
            obj.set(ARCHIVERANGE, archiverange);
        } else {
            obj.set(ARCHIVERANGE, (Object)"");
        }
    }

    private String getBillName(Printsample printsample) {
        String billName;
        try {
            String billType = printsample.getBillType();
            billName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
        }
        catch (Exception e) {
            billName = printsample.getRefbillsampleName();
            logger.error((Throwable)e);
        }
        return billName;
    }

    private String getArchiveTypeByEntryId(Long entryId) {
        return (String)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select farchivetype as archivetype from t_aef_archiveentry where fentryid = ? ", (Object[])new Object[]{entryId}, e -> {
            if (e.next()) {
                return e.getString("archivetype");
            }
            return "";
        });
    }

    private Set<String> getArchiveTypeSet(Long id) {
        return (Set)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select farchivetype as archivetype from t_aef_archiveentry where fid = ? group by farchivetype ", (Object[])new Object[]{id}, e -> {
            HashSet<String> set = new HashSet<String>(2);
            while (e.next()) {
                set.add(e.getString("archivetype"));
            }
            return set;
        });
    }
}

