/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.upgradeservice.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class FaPermissionUpgradeServiceImpl {
    public static final String DELIMITER = "_split_";

    public void addPermItemsByExistPermItem(List<String> existPermInfoList, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        this.processUserPerm(existPermInfoList, newEntityTypeID, newAppID, newPermItemIds);
        this.processRolePerm(existPermInfoList, newEntityTypeID, newAppID, newPermItemIds);
        this.processBizRolePerm(existPermInfoList, newEntityTypeID, newAppID, newPermItemIds);
        PermissionServiceHelper.clearAllCache();
    }

    private void processBizRolePerm(List<String> existPermInfoList, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Set parentIds = new HashSet(existPermInfoList.size());
        for (int i = 0; i < existPermInfoList.size(); ++i) {
            String info = existPermInfoList.get(i);
            String[] split = info.split(DELIMITER);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid from t_perm_bizroleperm where fpermitemid = ? and fentitytypeid = ? and fbizappid = ? ", new Object[]{split[0], split[1], split[2]});
            Set idSet = (Set)DB.query((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder, r -> {
                HashSet<String> ids = new HashSet<String>(4);
                while (r.next()) {
                    ids.add(r.getString("fid"));
                }
                return ids;
            });
            if (i == 0) {
                parentIds = idSet;
                continue;
            }
            parentIds.retainAll(idSet);
        }
        String insertSql = "INSERT INTO t_perm_bizroleperm(FID,FENTRYID,FSEQ,FPERMITEMID,FENTITYTYPEID,FBIZAPPID) VALUES (?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set<String> hadPermIds = this.getHadPermIds(newEntityTypeID, newAppID, newPermItemID, "select fid from t_perm_bizroleperm where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", 4);
            HashSet realIds = new HashSet(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(4);
            int i = 0;
            long[] entryIds = this.getLongIds(pidSize);
            for (String pid : realIds) {
                Object[] param = new Object[]{Long.parseLong(pid), entryIds[i], 0, newPermItemID, newEntityTypeID, newAppID};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                this.batchExecute(insertSql, paramCache);
                paramCache.clear();
            }
        }
    }

    private void processRolePerm(List<String> existPermInfoList, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Set parentIds = new HashSet(existPermInfoList.size());
        for (int i = 0; i < existPermInfoList.size(); ++i) {
            String info = existPermInfoList.get(i);
            String[] split = info.split(DELIMITER);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid from t_perm_rolepermdetial where  fpermitemid = ? and fentitytypeid = ? and fbizappid = ? ", new Object[]{split[0], split[1], split[2]});
            Set idSet = (Set)DB.query((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder, r -> {
                HashSet<String> ids = new HashSet<String>(8);
                while (r.next()) {
                    ids.add(r.getString("fid"));
                }
                return ids;
            });
            if (i == 0) {
                parentIds = idSet;
                continue;
            }
            parentIds.retainAll(idSet);
        }
        String insertSql = "INSERT INTO T_PERM_ROLEPERMDETIAL(FID,FENTRYID,FSEQ,FCONTROLMODE,FPERMITEMID,FINHERITMODE,FENTITYTYPEID,FBIZAPPID) VALUES (?,?,?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set<String> hadPermIds = this.getHadPermIds(newEntityTypeID, newAppID, newPermItemID, "select fid from T_PERM_ROLEPERMDETIAL where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", 8);
            HashSet realIds = new HashSet(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(8);
            int i = 0;
            String[] entryIds = this.genStringIds("T_PERM_ROLEPERMDETIAL", pidSize);
            for (String pid : realIds) {
                Object[] param = new Object[]{pid, entryIds[i], 0, Character.valueOf(' '), newPermItemID, Character.valueOf(' '), newEntityTypeID, newAppID};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                this.batchExecute(insertSql, paramCache);
                paramCache.clear();
            }
        }
    }

    private void processUserPerm(List<String> existPermInfoList, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Map headFieldsMap;
        SqlBuilder sqlBuilder;
        Set noPermParentIds = new HashSet(existPermInfoList.size());
        for (int i = 0; i < existPermInfoList.size(); ++i) {
            String info = existPermInfoList.get(i);
            String[] split = info.split(DELIMITER);
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select p.fid as fid from t_perm_userperm as p inner join t_perm_disfunperm as d on p.fuserid=d.fuserid and p.forgid=d.forgid where d.fpermitemid = ? and d.fentitytypeid = ? and d.fbizappid = ? ", new Object[]{split[0], split[1], split[2]});
            Set idSet = (Set)DB.query((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder, r -> {
                HashSet<String> ids = new HashSet<String>(16);
                while (r.next()) {
                    ids.add(r.getString("fid"));
                }
                return ids;
            });
            if (i == 0) {
                noPermParentIds = idSet;
                continue;
            }
            noPermParentIds.retainAll(idSet);
        }
        Set parentIds = new HashSet(existPermInfoList.size());
        for (int i = 0; i < existPermInfoList.size(); ++i) {
            String info = existPermInfoList.get(i);
            String[] split = info.split(DELIMITER);
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid from T_PERM_USERPERMDETAIL where fpermitemid = ? and fentitytypeid = ? and fbizappid = ? ", new Object[]{split[0], split[1], split[2]});
            Set idSet = (Set)DB.query((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder, r -> {
                HashSet<String> ids = new HashSet<String>(32);
                while (r.next()) {
                    String fid = r.getString("fid");
                    ids.add(fid);
                }
                return ids;
            });
            if (i == 0) {
                parentIds = idSet;
                continue;
            }
            parentIds.retainAll(idSet);
        }
        parentIds.removeAll(noPermParentIds);
        if (parentIds.isEmpty()) {
            headFieldsMap = new HashMap(0);
        } else {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fuserid, forgid, fisincludesuborg from t_perm_userperm where ", new Object[0]);
            sqlBuilder.appendIn("fid", parentIds.toArray());
            headFieldsMap = (Map)DB.query((DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder, r -> {
                HashMap<String, String> headFieldMap = new HashMap<String, String>(16);
                while (r.next()) {
                    String id = r.getString("fid");
                    String userId = r.getString("fuserid");
                    String orgId = r.getString("forgid");
                    String isIncludeSubOrg = r.getString("fisincludesuborg");
                    headFieldMap.put(id, String.join((CharSequence)DELIMITER, userId, orgId, isIncludeSubOrg));
                }
                return headFieldMap;
            });
        }
        String insertSql = "INSERT INTO T_PERM_USERPERMDETAIL(FID,FENTRYID,FSEQ,FCONTROLMODE,FPERMITEMID,FENTITYTYPEID,FBIZAPPID,FSOURCE,FBIZROLEID,FUSERID,FDIMTYPE,FDIMID,FISINCLUDESUB) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set<String> hadPermIds = this.getHadPermIds(newEntityTypeID, newAppID, newPermItemID, "select fid from T_PERM_USERPERMDETAIL where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", 32);
            HashSet realIds = new HashSet(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(32);
            int i = 0;
            String[] entryIds = this.genStringIds("T_PERM_USERPERMDETAIL", pidSize);
            for (String pid : realIds) {
                String headFields = (String)headFieldsMap.get(pid);
                String[] headFieldArr = headFields.split(DELIMITER);
                Object[] param = new Object[]{pid, entryIds[i], 0, 10, newPermItemID, newEntityTypeID, newAppID, 1, 0, Long.parseLong(headFieldArr[0]), "bos_org", Long.parseLong(headFieldArr[1]), headFieldArr[2]};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                this.batchExecute(insertSql, paramCache);
                paramCache.clear();
            }
        }
    }

    private void batchExecute(String insertSql, List<Object[]> paramCache) {
        DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, paramCache);
    }

    private String[] genStringIds(String tableName, int pidSize) {
        return DB.genStringIds((String)tableName, (int)pidSize);
    }

    private long[] getLongIds(int pidSize) {
        return DB.genLongIds((String)"t_perm_bizroleperm", (int)pidSize);
    }

    private Set<String> getHadPermIds(String newEntityTypeID, String newAppID, String newPermItemID, String sql, int initialCapacity) {
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{newPermItemID, newEntityTypeID, newAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(initialCapacity);
            while (r.next()) {
                String fid = r.getString("fid");
                ids.add(fid);
            }
            return ids;
        });
    }
}

