/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.permission.mservice.PermissionUpgradeServiceImpl;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class AiPermissionUpgradeService
implements IUpgradeService {
    private static final String viewPer = "47150e89000000ac";
    private static final String iepAppId = "3815fd11000209ac";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle han = TX.requiresNew();){
            try {
                PermissionUpgradeServiceImpl perService = new PermissionUpgradeServiceImpl();
                this.addAiEventPerToIep(perService);
            }
            catch (Exception exc) {
                han.markRollback();
                result.setSuccess(false);
                result.setErrorInfo("AcctMapTypeMultiAcctTabUpdateFailed" + ExceptionUtils.getExceptionStackTraceMessage((Exception)exc));
            }
        }
        return result;
    }

    private void addAiEventPerToIep(PermissionUpgradeServiceImpl perService) {
        String newEntity = "ai_event";
        ArrayList<String> newPers = new ArrayList<String>();
        newPers.add(viewPer);
        perService.addPermItemsByExistPermItem(viewPer, newEntity, "ai", newEntity, iepAppId, newPers);
        newEntity = "ai_eventclass";
        ArrayList<String> classNewPers = new ArrayList<String>();
        classNewPers.add(viewPer);
        classNewPers.add("47156aff000000ac");
        classNewPers.add("4715a0df000000ac");
        classNewPers.add("4715e1f1000000ac");
        classNewPers.add("47160c2b000000ac");
        classNewPers.add("47162f66000000ac");
        classNewPers.add("47165e8e000000ac");
        classNewPers.add("4730fc5d000000ac");
        classNewPers.add("4730fc9f000003ae");
        classNewPers.add("4730fc9f000004ae");
        classNewPers.add("804f6478000000ac");
        classNewPers.add("80513207000000ac");
        perService.addPermItemsByExistPermItem(viewPer, newEntity, "ai", newEntity, iepAppId, classNewPers);
    }
}

