/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.permission.mservice.PermissionUpgradeServiceImpl;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class BaseDataPermissionUpgradeService
implements IUpgradeService {
    private static final String viewPer = "47150e89000000ac";
    private static final String iepAppId = "3815fd11000209ac";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle han = TX.requiresNew();){
            try {
                PermissionUpgradeServiceImpl perService = new PermissionUpgradeServiceImpl();
                this.addBaseDataPer(perService);
            }
            catch (Exception exc) {
                han.markRollback();
                result.setSuccess(false);
                result.setErrorInfo("AcctMapTypeMultiAcctTabUpdateFailed" + ExceptionUtils.getExceptionStackTraceMessage((Exception)exc));
            }
        }
        return result;
    }

    private void addBaseDataPer(PermissionUpgradeServiceImpl perService) {
        ArrayList<String> entityLists = new ArrayList<String>();
        entityLists.add("ai_asstdimmaptype");
        entityLists.add("ai_accountmaptype");
        entityLists.add("ai_basedatamapping");
        entityLists.add("ai_vchchangefield");
        ArrayList<String> newPers = new ArrayList<String>();
        newPers.add("4730fc9f000003ae");
        newPers.add("4730fc9f000004ae");
        for (String entityId : entityLists) {
            perService.addPermItemsByExistPermItem(viewPer, entityId, iepAppId, entityId, iepAppId, newPers);
            perService.addPermItemsByExistPermItem(viewPer, entityId, "ai", entityId, iepAppId, newPers);
        }
    }
}

