/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class ExtDataModelUpdateFieldLengthUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.ExtDataModelUpdateFieldLengthUpgradeService");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.ai.upgradeservice.ExtDataModelUpdateFieldLengthUpgradeService", (DBRoute)FAHCommonConstant.AI, (String)"select fnumber from t_ai_eventclass");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String tableName = DataModelDaoImpl.getTableName((String)row.getString("fnumber"));
                if (!DB.exitsTable((DBRoute)FAHCommonConstant.AI, (String)tableName)) continue;
                DataModelDaoImpl.updateFieldLength((DBRoute)FAHCommonConstant.AI, (String)tableName, (String)"fdescription", (Integer)FAHCommonConstant.DESCRIPTION_LENGTH_DATA);
            }
            result.setSuccess(true);
            log.info("ExtDataModelUpdateFieldLengthUpgradeService_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("ExtDataModelUpdateFieldLengthUpgradeService_ERROR");
            result.setErrorInfo("ExtDataModelUpdateFieldLengthUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }
}

