/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.Date;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.v2.fah.dao.biz.SDOSaveHelper;
import kd.fi.v2.fah.utils.ParamUtils;

public class MarkExtDataClientTypeUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(MarkExtDataClientTypeUpgradeService.class);
    private static String querySql = "select count(1) cnt from t_ai_eventclass where fappversion = '0'";
    private static String deleteSql = "delete t_ai_sysparam where fkey in (?,?,?)";
    private static Object[] deleteParam = new Object[]{"fah.extData.client.type.mark", "fah.extData.client.type.mark.time", "fah.extData.client.type.mark.code"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.markExtDataClientType();
            result.setSuccess(true);
            logger.info("MarkExtDataClientType_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            logger.info("MarkExtDataClientType_ERROR");
            result.setErrorInfo("MarkExtDataClientType_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void markExtDataClientType() {
        boolean hasOld = this.hasOldModel();
        String mark = hasOld ? "0" : "1";
        Date now = new Date();
        String time = DateUtils.formatString((Date)now, (String)"yyyy-MM-dd HH:mm:ss");
        String code = ParamUtils.encode((String)mark, (Long)now.getTime());
        this.saveMark(mark, time, code);
    }

    private boolean hasOldModel() {
        int count = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"MarkExtDataClientTypeUpgradeService.hasOldModel", (DBRoute)DBRoute.of((String)"ai"), (String)querySql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                count = row.getInteger("cnt");
            }
        }
        return count > 0;
    }

    private void saveMark(String mark, String time, String code) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"ai"), (String)deleteSql, (Object[])deleteParam);
                LinkedList<Object[]> saveParamList = new LinkedList<Object[]>();
                Long[] ids = SDOSaveHelper.getIds((String)"t_ai_sysparam", (String)"ai", (int)3);
                saveParamList.add(new Object[]{ids[0], "fah.extData.client.type.mark", mark, time});
                saveParamList.add(new Object[]{ids[1], "fah.extData.client.type.mark.time", time, time});
                saveParamList.add(new Object[]{ids[2], "fah.extData.client.type.mark.code", code, time});
                DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)ParamUtils.saveSql, saveParamList);
                logger.info("saveMark success\uff1amark:{}, time:{}, code:{}", new Object[]{mark, time, code});
            }
            catch (Exception e) {
                logger.info("saveMark error\uff1amark:{}, time:{}, code:{}", new Object[]{mark, time, code, e});
                tx.markRollback();
                throw e;
            }
        }
    }
}

