/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.permUserperm;

public class PermissionUpgradeServiceImpl {
    public void addPermItemsByExistPermItem(String existPermItemID, String existEntityTypeID, String existAppID, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        this.processUserPerm(existPermItemID, existEntityTypeID, existAppID, newEntityTypeID, newAppID, newPermItemIds);
        PermissionServiceHelper.clearAllCache();
    }

    private void processUserPerm(String existPermItemID, String existEntityTypeID, String existAppID, String newEntityTypeID, String newAppID, List<String> newPermItemIds) {
        Set noPermParentIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select p.fid as fid from t_perm_userperm as p inner join t_perm_disfunperm as d on p.fuserid=d.fuserid and p.forgid=d.forgid where d.fpermitemid=? and d.fentitytypeid=? and d.fbizappid=?;", (Object[])new Object[]{existPermItemID, existEntityTypeID, existAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(16);
            while (r.next()) {
                ids.add(r.getString("fid"));
            }
            return ids;
        });
        Set parentIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)"select fid from T_PERM_USERPERMDETAIL where fpermitemid=? and fentitytypeid=? and fbizappid=?;", (Object[])new Object[]{existPermItemID, existEntityTypeID, existAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(32);
            while (r.next()) {
                String fid = r.getString("fid");
                ids.add(fid);
            }
            return ids;
        });
        parentIds.removeAll(noPermParentIds);
        String insertSql = "INSERT INTO T_PERM_USERPERMDETAIL(FID,FENTRYID,FSEQ,FCONTROLMODE,FPERMITEMID,FENTITYTYPEID,FBIZAPPID,FSOURCE,FBIZROLEID,FUSERID,FDIMTYPE,FDIMID,FISINCLUDESUB) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?);";
        for (String newPermItemID : newPermItemIds) {
            Set<String> hadPermIds = this.getHadPermIds(newEntityTypeID, newAppID, newPermItemID, "select fid from T_PERM_USERPERMDETAIL where FPERMITEMID=? and fentitytypeid=? and fbizappid=?;", 32);
            HashSet<String> realIds = new HashSet<String>(parentIds);
            realIds.removeAll(hadPermIds);
            int pidSize = realIds.size();
            HashMap<String, permUserperm> map = new HashMap<String, permUserperm>(8);
            List<Set<String>> all_task_billids = PermissionUpgradeServiceImpl.splitSet(realIds, 10000);
            for (Set<String> ids : all_task_billids) {
                QFilter IdFilter = new QFilter("id", "in", ids);
                DataSet set = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.upgradeservice.PermissionUpgradeServiceImpl", (String)"perm_userperm", (String)"id,entryentity.dim_id dimid,entryentity.dim_type dimtype,entryentity.userfield userid ,entryentity.includesub includesub", (QFilter[])new QFilter[]{IdFilter}, null);
                Throwable throwable = null;
                try {
                    for (Row row : set) {
                        permUserperm userperm = new permUserperm();
                        userperm.setId(row.getString("id"));
                        userperm.setDimid(row.getLong("dimid"));
                        userperm.setDimtype(row.getString("dimtype"));
                        userperm.setIncludesub(row.getString("includesub"));
                        userperm.setUserfield(row.getLong("userid"));
                        map.put(row.getString("id"), userperm);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (set == null) continue;
                    if (throwable != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    set.close();
                }
            }
            ArrayList<Object[]> paramCache = new ArrayList<Object[]>(32);
            int i = 0;
            String[] entryIds = this.genStringIds("T_PERM_USERPERMDETAIL", pidSize);
            if (map.isEmpty()) continue;
            for (String pid : realIds) {
                permUserperm userperm = (permUserperm)map.get(pid);
                Long userid = userperm.getUserfield();
                String type = userperm.getDimtype();
                Long dimid = userperm.getDimid();
                String flag = "true".equals(userperm.getIncludesub()) ? "1" : "0";
                Object[] param = new Object[]{pid, entryIds[i], 0, 10, newPermItemID, newEntityTypeID, newAppID, 1, 0, userid, type, dimid, flag};
                paramCache.add(param);
                if (++i % 1000 != 0 && i != pidSize) continue;
                this.batchExecute(insertSql, paramCache);
                paramCache.clear();
            }
        }
    }

    private void batchExecute(String insertSql, List<Object[]> paramCache) {
        DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, paramCache);
    }

    private String[] genStringIds(String tableName, int pidSize) {
        return DB.genStringIds((String)tableName, (int)pidSize);
    }

    private Set<String> getHadPermIds(String newEntityTypeID, String newAppID, String newPermItemID, String sql, int initialCapacity) {
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{newPermItemID, newEntityTypeID, newAppID}, r -> {
            HashSet<String> ids = new HashSet<String>(initialCapacity);
            while (r.next()) {
                String fid = r.getString("fid");
                ids.add(fid);
            }
            return ids;
        });
    }

    public static List<Set<String>> splitSet(Set<String> ids, int batchSize) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>(8);
        int i = 0;
        HashSet<String> data = new HashSet<String>(batchSize);
        for (String id : ids) {
            data.add(id);
            if (++i % batchSize != 0 && i != ids.size()) continue;
            result.add(new HashSet(data));
            data.clear();
        }
        return result;
    }
}

