/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class VchCtrlStrategyUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.VchCtrlStrategyUpgradeService");
    private static final String CTRL_STRATEGY = "select a.fid, b.fdefaultctrlstrategy from t_bd_basedataview a, t_bd_defaultctrlstrategy b where a.fbasedataid = b.fbasedataid and a.fbasedataid = 'ai_vchtemplate' ";
    private static final String CTRL_STRATEGYROW = "select fid,fcuid from T_BD_CtrlStrategy t where fbasedataviewid = ? ";
    private static final String VCH_TEMPLATESQL = "select fcreateorgid from t_ai_vchtemplate t group by fcreateorgid ";
    private static final String ORG_TEMPLATESQL = "select fid from t_org_org t where ";
    private static final String INSERTSTRATEGYS = "insert into t_bd_ctrlstrategy(fmodifierid,fcreatorid,fbasedataviewid,fcuid,fdisablerid,fmasterid,fmodifytime,fcreatetime,fenable,fstatus,fdisabledate,fnumber,fid) values (?,?,?,?,?,?,?,?,?,?,?,?,?) ";
    private static final String INSERTDETAILS = "insert into t_bd_ctrlstrategydetail(fid,fcreateorgid,fmanagestrategy,fctrlstrategy,fctrltype,fseq,fentryid) values (?,?,?,?,?,?,?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info("class VchCtrlStrategyUpgradeService Execute starting...");
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        log.info("class VchCtrlStrategyUpgradeService Execute end...");
        return result;
    }

    private void upgrade() throws Exception {
        Object row2;
        String viewId = null;
        String defaultStrategy = null;
        try (DataSet defaultData = this.getSrategyData();){
            for (Object row2 : defaultData) {
                viewId = row2.getString("fid");
                defaultStrategy = row2.getString("fdefaultctrlstrategy");
            }
        }
        if (StringUtils.isBlank(viewId) || StringUtils.isBlank(defaultStrategy)) {
            log.info("VchCtrlStrategyUpgradeService no data to upgrade:{},{}", (Object)viewId, defaultStrategy);
            return;
        }
        log.info("VchCtrlStrategyUpgradeService viewId:{}, defaultData:{}", (Object)viewId, (Object)defaultStrategy);
        ArrayList<Long> rowList = new ArrayList<Long>(10);
        DataSet rowData = this.getSrategyRowData(viewId);
        Object object = null;
        try {
            for (Object row3 : rowData) {
                rowList.add(row3.getLong("fcuid"));
            }
        }
        catch (Throwable row2) {
            object = row2;
            throw row2;
        }
        finally {
            if (rowData != null) {
                if (object != null) {
                    try {
                        rowData.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)object).addSuppressed(row2);
                    }
                } else {
                    rowData.close();
                }
            }
        }
        if (rowList.isEmpty()) {
            log.info("VchCtrlStrategyUpgradeService no rowData to upgrade:{}", rowList);
            return;
        }
        log.info("VchCtrlStrategyUpgradeService rowMap to upgrade:{}", rowList);
        ArrayList<Long> vchOrgId = new ArrayList<Long>(10);
        DataSet vchOrgData = this.getVchTemplateOrgData();
        row2 = null;
        try {
            for (Row row4 : vchOrgData) {
                vchOrgId.add(row4.getLong("fcreateorgid"));
            }
        }
        catch (Throwable row3) {
            row2 = row3;
            throw row3;
        }
        finally {
            if (vchOrgData != null) {
                if (row2 != null) {
                    try {
                        vchOrgData.close();
                    }
                    catch (Throwable row3) {
                        ((Throwable)row2).addSuppressed(row3);
                    }
                } else {
                    vchOrgData.close();
                }
            }
        }
        if (vchOrgId.isEmpty()) {
            return;
        }
        log.info("VchCtrlStrategyUpgradeService vchOrgId to upgrade:{}", vchOrgId);
        vchOrgId.removeAll(rowList);
        log.info("VchCtrlStrategyUpgradeService vchOrgId remove end:{}", vchOrgId);
        if (vchOrgId.isEmpty()) {
            return;
        }
        ArrayList<Long> orgList = new ArrayList<Long>(vchOrgId.size());
        for (Long orgId : vchOrgId) {
            orgList.add(orgId);
        }
        ArrayList<Long> vchQueryOrgId = new ArrayList<Long>(vchOrgId.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(ORG_TEMPLATESQL, new Object[0]).appendIn("fid", orgList);
        try (DataSet qd = DB.queryDataSet((String)VchCtrlStrategyUpgradeService.class.getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
            for (Row row5 : qd) {
                vchQueryOrgId.add(row5.getLong("fid"));
            }
        }
        log.info("VchCtrlStrategyUpgradeService vchQueryOrgId query end:{}", vchQueryOrgId);
        if (!vchQueryOrgId.isEmpty()) {
            this.buildStrategyData(viewId, defaultStrategy, vchQueryOrgId);
        }
    }

    private DataSet getSrategyData() {
        DBRoute route = DBRoute.of((String)"sys");
        DataSet srategyData = DB.queryDataSet((String)VchCtrlStrategyUpgradeService.class.getName(), (DBRoute)route, (String)CTRL_STRATEGY);
        return srategyData;
    }

    private DataSet getSrategyRowData(String baseDataViewId) {
        DBRoute route = DBRoute.of((String)"sys");
        DataSet srategyRowData = DB.queryDataSet((String)VchCtrlStrategyUpgradeService.class.getName(), (DBRoute)route, (String)CTRL_STRATEGYROW, (Object[])new Object[]{baseDataViewId});
        return srategyRowData;
    }

    private DataSet getVchTemplateOrgData() {
        DBRoute route = DBRoute.of((String)"ai");
        DataSet vchTemplateOrgData = DB.queryDataSet((String)VchCtrlStrategyUpgradeService.class.getName(), (DBRoute)route, (String)VCH_TEMPLATESQL);
        return vchTemplateOrgData;
    }

    private void buildStrategyData(String viewId, String defaultStrategy, List<Long> vchOrgIds) throws Exception {
        int size = vchOrgIds.size();
        ArrayList<Object[]> strategys = new ArrayList<Object[]>(size);
        ArrayList<Object[]> strategyDetails = new ArrayList<Object[]>(size);
        Long[] strategyIds = DBServiceHelper.genLongIds((String)"sys", (String)"t_bd_ctrlstrategy", (int)size);
        Long[] detailIds = DBServiceHelper.genLongIds((String)"sys", (String)"t_bd_ctrlstrategydetail", (int)size);
        for (int i = 0; i < size; ++i) {
            Long createOrgId = vchOrgIds.get(i);
            Long strategyId = strategyIds[i];
            Long detailId = detailIds[i];
            Date date = new Date();
            Object[] strategy = new Object[]{1, 1, viewId, createOrgId, 0, 0, date, date, " ", " ", null, " ", strategyId};
            strategys.add(strategy);
            Object[] detail = new Object[]{strategyId, createOrgId, "2", defaultStrategy, "S", 0, detailId};
            strategyDetails.add(detail);
        }
        this.insertVchStrategy(strategys, strategyDetails);
    }

    private void insertVchStrategy(List<Object[]> strategys, List<Object[]> strategyDetails) throws Exception {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DBRoute route = DBRoute.of((String)"sys");
                if (!strategys.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)INSERTSTRATEGYS, strategys);
                }
                if (!strategyDetails.isEmpty()) {
                    DB.executeBatch((DBRoute)route, (String)INSERTDETAILS, strategyDetails);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error((Throwable)e);
                throw e;
            }
        }
    }
}

