/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.VchExpireDate;

public class VchTemplateDateFieldUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.VchTemplateDateFieldUpgradeService");

    public void test() {
        this.beforeExecuteSqlWithResult("", "", "", "");
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult realt = new UpgradeResult();
        try {
            this.upgrade();
            realt.setSuccess(true);
            log.info("VchTemplateDateFieldUpgradeService_SUCCESS");
        }
        catch (Exception e) {
            realt.setSuccess(false);
            log.info("VchTemplateDateFieldUpgradeService_ERROR");
            realt.setErrorInfo("VchTemplateDateFieldUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return realt;
    }

    private void upgrade() {
        DynamicObject[] vchTemplates = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"fxml", (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
        if (vchTemplates.length == 0) {
            return;
        }
        HashMap<String, MainEntityType> typeCache = new HashMap<String, MainEntityType>();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>((int)((double)vchTemplates.length / 0.75));
        for (DynamicObject vchTemplate : vchTemplates) {
            boolean updated;
            String json = vchTemplate.getString("fxml");
            Map map = (Map)JSONObject.parseObject((String)json, Map.class);
            if (map == null || !(updated = this.handleContent(typeCache, map))) continue;
            json = JSONObject.toJSONString((Object)map);
            vchTemplate.set("fxml", (Object)json);
            result.add(vchTemplate);
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    private boolean handleContent(Map<String, MainEntityType> typeCache, Map<String, Object> map) {
        boolean updated = false;
        for (String key : new String[]{"VchDateSet2", "BizDateSet2"}) {
            String sourcetype;
            String dateName;
            String oldKey;
            if (map.containsKey(key) || !map.containsKey(oldKey = key.substring(0, key.length() - 1))) continue;
            String oldFieldName = (String)map.get(oldKey);
            if (oldFieldName.equalsIgnoreCase("newdate")) {
                dateName = VchExpireDate.newDateAlias();
                sourcetype = "fix";
            } else if (oldFieldName.equalsIgnoreCase("lastdate")) {
                dateName = VchExpireDate.lastDateAlias();
                sourcetype = "fix";
            } else {
                MainEntityType type;
                if (!map.containsKey("SourceBill")) continue;
                String sourceBill = (String)map.get("SourceBill");
                if (typeCache.containsKey(sourceBill)) {
                    type = typeCache.get(sourceBill);
                } else {
                    type = EntityMetadataCache.getDataEntityType((String)sourceBill);
                    typeCache.put(sourceBill, type);
                }
                if (type == null || type.getProperty(oldFieldName) == null || type.getProperty(oldFieldName).getDisplayName() == null) continue;
                dateName = type.getProperty(oldFieldName).getDisplayName().getLocaleValue();
                sourcetype = "exp";
            }
            HashMap<String, String> newContent = new HashMap<String, String>();
            newContent.put("_Type_", "VchExpireDate");
            newContent.put("Sourcetype", sourcetype);
            newContent.put("DateName", dateName);
            newContent.put("Exp", oldFieldName);
            map.put(key, newContent);
            updated = true;
        }
        return updated;
    }
}

