/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.DapUtil;

public class VchTemplateDisPlayFieldUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.VchTemplateDisPlayFieldUpgradeService");
    public static final int batchCount = 100;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgrade();
            result.setSuccess(true);
            log.info("VchTemplateDisPlayFieldUpgradeService_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("VchTemplateDisPlayFieldUpgradeService_ERROR");
            result.setErrorInfo("VchTemplateDisPlayFieldUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void upgrade() {
        DBRoute dbRoute = DBRoute.of((String)"ai");
        List idList = (List)DB.query((DBRoute)dbRoute, (String)"select fid as id from t_ai_vchtemplate where facctorgid=' ' or fvchtypedesc=' ' or fvoucherdatedesc=' ' or fbizdatedesc=' '", null, e -> {
            ArrayList<Long> ids = new ArrayList<Long>(100);
            while (e.next()) {
                Long id = e.getLong("id");
                ids.add(id);
            }
            return ids;
        });
        if (idList.isEmpty()) {
            return;
        }
        int count = idList.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>(count);
        int i = (count + 100 - 1) / 100;
        for (int j = 0; j < i; ++j) {
            int start = 100 * j;
            int end = Math.min(100 * (j + 1), count);
            List batchIds = idList.subList(start, end);
            QFilter qFilter = new QFilter("id", "in", batchIds);
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id,fsourcebill,eventclass_id,fxml", (QFilter[])qFilter.toArray());
            for (DynamicObject object : templates) {
                this.addObjToParams(params, object);
            }
        }
        if (!params.isEmpty()) {
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    String updateSql = "update t_ai_vchtemplate set facctorgid = ?, fvchtypedesc = ?, fvoucherdatedesc = ?, fbizdatedesc = ? where fid = ?";
                    DB.executeBatch((DBRoute)dbRoute, (String)updateSql, params);
                }
                catch (Exception e2) {
                    txHandle.markRollback();
                    log.error((Throwable)e2);
                }
            }
        }
    }

    private void addObjToParams(List<Object[]> params, DynamicObject vchTemplateObj) {
        String json = vchTemplateObj.getString("fxml");
        if (StringUtils.isEmpty((CharSequence)json)) {
            return;
        }
        boolean isEvent = "ai_eventclass".equals(vchTemplateObj.getString("fsourcebill"));
        VCHTemplate vchTemplate = VCHTemplate.deserializeFromString((String)json, null);
        MainEntityType srcMainET = null;
        try {
            if (isEvent) {
                srcMainET = AiEventMetaUtil.getEntityType((Object)vchTemplateObj.getLong("eventclass_id"));
            } else {
                String fsourcebill = vchTemplateObj.getString("fsourcebill");
                srcMainET = EntityMetadataCache.getDataEntityType((String)fsourcebill);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b9e\u4f53\u5143\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        if (null != srcMainET) {
            String vchTypeDesc = this.getVchTypeDesc(vchTemplate);
            HashSet<String> entityIds = new HashSet<String>(3);
            entityIds.add("bos_org");
            entityIds.add("bos_adminorg");
            entityIds.add("bos_costcenter");
            List orgItems = DapUtil.buildPropComboItems(entityIds, (MainEntityType)srcMainET, (boolean)false, (boolean)true, (boolean)false);
            String bizOrgField = " ";
            for (ComboItem c : orgItems) {
                if (!vchTemplate.getAcctOrgSet().equalsIgnoreCase(c.getValue())) continue;
                bizOrgField = c.getCaption().toString();
            }
            String fvoucherdatedesc = " ";
            VchExpireDate vchDateSetBox = vchTemplate.getVchDateSet2();
            if (vchDateSetBox != null) {
                fvoucherdatedesc = vchDateSetBox.getDescriptionString();
            } else if (vchTemplate.getVchDateSet() != null) {
                fvoucherdatedesc = this.getFieldName(srcMainET, vchTemplate.getVchDateSet());
            }
            String fbizdatedesc = " ";
            VchExpireDate bizDateSetBox = vchTemplate.getBizDateSet2();
            if (bizDateSetBox != null) {
                fbizdatedesc = bizDateSetBox.getDescriptionString();
            } else if (vchTemplate.getBizDateSet() != null) {
                fbizdatedesc = this.getFieldName(srcMainET, vchTemplate.getBizDateSet());
            }
            params.add(new Object[]{bizOrgField, vchTypeDesc, fvoucherdatedesc, fbizdatedesc, vchTemplateObj.getLong("id")});
        }
    }

    private String getFieldName(MainEntityType entity, String fieldKey) {
        String fieldName = "";
        for (IDataEntityProperty prop : entity.getProperties()) {
            if (!fieldKey.equalsIgnoreCase(prop.getName())) continue;
            fieldName = this.buildPropCaption(prop);
            break;
        }
        if ("newdate".equalsIgnoreCase(fieldKey) && "".equals(fieldName)) {
            return VchExpireDate.newDateAlias();
        }
        if ("lastdate".equalsIgnoreCase(fieldKey) && "".equals(fieldName)) {
            return VchExpireDate.lastDateAlias();
        }
        return fieldName;
    }

    private String buildPropCaption(IDataEntityProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"VchTemplateDisPlayFieldUpgradeService_0", (String)"fi-ai-upgradeservice", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : this.getFieldSelector(prop);
        return String.format("%s.%s", parentName, propName);
    }

    private String getFieldSelector(IDataEntityProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }

    private String getVchTypeDesc(VCHTemplate vchTemplate) {
        StringBuilder grpDesc = new StringBuilder();
        try {
            VchTplVoucherTypes vchTypesSet = vchTemplate.getVchTypesSet();
            if (null != vchTypesSet && null != vchTypesSet.getItems() && !vchTypesSet.getItems().isEmpty()) {
                for (VchTplVoucherType vchTempGrp : vchTypesSet.getItems()) {
                    grpDesc.append(vchTempGrp.getVchGrpName().getLocaleValue()).append('/');
                }
                if (grpDesc.length() > 0) {
                    grpDesc.deleteCharAt(grpDesc.length() - 1);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ecefxm\u89e3\u6790\u51fa\u51ed\u8bc1\u7c7b\u578b\u8bbe\u7f6e\u5b57\u6bb5\u51fa\u9519, ", (Throwable)e);
        }
        return StringUtils.isBlank((CharSequence)grpDesc.toString()) ? " " : grpDesc.toString();
    }
}

